/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.query.modifiers;

import com.googlecode.mjorm.DBObjectUtil;
import com.googlecode.mjorm.query.modifiers.Modifier;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModifierBuilder<T extends AbstractModifierBuilder<T>> {
    protected Stack<String> propertyStack = new Stack();
    protected Map<String, List<Modifier>> modifiersMap = new LinkedHashMap<String, List<Modifier>>();

    protected abstract T self();

    public void clear() {
        this.modifiersMap.clear();
        this.propertyStack.clear();
    }

    public Modifier[] getModifiers(String property) {
        String key = this.propertyHierarchy(property);
        if (!this.modifiersMap.containsKey(key)) {
            return new Modifier[0];
        }
        return this.modifiersMap.get(key).toArray(new Modifier[0]);
    }

    public Boolean hasModifiersFor(String property) {
        return this.getModifiers(property).length > 0;
    }

    public T push(String property) {
        this.propertyStack.push(property);
        return this.self();
    }

    public T pop() {
        this.propertyStack.pop();
        return this.self();
    }

    public T add(String property, Modifier modifier) {
        String key = this.propertyHierarchy(property);
        if (!this.modifiersMap.containsKey(key)) {
            this.modifiersMap.put(key, new ArrayList());
        }
        this.modifiersMap.get(key).add(modifier);
        return this.self();
    }

    protected String propertyHierarchy(String property) {
        String ret = "";
        for (int i = 0; i < this.propertyStack.size(); ++i) {
            ret = ret + (String)this.propertyStack.get(i) + ".";
        }
        ret = ret + property;
        return ret;
    }

    public String toString() {
        DBObject queryObj = this.toModifierObject();
        return queryObj != null ? queryObj.toString() : "null";
    }

    public DBObject toModifierObject() {
        BasicDBObject ret = new BasicDBObject();
        for (Map.Entry<String, List<Modifier>> entry : this.modifiersMap.entrySet()) {
            String propertyName = entry.getKey();
            for (Modifier modifier : entry.getValue()) {
                DBObject curVal = modifier.toModifierObject(propertyName);
                DBObjectUtil.merge(curVal, (DBObject)ret);
            }
        }
        return ret;
    }
}

