/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.spring;

import com.googlecode.mjorm.mql.Statement;
import com.googlecode.mjorm.query.DaoQuery;
import com.googlecode.mjorm.spring.MongoDBDaoSupport;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMJORMDao
extends MongoDBDaoSupport {
    private boolean cacheStatements = true;
    private Map<String, Statement> statementCache = new HashMap<String, Statement>();

    protected ObjectId[] oids(String ... ids) {
        ObjectId[] ret = new ObjectId[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            ret[i] = ids[i] != null ? new ObjectId(ids[i]) : null;
        }
        return ret;
    }

    protected List<ObjectId> oids(Collection<String> ids) {
        ArrayList<ObjectId> ret = new ArrayList<ObjectId>(ids.size());
        for (String id : ids) {
            ret.add(id != null ? new ObjectId(id) : null);
        }
        return ret;
    }

    protected ObjectId oid(String objectId) {
        return objectId != null ? new ObjectId(objectId) : null;
    }

    protected <T> T createObject(String collection, T object) {
        return this.getMongoDao().createObject(collection, object);
    }

    protected <T> T createObject(String collection, T object, WriteConcern concern) {
        return this.getMongoDao().createObject(collection, object, concern);
    }

    protected <T> T readObject(String collection, Object id, Class<T> clazz) {
        return this.getMongoDao().readObject(collection, id, clazz);
    }

    protected void updateObject(String collection, Object id, Object o) {
        this.getMongoDao().updateObject(collection, id, o);
    }

    protected void updateObject(String collection, Object id, Object o, WriteConcern concern) {
        this.getMongoDao().updateObject(collection, id, o, concern);
    }

    protected void deleteObject(String collection, Object id) {
        this.getMongoDao().deleteObject(collection, id);
    }

    protected void deleteObject(String collection, Object id, WriteConcern concern) {
        this.getMongoDao().deleteObject(collection, id, concern);
    }

    protected DaoQuery createQuery() {
        return this.getMongoDao().createQuery();
    }

    protected DaoQuery createQuery(String collectionName) {
        return this.createQuery().setCollection(collectionName);
    }

    protected Statement createStatement(String mql) {
        if (this.cacheStatements && this.statementCache.containsKey(mql)) {
            return this.statementCache.get(mql);
        }
        Statement ret = this.getMongoDao().createStatement(mql);
        if (this.cacheStatements) {
            this.statementCache.put(mql, ret);
        }
        return ret;
    }
}

