/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mjorm.spring;

import com.googlecode.mjorm.MapReduceConfiguration;
import com.googlecode.mjorm.MongoDao;
import com.googlecode.mjorm.MongoDaoImpl;
import com.googlecode.mjorm.ObjectMapper;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.dao.support.DaoSupport;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoDBDaoSupport
extends DaoSupport
implements InitializingBean,
BeanFactoryAware {
    private MongoDao mongoDao;
    private BeanFactory beanFactory;
    private ObjectMapper objectMapper;
    private Mongo mongo;
    private DB db;
    private String dbName;
    private String username;
    private String password;
    private Map<String, MapReduceConfiguration> mapReduceConfigs = new HashMap<String, MapReduceConfiguration>();

    protected void checkDaoConfig() {
        if (this.objectMapper == null && ListableBeanFactory.class.isInstance(this.beanFactory)) {
            this.objectMapper = (ObjectMapper)BeanFactoryUtils.beanOfType((ListableBeanFactory)((ListableBeanFactory)ListableBeanFactory.class.cast(this.beanFactory)), ObjectMapper.class);
        }
        Assert.notNull((Object)this.objectMapper, (String)"an ObjectMapper is required");
        if (this.mongo == null && ListableBeanFactory.class.isInstance(this.beanFactory)) {
            this.mongo = (Mongo)BeanFactoryUtils.beanOfType((ListableBeanFactory)((ListableBeanFactory)ListableBeanFactory.class.cast(this.beanFactory)), Mongo.class);
        }
        Assert.notNull((Object)this.mongo, (String)"a Mongo connection is required");
        if (this.db == null && StringUtils.hasText((String)this.dbName)) {
            this.db = this.mongo.getDB(this.dbName);
        }
        Assert.notNull((Object)this.db, (String)"a mongo db or db name is required");
    }

    protected void initDao() throws Exception {
        if (StringUtils.hasText((String)this.username) && StringUtils.hasText((String)this.password)) {
            this.db.authenticate(this.username, this.password.toCharArray());
        }
        if (this.mongoDao == null) {
            this.mongoDao = new MongoDaoImpl(this.db, this.objectMapper);
        }
        this.ensureIndexes();
    }

    protected void ensureIndexes() {
    }

    protected MapReduceConfiguration getMapReduceConfiguration(String classPath) {
        if (!this.mapReduceConfigs.containsKey(classPath)) {
            try {
                MapReduceConfiguration config = MapReduceConfiguration.create(((Object)((Object)this)).getClass().getResourceAsStream(classPath));
                this.mapReduceConfigs.put(classPath, config);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.mapReduceConfigs.get(classPath);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public MongoDao getMongoDao() {
        return this.mongoDao;
    }

    public DBCollection getCollection(String name) {
        return this.getDb().getCollection(name);
    }

    public DB getDb() {
        return this.db;
    }

    public Mongo getMongo() {
        return this.mongo;
    }

    public void setMongo(Mongo mongo) {
        this.mongo = mongo;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setMongoDao(MongoDao mongoDao) {
        this.mongoDao = mongoDao;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setDb(DB db) {
        this.db = db;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

