/*
 * Decompiled with CFR 0.152.
 */
package com.belteshazzar.jquery;

import com.belteshazzar.jquery.AnimationOptions;
import com.belteshazzar.jquery.Event;
import com.belteshazzar.jquery.EventHandler;
import com.belteshazzar.jquery.Offset;
import com.belteshazzar.jquery.PlainObject;
import com.belteshazzar.jquery.Promise;
import com.belteshazzar.jquery.functions.IntElementBooleanFunction;
import com.belteshazzar.jquery.functions.IntElementFunction;
import com.belteshazzar.jquery.functions.IntElementObjectFunction;
import com.belteshazzar.jquery.functions.IntElementVoidFunction;
import com.belteshazzar.jquery.functions.IntIntIntFunction;
import com.belteshazzar.jquery.functions.IntIntStringFunction;
import com.belteshazzar.jquery.functions.IntJQueryFunction;
import com.belteshazzar.jquery.functions.IntObjectObjectFunction;
import com.belteshazzar.jquery.functions.IntOffsetOffsetFunction;
import com.belteshazzar.jquery.functions.IntStringBooleanStringFunction;
import com.belteshazzar.jquery.functions.IntStringElementFunction;
import com.belteshazzar.jquery.functions.IntStringFunction;
import com.belteshazzar.jquery.functions.IntStringIntFunction;
import com.belteshazzar.jquery.functions.IntStringJQueryFunction;
import com.belteshazzar.jquery.functions.IntStringStringFunction;
import com.belteshazzar.jquery.functions.IntTweenVoidFunction;
import com.belteshazzar.jquery.functions.JQueryFunction;
import com.belteshazzar.jquery.functions.PromiseBooleanVoidFunction;
import com.belteshazzar.jquery.functions.PromiseIntIntVoidFunction;
import com.belteshazzar.jquery.functions.PromiseVoidFunction;
import com.belteshazzar.jquery.functions.VoidFunction;
import com.belteshazzar.jquery.functions.VoidFunctionFunction;
import com.belteshazzar.jquery.functions.callers.EventHandlerCaller;
import com.belteshazzar.jquery.functions.callers.IntElementBooleanFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntElementFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntElementObjectFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntIntIntFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntIntStringFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntJQueryFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntObjectObjectFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntOffsetOffsetFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntStringBooleanStringFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntStringElementFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntStringFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntStringIntFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntStringJQueryFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntStringStringFunctionCaller;
import com.belteshazzar.jquery.functions.callers.IntTweenVoidFunctionCaller;
import com.belteshazzar.jquery.functions.callers.PromiseBooleanVoidFunctionCaller;
import com.belteshazzar.jquery.functions.callers.PromiseIntIntVoidFunctionCaller;
import com.belteshazzar.jquery.functions.callers.PromiseVoidFunctionCaller;
import com.belteshazzar.jquery.functions.callers.VoidFunctionCaller;
import com.belteshazzar.jquery.functions.callers.VoidFunctionFunctionCaller;
import com.sun.webkit.dom.HTMLScriptElementImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.html.HTMLDocument;

public class JQuery {
    public static final String DEFAULT_JQUERY_LOCAL = JQuery.class.getResource("jquery-2.2.1.min.js").toExternalForm();
    public static final String DEFAULT_JQUERY_REMOTE = "http://ajax.googleapis.com/ajax/libs/jquery/2.2.0/jquery.min.js";
    public static final boolean DEFAULT_CLEAR_READY_FUNCTIONS = true;
    private static final List<VoidFunction> readyFunctions = new ArrayList<VoidFunction>();
    private static final Map<Integer, JSObject> eventHandlerMap = new HashMap<Integer, JSObject>();
    private static WebEngine webEngine;
    private static JSObject window;
    private static Config config;
    public final int length;
    private final JSObject js;

    public static void setEngine(WebEngine webEngine) {
        JQuery.webEngine = webEngine;
        webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    JQuery.documentLoaded();
                } else {
                    window = null;
                }
            }
        });
        if (webEngine.getLoadWorker().getState() == Worker.State.SUCCEEDED) {
            JQuery.documentLoaded();
        }
    }

    private static void documentLoaded() {
        try {
            Object jQuery = webEngine.executeScript("jQuery");
            window = (JSObject)webEngine.executeScript("window");
            JQuery.documentReady();
        }
        catch (JSException jsex) {
            HTMLDocument doc = (HTMLDocument)webEngine.getDocument();
            final HTMLScriptElementImpl script = (HTMLScriptElementImpl)doc.createElement("script");
            script.addEventListener("load", new EventListener(){

                @Override
                public void handleEvent(org.w3c.dom.events.Event evt) {
                    Object jQuery = webEngine.executeScript("jQuery");
                    if (!(jQuery instanceof JSObject)) {
                        throw new IllegalStateException("JQuery hasn't been loaded into web page");
                    }
                    window = (JSObject)webEngine.executeScript("window");
                    JQuery.documentReady();
                }
            }, false);
            script.addEventListener("error", new EventListener(){

                @Override
                public void handleEvent(org.w3c.dom.events.Event evt) {
                    if (script.getSrc().equals(config.local)) {
                        script.setSrc(config.remote);
                    }
                }
            }, false);
            script.setSrc(JQuery.config.local);
            doc.getBody().appendChild((Node)script);
        }
    }

    private static void documentReady() {
        for (VoidFunction f : readyFunctions) {
            f.apply();
        }
        if (JQuery.config.clearReadyFunctions) {
            readyFunctions.clear();
        }
    }

    static JSObject createFunction(IntStringStringFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntStringStringFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,s) { return obj.java.call(i,s); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(EventHandler handler) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new EventHandlerCaller(handler));
        obj.eval("(function(obj) { obj.fn = function(ev) { obj.java.call(ev); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntElementObjectFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntElementObjectFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,el) { return obj.java.call(i,el); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntStringFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntStringFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i) { return obj.java.call(i); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntStringBooleanStringFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntStringBooleanStringFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,s,b) { return obj.java.call(i,s,b); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntElementFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntElementFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,s,b) { return obj.java.call(i,s,b); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntJQueryFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntJQueryFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,s,b) { return obj.java.call(i,s,b); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntStringJQueryFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntStringJQueryFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,s,b) { return obj.java.call(i,s,b); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntStringElementFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntStringElementFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,s,b) { return obj.java.call(i,s,b); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntIntStringFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntIntStringFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,j) { return obj.java.call(i,j); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntIntIntFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntIntIntFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,j) { return obj.java.call(i,j); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(VoidFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new VoidFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function() { obj.java.call(); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntObjectObjectFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntObjectObjectFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,o) { return obj.java.call(i,o); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntTweenVoidFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntTweenVoidFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,t) { return obj.java.call(i,t); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntElementBooleanFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntElementBooleanFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,el) { return obj.java.call(i,el); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntOffsetOffsetFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntOffsetOffsetFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,os) { return obj.java.call(i,os); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(PromiseVoidFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new PromiseVoidFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(promise) { obj.java.call(promise); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(PromiseBooleanVoidFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new PromiseBooleanVoidFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(promise,finished) { obj.java.call(promise,finished); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(PromiseIntIntVoidFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new PromiseIntIntVoidFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(promise,i,j) { obj.java.call(promise,i,j); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(IntStringIntFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new IntStringIntFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function(i,s) { return obj.java.call(i,s); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createFunction(VoidFunctionFunction function) {
        JSObject obj = JQuery.createObject();
        obj.setMember("java", new VoidFunctionFunctionCaller(function));
        obj.eval("(function(obj) { obj.fn = function() { return obj.java.call(); } })(this)");
        return (JSObject)obj.getMember("fn");
    }

    static JSObject createArray(Object[] values) {
        JSObject array = JQuery.createArray();
        for (int i = 0; i < values.length; ++i) {
            array.setSlot(i, values[i]);
        }
        return array;
    }

    static JSObject createArray() {
        return (JSObject)window.eval("(function() { return []; })()");
    }

    static JSObject createObject() {
        return (JSObject)window.eval("(function() { return {}; })()");
    }

    public static JQuery $(String selector) {
        return new JQuery(window.call("jQuery", selector));
    }

    public static JQuery $(String selector, Element context) {
        return new JQuery(window.call("jQuery", selector, context));
    }

    public static JQuery $(String selector, JQuery context) {
        return new JQuery(window.call("jQuery", selector, context.js));
    }

    public static JQuery $(Element element) {
        return new JQuery(window.call("jQuery", element));
    }

    public static JQuery $(Element ... elementArray) {
        return new JQuery(window.call("jQuery", JQuery.createArray(elementArray)));
    }

    public static JQuery $(PlainObject object) {
        return new JQuery(window.call("jQuery", object.toJSObject()));
    }

    public static JQuery $(JQuery selection) {
        return new JQuery(window.call("jQuery", selection.js));
    }

    public static JQuery $() {
        return new JQuery(window.call("jQuery", new Object[0]));
    }

    public static JQuery $(String html, PlainObject attributes) {
        return new JQuery(window.call("jQuery", html, attributes.toJSObject()));
    }

    public static JQuery $(VoidFunction callback) {
        readyFunctions.add(callback);
        return new JQuery(null);
    }

    private JQuery(Object o) {
        if (o instanceof JSObject) {
            this.js = (JSObject)o;
            this.length = (Integer)this.js.getMember("length");
        } else {
            this.js = null;
            this.length = 0;
        }
    }

    public JQuery add(String selector) {
        return new JQuery(this.js.call("add", selector));
    }

    public JQuery add(Element element) {
        return new JQuery(this.js.call("add", element));
    }

    public JQuery add(JQuery selection) {
        return new JQuery(this.js.call("add", selection.js));
    }

    public JQuery add(String selector, Element context) {
        return new JQuery(this.js.call("add", selector, context));
    }

    public JQuery addBack() {
        return new JQuery(this.js.call("addBack", new Object[0]));
    }

    public JQuery addBack(String selector) {
        return new JQuery(this.js.call("addBack", selector));
    }

    public JQuery addClass(String classname) {
        this.js.call("addClass", classname);
        return this;
    }

    public JQuery addClass(IntStringStringFunction function) {
        this.js.call("addClass", JQuery.createFunction(function));
        return this;
    }

    public JQuery after(String content) {
        this.js.call("after", content);
        return this;
    }

    public JQuery after(Element content) {
        this.js.call("after", content);
        return this;
    }

    public JQuery after(Element ... content) {
        this.js.call("after", JQuery.createArray(content));
        return this;
    }

    public JQuery after(JQuery content) {
        this.js.call("after", content.js);
        return this;
    }

    public JQuery after(IntStringFunction function) {
        return new JQuery(this.js.call("after", JQuery.createFunction(function)));
    }

    public JQuery after(IntElementFunction function) {
        return new JQuery(this.js.call("after", JQuery.createFunction(function)));
    }

    public JQuery after(IntJQueryFunction function) {
        return new JQuery(this.js.call("after", JQuery.createFunction(function)));
    }

    public JQuery after(IntStringStringFunction function) {
        return new JQuery(this.js.call("after", JQuery.createFunction(function)));
    }

    public JQuery after(IntStringElementFunction function) {
        return new JQuery(this.js.call("after", JQuery.createFunction(function)));
    }

    public JQuery after(IntStringJQueryFunction function) {
        return new JQuery(this.js.call("after", JQuery.createFunction(function)));
    }

    public JQuery animate(PlainObject properties) {
        return new JQuery(this.js.call("animate", properties.toJSObject()));
    }

    public JQuery animate(PlainObject properties, VoidFunction complete) {
        return new JQuery(this.js.call("animate", properties.toJSObject(), JQuery.createFunction(complete)));
    }

    public JQuery animate(PlainObject properties, int duration) {
        return new JQuery(this.js.call("animate", properties.toJSObject(), duration));
    }

    public JQuery animate(PlainObject properties, int duration, VoidFunction complete) {
        return new JQuery(this.js.call("animate", properties.toJSObject(), duration, JQuery.createFunction(complete)));
    }

    public JQuery animate(PlainObject properties, int duration, String easing) {
        return new JQuery(this.js.call("animate", properties.toJSObject(), duration, easing));
    }

    public JQuery animate(PlainObject properties, int duration, String easing, VoidFunction complete) {
        return new JQuery(this.js.call("animate", properties.toJSObject(), duration, easing, JQuery.createFunction(complete)));
    }

    public JQuery animate(PlainObject properties, AnimationOptions options) {
        return new JQuery(this.js.call("animate", properties.toJSObject(), options.toJSObject()));
    }

    public JQuery append(String content) {
        this.js.call("append", content);
        return this;
    }

    public JQuery append(Element content) {
        this.js.call("append", content);
        return this;
    }

    public JQuery append(Element ... content) {
        this.js.call("append", JQuery.createArray(content));
        return this;
    }

    public JQuery append(JQuery content) {
        this.js.call("append", content.js);
        return this;
    }

    public JQuery append(IntStringStringFunction function) {
        return new JQuery(this.js.call("append", JQuery.createFunction(function)));
    }

    public JQuery append(IntStringElementFunction function) {
        return new JQuery(this.js.call("append", JQuery.createFunction(function)));
    }

    public JQuery append(IntStringJQueryFunction function) {
        return new JQuery(this.js.call("append", JQuery.createFunction(function)));
    }

    public JQuery appendTo(String target) {
        this.js.call("appendTo", target);
        return this;
    }

    public JQuery appendTo(Element target) {
        this.js.call("appendTo", target);
        return this;
    }

    public JQuery appendTo(Element ... target) {
        this.js.call("appendTo", JQuery.createArray(target));
        return this;
    }

    public JQuery appendTo(JQuery target) {
        this.js.call("appendTo", target.js);
        return this;
    }

    public String attr(String attributeName) {
        return (String)this.js.call("attr", attributeName);
    }

    public JQuery attr(String attributeName, String value) {
        this.js.call("attr", attributeName, value);
        return this;
    }

    public JQuery attr(String attributeName, Number value) {
        this.js.call("attr", attributeName, value);
        return this;
    }

    public JQuery attr(PlainObject attributes) {
        this.js.call("attr", attributes.toJSObject());
        return this;
    }

    public JQuery attr(String attributeName, IntStringStringFunction function) {
        this.js.call("attr", attributeName, JQuery.createFunction(function));
        return this;
    }

    public JQuery attr(String attributeName, IntStringIntFunction function) {
        this.js.call("attr", attributeName, JQuery.createFunction(function));
        return this;
    }

    public JQuery before(String content) {
        this.js.call("before", content);
        return this;
    }

    public JQuery before(Element content) {
        this.js.call("before", content);
        return this;
    }

    public JQuery before(Element ... content) {
        this.js.call("before", JQuery.createArray(content));
        return this;
    }

    public JQuery before(JQuery content) {
        this.js.call("before", content.js);
        return this;
    }

    public JQuery before(IntStringFunction function) {
        return new JQuery(this.js.call("before", JQuery.createFunction(function)));
    }

    public JQuery before(IntElementFunction function) {
        return new JQuery(this.js.call("before", JQuery.createFunction(function)));
    }

    public JQuery before(IntJQueryFunction function) {
        return new JQuery(this.js.call("before", JQuery.createFunction(function)));
    }

    public JQuery before(IntStringStringFunction function) {
        return new JQuery(this.js.call("before", JQuery.createFunction(function)));
    }

    public JQuery before(IntStringElementFunction function) {
        return new JQuery(this.js.call("before", JQuery.createFunction(function)));
    }

    public JQuery before(IntStringJQueryFunction function) {
        return new JQuery(this.js.call("before", JQuery.createFunction(function)));
    }

    public JQuery bind(String eventType, EventHandler handler) {
        JSObject jsHandler = JQuery.createFunction(handler);
        eventHandlerMap.put(handler.hashCode(), jsHandler);
        this.js.call("bind", eventType, jsHandler);
        return this;
    }

    public JQuery bind(String eventType, Object eventData, EventHandler handler) {
        JSObject jsHandler = JQuery.createFunction(handler);
        eventHandlerMap.put(jsHandler.hashCode(), jsHandler);
        this.js.call("bind", eventType, eventData, jsHandler);
        return this;
    }

    public JQuery blur(EventHandler handler) {
        return this.bind("blur", handler);
    }

    public JQuery blur(Object data, EventHandler handler) {
        return this.bind("blur", data, handler);
    }

    public JQuery blur() {
        this.js.call("blur", new Object[0]);
        return this;
    }

    public JQuery change(EventHandler handler) {
        return this.bind("change", handler);
    }

    public JQuery change(Object data, EventHandler handler) {
        return this.bind("change", data, handler);
    }

    public JQuery change() {
        this.js.call("change", new Object[0]);
        return this;
    }

    public JQuery children() {
        return new JQuery(this.js.call("children", new Object[0]));
    }

    public JQuery children(String selector) {
        return new JQuery(this.js.call("children", selector));
    }

    public JQuery clearQueue() {
        return new JQuery(this.js.call("clearQueue", new Object[0]));
    }

    public JQuery clearQueue(String queueName) {
        return new JQuery(this.js.call("clearQueue", queueName));
    }

    public JQuery click(EventHandler handler) {
        return this.bind("click", handler);
    }

    public JQuery click(Object data, EventHandler handler) {
        return this.bind("click", data, handler);
    }

    public JQuery click() {
        this.js.call("click", new Object[0]);
        return this;
    }

    public JQuery clone() {
        return this.clone(false, false);
    }

    public JQuery clone(boolean withDataAndEvents) {
        return this.clone(withDataAndEvents, withDataAndEvents);
    }

    public JQuery clone(boolean withDataAndEvents, boolean deepWithDataAndEvents) {
        return new JQuery(this.js.call("clone", withDataAndEvents, deepWithDataAndEvents));
    }

    public JQuery closest(String selector) {
        return new JQuery(this.js.call("closest", selector));
    }

    public JQuery closest(String selector, Element context) {
        return new JQuery(this.js.call("closest", selector, context));
    }

    public JQuery closest(JQuery selection) {
        return new JQuery(this.js.call("closest", selection));
    }

    public JQuery closest(Element element) {
        return new JQuery(this.js.call("closest", element));
    }

    public JQuery contents() {
        return new JQuery(this.js.call("contents", new Object[0]));
    }

    public JQuery contextmenu(EventHandler handler) {
        this.bind("contextmenu", handler);
        return this;
    }

    public JQuery contextmenu(Object eventData, EventHandler handler) {
        this.bind("contextmenu", eventData, handler);
        return this;
    }

    public JQuery contextmenu() {
        this.js.call("contextmenu", new Object[0]);
        return this;
    }

    public String css(String propertyName) {
        return (String)this.js.call("css", propertyName);
    }

    public PlainObject css(String ... propertyNames) {
        return new PlainObject((JSObject)this.js.call("css", JQuery.createArray(propertyNames)));
    }

    public JQuery css(String propertyName, String value) {
        this.js.call("css", propertyName, value);
        return this;
    }

    public JQuery css(String propertyName, IntStringStringFunction function) {
        this.js.call("css", propertyName, JQuery.createFunction(function));
        return this;
    }

    public JQuery css(PlainObject properties) {
        this.js.call("css", properties.toJSObject());
        return this;
    }

    public JQuery data(String key, Object value) {
        this.js.call("data", key, value);
        return this;
    }

    public JQuery data(PlainObject obj) {
        this.js.call("data", obj.toJSObject());
        return this;
    }

    public Object data(String key) {
        return this.js.call("data", key);
    }

    public Object data() {
        return this.js.call("data", new Object[0]);
    }

    public JQuery dblclick(EventHandler handler) {
        return this.bind("dblclick", handler);
    }

    public JQuery dblclick(Object data, EventHandler handler) {
        return this.bind("dblclick", data, handler);
    }

    public JQuery dblclick() {
        this.js.call("dblclick", new Object[0]);
        return this;
    }

    public JQuery delay(int duration) {
        this.js.call("delay", duration);
        return this;
    }

    public JQuery delay(int duration, String queueName) {
        this.js.call("delay", duration, queueName);
        return this;
    }

    public JQuery delegate(String selector, String eventType, EventHandler handler) {
        this.js.call("delegate", selector, eventType, JQuery.createFunction(handler));
        return this;
    }

    public JQuery delegate(String selector, String eventType, Object eventData, EventHandler handler) {
        this.js.call("delegate", selector, eventType, eventData, JQuery.createFunction(handler));
        return this;
    }

    public JQuery delegate(String selector, PlainObject events) {
        this.js.call("delegate", selector, events.toJSObject());
        return this;
    }

    public JQuery dequeue() {
        this.js.call("dequeue", new Object[0]);
        return this;
    }

    public JQuery dequeue(String queueName) {
        this.js.call("dequeue", queueName);
        return this;
    }

    public JQuery detach() {
        this.js.call("detach", new Object[0]);
        return this;
    }

    public JQuery detach(String selector) {
        this.js.call("detach", selector);
        return this;
    }

    public JQuery each(IntElementVoidFunction function) {
        for (int i = 0; i < this.length; ++i) {
            Element el = (Element)this.js.getSlot(i);
            function.apply(i, el);
        }
        return this;
    }

    public JQuery empty() {
        return new JQuery(this.js.call("empty", new Object[0]));
    }

    public JQuery end() {
        return new JQuery(this.js.call("end", new Object[0]));
    }

    public JQuery eq(int index) {
        return new JQuery(this.js.call("eq", index));
    }

    public JQuery error(EventHandler handler) {
        return this.bind("error", handler);
    }

    public JQuery error(Object eventData, EventHandler handler) {
        return this.bind("error", eventData, handler);
    }

    public JQuery fadeIn() {
        this.js.call("fadeIn", new Object[0]);
        return this;
    }

    public JQuery fadeIn(String duration) {
        this.js.call("fadeIn", duration);
        return this;
    }

    public JQuery fadeIn(String duration, VoidFunction complete) {
        this.js.call("fadeIn", duration, JQuery.createFunction(complete));
        return this;
    }

    public JQuery fadeIn(AnimationOptions options) {
        this.js.call("fadeIn", options.toJSObject());
        return this;
    }

    public JQuery fadeIn(String duration, String easing) {
        this.js.call("fadeIn", duration, easing);
        return this;
    }

    public JQuery fadeIn(String duration, String easing, VoidFunction complete) {
        this.js.call("fadeIn", duration, easing, JQuery.createFunction(complete));
        return this;
    }

    public JQuery fadeOut() {
        this.js.call("fadeOut", new Object[0]);
        return this;
    }

    public JQuery fadeOut(String duration) {
        this.js.call("fadeOut", duration);
        return this;
    }

    public JQuery fadeOut(String duration, VoidFunction complete) {
        this.js.call("fadeOut", duration, JQuery.createFunction(complete));
        return this;
    }

    public JQuery fadeOut(AnimationOptions options) {
        this.js.call("fadeOut", options.toJSObject());
        return this;
    }

    public JQuery fadeOut(String duration, String easing) {
        this.js.call("fadeOut", duration, easing);
        return this;
    }

    public JQuery fadeOut(String duration, String easing, VoidFunction complete) {
        this.js.call("fadeOut", duration, easing, JQuery.createFunction(complete));
        return this;
    }

    public JQuery fadeTo(String duration, double opacity) {
        this.js.call("fadeTo", duration, opacity);
        return this;
    }

    public JQuery fadeTo(String duration, double opacity, VoidFunction complete) {
        this.js.call("fadeTo", duration, opacity, JQuery.createFunction(complete));
        return this;
    }

    public JQuery fadeTo(String duration, double opacity, String easing) {
        this.js.call("fadeTo", duration, opacity, easing);
        return this;
    }

    public JQuery fadeTo(String duration, double opacity, String easing, VoidFunction complete) {
        this.js.call("fadeTo", duration, opacity, easing, JQuery.createFunction(complete));
        return this;
    }

    public JQuery fadeToggle() {
        this.js.call("fadeToggle", new Object[0]);
        return this;
    }

    public JQuery fadeToggle(String duration) {
        this.js.call("fadeToggle", duration);
        return this;
    }

    public JQuery fadeToggle(String duration, String easing) {
        this.js.call("fadeToggle", duration, easing);
        return this;
    }

    public JQuery fadeToggle(String duration, String easing, VoidFunction complete) {
        this.js.call("fadeToggle", duration, easing, JQuery.createFunction(complete));
        return this;
    }

    public JQuery fadeToggle(AnimationOptions options) {
        this.js.call("fadeToggle", options.toJSObject());
        return this;
    }

    public JQuery filter(String selector) {
        return new JQuery(this.js.call("filter", selector));
    }

    public JQuery filter(IntElementBooleanFunction selector) {
        return new JQuery(this.js.call("filter", JQuery.createFunction(selector)));
    }

    public JQuery filter(Element elemements) {
        return new JQuery(this.js.call("filter", elemements));
    }

    public JQuery filter(Element ... elemements) {
        return new JQuery(this.js.call("filter", JQuery.createArray(elemements)));
    }

    public JQuery filter(JQuery selector) {
        return new JQuery(this.js.call("filter", selector.js));
    }

    public JQuery find(String selector) {
        return new JQuery(this.js.call("find", selector));
    }

    public JQuery find(Element element) {
        return new JQuery(this.js.call("find", element));
    }

    public JQuery find(JQuery element) {
        return new JQuery(this.js.call("find", element.js));
    }

    public JQuery finish() {
        this.js.call("finish", new Object[0]);
        return this;
    }

    public JQuery finish(String queue) {
        this.js.call("finish", queue);
        return this;
    }

    public JQuery first() {
        return new JQuery(this.js.call("first", new Object[0]));
    }

    public JQuery focus(EventHandler handler) {
        return this.bind("focus", handler);
    }

    public JQuery focus(Object data, EventHandler handler) {
        return this.bind("focus", data, handler);
    }

    public JQuery focus() {
        this.js.call("focus", new Object[0]);
        return this;
    }

    public JQuery focusin(EventHandler handler) {
        return this.bind("focusin", handler);
    }

    public JQuery focusin(Object data, EventHandler handler) {
        return this.bind("focusin", data, handler);
    }

    public JQuery focusin() {
        this.js.call("focusin", new Object[0]);
        return this;
    }

    public JQuery focusout(EventHandler handler) {
        return this.bind("focusout", handler);
    }

    public JQuery focusout(Object data, EventHandler handler) {
        return this.bind("focusout", data, handler);
    }

    public JQuery focusout() {
        this.js.call("focusout", new Object[0]);
        return this;
    }

    public Element[] get() {
        JSObject els = (JSObject)this.js.call("get", new Object[0]);
        int count = (Integer)els.getMember("length");
        Element[] r = new Element[count];
        for (int i = 0; i < count; ++i) {
            r[i] = (Element)els.getSlot(i);
        }
        return r;
    }

    public Object get(int i) {
        return this.js.call("get", i);
    }

    public JQuery has(String selector) {
        return new JQuery(this.js.call("has", selector));
    }

    public JQuery has(Element selector) {
        return new JQuery(this.js.call("has", selector));
    }

    public boolean hasClass(String className) {
        return (Boolean)this.js.call("hasClass", className);
    }

    public int height() {
        return (Integer)this.js.call("height", new Object[0]);
    }

    public JQuery height(String value) {
        this.js.call("height", value);
        return this;
    }

    public JQuery height(IntIntStringFunction function) {
        this.js.call("height", JQuery.createFunction(function));
        return this;
    }

    public JQuery hide() {
        this.js.call("hide", new Object[0]);
        return this;
    }

    public JQuery hide(String duration) {
        this.js.call("hide", duration);
        return this;
    }

    public JQuery hide(String duration, VoidFunction complete) {
        this.js.call("hide", duration, JQuery.createFunction(complete));
        return this;
    }

    public JQuery hide(AnimationOptions options) {
        this.js.call("hide", options.toJSObject());
        return this;
    }

    public JQuery hide(String duration, String easing) {
        this.js.call("hide", duration, easing);
        return this;
    }

    public JQuery hide(String duration, String easing, VoidFunction complete) {
        this.js.call("hide", duration, easing, JQuery.createFunction(complete));
        return this;
    }

    public JQuery hover(EventHandler handler) {
        return this.bind("hover", handler);
    }

    public JQuery hover(Object data, EventHandler handler) {
        return this.bind("hover", data, handler);
    }

    public JQuery hover() {
        this.js.call("hover", new Object[0]);
        return this;
    }

    public String html() {
        return (String)this.js.call("html", new Object[0]);
    }

    public JQuery html(String htmlString) {
        return new JQuery(this.js.call("html", htmlString));
    }

    public JQuery html(IntStringStringFunction function) {
        return new JQuery(this.js.call("html", JQuery.createFunction(function)));
    }

    public int index() {
        return (Integer)this.js.call("index", new Object[0]);
    }

    public int index(String selector) {
        return (Integer)this.js.call("index", selector);
    }

    public int index(Element element) {
        return (Integer)this.js.call("index", element);
    }

    public int index(JQuery element) {
        return (Integer)this.js.call("index", element.js);
    }

    public int innerHeight() {
        return (Integer)this.js.call("innerHeight", new Object[0]);
    }

    public JQuery innerHeight(String height) {
        this.js.call("innerHeight", height);
        return this;
    }

    public JQuery innerHeight(int height) {
        this.js.call("innerHeight", height);
        return this;
    }

    public JQuery innerHeight(IntIntStringFunction function) {
        this.js.call("innerHeight", JQuery.createFunction(function));
        return this;
    }

    public int innerWidth() {
        return (Integer)this.js.call("innerWidth", new Object[0]);
    }

    public JQuery innerWidth(String height) {
        this.js.call("innerWidth", height);
        return this;
    }

    public JQuery innerWidth(int height) {
        this.js.call("innerWidth", height);
        return this;
    }

    public JQuery innerWidth(IntIntStringFunction function) {
        this.js.call("innerWidth", JQuery.createFunction(function));
        return this;
    }

    public JQuery insertAfter(String target) {
        return new JQuery(this.js.call("insertAfter", target));
    }

    public JQuery insertAfter(Element target) {
        return new JQuery(this.js.call("insertAfter", target));
    }

    public JQuery insertAfter(Element ... target) {
        return new JQuery(this.js.call("insertAfter", JQuery.createArray(target)));
    }

    public JQuery insertAfter(JQuery target) {
        return new JQuery(this.js.call("insertAfter", target.js));
    }

    public JQuery insertBefore(String target) {
        return new JQuery(this.js.call("insertBefore", target));
    }

    public JQuery insertBefore(Element target) {
        return new JQuery(this.js.call("insertBefore", target));
    }

    public JQuery insertBefore(Element ... target) {
        return new JQuery(this.js.call("insertBefore", JQuery.createArray(target)));
    }

    public JQuery insertBefore(JQuery target) {
        return new JQuery(this.js.call("insertBefore", target.js));
    }

    public boolean is(String selector) {
        return (Boolean)this.js.call("is", selector);
    }

    public boolean is(IntElementBooleanFunction function) {
        return (Boolean)this.js.call("is", JQuery.createFunction(function));
    }

    public boolean is(JQuery selection) {
        return (Boolean)this.js.call("is", selection.js);
    }

    public boolean is(Element ... elements) {
        return (Boolean)this.js.call("is", JQuery.createArray(elements));
    }

    public JQuery keydown(EventHandler handler) {
        return this.bind("keydown", handler);
    }

    public JQuery keydown(Object data, EventHandler handler) {
        return this.bind("keydown", data, handler);
    }

    public JQuery keydown() {
        this.js.call("keydown", new Object[0]);
        return this;
    }

    public JQuery keypress(EventHandler handler) {
        return this.bind("keypress", handler);
    }

    public JQuery keypress(Object data, EventHandler handler) {
        return this.bind("keypress", data, handler);
    }

    public JQuery keypress() {
        this.js.call("keypress", new Object[0]);
        return this;
    }

    public JQuery keyup(EventHandler handler) {
        return this.bind("keyup", handler);
    }

    public JQuery keyup(Object data, EventHandler handler) {
        return this.bind("keyup", data, handler);
    }

    public JQuery keyup() {
        this.js.call("keyup", new Object[0]);
        return this;
    }

    public JQuery last() {
        return new JQuery(this.js.call("last", new Object[0]));
    }

    public JQuery map(IntElementObjectFunction function) {
        return new JQuery(this.js.call("map", JQuery.createFunction(function)));
    }

    public JQuery mousedown(EventHandler handler) {
        return this.bind("mousedown", handler);
    }

    public JQuery mousedown(Object data, EventHandler handler) {
        return this.bind("mousedown", data, handler);
    }

    public JQuery mousedown() {
        this.js.call("mousedown", new Object[0]);
        return this;
    }

    public JQuery mouseenter(EventHandler handler) {
        return this.bind("mouseenter", handler);
    }

    public JQuery mouseenter(Object data, EventHandler handler) {
        return this.bind("mouseenter", data, handler);
    }

    public JQuery mouseenter() {
        this.js.call("mouseenter", new Object[0]);
        return this;
    }

    public JQuery mouseleave(EventHandler handler) {
        return this.bind("mouseleave", handler);
    }

    public JQuery mouseleave(Object data, EventHandler handler) {
        return this.bind("mouseleave", data, handler);
    }

    public JQuery mouseleave() {
        this.js.call("mouseleave", new Object[0]);
        return this;
    }

    public JQuery mousemove(EventHandler handler) {
        return this.bind("mousemove", handler);
    }

    public JQuery mousemove(Object data, EventHandler handler) {
        return this.bind("mousemove", data, handler);
    }

    public JQuery mousemove() {
        this.js.call("mousemove", new Object[0]);
        return this;
    }

    public JQuery mouseout(EventHandler handler) {
        return this.bind("mouseout", handler);
    }

    public JQuery mouseout(Object data, EventHandler handler) {
        return this.bind("mouseout", data, handler);
    }

    public JQuery mouseout() {
        this.js.call("mouseout", new Object[0]);
        return this;
    }

    public JQuery mouseover(EventHandler handler) {
        return this.bind("mouseover", handler);
    }

    public JQuery mouseover(Object data, EventHandler handler) {
        return this.bind("mouseover", data, handler);
    }

    public JQuery mouseover() {
        this.js.call("mouseover", new Object[0]);
        return this;
    }

    public JQuery mouseup(EventHandler handler) {
        return this.bind("mouseup", handler);
    }

    public JQuery mouseup(Object data, EventHandler handler) {
        return this.bind("mouseup", data, handler);
    }

    public JQuery mouseup() {
        this.js.call("mouseup", new Object[0]);
        return this;
    }

    public JQuery next() {
        return new JQuery(this.js.call("next", new Object[0]));
    }

    public JQuery next(String selector) {
        return new JQuery(this.js.call("next", selector));
    }

    public JQuery nextAll() {
        return new JQuery(this.js.call("nextAll", new Object[0]));
    }

    public JQuery nextAll(String selector) {
        return new JQuery(this.js.call("nextAll", selector));
    }

    public JQuery nextUntil() {
        return new JQuery(this.js.call("nextUntil", new Object[0]));
    }

    public JQuery nextUntil(String selector) {
        return new JQuery(this.js.call("nextUntil", selector));
    }

    public JQuery nextUntil(String selector, String filter) {
        return new JQuery(this.js.call("nextUntil", selector, filter));
    }

    public JQuery nextUntil(Element element) {
        return new JQuery(this.js.call("nextUntil", element));
    }

    public JQuery nextUntil(Element element, String filter) {
        return new JQuery(this.js.call("nextUntil", element, filter));
    }

    public JQuery nextUntil(JQuery element) {
        return new JQuery(this.js.call("nextUntil", element.js));
    }

    public JQuery nextUntil(JQuery element, String filter) {
        return new JQuery(this.js.call("nextUntil", element, filter));
    }

    public JQuery not(String selector) {
        return new JQuery(this.js.call("not", selector));
    }

    public JQuery not(IntElementBooleanFunction function) {
        return new JQuery(this.js.call("not", JQuery.createFunction(function)));
    }

    public JQuery not(JQuery selection) {
        return new JQuery(this.js.call("not", selection.js));
    }

    public JQuery off(String events) {
        this.js.call("off", events);
        return this;
    }

    public JQuery off(String events, String selector) {
        this.js.call("off", events, selector);
        return this;
    }

    public JQuery off(String events, EventHandler handler) {
        this.js.call("off", events, JQuery.createFunction(handler));
        return this;
    }

    public JQuery off(String events, String selector, EventHandler handler) {
        this.js.call("off", events, selector, JQuery.createFunction(handler));
        return this;
    }

    public JQuery off(PlainObject events) {
        this.js.call("off", events.toJSObject());
        return this;
    }

    public JQuery off(PlainObject events, String selector) {
        this.js.call("off", events.toJSObject(), selector);
        return this;
    }

    public JQuery off(Event event) {
        this.js.call("off", event);
        return this;
    }

    public JQuery off() {
        this.js.call("off", new Object[0]);
        return this;
    }

    public Offset offset() {
        return new Offset((JSObject)this.js.call("offset", new Object[0]));
    }

    public JQuery offset(Offset coordinates) {
        this.js.call("offset", coordinates);
        return this;
    }

    public JQuery offset(IntOffsetOffsetFunction function) {
        this.js.call("offset", JQuery.createFunction(function));
        return this;
    }

    public JQuery offsetParent() {
        return new JQuery(this.js.call("offsetParent", new Object[0]));
    }

    public JQuery on(String events, EventHandler handler) {
        this.js.call("on", events, JQuery.createFunction(handler));
        return this;
    }

    public JQuery on(String events, String selector, EventHandler handler) {
        this.js.call("on", events, selector, JQuery.createFunction(handler));
        return this;
    }

    public JQuery on(String events, Object data, EventHandler handler) {
        this.js.call("on", events, data, JQuery.createFunction(handler));
        return this;
    }

    public JQuery on(String events, String selector, Object data, EventHandler handler) {
        this.js.call("on", events, selector, data, JQuery.createFunction(handler));
        return this;
    }

    public JQuery on(PlainObject events) {
        this.js.call("on", events.toJSObject());
        return this;
    }

    public JQuery on(PlainObject events, String selector) {
        this.js.call("on", events.toJSObject(), selector);
        return this;
    }

    public JQuery on(PlainObject events, Object data) {
        this.js.call("on", events.toJSObject(), data);
        return this;
    }

    public JQuery on(PlainObject events, String selector, Object data) {
        this.js.call("on", events.toJSObject(), selector, data);
        return this;
    }

    public JQuery one(String events, EventHandler handler) {
        this.js.call("one", events, JQuery.createFunction(handler));
        return this;
    }

    public JQuery one(String events, PlainObject data, EventHandler handler) {
        this.js.call("one", events, data.toJSObject(), JQuery.createFunction(handler));
        return this;
    }

    public JQuery one(String events, String selector, EventHandler handler) {
        this.js.call("one", events, selector, JQuery.createFunction(handler));
        return this;
    }

    public JQuery one(String events, Object data, EventHandler handler) {
        this.js.call("one", events, data, JQuery.createFunction(handler));
        return this;
    }

    public JQuery one(String events, String selector, Object data, EventHandler handler) {
        this.js.call("one", events, selector, data, JQuery.createFunction(handler));
        return this;
    }

    public JQuery one(PlainObject events) {
        this.js.call("one", events.toJSObject());
        return this;
    }

    public JQuery one(PlainObject events, String selector) {
        this.js.call("one", events.toJSObject(), selector);
        return this;
    }

    public JQuery one(PlainObject events, Object data) {
        this.js.call("one", events.toJSObject(), data);
        return this;
    }

    public JQuery one(PlainObject events, String selector, Object data) {
        this.js.call("one", events.toJSObject(), selector, data);
        return this;
    }

    public int outerHeight() {
        return (Integer)this.js.call("outerHeight", new Object[0]);
    }

    public JQuery outerHeight(String height) {
        this.js.call("outerHeight", height);
        return this;
    }

    public JQuery outerHeight(int height) {
        this.js.call("outerHeight", height);
        return this;
    }

    public JQuery outerHeight(IntIntStringFunction function) {
        this.js.call("outerHeight", JQuery.createFunction(function));
        return this;
    }

    public int outerWidth() {
        return (Integer)this.js.call("outerWidth", new Object[0]);
    }

    public JQuery outerWidth(String width) {
        this.js.call("outerWidth", width);
        return this;
    }

    public JQuery outerWidth(int width) {
        this.js.call("outerWidth", width);
        return this;
    }

    public JQuery outerWidth(IntIntStringFunction function) {
        this.js.call("outerWidth", JQuery.createFunction(function));
        return this;
    }

    public JQuery parent() {
        return new JQuery(this.js.call("parent", new Object[0]));
    }

    public JQuery parent(String selector) {
        return new JQuery(this.js.call("parent", selector));
    }

    public JQuery parents() {
        return new JQuery(this.js.call("parents", new Object[0]));
    }

    public JQuery parents(String selector) {
        return new JQuery(this.js.call("parents", selector));
    }

    public JQuery parentsUntil() {
        return new JQuery(this.js.call("parentsUntil", new Object[0]));
    }

    public JQuery parentsUntil(String selector) {
        return new JQuery(this.js.call("parentsUntil", selector));
    }

    public JQuery parentsUntil(String selector, String filter) {
        return new JQuery(this.js.call("parentsUntil", selector, filter));
    }

    public JQuery parentsUntil(Element element) {
        return new JQuery(this.js.call("parentsUntil", element));
    }

    public JQuery parentsUntil(Element element, String filter) {
        return new JQuery(this.js.call("parentsUntil", element, filter));
    }

    public JQuery parentsUntil(JQuery element) {
        return new JQuery(this.js.call("parentsUntil", element.js));
    }

    public JQuery parentsUntil(JQuery element, String filter) {
        return new JQuery(this.js.call("parentsUntil", element.js, filter));
    }

    public Offset position() {
        return new Offset((JSObject)this.js.call("position", new Object[0]));
    }

    public JQuery prepend(String content) {
        return new JQuery(this.js.call("prepend", content));
    }

    public JQuery prepend(Element content) {
        return new JQuery(this.js.call("prepend", content));
    }

    public JQuery prepend(Element ... content) {
        return new JQuery(this.js.call("prepend", JQuery.createArray(content)));
    }

    public JQuery prepend(JQuery content) {
        return new JQuery(this.js.call("prepend", content.js));
    }

    public JQuery prepend(IntStringStringFunction function) {
        return new JQuery(this.js.call("prepend", function));
    }

    public JQuery prependTo(String target) {
        return new JQuery(this.js.call("prependTo", target));
    }

    public JQuery prependTo(Element target) {
        return new JQuery(this.js.call("prependTo", target));
    }

    public JQuery prependTo(Element ... target) {
        return new JQuery(this.js.call("prependTo", JQuery.createArray(target)));
    }

    public JQuery prependTo(JQuery target) {
        return new JQuery(this.js.call("prependTo", target.js));
    }

    public JQuery prev() {
        return new JQuery(this.js.call("prev", new Object[0]));
    }

    public JQuery prev(String selector) {
        return new JQuery(this.js.call("prev", selector));
    }

    public JQuery prevAll() {
        return new JQuery(this.js.call("prevAll", new Object[0]));
    }

    public JQuery prevAll(String selector) {
        return new JQuery(this.js.call("prevAll", selector));
    }

    public JQuery prevUntil() {
        return new JQuery(this.js.call("prevUntil", new Object[0]));
    }

    public JQuery prevUntil(String selector) {
        return new JQuery(this.js.call("prevUntil", selector));
    }

    public JQuery prevUntil(String selector, String filter) {
        return new JQuery(this.js.call("prevUntil", selector, filter));
    }

    public JQuery prevUntil(Element element) {
        return new JQuery(this.js.call("prevUntil", element));
    }

    public JQuery prevUntil(Element element, String filter) {
        return new JQuery(this.js.call("prevUntil", element, filter));
    }

    public JQuery prevUntil(JQuery element) {
        return new JQuery(this.js.call("prevUntil", element.js));
    }

    public JQuery prevUntil(JQuery element, String filter) {
        return new JQuery(this.js.call("prevUntil", element.js, filter));
    }

    public Promise promise() {
        return new Promise((JSObject)this.js.call("promise", new Object[0]));
    }

    public Promise promise(String type) {
        return new Promise((JSObject)this.js.call("promise", type));
    }

    public Promise promise(String type, Object target) {
        return new Promise((JSObject)this.js.call("promise", type, target));
    }

    public Object prop(String propertyName) {
        return this.js.call("prop", propertyName);
    }

    public JQuery prop(String propertyName, Object value) {
        return new JQuery(this.js.call("prop", propertyName, value));
    }

    public Object prop(Object properties) {
        return this.js.call("prop", properties);
    }

    public Object prop(String propertyName, IntObjectObjectFunction function) {
        return this.js.call("prop", propertyName, JQuery.createFunction(function));
    }

    public Object[] queue() {
        return (Object[])this.js.call("queue", new Object[0]);
    }

    public Object[] queue(String queueName) {
        return (Object[])this.js.call("queue", queueName);
    }

    public JQuery queue(Object[] newQueue) {
        this.js.call("queue", JQuery.createArray(newQueue));
        return this;
    }

    public JQuery queue(String queueName, Object ... newQueue) {
        this.js.call("queue", queueName, JQuery.createArray(newQueue));
        return this;
    }

    public JQuery queue(VoidFunctionFunction callback) {
        this.js.call("queue", JQuery.createFunction(callback));
        return this;
    }

    public JQuery queue(String queueName, VoidFunctionFunction callback) {
        this.js.call("queue", queueName, JQuery.createFunction(callback));
        return this;
    }

    public JQuery ready(VoidFunction function) {
        readyFunctions.add(function);
        return this;
    }

    public JQuery remove() {
        return new JQuery(this.js.call("remove", new Object[0]));
    }

    public JQuery remove(String selector) {
        return new JQuery(this.js.call("remove", selector));
    }

    public JQuery removeAttr(String attributeName) {
        this.js.call("removeAttr", attributeName);
        return this;
    }

    public JQuery removeClass() {
        this.js.call("removeClass", new Object[0]);
        return this;
    }

    public JQuery removeClass(String classname) {
        this.js.call("removeClass", classname);
        return this;
    }

    public JQuery removeClass(IntStringStringFunction function) {
        this.js.call("removeClass", JQuery.createFunction(function));
        return this;
    }

    public JQuery removeData() {
        this.js.call("removeData", new Object[0]);
        return this;
    }

    public JQuery removeData(String name) {
        this.js.call("removeData", name);
        return this;
    }

    public JQuery removeData(String ... names) {
        this.js.call("removeData", JQuery.createArray(names));
        return this;
    }

    public JQuery removeProp(String propertyName) {
        this.js.call("removeProp", propertyName);
        return this;
    }

    public JQuery replaceAll(String target) {
        return new JQuery(this.js.call("replaceAll", target));
    }

    public JQuery replaceAll(JQuery target) {
        return new JQuery(this.js.call("replaceAll", target.js));
    }

    public JQuery replaceAll(Element target) {
        return new JQuery(this.js.call("replaceAll", target));
    }

    public JQuery replaceAll(Element ... target) {
        return new JQuery(this.js.call("replaceAll", JQuery.createArray(target)));
    }

    public JQuery replaceWith(String newContent) {
        return new JQuery(this.js.call("replaceWith", newContent));
    }

    public JQuery replaceWith(Element newContent) {
        return new JQuery(this.js.call("replaceWith", newContent));
    }

    public JQuery replaceWith(Element ... newContent) {
        return new JQuery(this.js.call("replaceWith", JQuery.createArray(newContent)));
    }

    public JQuery replaceWith(JQuery newContent) {
        return new JQuery(this.js.call("replaceWith", newContent.js));
    }

    public JQuery replaceWith(JQueryFunction newContent) {
        return new JQuery(this.js.call("replaceWith", new Object[0]));
    }

    public JQuery resize() {
        this.js.call("resize", new Object[0]);
        return this;
    }

    public JQuery resize(EventHandler handler) {
        return this.bind("resize", handler);
    }

    public JQuery resize(Object eventData, EventHandler handler) {
        return this.bind("resize", eventData, handler);
    }

    public JQuery scroll() {
        this.js.call("scroll", new Object[0]);
        return this;
    }

    public JQuery scroll(EventHandler handler) {
        return this.bind("scroll", handler);
    }

    public JQuery scroll(Object eventData, EventHandler handler) {
        return this.bind("scroll", eventData, handler);
    }

    public int scrollLeft() {
        return (Integer)this.js.call("scrollLeft", new Object[0]);
    }

    public int scrollLeft(int value) {
        return (Integer)this.js.call("scrollLeft", value);
    }

    public int scrollTop() {
        return (Integer)this.js.call("scrollTop", new Object[0]);
    }

    public int scrollTop(int value) {
        return (Integer)this.js.call("scrollTop", value);
    }

    public JQuery select() {
        this.js.call("select", new Object[0]);
        return this;
    }

    public JQuery select(EventHandler handler) {
        return this.bind("select", handler);
    }

    public JQuery select(Object eventData, EventHandler handler) {
        return this.bind("select", eventData, handler);
    }

    public JQuery show() {
        this.js.call("show", new Object[0]);
        return this;
    }

    public JQuery show(String duration) {
        this.js.call("show", duration);
        return this;
    }

    public JQuery show(String duration, VoidFunction complete) {
        this.js.call("show", duration, JQuery.createFunction(complete));
        return this;
    }

    public JQuery show(AnimationOptions options) {
        this.js.call("show", options.toJSObject());
        return this;
    }

    public JQuery show(String duration, String easing) {
        this.js.call("show", duration, easing);
        return this;
    }

    public JQuery show(String duration, String easing, VoidFunction complete) {
        this.js.call("show", duration, easing, JQuery.createFunction(complete));
        return this;
    }

    public JQuery siblings() {
        return new JQuery(this.js.call("siblings", new Object[0]));
    }

    public JQuery siblings(String selector) {
        return new JQuery(this.js.call("siblings", selector));
    }

    public int size() {
        return (Integer)this.js.call("size", new Object[0]);
    }

    public JQuery slice(int start) {
        return new JQuery(this.js.call("slice", start));
    }

    public JQuery slice(int start, int end) {
        return new JQuery(this.js.call("slice", start, end));
    }

    public JQuery slideToggle() {
        this.js.call("slideToggle", new Object[0]);
        return this;
    }

    public JQuery slideToggle(String duration) {
        this.js.call("slideToggle", duration);
        return this;
    }

    public JQuery slideToggle(String duration, VoidFunction complete) {
        this.js.call("slideToggle", duration, JQuery.createFunction(complete));
        return this;
    }

    public JQuery slideToggle(AnimationOptions options) {
        this.js.call("slideToggle", options.toJSObject());
        return this;
    }

    public JQuery slideToggle(String duration, String easing) {
        this.js.call("slideToggle", duration, easing);
        return this;
    }

    public JQuery slideToggle(String duration, String easing, VoidFunction complete) {
        this.js.call("slideToggle", duration, easing, JQuery.createFunction(complete));
        return this;
    }

    public JQuery slideDown() {
        this.js.call("slideDown", new Object[0]);
        return this;
    }

    public JQuery slideDown(String duration) {
        this.js.call("slideDown", duration);
        return this;
    }

    public JQuery slideDown(String duration, VoidFunction complete) {
        this.js.call("slideDown", duration, JQuery.createFunction(complete));
        return this;
    }

    public JQuery slideDown(AnimationOptions options) {
        this.js.call("slideDown", options.toJSObject());
        return this;
    }

    public JQuery slideDown(String duration, String easing) {
        this.js.call("slideDown", duration, easing);
        return this;
    }

    public JQuery slideDown(String duration, String easing, VoidFunction complete) {
        this.js.call("slideDown", duration, easing, JQuery.createFunction(complete));
        return this;
    }

    public JQuery slideUp() {
        this.js.call("slideUp", new Object[0]);
        return this;
    }

    public JQuery slideUp(String duration) {
        this.js.call("slideUp", duration);
        return this;
    }

    public JQuery slideUp(String duration, VoidFunction complete) {
        this.js.call("slideUp", duration, JQuery.createFunction(complete));
        return this;
    }

    public JQuery slideUp(AnimationOptions options) {
        this.js.call("slideUp", options.toJSObject());
        return this;
    }

    public JQuery slideUp(String duration, String easing) {
        this.js.call("slideUp", duration, easing);
        return this;
    }

    public JQuery slideUp(String duration, String easing, VoidFunction complete) {
        this.js.call("slideUp", duration, easing);
        return this;
    }

    public JQuery stop() {
        this.js.call("stop", new Object[0]);
        return this;
    }

    public JQuery stop(boolean clearQueue) {
        this.js.call("stop", clearQueue);
        return this;
    }

    public JQuery stop(boolean clearQueue, boolean jumpToEnd) {
        this.js.call("stop", clearQueue, jumpToEnd);
        return this;
    }

    public JQuery stop(String queue) {
        this.js.call("stop", queue);
        return this;
    }

    public JQuery stop(String queue, boolean clearQueue) {
        this.js.call("stop", queue, clearQueue);
        return this;
    }

    public JQuery stop(String queue, boolean clearQueue, boolean jumpToEnd) {
        this.js.call("stop", queue, clearQueue, jumpToEnd);
        return this;
    }

    public JQuery submit(EventHandler handler) {
        return this.bind("submit", handler);
    }

    public JQuery submit(Object eventData, EventHandler handler) {
        return this.bind("submit", eventData, handler);
    }

    public JQuery submit() {
        this.js.call("submit", new Object[0]);
        return this;
    }

    public String text() {
        return (String)this.js.call("text", new Object[0]);
    }

    public JQuery text(Object str) {
        return new JQuery(this.js.call("text", str.toString()));
    }

    public JQuery text(IntStringStringFunction function) {
        return new JQuery(this.js.call("text", JQuery.createFunction(function)));
    }

    public Element[] toArray() {
        JSObject result = (JSObject)this.js.call("toArray", new Object[0]);
        Element[] els = new Element[((Integer)result.getMember("length")).intValue()];
        for (int i = 0; i < els.length; ++i) {
            els[i] = (Element)result.getSlot(i);
        }
        return els;
    }

    public JQuery toggle() {
        this.js.call("toggle", new Object[0]);
        return this;
    }

    public JQuery toggle(int duration) {
        this.js.call("toggle", duration);
        return this;
    }

    public JQuery toggle(int duration, VoidFunction complete) {
        this.js.call("toggle", duration, JQuery.createFunction(complete));
        return this;
    }

    public JQuery toggle(AnimationOptions options) {
        this.js.call("toggle", options.toJSObject());
        return this;
    }

    public JQuery toggle(String duration, String easing) {
        this.js.call("toggle", duration, easing);
        return this;
    }

    public JQuery toggle(String duration, String easing, VoidFunction complete) {
        this.js.call("toggle", duration, easing, JQuery.createFunction(complete));
        return this;
    }

    public JQuery toggle(boolean display) {
        this.js.call("toggle", display);
        return this;
    }

    public JQuery toggleClass(String className) {
        this.js.call("toggle", className);
        return this;
    }

    public JQuery toggleClass(String className, boolean state) {
        this.js.call("toggle", className, state);
        return this;
    }

    public JQuery toggleClass() {
        this.js.call("toggle", new Object[0]);
        return this;
    }

    public JQuery toggleClass(boolean state) {
        this.js.call("toggle", state);
        return this;
    }

    public JQuery toggleClass(IntStringBooleanStringFunction function) {
        this.js.call("toggleClass", JQuery.createFunction(function));
        return this;
    }

    public JQuery toggleClass(IntStringBooleanStringFunction function, boolean state) {
        this.js.call("toggleClass", JQuery.createFunction(function), state);
        return this;
    }

    public JQuery trigger(String eventType) {
        this.js.call("trigger", eventType);
        return this;
    }

    public JQuery trigger(String eventType, PlainObject extraParameters) {
        this.js.call("trigger", eventType, extraParameters.toJSObject());
        return this;
    }

    public JQuery trigger(String eventType, Object ... extraParameters) {
        this.js.call("trigger", eventType, JQuery.createArray(extraParameters));
        return this;
    }

    public JQuery trigger(Event event) {
        this.js.call("trigger", event.js);
        return this;
    }

    public JQuery trigger(Event event, PlainObject extraParameters) {
        this.js.call("trigger", event.js, extraParameters.toJSObject());
        return this;
    }

    public JQuery trigger(Event event, Object ... extraParameters) {
        this.js.call("trigger", event.js, JQuery.createArray(extraParameters));
        return this;
    }

    public JQuery triggerHandler(String eventType) {
        this.js.call("triggerHandler", eventType);
        return this;
    }

    public JQuery triggerHandler(String eventType, PlainObject extraParameters) {
        this.js.call("triggerHandler", eventType, extraParameters.toJSObject());
        return this;
    }

    public JQuery triggerHandler(String eventType, Object ... extraParameters) {
        this.js.call("triggerHandler", eventType, JQuery.createArray(extraParameters));
        return this;
    }

    public JQuery triggerHandler(Event event) {
        this.js.call("triggerHandler", new Object[0]);
        return this;
    }

    public JQuery triggerHandler(Event event, PlainObject extraParameters) {
        this.js.call("triggerHandler", event.js, extraParameters.toJSObject());
        return this;
    }

    public JQuery triggerHandler(Event event, Object ... extraParameters) {
        this.js.call("triggerHandler", event.js, JQuery.createArray(extraParameters));
        return this;
    }

    public JQuery unbind() {
        this.js.call("unbind", new Object[0]);
        return this;
    }

    public JQuery unbind(String eventType) {
        this.js.call("unbind", eventType);
        return this;
    }

    public JQuery unbind(String eventType, EventHandler handler) {
        this.js.call("unbind", eventType, eventHandlerMap.get(handler.hashCode()));
        return this;
    }

    public JQuery unbind(String eventType, boolean b) {
        this.js.call("unbind", eventType, false);
        return this;
    }

    public JQuery unbind(Event event) {
        this.js.call("unbind", event.js);
        return this;
    }

    public JQuery undelegate() {
        this.js.call("undelegate", new Object[0]);
        return this;
    }

    public JQuery undelegate(String selector, String eventType) {
        this.js.call("undelegate", selector, eventType);
        return this;
    }

    public JQuery undelegate(String selector, String eventType, EventHandler handler) {
        return new JQuery(this.js.call("undelegate", selector, eventType, JQuery.createFunction(handler)));
    }

    public JQuery undelegate(String selector, Object events) {
        return new JQuery(this.js.call("undelegate", selector, events));
    }

    public JQuery undelegate(String namespace) {
        this.js.call("undelegate", namespace);
        return this;
    }

    public JQuery unwrap() {
        return new JQuery(this.js.call("unwrap", new Object[0]));
    }

    public Object val() {
        return this.js.call("val", new Object[0]);
    }

    public JQuery val(Object value) {
        this.js.call("val", value);
        return this;
    }

    public JQuery val(IntStringStringFunction function) {
        this.js.call("val", JQuery.createFunction(function));
        return this;
    }

    public double width() {
        return ((Integer)this.js.call("width", new Object[0])).intValue();
    }

    public JQuery width(double value) {
        this.js.call("width", value);
        return this;
    }

    public JQuery width(IntIntStringFunction function) {
        return new JQuery(this.js.call("width", JQuery.createFunction(function)));
    }

    public JQuery width(IntIntIntFunction function) {
        return new JQuery(this.js.call("width", JQuery.createFunction(function)));
    }

    public JQuery wrap(String selectorOrHTML) {
        return new JQuery(this.js.call("wrap", selectorOrHTML));
    }

    public JQuery wrap(JQuery wrappingElement) {
        return new JQuery(this.js.call("wrap", wrappingElement.js));
    }

    public JQuery wrap(Element wrappingElement) {
        return new JQuery(this.js.call("wrap", wrappingElement));
    }

    public JQuery wrap(IntStringFunction function) {
        return new JQuery(this.js.call("wrap", JQuery.createFunction(function)));
    }

    public JQuery wrapAll(String selectorOrHTML) {
        return new JQuery(this.js.call("wrapAll", selectorOrHTML));
    }

    public JQuery wrapAll(JQuery wrappingElement) {
        return new JQuery(this.js.call("wrapAll", wrappingElement.js));
    }

    public JQuery wrapAll(Element wrappingElement) {
        return new JQuery(this.js.call("wrapAll", wrappingElement));
    }

    public JQuery wrapAll(IntStringFunction function) {
        return new JQuery(this.js.call("wrapAll", JQuery.createFunction(function)));
    }

    public JQuery wrapInner(String selectorOrHTML) {
        return new JQuery(this.js.call("wrapInner", selectorOrHTML));
    }

    public JQuery wrapInner(JQuery wrappingElement) {
        return new JQuery(this.js.call("wrapInner", wrappingElement.js));
    }

    public JQuery wrapInner(Element wrappingElement) {
        return new JQuery(this.js.call("wrapInner", wrappingElement));
    }

    public JQuery wrapInner(IntStringFunction function) {
        return new JQuery(this.js.call("wrapInner", JQuery.createFunction(function)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JQuery[");
        if (this.length > 0) {
            sb.append(this.get(0));
            for (int i = 1; i < this.length; ++i) {
                sb.append(",");
                sb.append(this.get(i).toString());
            }
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        window = null;
        config = new Config();
    }

    private static class Config {
        String local = DEFAULT_JQUERY_LOCAL;
        String remote = "http://ajax.googleapis.com/ajax/libs/jquery/2.2.0/jquery.min.js";
        boolean clearReadyFunctions = true;

        Config() {
        }
    }
}

