/*
 * Decompiled with CFR 0.152.
 */
package com.belteshazzar.jquery;

import com.belteshazzar.jquery.JQuery;
import com.belteshazzar.jquery.functions.PromiseBooleanVoidFunction;
import com.belteshazzar.jquery.functions.PromiseIntIntVoidFunction;
import com.belteshazzar.jquery.functions.PromiseVoidFunction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.javascript.JSObject;

public class PlainObject {
    private Map<String, Object> values = new HashMap<String, Object>();

    public PlainObject() {
    }

    public PlainObject(JSObject js) {
        this();
        JSObject names = (JSObject)js.eval("(function (obj) { var names = []; for (var name in obj) names.push(name); return names; })(this)");
        int count = (Integer)names.getMember("length");
        for (int i = 0; i < count; ++i) {
            String name = (String)names.getSlot(i);
            this.values.put(name, js.getMember(name));
        }
    }

    public PlainObject set(String key, Object value) {
        this.values.put(key, value);
        return this;
    }

    public Object get(String key) {
        return this.values.get(key);
    }

    public Set<String> keys() {
        return this.values.keySet();
    }

    public Collection<Object> values() {
        return this.values.values();
    }

    public Set<Map.Entry<String, Object>> entries() {
        return this.values.entrySet();
    }

    public PlainObject remove(String key) {
        this.values.remove(key);
        return this;
    }

    public PlainObject empty() {
        this.values.clear();
        return this;
    }

    public JSObject toJSObject() {
        JSObject js = JQuery.createObject();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof PromiseVoidFunction) {
                js.setMember(name, JQuery.createFunction((PromiseVoidFunction)value));
                continue;
            }
            if (value instanceof PromiseBooleanVoidFunction) {
                js.setMember(name, JQuery.createFunction((PromiseBooleanVoidFunction)value));
                continue;
            }
            if (value instanceof PromiseIntIntVoidFunction) {
                js.setMember(name, JQuery.createFunction((PromiseIntIntVoidFunction)value));
                continue;
            }
            js.setMember(name, value);
        }
        return js;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PlainObject[");
        Iterator<Map.Entry<String, Object>> entries = this.entries().iterator();
        if (entries.hasNext()) {
            Map.Entry<String, Object> entry = entries.next();
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            while (entries.hasNext()) {
                entry = entries.next();
                sb.append(",");
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(entry.getValue());
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlainObject other = (PlainObject)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }
}

