/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.comms;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IEventCallback;
import com.bitheads.braincloud.client.IFileUploadCallback;
import com.bitheads.braincloud.client.IGlobalErrorCallback;
import com.bitheads.braincloud.client.INetworkErrorCallback;
import com.bitheads.braincloud.client.IRewardCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.FileUploader;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.comms.ServerResponse;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BrainCloudRestClient
implements Runnable {
    private static long NO_PACKET_EXPECTED = -1L;
    private BrainCloudClient _client;
    private String _serverUrl;
    private String _uploadUrl;
    private String _appId;
    private String _secretKey;
    private Map<String, String> _secretMap = new HashMap<String, String>();
    private String _sessionId;
    private long _packetId;
    private long _expectedPacketId;
    private boolean _isAuthenticated = false;
    private boolean _isInitialized = false;
    private boolean _loggingEnabled = false;
    private int _authenticationTimeoutMillis = 15000;
    private boolean _oldStyleStatusMessageErrorCallback = false;
    private boolean _cacheMessagesOnNetworkError = false;
    private long _lastSendTime;
    private long _lastReceivedPacket;
    private boolean _useCompresssion = false;
    private int _uploadLowTransferTimeoutSecs = 120;
    private int _uploadLowTransferThresholdSecs = 50;
    private boolean _blockingQueue = false;
    private boolean _networkErrorCallbackReadyToBeSent = false;
    private IEventCallback _eventCallback = null;
    private IRewardCallback _rewardCallback = null;
    private IFileUploadCallback _fileUploadCallback = null;
    private IGlobalErrorCallback _globalErrorCallback = null;
    private INetworkErrorCallback _networkErrorCallback = null;
    private Thread _thread;
    private final Object _lock = new Object();
    private long _heartbeatIntervalMillis = 30000L;
    private int _maxBundleSize = 10;
    private int _retryCount;
    private ArrayList<Integer> _packetTimeouts = new ArrayList();
    private long _messageQueuePollIntervalMillis = 1000L;
    private int _killSwitchThreshold = 11;
    private boolean _killSwitchEngaged;
    private int _killSwitchErrorCount;
    private String _killSwitchService;
    private String _killSwitchOperation;
    private LinkedBlockingQueue<ServerCall> _waitingQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<ServerCall> _messageQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<ServerCall> _bundleQueue = new LinkedBlockingQueue();
    private LinkedList<ServerCall> _networkErrorMessageQueue = new LinkedList();
    private LinkedList<ServerResponse> _serverResponses = new LinkedList();
    private LinkedList<JSONObject> _eventResponses = new LinkedList();
    private LinkedList<JSONObject> _rewardResponses = new LinkedList();
    private ArrayList<FileUploader> _fileUploads = new ArrayList();
    private int _statusCodeCache;
    private int _reasonCodeCache;
    private String _statusMessageCache;
    private Semaphore _messageQueueCount = new Semaphore(0);
    static final boolean DISABLE_SSL_CHECK = false;

    public BrainCloudRestClient(BrainCloudClient client) {
        this._client = client;
        this.setPacketTimeoutsToDefault();
        this.resetErrorCache();
    }

    public void initialize(String serverUrl, String appId, String secretKey) {
        this.resetCommunication();
        this._expectedPacketId = NO_PACKET_EXPECTED;
        this._serverUrl = serverUrl;
        this._appId = appId;
        this._secretKey = secretKey;
        this._retryCount = 0;
        this._isInitialized = true;
        this._secretMap.put(appId, secretKey);
        String suffix = "/dispatcherv2";
        if (this._serverUrl.endsWith(suffix)) {
            this._serverUrl = this._serverUrl.substring(0, this._serverUrl.length() - suffix.length());
        }
        while (this._serverUrl.length() > 0 && this._serverUrl.charAt(this._serverUrl.length() - 1) == '/') {
            this._serverUrl = this._serverUrl.substring(0, this._serverUrl.length() - 1);
        }
        this._uploadUrl = this._serverUrl + "/uploader";
        this._serverUrl = this._serverUrl + "/dispatcherv2";
        if (this._thread == null) {
            this._thread = new Thread(this);
            this._thread.start();
        }
    }

    public void initializeWithApps(String serverUrl, String appId, Map<String, String> secretMap) {
        this._secretMap = null;
        this._secretMap = secretMap;
        this.initialize(serverUrl, appId, secretMap.get(appId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(ServerCall serverCall) {
        Object object = this._lock;
        synchronized (object) {
            this._waitingQueue.add(serverCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCallbacks() {
        if (this._blockingQueue) {
            if (this._networkErrorCallbackReadyToBeSent) {
                if (this._networkErrorCallback != null) {
                    this._networkErrorCallback.networkError();
                }
                this._networkErrorCallbackReadyToBeSent = false;
            }
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            JSONObject events;
            JSONObject rewards;
            ServerResponse response;
            if (this._messageQueue.peek() == null) {
                this._messageQueue.addAll(this._waitingQueue);
                this._messageQueueCount.release(this._waitingQueue.size());
                this._waitingQueue.clear();
            }
            while ((response = this._serverResponses.poll()) != null) {
                ServerCall sc = response._serverCall;
                if (sc.getCallback() == null) continue;
                if (response._isError) {
                    String jsonError = this._oldStyleStatusMessageErrorCallback ? response._statusMessage : response._data.toString();
                    sc.getCallback().serverError(sc.getServiceName(), sc.getServiceOperation(), response._statusCode, response._reasonCode, jsonError);
                    if (this._globalErrorCallback == null) continue;
                    this._globalErrorCallback.globalError(sc.getServiceName(), sc.getServiceOperation(), response._statusCode, response._reasonCode, jsonError);
                    continue;
                }
                sc.getCallback().serverCallback(sc.getServiceName(), sc.getServiceOperation(), response._data);
            }
            while ((rewards = this._rewardResponses.poll()) != null) {
                this._rewardCallback.rewardCallback(rewards);
            }
            while ((events = this._eventResponses.poll()) != null) {
                this._eventCallback.eventsReceived(events);
            }
            this.runFileUploadCallbacks();
        }
    }

    public void enableCompression() {
        this._useCompresssion = true;
    }

    public void disableCompression() {
        this._useCompresssion = false;
    }

    private void runFileUploadCallbacks() {
        Iterator<FileUploader> iter = this._fileUploads.iterator();
        while (iter.hasNext()) {
            FileUploader temp = iter.next();
            if (temp.getStatus() == FileUploader.FileUploaderStatus.CompleteSuccess) {
                if (this._fileUploadCallback != null) {
                    this._fileUploadCallback.fileUploadCompleted(temp.getUploadId(), temp.getResponse());
                }
                this.LogString("Upload success: " + temp.getUploadId() + " | " + temp.getStatusCode() + "\n" + temp.getResponse());
                iter.remove();
                continue;
            }
            if (temp.getStatus() != FileUploader.FileUploaderStatus.CompleteFailed) continue;
            if (this._fileUploadCallback != null) {
                this._fileUploadCallback.fileUploadFailed(temp.getUploadId(), temp.getStatusCode(), temp.getReasonCode(), temp.getResponse());
            }
            this.LogString("Upload failed: " + temp.getUploadId() + " | " + temp.getStatusCode() + "\n" + temp.getResponse());
            iter.remove();
        }
    }

    public int getUploadLowTransferRateTimeout() {
        return this._uploadLowTransferTimeoutSecs;
    }

    public void setUploadLowTransferRateTimeout(int timeoutSecs) {
        this._uploadLowTransferTimeoutSecs = timeoutSecs;
    }

    public int getUploadLowTransferRateThreshold() {
        return this._uploadLowTransferThresholdSecs;
    }

    public void setUploadLowTransferRateThreshold(int bytesPerSec) {
        this._uploadLowTransferThresholdSecs = bytesPerSec;
    }

    public long getLastReceivedPacketId() {
        return this._lastReceivedPacket;
    }

    public void cancelUpload(String uploadFileId) {
        FileUploader uploader = this.getFileUploader(uploadFileId);
        if (uploader != null) {
            uploader.cancel();
        }
    }

    public double getUploadProgress(String uploadFileId) {
        FileUploader uploader = this.getFileUploader(uploadFileId);
        if (uploader != null) {
            return uploader.getProgress();
        }
        return -1.0;
    }

    public long getUploadBytesTransferred(String uploadFileId) {
        FileUploader uploader = this.getFileUploader(uploadFileId);
        if (uploader != null) {
            return uploader.getBytesTransferred();
        }
        return -1L;
    }

    public long getUploadTotalBytesToTransfer(String uploadFileId) {
        FileUploader uploader = this.getFileUploader(uploadFileId);
        if (uploader != null) {
            return uploader.getTotalBytesToTransfer();
        }
        return -1L;
    }

    private FileUploader getFileUploader(String uploadId) {
        for (FileUploader temp : this._fileUploads) {
            if (!temp.getUploadId().equals(uploadId)) continue;
            return temp;
        }
        this.LogString("GetUploadProgress could not find upload ID " + uploadId);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCommunication() {
        Object object = this._lock;
        synchronized (object) {
            this._waitingQueue.clear();
            this._messageQueue.clear();
            this._bundleQueue.clear();
            this._networkErrorMessageQueue.clear();
            this._serverResponses.clear();
            this._eventResponses.clear();
            this._rewardResponses.clear();
            this._isAuthenticated = false;
            this._isInitialized = false;
            this._sessionId = "";
            this._packetId = 0L;
            this._blockingQueue = false;
            this._networkErrorCallbackReadyToBeSent = false;
            this._client.getAuthenticationService().clearSavedProfileId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventCallback(IEventCallback callback) {
        Object object = this._lock;
        synchronized (object) {
            this._eventCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterEventCallback() {
        Object object = this._lock;
        synchronized (object) {
            this._eventCallback = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRewardCallback(IRewardCallback in_rewardCallback) {
        Object object = this._lock;
        synchronized (object) {
            this._rewardCallback = in_rewardCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterRewardCallback() {
        Object object = this._lock;
        synchronized (object) {
            this._rewardCallback = null;
        }
    }

    public void registerFileUploadCallback(IFileUploadCallback fileUploadCallback) {
        this._fileUploadCallback = fileUploadCallback;
    }

    public void deregisterFileUploadCallback() {
        this._fileUploadCallback = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerGlobalErrorCallback(IGlobalErrorCallback in_globalErrorCallback) {
        Object object = this._lock;
        synchronized (object) {
            this._globalErrorCallback = in_globalErrorCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterGlobalErrorCallback() {
        Object object = this._lock;
        synchronized (object) {
            this._globalErrorCallback = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNetworkErrorCallback(INetworkErrorCallback in_networkErrorCallback) {
        Object object = this._lock;
        synchronized (object) {
            this._networkErrorCallback = in_networkErrorCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterNetworkErrorCallback() {
        Object object = this._lock;
        synchronized (object) {
            this._networkErrorCallback = null;
        }
    }

    public ArrayList<Integer> getPacketTimeouts() {
        return this._packetTimeouts;
    }

    public void setPacketTimeouts(ArrayList<Integer> in_packetTimeouts) {
        this._packetTimeouts = in_packetTimeouts;
    }

    public void setPacketTimeoutsToDefault() {
        this._packetTimeouts = new ArrayList();
        this._packetTimeouts.add(15);
        this._packetTimeouts.add(20);
        this._packetTimeouts.add(35);
        this._packetTimeouts.add(50);
    }

    public int getAuthenticationPacketTimeout() {
        return this._authenticationTimeoutMillis / 1000;
    }

    public void setAuthenticationPacketTimeout(int timeoutSecs) {
        if (timeoutSecs > 0) {
            this._authenticationTimeoutMillis = timeoutSecs * 1000;
        }
    }

    public void setOldStyleStatusMessageErrorCallback(boolean in_enabled) {
        this._oldStyleStatusMessageErrorCallback = in_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableNetworkErrorMessageCaching(boolean in_enabled) {
        Object object = this._lock;
        synchronized (object) {
            this._cacheMessagesOnNetworkError = in_enabled;
        }
    }

    public String getAppId() {
        return this._appId;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(String sessionId) {
        this._sessionId = sessionId;
    }

    public long getHeartbeatInterval() {
        return this._heartbeatIntervalMillis;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this._heartbeatIntervalMillis = heartbeatInterval;
    }

    public void setMessageQueuePollInterval(long pollIntervalMillis) {
        this._messageQueuePollIntervalMillis = pollIntervalMillis;
    }

    public boolean isAuthenticated() {
        return this._isAuthenticated;
    }

    public void setAuthenticated() {
        this._isAuthenticated = true;
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    public boolean getLoggingEnabled() {
        return this._loggingEnabled;
    }

    public void enableLogging(boolean isEnabled) {
        this._loggingEnabled = isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryCachedMessages() {
        Object object = this._lock;
        synchronized (object) {
            if (!this._blockingQueue) {
                return;
            }
            --this._packetId;
            this._serverResponses.clear();
            this._blockingQueue = false;
            this._networkErrorCallbackReadyToBeSent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCachedMessages(boolean in_sendApiErrorCallbacks) {
        Object object = this._lock;
        synchronized (object) {
            if (!this._blockingQueue) {
                return;
            }
            if (!in_sendApiErrorCallbacks) {
                this._serverResponses.clear();
            }
            this._networkErrorMessageQueue.clear();
            this._blockingQueue = false;
            this._networkErrorCallbackReadyToBeSent = false;
        }
    }

    public void insertEndOfMessageBundleMarker() {
        ServerCall sc = new ServerCall(null, null, null, null);
        sc.setEndOfBundleMarker(true);
        this.addToQueue(sc);
    }

    private boolean shouldRetryPacket() {
        for (ServerCall serverCall : this._bundleQueue) {
            if (serverCall == null || serverCall.getServiceName() != ServiceName.authenticationV2 || serverCall.getServiceOperation() != ServiceOperation.AUTHENTICATE) continue;
            return false;
        }
        return true;
    }

    private int getRetryTimeoutMillis(int retryAttempt) {
        if (!this.shouldRetryPacket()) {
            return this._authenticationTimeoutMillis;
        }
        return this._packetTimeouts.get(retryAttempt >= this._packetTimeouts.size() ? this._packetTimeouts.size() - 1 : retryAttempt) * 1000;
    }

    private int getMaxSendAttempts() {
        if (!this.shouldRetryPacket()) {
            return 1;
        }
        return this._packetTimeouts.size();
    }

    @Override
    public void run() {
        block4: while (!this._thread.isInterrupted()) {
            if (!this._isInitialized || this._blockingQueue) {
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (this._networkErrorMessageQueue.size() > 0) {
                this._bundleQueue.addAll(this._networkErrorMessageQueue);
                this._networkErrorMessageQueue.clear();
            } else {
                this.fillBundle();
            }
            if (this._bundleQueue.size() <= 0 || !this._isInitialized) continue;
            boolean isAuth = this._isAuthenticated;
            if (!isAuth || this._bundleQueue.size() > 1) {
                Iterator<ServerCall> iter = this._bundleQueue.iterator();
                while (iter.hasNext()) {
                    ServerCall serverCall = iter.next();
                    if (serverCall.getServiceOperation() == ServiceOperation.AUTHENTICATE || serverCall.getServiceOperation() == ServiceOperation.RESET_EMAIL_PASSWORD || serverCall.getServiceOperation() == ServiceOperation.RESET_EMAIL_PASSWORD_ADVANCED) {
                        isAuth = true;
                        continue;
                    }
                    if (serverCall.getServiceName() != ServiceName.heartbeat) continue;
                    iter.remove();
                }
            }
            if (!this._killSwitchEngaged) {
                if (!isAuth) {
                    this.fakeErrorResponse(this._statusCodeCache, this._reasonCodeCache, this._statusMessageCache);
                    continue;
                }
                this._retryCount = 0;
                ++this._packetId;
                this._expectedPacketId = this._expectedPacketId;
                while (true) {
                    long timeoutTimeMs = this.getRetryTimeoutMillis(this._retryCount);
                    long startTime = System.currentTimeMillis();
                    if (this.sendBundle()) continue block4;
                    ++this._retryCount;
                    long endTime = System.currentTimeMillis();
                    if (endTime >= startTime + timeoutTimeMs) continue;
                    try {
                        Thread.sleep(startTime + timeoutTimeMs - endTime);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.fakeErrorResponse(900, 90200, "Client has been disabled due to repeated errors from a single API call");
        }
    }

    public void fakeErrorResponse(int statusCode, int reasonCode, String statusMessage) {
        if (this._loggingEnabled) {
            try {
                String body = this.getDataString();
                JSONObject jlog = new JSONObject(body);
                this.LogString("OUTGOING" + (this._retryCount > 0 ? " retry(" + this._retryCount + "): " : ": ") + jlog.toString(2));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.fillWithError(statusCode, reasonCode, statusMessage);
        if (this._loggingEnabled) {
            ArrayList<JSONObject> responses = new ArrayList<JSONObject>(this._serverResponses.size());
            for (ServerResponse response : this._serverResponses) {
                responses.add(response._data);
            }
            try {
                JSONObject responseBody = new JSONObject();
                JSONArray responseArray = new JSONArray(responses);
                responseBody.put("packetId", this._expectedPacketId);
                responseBody.put("responses", (Object)responseArray);
                this.LogString("INCOMING (200): " + responseBody.toString(2));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void LogString(String s) {
        if (this._loggingEnabled) {
            System.out.println("#BCC " + s);
        }
    }

    private void fillBundle() {
        ServerCall call;
        long polltime = this._heartbeatIntervalMillis;
        if (this._isAuthenticated && (polltime = System.currentTimeMillis() + this._heartbeatIntervalMillis - this._lastSendTime) < 0L) {
            polltime = 500L;
        }
        boolean hasRecords = false;
        try {
            hasRecords = this._messageQueueCount.tryAcquire(1, polltime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this._serverResponses.peek() != null) {
            try {
                Thread.sleep(1000L);
                if (hasRecords) {
                    this._messageQueueCount.release();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        if (!hasRecords) {
            if (System.currentTimeMillis() - this._lastSendTime > this._heartbeatIntervalMillis && this._isAuthenticated) {
                ServerCall serverCall = new ServerCall(ServiceName.heartbeat, ServiceOperation.READ, null, null);
                this._bundleQueue.add(serverCall);
                return;
            }
            return;
        }
        Iterator<ServerCall> it = this._messageQueue.iterator();
        while (it.hasNext() && !(call = it.next()).isEndOfBundleMarker()) {
            if (call.getServiceOperation() != ServiceOperation.AUTHENTICATE) continue;
            it.remove();
            this._bundleQueue.add(call);
            return;
        }
        this._messageQueueCount.release();
        while (this._bundleQueue.size() < this._maxBundleSize && this._messageQueue.size() > 0) {
            ServerCall serverCall = null;
            try {
                serverCall = this._messageQueue.poll();
                this._messageQueueCount.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (serverCall.isEndOfBundleMarker()) {
                return;
            }
            this._bundleQueue.add(serverCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillWithError(int statusCode, int reasonCode, String statusMessage) {
        Object object = this._lock;
        synchronized (object) {
            JSONObject jsonError = new JSONObject();
            try {
                jsonError.put("status", statusCode);
                jsonError.put("reason_code", reasonCode);
                jsonError.put("severity", (Object)"ERROR");
                jsonError.put("status_message", (Object)statusMessage);
            }
            catch (JSONException je) {
                je.printStackTrace();
            }
            for (ServerCall serverCall : this._bundleQueue) {
                ServerResponse response = new ServerResponse();
                response._serverCall = serverCall;
                response._isError = true;
                response._statusCode = statusCode;
                response._reasonCode = reasonCode;
                response._statusMessage = statusMessage;
                response._data = jsonError;
                this._serverResponses.push(response);
            }
            this._bundleQueue.clear();
        }
    }

    private boolean onTimeout() {
        if (this._retryCount < this.getMaxSendAttempts()) {
            return false;
        }
        if (this._cacheMessagesOnNetworkError) {
            this._networkErrorMessageQueue.clear();
            this._networkErrorMessageQueue.addAll(this._bundleQueue);
            this._networkErrorCallbackReadyToBeSent = true;
            this._blockingQueue = true;
        }
        this.fillWithError(900, 90001, "timeout");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendBundle() {
        HttpURLConnection connection = null;
        try {
            long receivedPacketId;
            String line;
            connection = (HttpURLConnection)new URL(this._serverUrl).openConnection();
            connection.setConnectTimeout(this.getRetryTimeoutMillis(this._retryCount));
            connection.setReadTimeout(this.getRetryTimeoutMillis(this._retryCount));
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            String body = this.getDataString();
            if (this._secretKey.length() > 0) {
                connection.setRequestProperty("X-SIG", this.getSignature(body));
            }
            connection.setRequestProperty("X-APPID", this._appId);
            if (this._useCompresssion) {
                connection.setRequestProperty("Content-Encoding", "gzip");
                connection.setRequestProperty("Accept-Encoding", "gzip");
            }
            connection.setRequestProperty("charset", "utf-8");
            byte[] postData = body.getBytes("UTF-8");
            if (this._loggingEnabled) {
                try {
                    JSONObject jlog = new JSONObject(body);
                    this.LogString("OUTGOING" + (this._retryCount > 0 ? " retry(" + this._retryCount + "): " : ": ") + jlog.toString(2) + ", t: " + new Date().toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            this._lastSendTime = System.currentTimeMillis();
            connection.connect();
            DataOutputStream wr = null;
            if (this._useCompresssion) {
                GZIPOutputStream gzipOutputStream = new GZIPOutputStream(connection.getOutputStream());
                wr = new DataOutputStream(gzipOutputStream);
            } else {
                wr = new DataOutputStream(connection.getOutputStream());
            }
            try {
                wr.write(postData);
            }
            finally {
                wr.close();
            }
            BufferedReader reader = null;
            if (this._useCompresssion) {
                GZIPInputStream gzipInputStream = new GZIPInputStream(connection.getInputStream());
                reader = new BufferedReader(new InputStreamReader(gzipInputStream));
            } else {
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            }
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            String responseBody = builder.toString();
            if (this._loggingEnabled) {
                try {
                    JSONObject jlog = new JSONObject(responseBody);
                    this.LogString("INCOMING (" + connection.getResponseCode() + "): " + jlog.toString(2) + ", t: " + new Date().toString());
                }
                catch (JSONException e) {
                    this.LogString("INCOMING (" + connection.getResponseCode() + "): " + responseBody + ", t: " + new Date().toString());
                }
            }
            if (connection.getResponseCode() != 200 || responseBody.length() == 0) {
                return this.onTimeout();
            }
            JSONObject root = new JSONObject(responseBody);
            this._lastReceivedPacket = receivedPacketId = root.getLong("packetId");
            if (receivedPacketId != NO_PACKET_EXPECTED && (this._expectedPacketId == NO_PACKET_EXPECTED || receivedPacketId != this._expectedPacketId)) {
                this.LogString("Received packet id " + receivedPacketId + " but expected packet id " + this._expectedPacketId);
                return true;
            }
            this._expectedPacketId = NO_PACKET_EXPECTED;
            this.handleBundle(root);
            this._bundleQueue.clear();
        }
        catch (SocketTimeoutException e) {
            this.LogString("TIMEOUT t: " + new Date().toString());
            return this.onTimeout();
        }
        catch (Exception e) {
            int status_code = 0;
            try {
                int n = status_code = connection != null ? connection.getResponseCode() : 0;
                if (status_code == 503 || status_code == 502 || status_code == 504) {
                    return this.onTimeout();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            e.printStackTrace();
            if (this._cacheMessagesOnNetworkError) {
                this._networkErrorMessageQueue.clear();
                this._networkErrorMessageQueue.addAll(this._bundleQueue);
                this._networkErrorCallbackReadyToBeSent = true;
                this._blockingQueue = true;
            }
            this.fillWithError(900, 90001, "Network error");
        }
        return true;
    }

    private String getDataString() throws JSONException {
        JSONArray messages = new JSONArray();
        for (ServerCall serverCall : this._bundleQueue) {
            messages.put((Object)serverCall.getPayload());
        }
        JSONObject allMessages = new JSONObject();
        allMessages.put("messages", (Object)messages);
        allMessages.put("gameId", (Object)this._appId);
        allMessages.put("sessionId", (Object)this._sessionId);
        allMessages.put("packetId", this._expectedPacketId);
        return allMessages.toString() + "\r\n\r\n";
    }

    private String getSignature(String body) throws NoSuchAlgorithmException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(body.getBytes("UTF-8"));
            messageDigest.update(this._secretKey.getBytes("UTF-8"));
            return this.toHexString(messageDigest.digest());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private void resetErrorCache() {
        this._statusCodeCache = 403;
        this._reasonCodeCache = 40304;
        this._statusMessageCache = "No session";
    }

    private void updateKillSwitch(int statusCode, String service, String operation) {
        if (statusCode == 900) {
            return;
        }
        if (this._killSwitchService == null) {
            this._killSwitchService = service;
            this._killSwitchOperation = operation;
            ++this._killSwitchErrorCount;
        } else if (service == this._killSwitchService && operation == this._killSwitchOperation) {
            ++this._killSwitchErrorCount;
        }
        if (!this._killSwitchEngaged && this._killSwitchErrorCount >= this._killSwitchThreshold) {
            this._killSwitchEngaged = true;
            this.LogString("Client disabled due to repeated errors from a single API call: " + service + " | " + operation);
        }
    }

    private void resetKillSwitch() {
        this._killSwitchErrorCount = 0;
        this._killSwitchService = null;
        this._killSwitchOperation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBundle(JSONObject root) throws JSONException {
        JSONArray messages = root.getJSONArray("responses");
        Object object = this._lock;
        synchronized (object) {
            int ilen = messages.length();
            for (int i = 0; i < ilen; ++i) {
                ServerCall sc = this._bundleQueue.poll();
                if (sc != null) {
                    JSONObject message = messages.getJSONObject(i);
                    int status = message.getInt("status");
                    ServerResponse serverResponse = new ServerResponse();
                    serverResponse._serverCall = sc;
                    serverResponse._statusCode = status;
                    if (status == 200) {
                        JSONObject data;
                        this.resetKillSwitch();
                        if (message.has("data") && (sc.getServiceName() == ServiceName.authenticationV2 || sc.getServiceName() == ServiceName.identity) && (data = message.optJSONObject("data")) != null) {
                            if (data.has("sessionId")) {
                                this._sessionId = data.getString("sessionId");
                            }
                            if (data.has("profileId")) {
                                this._client.getAuthenticationService().setProfileId(data.getString("profileId"));
                            }
                            if (data.has("switchToAppId")) {
                                this._appId = data.getString("switchToAppId");
                                this._secretKey = "MISSING";
                                if (this._secretMap.containsKey(this._appId)) {
                                    this._secretKey = this._secretMap.get(this._appId);
                                }
                            }
                        }
                        if (sc.getServiceName().equals((Object)ServiceName.authenticationV2) && sc.getServiceOperation().equals((Object)ServiceOperation.AUTHENTICATE)) {
                            data = message.getJSONObject("data");
                            String sessionId = data.getString("sessionId");
                            String profileId = data.getString("profileId");
                            this._sessionId = sessionId;
                            this._isAuthenticated = true;
                            this.resetErrorCache();
                            this._client.getAuthenticationService().setProfileId(profileId);
                            long sessionExpiry = data.getLong("playerSessionExpiry");
                            this._heartbeatIntervalMillis = sessionExpiry * 850L;
                            this._maxBundleSize = data.getInt("maxBundleMsgs");
                            if (data.has("maxKillCount")) {
                                this._killSwitchThreshold = data.getInt("maxKillCount");
                            }
                        } else if (sc.getServiceName().equals((Object)ServiceName.playerState) && sc.getServiceOperation().equals((Object)ServiceOperation.LOGOUT)) {
                            this._isAuthenticated = false;
                            this._sessionId = "";
                            this.resetErrorCache();
                            this._client.getAuthenticationService().clearSavedProfileId();
                        } else if (sc.getServiceName().equals((Object)ServiceName.file) && sc.getServiceOperation().equals((Object)ServiceOperation.PREPARE_USER_UPLOAD)) {
                            data = message.getJSONObject("data").getJSONObject("fileDetails");
                            String uploadId = data.getString("uploadId");
                            String localPath = data.getString("localPath");
                            this._fileUploads.add(new FileUploader(uploadId, localPath, this._uploadUrl, this._sessionId, this._uploadLowTransferTimeoutSecs, this._uploadLowTransferThresholdSecs));
                        }
                        serverResponse._isError = false;
                        serverResponse._data = message;
                        if (this._rewardCallback != null) {
                            try {
                                JSONObject innerRewards;
                                data = message.getJSONObject("data");
                                JSONObject rewards = null;
                                if (sc.getServiceName().equals((Object)ServiceName.authenticationV2) && sc.getServiceOperation().equals((Object)ServiceOperation.AUTHENTICATE)) {
                                    JSONObject innerRewards2;
                                    JSONObject outerRewards = data.optJSONObject("rewards");
                                    if (outerRewards != null && (innerRewards2 = outerRewards.optJSONObject("rewards")) != null && innerRewards2.length() > 0) {
                                        rewards = outerRewards;
                                    }
                                } else if ((sc.getServiceName().equals((Object)ServiceName.playerStatistics) && sc.getServiceOperation().equals((Object)ServiceOperation.UPDATE) || sc.getServiceName().equals((Object)ServiceName.playerStatisticsEvent) && (sc.getServiceOperation().equals((Object)ServiceOperation.TRIGGER) || sc.getServiceOperation().equals((Object)ServiceOperation.TRIGGER_MULTIPLE))) && (innerRewards = data.optJSONObject("rewards")) != null && innerRewards.length() > 0) {
                                    rewards = data;
                                }
                                if (rewards != null) {
                                    JSONObject apiReward = new JSONObject();
                                    apiReward.put("service", (Object)sc.getServiceName());
                                    apiReward.put("operation", (Object)sc.getServiceOperation());
                                    apiReward.put("rewards", (Object)rewards);
                                    JSONObject callbackObj = new JSONObject();
                                    JSONArray apiRewards = new JSONArray();
                                    apiRewards.put((Object)apiReward);
                                    callbackObj.put("apiRewards", (Object)apiRewards);
                                    this._rewardResponses.addLast(callbackObj);
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        int reasonCode = 0;
                        if (!message.isNull("reason_code")) {
                            reasonCode = message.getInt("reason_code");
                        }
                        String statusMessage = message.getString("status_message");
                        if (reasonCode == 40303 || reasonCode == 40304 || reasonCode == 40356) {
                            this._isAuthenticated = false;
                            this._sessionId = "";
                            this._statusCodeCache = status;
                            this._reasonCodeCache = reasonCode;
                            this._statusMessageCache = statusMessage;
                        } else if (sc.getServiceOperation() == ServiceOperation.LOGOUT && reasonCode == 90001) {
                            this._isAuthenticated = false;
                            this._sessionId = "";
                        }
                        serverResponse._isError = true;
                        serverResponse._reasonCode = reasonCode;
                        serverResponse._statusMessage = statusMessage;
                        serverResponse._data = message;
                        this.updateKillSwitch(status, sc.getServiceName().toString(), sc.getServiceOperation().toString());
                    }
                    this._serverResponses.addLast(serverResponse);
                    continue;
                }
                this.LogString("missing server call for json response: " + messages.toString());
            }
            if (!root.isNull("events") && this._eventCallback != null) {
                try {
                    JSONArray events = root.getJSONArray("events");
                    JSONObject eventsAsJson = new JSONObject();
                    eventsAsJson.put("events", (Object)events);
                    this._eventResponses.addLast(eventsAsJson);
                }
                catch (JSONException je) {
                    je.printStackTrace();
                }
            }
        }
    }

    private String toHexString(byte[] bytes) {
        StringBuilder buffer = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(0xFF & aByte);
            if (hex.length() == 1) {
                buffer.append("0");
            }
            buffer.append(hex);
        }
        return buffer.toString();
    }

    private static void disableSslCheck() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }
}

