/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.comms;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;

public class FileUploader
implements Runnable {
    private String _serverUrl;
    private String _uploadId;
    private String _localPath;
    private String _sessionId;
    private long _timeoutThreshold = 50L;
    private int _timeout = 120;
    private String _fileName;
    private FileUploaderStatus _status;
    private double _progress;
    private long _bytesTransferred;
    private long _totalBytesToTransfer;
    private int _statusCode;
    private int _reasonCode;
    private String _response;
    private final Object _lock = new Object();
    private boolean _isCanceled;
    private long _timeBelowThreshold;
    private long _prevTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileUploaderStatus getStatus() {
        Object object = this._lock;
        synchronized (object) {
            return this._status;
        }
    }

    public String getUploadId() {
        return this._uploadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getProgress() {
        Object object = this._lock;
        synchronized (object) {
            return this._progress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesTransferred() {
        Object object = this._lock;
        synchronized (object) {
            return this._bytesTransferred;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalBytesToTransfer() {
        Object object = this._lock;
        synchronized (object) {
            return this._totalBytesToTransfer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatusCode() {
        Object object = this._lock;
        synchronized (object) {
            return this._statusCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReasonCode() {
        Object object = this._lock;
        synchronized (object) {
            return this._reasonCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponse() {
        Object object = this._lock;
        synchronized (object) {
            return this._response;
        }
    }

    public FileUploader(String uploadId, String localPath, String serverUrl, String sessionId, int timeout, int timeoutThreshold) {
        this._serverUrl = serverUrl;
        this._uploadId = uploadId;
        this._localPath = localPath;
        this._sessionId = sessionId;
        this._timeout = timeout;
        this._timeoutThreshold = timeoutThreshold;
        File file = new File(localPath);
        if (!file.exists()) {
            this.throwError(90102, "File at" + localPath + " does not exist");
            return;
        }
        this._fileName = file.getName();
        this._status = FileUploaderStatus.Uploading;
        this._prevTime = System.currentTimeMillis();
        Thread _thread = new Thread(this);
        _thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytesTransferred(long bytes) {
        Object object = this._lock;
        synchronized (object) {
            this._bytesTransferred = bytes;
            this._progress = (double)this._bytesTransferred / (double)this._totalBytesToTransfer;
        }
        long elapsedTime = System.currentTimeMillis() - this._prevTime;
        double rate = (double)bytes / ((double)elapsedTime / 1000.0);
        this._timeBelowThreshold = rate > (double)this._timeoutThreshold ? 0L : (this._timeBelowThreshold += elapsedTime);
        this._prevTime = System.currentTimeMillis();
        if (this._timeBelowThreshold > (long)(this._timeout * 1000)) {
            this._isCanceled = true;
            this.throwError(90101, "Upload of " + this._fileName + " timed out.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block32: {
            File file = new File(this._localPath);
            HttpURLConnection connection = null;
            String fileName = file.getName();
            try {
                String line;
                connection = (HttpURLConnection)new URL(this._serverUrl).openConnection();
                connection.setConnectTimeout(this._timeout * 1000);
                connection.setReadTimeout(this._timeout * 1000);
                connection.setRequestMethod("POST");
                String boundary = "---------------------------boundary";
                String tail = "\r\n--" + boundary + "--\r\n";
                connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                connection.setDoOutput(true);
                String metadataPart = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"metadata\"\r\n\r\n\r\n";
                String sessionPart = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"sessionId\"\r\n\r\n" + this._sessionId + "\r\n";
                String uploadIdPart = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"uploadId\"\r\n\r\n" + this._uploadId + "\r\n";
                String fileSizePart = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"fileSize\"\r\n\r\n" + file.length() + "\r\n";
                String fileHeader1 = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"uploadFile\"; filename=\"" + fileName + "\"\r\nContent-Type: application/octet-stream\r\nContent-Transfer-Encoding: binary\r\n";
                long fileLength = file.length() + (long)tail.length();
                String fileHeader2 = "Content-length: " + fileLength + "\r\n";
                String fileHeader = sessionPart + uploadIdPart + fileSizePart + fileHeader1 + fileHeader2 + "\r\n";
                String stringData = metadataPart + fileHeader;
                this._totalBytesToTransfer = (long)stringData.length() + fileLength;
                connection.setRequestProperty("Content-length", "" + this._totalBytesToTransfer);
                connection.setFixedLengthStreamingMode((int)this._totalBytesToTransfer);
                connection.connect();
                try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());){
                    out.writeBytes(stringData);
                    out.flush();
                    int progress = 0;
                    byte[] buf = new byte[1024];
                    try (BufferedInputStream bufInput = new BufferedInputStream(new FileInputStream(file));){
                        int bytesRead;
                        while ((bytesRead = bufInput.read(buf)) != -1 && !this._isCanceled) {
                            out.write(buf, 0, bytesRead);
                            out.flush();
                            this.setBytesTransferred(progress += bytesRead);
                        }
                    }
                    if (!this._isCanceled) {
                        out.writeBytes(tail);
                        out.flush();
                    }
                }
                if (this._isCanceled) break block32;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                Object object = this._lock;
                synchronized (object) {
                    this._statusCode = connection.getResponseCode();
                    if (this._statusCode == 200) {
                        this._response = builder.toString();
                        this._status = FileUploaderStatus.CompleteSuccess;
                    } else {
                        this.throwError(90102, connection.getResponseMessage());
                    }
                }
            }
            catch (SocketTimeoutException e) {
                Object object = this._lock;
                synchronized (object) {
                    this.throwError(90101, "Upload of " + this._fileName + " timed out.");
                }
            }
            catch (IOException e) {
                if (!this._isCanceled) {
                    e.printStackTrace();
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }

    public void cancel() {
        if (this._isCanceled) {
            return;
        }
        this._isCanceled = true;
        this.throwError(90100, "Upload of " + this._fileName + " cancelled by user");
    }

    private void throwError(int reasonCode, String message) {
        this._status = FileUploaderStatus.CompleteFailed;
        this._statusCode = 900;
        this._reasonCode = reasonCode;
        this._response = this.createErrorString(this._statusCode, this._reasonCode, message);
    }

    private String createErrorString(int statusCode, int reasonCode, String message) {
        JSONObject error = new JSONObject();
        try {
            error.put("status", statusCode);
            error.put("reason_code", reasonCode);
            error.put("status_message", (Object)message);
            error.put("severity", (Object)"ERROR");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return error.toString();
    }

    public static enum FileUploaderStatus {
        None,
        Pending,
        Uploading,
        CompleteFailed,
        CompleteSuccess;

    }
}

