/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import java.math.BigInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AsyncMatchService {
    private BrainCloudClient _client;

    public AsyncMatchService(BrainCloudClient client) {
        this._client = client;
    }

    public void createMatch(String jsonOpponentIds, String pushNotificationMessage, IServerCallback callback) {
        this.createMatchWithInitialTurn(jsonOpponentIds, null, pushNotificationMessage, null, null, callback);
    }

    public void createMatchWithInitialTurn(String jsonOpponentIds, String jsonMatchState, String pushNotificationMessage, String nextPlayer, String jsonSummary, IServerCallback callback) {
        try {
            JSONArray opponentIdsData = new JSONArray(jsonOpponentIds);
            JSONObject data = new JSONObject();
            data.put(Parameter.players.name(), (Object)opponentIdsData);
            if (StringUtil.IsOptionalParameterValid(jsonMatchState)) {
                JSONObject matchStateData = new JSONObject(jsonMatchState);
                data.put(Parameter.matchState.name(), (Object)matchStateData);
            }
            if (StringUtil.IsOptionalParameterValid(nextPlayer)) {
                JSONObject currPlayer = new JSONObject();
                currPlayer.put(Parameter.currentPlayer.name(), (Object)nextPlayer);
                data.put(Parameter.status.name(), (Object)currPlayer);
            }
            if (StringUtil.IsOptionalParameterValid(jsonSummary)) {
                data.put(Parameter.summary.name(), (Object)new JSONObject(jsonSummary));
            }
            if (StringUtil.IsOptionalParameterValid(pushNotificationMessage)) {
                data.put(Parameter.pushContent.name(), (Object)pushNotificationMessage);
            }
            ServerCall sc = new ServerCall(ServiceName.asyncMatch, ServiceOperation.CREATE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void submitTurn(String ownerId, String matchId, BigInteger version, String jsonMatchState, String pushNotificationMessage, String nextPlayer, String jsonSummary, String jsonStatistics, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.ownerId.name(), (Object)ownerId);
            data.put(Parameter.matchId.name(), (Object)matchId);
            data.put(Parameter.version.name(), version.longValue());
            if (StringUtil.IsOptionalParameterValid(jsonMatchState)) {
                data.put(Parameter.matchState.name(), (Object)new JSONObject(jsonMatchState));
            }
            if (StringUtil.IsOptionalParameterValid(jsonMatchState)) {
                JSONObject currPlayer = new JSONObject();
                currPlayer.put(Parameter.currentPlayer.name(), (Object)nextPlayer);
                data.put(Parameter.status.name(), (Object)currPlayer);
            }
            if (StringUtil.IsOptionalParameterValid(jsonMatchState)) {
                data.put(Parameter.summary.name(), (Object)new JSONObject(jsonSummary));
            }
            if (StringUtil.IsOptionalParameterValid(jsonMatchState)) {
                data.put(Parameter.statistics.name(), (Object)new JSONObject(jsonStatistics));
            }
            if (StringUtil.IsOptionalParameterValid(jsonMatchState)) {
                data.put(Parameter.pushContent.name(), (Object)pushNotificationMessage);
            }
            ServerCall sc = new ServerCall(ServiceName.asyncMatch, ServiceOperation.SUBMIT_TURN, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateMatchSummaryData(String ownerId, String matchId, BigInteger version, String jsonSummary, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.ownerId.name(), (Object)ownerId);
            data.put(Parameter.matchId.name(), (Object)matchId);
            data.put(Parameter.version.name(), (Object)version);
            if (StringUtil.IsOptionalParameterValid(jsonSummary)) {
                data.put(Parameter.summary.name(), (Object)new JSONObject(jsonSummary));
            }
            ServerCall sc = new ServerCall(ServiceName.asyncMatch, ServiceOperation.UPDATE_SUMMARY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void completeMatch(String ownerId, String matchId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.ownerId.name(), (Object)ownerId);
            data.put(Parameter.matchId.name(), (Object)matchId);
            ServerCall sc = new ServerCall(ServiceName.asyncMatch, ServiceOperation.COMPLETE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void readMatch(String ownerId, String matchId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.ownerId.name(), (Object)ownerId);
            data.put(Parameter.matchId.name(), (Object)matchId);
            ServerCall sc = new ServerCall(ServiceName.asyncMatch, ServiceOperation.READ_MATCH, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void readMatchHistory(String ownerId, String matchId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.ownerId.name(), (Object)ownerId);
            data.put(Parameter.matchId.name(), (Object)matchId);
            ServerCall sc = new ServerCall(ServiceName.asyncMatch, ServiceOperation.READ_MATCH_HISTORY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void findMatches(IServerCallback callback) {
        JSONObject data = new JSONObject();
        ServerCall sc = new ServerCall(ServiceName.asyncMatch, ServiceOperation.FIND_MATCHES, data, callback);
        this._client.sendRequest(sc);
    }

    public void findCompleteMatches(IServerCallback callback) {
        JSONObject data = new JSONObject();
        ServerCall sc = new ServerCall(ServiceName.asyncMatch, ServiceOperation.FIND_MATCHES_COMPLETED, data, callback);
        this._client.sendRequest(sc);
    }

    public void abandonMatch(String ownerId, String matchId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.ownerId.name(), (Object)ownerId);
            data.put(Parameter.matchId.name(), (Object)matchId);
            ServerCall sc = new ServerCall(ServiceName.asyncMatch, ServiceOperation.ABANDON, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void deleteMatch(String ownerId, String matchId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.ownerId.name(), (Object)ownerId);
            data.put(Parameter.matchId.name(), (Object)matchId);
            ServerCall sc = new ServerCall(ServiceName.asyncMatch, ServiceOperation.DELETE_MATCH, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void completeMatchWithSummaryData(String ownerId, String matchId, String pushContent, String summary, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.ownerId.name(), (Object)ownerId);
            data.put(Parameter.matchId.name(), (Object)matchId);
            if (pushContent != null) {
                data.put(Parameter.pushContent.name(), (Object)pushContent);
            }
            JSONObject summaryData = new JSONObject(summary);
            data.put(Parameter.summary.name(), (Object)summaryData);
            ServerCall sc = new ServerCall(ServiceName.asyncMatch, ServiceOperation.COMPLETE_MATCH_WITH_SUMMARY_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void abandonMatchWithSummaryData(String ownerId, String matchId, String pushContent, String summary, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.ownerId.name(), (Object)ownerId);
            data.put(Parameter.matchId.name(), (Object)matchId);
            if (pushContent != null) {
                data.put(Parameter.pushContent.name(), (Object)pushContent);
            }
            JSONObject summaryData = new JSONObject(summary);
            data.put(Parameter.summary.name(), (Object)summaryData);
            ServerCall sc = new ServerCall(ServiceName.asyncMatch, ServiceOperation.COMPLETE_MATCH_WITH_SUMMARY_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static enum Parameter {
        players,
        matchState,
        currentPlayer,
        status,
        summary,
        pushContent,
        matchId,
        ownerId,
        statistics,
        version;

    }
}

