/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatService {
    private BrainCloudClient _client;

    public ChatService(BrainCloudClient client) {
        this._client = client;
    }

    public void channelConnect(String channelId, int maxReturn, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.channelId.name(), (Object)channelId);
            data.put(Parameter.maxReturn.name(), maxReturn);
            ServerCall sc = new ServerCall(ServiceName.chat, ServiceOperation.CHANNEL_CONNECT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void channelDisconnect(String channelId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.channelId.name(), (Object)channelId);
            ServerCall sc = new ServerCall(ServiceName.chat, ServiceOperation.CHANNEL_DISCONNECT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void deleteChatMessage(String channelId, String msgId, int version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.channelId.name(), (Object)channelId);
            data.put(Parameter.msgId.name(), (Object)msgId);
            data.put(Parameter.version.name(), version);
            ServerCall sc = new ServerCall(ServiceName.chat, ServiceOperation.DELETE_CHAT_MESSAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getChannelId(String channelType, String channelSubId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.channelType.name(), (Object)channelType);
            data.put(Parameter.channelSubId.name(), (Object)channelSubId);
            ServerCall sc = new ServerCall(ServiceName.chat, ServiceOperation.GET_CHANNEL_ID, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getChannelInfo(String channelId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.channelId.name(), (Object)channelId);
            ServerCall sc = new ServerCall(ServiceName.chat, ServiceOperation.GET_CHANNEL_INFO, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getChatMessage(String channelId, String msgId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.channelId.name(), (Object)channelId);
            data.put(Parameter.msgId.name(), (Object)msgId);
            ServerCall sc = new ServerCall(ServiceName.chat, ServiceOperation.GET_CHAT_MESSAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getRecentChatMessages(String channelId, int maxReturn, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.channelId.name(), (Object)channelId);
            data.put(Parameter.maxReturn.name(), maxReturn);
            ServerCall sc = new ServerCall(ServiceName.chat, ServiceOperation.GET_RECENT_CHAT_MESSAGES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getSubscribedChannels(String channelType, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.channelType.name(), (Object)channelType);
            ServerCall sc = new ServerCall(ServiceName.chat, ServiceOperation.GET_SUBSCRIBED_CHANNELS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postChatMessage(String channelId, String text, String rich, Boolean recordInHistory, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.channelId.name(), (Object)channelId);
            JSONObject content = new JSONObject();
            content.put(Parameter.text.name(), (Object)text);
            content.put(Parameter.rich.name(), (Object)new JSONObject(rich != null ? rich : "{}"));
            data.put(Parameter.content.name(), (Object)content);
            data.put(Parameter.recordInHistory.name(), (Object)recordInHistory);
            ServerCall sc = new ServerCall(ServiceName.chat, ServiceOperation.POST_CHAT_MESSAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postChatMessageSimple(String channelId, String text, Boolean recordInHistory, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.channelId.name(), (Object)channelId);
            data.put(Parameter.text.name(), (Object)text);
            data.put(Parameter.recordInHistory.name(), (Object)recordInHistory);
            ServerCall sc = new ServerCall(ServiceName.chat, ServiceOperation.POST_CHAT_MESSAGE_SIMPLE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void updateChatMessage(String channelId, String msgId, int version, String text, String rich, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.channelId.name(), (Object)channelId);
            data.put(Parameter.msgId.name(), (Object)msgId);
            data.put(Parameter.version.name(), version);
            JSONObject content = new JSONObject();
            content.put(Parameter.text.name(), (Object)text);
            content.put(Parameter.rich.name(), (Object)new JSONObject(rich != null ? rich : "{}"));
            data.put(Parameter.content.name(), (Object)content);
            ServerCall sc = new ServerCall(ServiceName.chat, ServiceOperation.UPDATE_CHAT_MESSAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private static enum Parameter {
        channelId,
        maxReturn,
        msgId,
        version,
        channelType,
        channelSubId,
        content,
        recordInHistory,
        plain,
        text,
        rich;

    }
}

