/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class EntityService {
    private BrainCloudClient _client;

    public EntityService(BrainCloudClient client) {
        this._client = client;
    }

    public void createEntity(String entityType, String jsonEntityData, String jsonEntityAcl, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            JSONObject jsonData = new JSONObject(jsonEntityData);
            data.put(Parameter.data.name(), (Object)jsonData);
            if (StringUtil.IsOptionalParameterValid(jsonEntityAcl)) {
                JSONObject jsonAcl = new JSONObject(jsonEntityAcl);
                data.put(Parameter.acl.name(), (Object)jsonAcl);
            }
            ServerCall serverCall = new ServerCall(ServiceName.entity, ServiceOperation.CREATE, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void deleteEntity(String entityId, int version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.version.name(), version);
            ServerCall sc = new ServerCall(ServiceName.entity, ServiceOperation.DELETE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void deleteSingleton(String entityType, int version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.version.name(), version);
            ServerCall sc = new ServerCall(ServiceName.entity, ServiceOperation.DELETE_SINGLETON, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getEntitiesByType(String entityType, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            ServerCall serverCall = new ServerCall(ServiceName.entity, ServiceOperation.READ_BY_TYPE, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getEntity(String entityId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            ServerCall serverCall = new ServerCall(ServiceName.entity, ServiceOperation.READ, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getSingleton(String entityType, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            ServerCall serverCall = new ServerCall(ServiceName.entity, ServiceOperation.READ_SINGLETON, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getSharedEntityForProfileId(String profileId, String entityId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.targetPlayerId.name(), (Object)profileId);
            data.put(Parameter.entityId.name(), (Object)entityId);
            ServerCall sc = new ServerCall(ServiceName.entity, ServiceOperation.READ_SHARED_ENTITY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getSharedEntitiesForProfileId(String profileId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.targetPlayerId.name(), (Object)profileId);
            ServerCall sc = new ServerCall(ServiceName.entity, ServiceOperation.READ_SHARED, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getSharedEntitiesListForProfileId(String profileId, String whereJson, String orderByJson, int maxReturn, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.targetPlayerId.name(), (Object)profileId);
            if (StringUtil.IsOptionalParameterValid(whereJson)) {
                data.put(Parameter.where.name(), (Object)new JSONObject(whereJson));
            }
            if (StringUtil.IsOptionalParameterValid(orderByJson)) {
                data.put(Parameter.orderBy.name(), (Object)new JSONObject(orderByJson));
            }
            data.put(Parameter.maxReturn.name(), maxReturn);
            ServerCall serverCall = new ServerCall(ServiceName.entity, ServiceOperation.READ_SHARED_ENTITIES_LIST, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void updateEntity(String entityId, String entityType, String jsonEntityData, String jsonEntityAcl, int version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.version.name(), version);
            JSONObject jsonData = new JSONObject(jsonEntityData);
            data.put(Parameter.data.name(), (Object)jsonData);
            if (StringUtil.IsOptionalParameterValid(jsonEntityAcl)) {
                JSONObject jsonAcl = new JSONObject(jsonEntityAcl);
                data.put(Parameter.acl.name(), (Object)jsonAcl);
            }
            ServerCall sc = new ServerCall(ServiceName.entity, ServiceOperation.UPDATE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateSharedEntity(String targetProfileId, String entityId, String entityType, String jsonEntityData, int version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.targetPlayerId.name(), (Object)targetProfileId);
            data.put(Parameter.version.name(), version);
            JSONObject jsonData = new JSONObject(jsonEntityData);
            data.put(Parameter.data.name(), (Object)jsonData);
            ServerCall sc = new ServerCall(ServiceName.entity, ServiceOperation.UPDATE_SHARED, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateSingleton(String entityType, String jsonEntityData, String jsonAclData, int version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityType.name(), (Object)entityType);
            data.put(Parameter.version.name(), version);
            JSONObject jsonData = new JSONObject(jsonEntityData);
            data.put(Parameter.data.name(), (Object)jsonData);
            if (StringUtil.IsOptionalParameterValid(jsonAclData)) {
                JSONObject jsonAcl = new JSONObject(jsonAclData);
                data.put(Parameter.acl.name(), (Object)jsonAcl);
            }
            ServerCall sc = new ServerCall(ServiceName.entity, ServiceOperation.UPDATE_SINGLETON, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getList(String whereJson, String orderByJson, int maxReturn, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (StringUtil.IsOptionalParameterValid(whereJson)) {
                data.put(Parameter.where.name(), (Object)new JSONObject(whereJson));
            }
            if (StringUtil.IsOptionalParameterValid(orderByJson)) {
                data.put(Parameter.orderBy.name(), (Object)new JSONObject(orderByJson));
            }
            data.put(Parameter.maxReturn.name(), maxReturn);
            ServerCall serverCall = new ServerCall(ServiceName.entity, ServiceOperation.GET_LIST, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getListCount(String whereJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.where.name(), (Object)new JSONObject(whereJson));
            ServerCall serverCall = new ServerCall(ServiceName.entity, ServiceOperation.GET_LIST_COUNT, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getPage(String jsonContext, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONObject context = new JSONObject(jsonContext);
            data.put(Parameter.context.name(), (Object)context);
            ServerCall sc = new ServerCall(ServiceName.entity, ServiceOperation.GET_PAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getPageOffset(String context, int pageOffset, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.context.name(), (Object)context);
            data.put(Parameter.pageOffset.name(), pageOffset);
            ServerCall sc = new ServerCall(ServiceName.entity, ServiceOperation.GET_PAGE_BY_OFFSET, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void incrementUserEntityData(String entityId, String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            ServerCall sc = new ServerCall(ServiceName.entity, ServiceOperation.INCREMENT_USER_ENTITY_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void incrementSharedUserEntityData(String entityId, String targetProfileId, String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.entityId.name(), (Object)entityId);
            data.put(Parameter.targetPlayerId.name(), (Object)targetProfileId);
            data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            ServerCall sc = new ServerCall(ServiceName.entity, ServiceOperation.INCREMENT_SHARED_USER_ENTITY_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static enum Parameter {
        entityId,
        entityType,
        acl,
        context,
        pageOffset,
        maxReturn,
        where,
        orderBy,
        targetPlayerId,
        version,
        data;

    }
}

