/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.IAchievementsDelegate;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GamificationService {
    private BrainCloudClient _client;
    public IAchievementsDelegate m_achievementsDelegate;

    public GamificationService(BrainCloudClient client) {
        this._client = client;
    }

    public void setAchievementAwardedDelegate(IAchievementsDelegate delegate) {
        this.m_achievementsDelegate = delegate;
    }

    public void readAllGamification(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readMilestones(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_MILESTONES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readAchievements(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_ACHIEVEMENTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readXpLevels(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_XP_LEVELS, null, callback);
        this._client.sendRequest(sc);
    }

    public void readAchievedAchievements(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_ACHIEVED_ACHIEVEMENTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readCompletedMilestones(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_COMPLETED_MILESTONES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readInProgressMilestones(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_IN_PROGRESS_MILESTONES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readMilestonesByCategory(String category, boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.category.name(), (Object)category);
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_MILESTONES_BY_CATEGORY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void awardAchievements(String[] achievementIds, IServerCallback callback) {
        try {
            JSONArray achievements = new JSONArray();
            for (String achId : achievementIds) {
                achievements.put((Object)achId);
            }
            JSONObject data = new JSONObject();
            data.put(Parameter.achievements.name(), (Object)achievements);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.AWARD_ACHIEVEMENTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void checkForAchievementsToAward(ServiceName serviceName, ServiceOperation serviceOperation, String data) {
        try {
            JSONObject incomingData = new JSONObject(data);
            if (!incomingData.isNull(Parameter.data.name())) {
                JSONArray josnData = incomingData.optJSONArray(Parameter.data.name());
                if (data != null) {
                    // empty if block
                }
                if (this.m_achievementsDelegate != null) {
                    this.m_achievementsDelegate.serverCallback(serviceName, serviceOperation, data.toString());
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readQuests(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_QUESTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readQuestsCompleted(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_COMPLETED_QUESTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readQuestsInProgress(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_IN_PROGRESS_QUESTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readQuestsNotStarted(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_NOT_STARTED_QUESTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readQuestsWithStatus(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_QUESTS_WITH_STATUS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readQuestsWithBasicPercentage(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_QUESTS_WITH_BASIC_PERCENTAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readQuestsWithComplexPercentage(boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_QUESTS_WITH_COMPLEX_PERCENTAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void readQuestsByCategory(String category, boolean includeMetaData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.category.name(), (Object)category);
            data.put(Parameter.includeMetaData.name(), includeMetaData);
            ServerCall sc = new ServerCall(ServiceName.gamification, ServiceOperation.READ_QUESTS_BY_CATEGORY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static enum Parameter {
        includeMetaData,
        category,
        achievements,
        data,
        milestones;

    }
}

