/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class MatchMakingService {
    private BrainCloudClient _client;

    public MatchMakingService(BrainCloudClient client) {
        this._client = client;
    }

    public void read(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.READ, null, callback);
        this._client.sendRequest(sc);
    }

    public void setPlayerRating(long playerRating, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.playerRating.name(), playerRating);
            ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.SET_PLAYER_RATING, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void resetPlayerRating(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.RESET_PLAYER_RATING, null, callback);
        this._client.sendRequest(sc);
    }

    public void incrementPlayerRating(long increment, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.playerRating.name(), increment);
            ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.INCREMENT_PLAYER_RATING, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void decrementPlayerRating(long decrement, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.playerRating.name(), decrement);
            ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.DECREMENT_PLAYER_RATING, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void turnShieldOn(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.SHIELD_ON, null, callback);
        this._client.sendRequest(sc);
    }

    public void turnShieldOnFor(int minutes, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.minutes.name(), minutes);
            ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.SHIELD_ON_FOR, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void incrementShieldOnFor(int minutes, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.minutes.name(), minutes);
            ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.INCREMENT_SHIELD_ON_FOR, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void turnShieldOff(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.SHIELD_OFF, null, callback);
        this._client.sendRequest(sc);
    }

    public void getShieldExpiry(String playerId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (StringUtil.IsOptionalParameterValid(playerId)) {
                data.put(Parameter.playerId.name(), (Object)playerId);
            }
            ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.GET_SHIELD_EXPIRY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void findPlayers(long rangeDelta, long numMatches, IServerCallback callback) {
        this.findPlayersWithAttributes(rangeDelta, numMatches, null, callback);
    }

    public void findPlayersWithAttributes(long rangeDelta, long numMatches, String jsonAttributes, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.rangeDelta.name(), rangeDelta);
            data.put(Parameter.numMatches.name(), numMatches);
            if (StringUtil.IsOptionalParameterValid(jsonAttributes)) {
                JSONObject jsonData = new JSONObject(jsonAttributes);
                data.put(Parameter.attributes.name(), (Object)jsonData);
            }
            ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.FIND_PLAYERS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void findPlayersUsingFilter(long rangeDelta, long numMatches, String jsonExtraParms, IServerCallback callback) {
        this.findPlayersWithAttributesUsingFilter(rangeDelta, numMatches, null, jsonExtraParms, callback);
    }

    public void findPlayersWithAttributesUsingFilter(long rangeDelta, long numMatches, String jsonAttributes, String jsonExtraParms, IServerCallback callback) {
        try {
            JSONObject jsonData;
            JSONObject data = new JSONObject();
            data.put(Parameter.rangeDelta.name(), rangeDelta);
            data.put(Parameter.numMatches.name(), numMatches);
            if (StringUtil.IsOptionalParameterValid(jsonExtraParms)) {
                jsonData = new JSONObject(jsonExtraParms);
                data.put(Parameter.extraParms.name(), (Object)jsonData);
            }
            if (StringUtil.IsOptionalParameterValid(jsonAttributes)) {
                jsonData = new JSONObject(jsonAttributes);
                data.put(Parameter.attributes.name(), (Object)jsonData);
            }
            ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.FIND_PLAYERS_USING_FILTER, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void enableMatchMaking(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.ENABLE_FOR_MATCH, null, callback);
        this._client.sendRequest(sc);
    }

    public void disableMatchMaking(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.matchMaking, ServiceOperation.DISABLE_FOR_MATCH, null, callback);
        this._client.sendRequest(sc);
    }

    private static enum Parameter {
        playerRating,
        minutes,
        rangeDelta,
        numMatches,
        extraParms,
        attributes,
        playerId;

    }
}

