/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MessagingService {
    private BrainCloudClient _client;

    public MessagingService(BrainCloudClient client) {
        this._client = client;
    }

    public void deleteMessages(String msgbox, ArrayList<String> msgIds, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.msgbox.name(), (Object)msgbox);
            if (msgIds != null) {
                data.put(Parameter.msgIds.name(), (Object)new JSONArray(msgIds));
            }
            ServerCall sc = new ServerCall(ServiceName.messaging, ServiceOperation.DELETE_MESSAGES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getMessageboxes(IServerCallback callback) {
        JSONObject data = new JSONObject();
        ServerCall sc = new ServerCall(ServiceName.messaging, ServiceOperation.GET_MESSAGE_BOXES, data, callback);
        this._client.sendRequest(sc);
    }

    public void getMessageCounts(IServerCallback callback) {
        JSONObject data = new JSONObject();
        ServerCall sc = new ServerCall(ServiceName.messaging, ServiceOperation.GET_MESSAGE_COUNTS, data, callback);
        this._client.sendRequest(sc);
    }

    public void getMessages(String msgbox, ArrayList<String> msgIds, Boolean markAsRead, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.msgbox.name(), (Object)msgbox);
            if (msgIds != null) {
                data.put(Parameter.msgIds.name(), (Object)new JSONArray(msgIds));
            }
            data.put(Parameter.markAsRead.name(), (Object)markAsRead);
            ServerCall sc = new ServerCall(ServiceName.messaging, ServiceOperation.GET_MESSAGES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getMessagesPage(String context, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (StringUtil.IsOptionalParameterValid(context)) {
                data.put(Parameter.context.name(), (Object)new JSONObject(context));
            }
            ServerCall sc = new ServerCall(ServiceName.messaging, ServiceOperation.GET_MESSAGES_PAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getMessagesPageOffset(String context, int pageOffset, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.context.name(), (Object)context);
            data.put(Parameter.pageOffset.name(), pageOffset);
            ServerCall sc = new ServerCall(ServiceName.messaging, ServiceOperation.GET_MESSAGES_PAGE_OFFSET, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void sendMessage(ArrayList<String> toProfileIds, String contentJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (toProfileIds != null) {
                data.put(Parameter.toProfileIds.name(), (Object)new JSONArray(toProfileIds));
            }
            data.put(Parameter.contentJson.name(), (Object)new JSONObject(contentJson));
            ServerCall sc = new ServerCall(ServiceName.messaging, ServiceOperation.SEND_MESSAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void sendMessageSimple(ArrayList<String> toProfileIds, String messageText, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (toProfileIds != null) {
                data.put(Parameter.toProfileIds.name(), (Object)new JSONArray(toProfileIds));
            }
            data.put(Parameter.text.name(), (Object)messageText);
            ServerCall sc = new ServerCall(ServiceName.messaging, ServiceOperation.SEND_MESSAGE_SIMPLE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void markMessagesRead(String msgbox, ArrayList<String> msgIds, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.msgbox.name(), (Object)msgbox);
            if (msgIds != null) {
                data.put(Parameter.msgIds.name(), (Object)new JSONArray(msgIds));
            }
            ServerCall sc = new ServerCall(ServiceName.messaging, ServiceOperation.MARK_MESSAGES_READ, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private static enum Parameter {
        msgbox,
        markAsRead,
        msgIds,
        context,
        pageOffset,
        toProfileIds,
        contentJson,
        text,
        subject;

    }
}

