/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONException;
import org.json.JSONObject;

public class OneWayMatchService {
    private BrainCloudClient _client;

    public OneWayMatchService(BrainCloudClient client) {
        this._client = client;
    }

    public void startMatch(String otherPlayerId, long rangeDelta, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.playerId.name(), (Object)otherPlayerId);
            data.put(Parameter.rangeDelta.name(), rangeDelta);
            ServerCall sc = new ServerCall(ServiceName.onewayMatch, ServiceOperation.START_MATCH, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void cancelMatch(String playbackStreamId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.playbackStreamId.name(), (Object)playbackStreamId);
            ServerCall sc = new ServerCall(ServiceName.onewayMatch, ServiceOperation.CANCEL_MATCH, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void completeMatch(String playbackStreamId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.playbackStreamId.name(), (Object)playbackStreamId);
            ServerCall sc = new ServerCall(ServiceName.onewayMatch, ServiceOperation.COMPLETE_MATCH, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static enum Parameter {
        playerId,
        rangeDelta,
        playbackStreamId;

    }
}

