/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PlayerStatisticsService {
    private BrainCloudClient _client;

    public PlayerStatisticsService(BrainCloudClient client) {
        this._client = client;
    }

    public void readAllUserStats(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.playerStatistics, ServiceOperation.READ, null, callback);
        this._client.sendRequest(sc);
    }

    public void readUserStatsSubset(String[] statistics, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONArray jsonData = new JSONArray();
            for (String att : statistics) {
                jsonData.put((Object)att);
            }
            data.put(Parameter.statistics.name(), (Object)jsonData);
            ServerCall sc = new ServerCall(ServiceName.playerStatistics, ServiceOperation.READ_SUBSET, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void readUserStatsForCategory(String category, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.category.name(), (Object)category);
            ServerCall sc = new ServerCall(ServiceName.playerStatistics, ServiceOperation.READ_FOR_CATEGORY, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void resetAllUserStats(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.playerStatistics, ServiceOperation.RESET, null, callback);
        this._client.sendRequest(sc);
    }

    public void incrementUserStats(String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONObject jsonDataObj = new JSONObject(jsonData);
            data.put(Parameter.statistics.name(), (Object)jsonDataObj);
            ServerCall sc = new ServerCall(ServiceName.playerStatistics, ServiceOperation.UPDATE_INCREMENT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void incrementExperiencePoints(int xpValue, IServerCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put(Parameter.xp_points.toString(), xpValue);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        ServerCall sc = new ServerCall(ServiceName.playerStatistics, ServiceOperation.UPDATE, data, callback);
        this._client.sendRequest(sc);
    }

    public void getNextExperienceLevel(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.playerStatistics, ServiceOperation.READ_NEXT_XPLEVEL, null, callback);
        this._client.sendRequest(sc);
    }

    public void setExperiencePoints(int xpValue, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.xp_points.name(), xpValue);
            ServerCall sc = new ServerCall(ServiceName.playerStatistics, ServiceOperation.SET_XPPOINTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void processStatistics(String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            JSONObject jsonDataObj = new JSONObject(jsonData);
            data.put(Parameter.statistics.name(), (Object)jsonDataObj);
            ServerCall sc = new ServerCall(ServiceName.playerStatistics, ServiceOperation.PROCESS_STATISTICS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private static enum Parameter {
        statistics,
        category,
        xp_points;

    }
}

