/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.Platform;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PushNotificationService {
    private BrainCloudClient _client;

    public PushNotificationService(BrainCloudClient client) {
        this._client = client;
    }

    public void deregisterAllPushNotificationDeviceTokens(IServerCallback callback) {
        JSONObject data = new JSONObject();
        ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.DEREGISTER_ALL, data, callback);
        this._client.sendRequest(sc);
    }

    public void deregisterPushNotificationDeviceToken(Platform platform, String token, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.deviceType.name(), (Object)platform.toString());
            data.put(Parameter.deviceToken.name(), (Object)token);
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.DEREGISTER, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void registerPushNotificationToken(Platform platform, String token, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.deviceType.name(), (Object)platform.toString());
            data.put(Parameter.deviceToken.name(), (Object)token);
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.REGISTER, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void sendSimplePushNotification(String toProfileId, String message, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.toPlayerId.name(), (Object)toProfileId);
            data.put(Parameter.message.name(), (Object)message);
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SEND_SIMPLE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void sendRichPushNotification(String toProfileId, int notificationTemplateId, IServerCallback callback) {
        this.sendRichPushNotificationWithParams(toProfileId, notificationTemplateId, null, callback);
    }

    public void sendRichPushNotificationWithParams(String toProfileId, int notificationTemplateId, String substitutionJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.toPlayerId.name(), (Object)toProfileId);
            data.put(Parameter.notificationTemplateId.name(), notificationTemplateId);
            if (StringUtil.IsOptionalParameterValid(substitutionJson)) {
                JSONObject subJson = new JSONObject(substitutionJson);
                data.put(Parameter.substitutions.name(), (Object)subJson);
            }
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SEND_RICH, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void sendTemplatedPushNotificationToGroup(String groupId, int notificationTemplateId, String substitutionsJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.notificationTemplateId.name(), notificationTemplateId);
            if (StringUtil.IsOptionalParameterValid(substitutionsJson)) {
                data.put(Parameter.substitutions.name(), (Object)new JSONObject(substitutionsJson));
            }
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SEND_TEMPLATED_TO_GROUP, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void sendNormalizedPushNotificationToGroup(String groupId, String alertContentJson, String customDataJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.alertContent.name(), (Object)new JSONObject(alertContentJson));
            if (StringUtil.IsOptionalParameterValid(customDataJson)) {
                data.put(Parameter.customData.name(), (Object)new JSONObject(customDataJson));
            }
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SEND_NORMALIZED_TO_GROUP, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void scheduleRawPushNotificationUTC(String profileId, String fcmContent, String iosContent, String facebookContent, long startTimeUTC, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileId.name(), (Object)profileId);
            if (StringUtil.IsOptionalParameterValid(fcmContent)) {
                data.put(Parameter.fcmContent.name(), (Object)new JSONObject(fcmContent));
            }
            if (StringUtil.IsOptionalParameterValid(iosContent)) {
                data.put(Parameter.iosContent.name(), (Object)new JSONObject(iosContent));
            }
            if (StringUtil.IsOptionalParameterValid(facebookContent)) {
                data.put(Parameter.facebookContent.name(), (Object)new JSONObject(facebookContent));
            }
            data.put(Parameter.startDateUTC.name(), startTimeUTC);
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SCHEDULE_RAW_NOTIFICATION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void scheduleRawPushNotificationMinutes(String profileId, String fcmContent, String iosContent, String facebookContent, int minutesFromNow, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileId.name(), (Object)profileId);
            if (StringUtil.IsOptionalParameterValid(fcmContent)) {
                data.put(Parameter.fcmContent.name(), (Object)new JSONObject(fcmContent));
            }
            if (StringUtil.IsOptionalParameterValid(iosContent)) {
                data.put(Parameter.iosContent.name(), (Object)new JSONObject(iosContent));
            }
            if (StringUtil.IsOptionalParameterValid(facebookContent)) {
                data.put(Parameter.facebookContent.name(), (Object)new JSONObject(facebookContent));
            }
            data.put(Parameter.minutesFromNow.name(), minutesFromNow);
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SCHEDULE_RAW_NOTIFICATION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void sendRawPushNotification(String toProfileId, String fcmContent, String iosContent, String facebookContent, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.toPlayerId.name(), (Object)toProfileId);
            if (StringUtil.IsOptionalParameterValid(fcmContent)) {
                data.put(Parameter.fcmContent.name(), (Object)new JSONObject(fcmContent));
            }
            if (StringUtil.IsOptionalParameterValid(iosContent)) {
                data.put(Parameter.iosContent.name(), (Object)new JSONObject(iosContent));
            }
            if (StringUtil.IsOptionalParameterValid(facebookContent)) {
                data.put(Parameter.facebookContent.name(), (Object)new JSONObject(facebookContent));
            }
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SEND_RAW, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void sendRawPushNotificationBatch(String[] profileIds, String fcmContent, String iosContent, String facebookContent, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileIds.name(), (Object)new JSONArray((Object)profileIds));
            if (StringUtil.IsOptionalParameterValid(fcmContent)) {
                data.put(Parameter.fcmContent.name(), (Object)new JSONObject(fcmContent));
            }
            if (StringUtil.IsOptionalParameterValid(iosContent)) {
                data.put(Parameter.iosContent.name(), (Object)new JSONObject(iosContent));
            }
            if (StringUtil.IsOptionalParameterValid(facebookContent)) {
                data.put(Parameter.facebookContent.name(), (Object)new JSONObject(facebookContent));
            }
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SEND_RAW_BATCH, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void sendRawPushNotificationToGroup(String groupId, String fcmContent, String iosContent, String facebookContent, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.groupId.name(), (Object)groupId);
            if (StringUtil.IsOptionalParameterValid(fcmContent)) {
                data.put(Parameter.fcmContent.name(), (Object)new JSONObject(fcmContent));
            }
            if (StringUtil.IsOptionalParameterValid(iosContent)) {
                data.put(Parameter.iosContent.name(), (Object)new JSONObject(iosContent));
            }
            if (StringUtil.IsOptionalParameterValid(facebookContent)) {
                data.put(Parameter.facebookContent.name(), (Object)new JSONObject(facebookContent));
            }
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SEND_RAW_TO_GROUP, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void scheduleNormalizedPushNotificationUTC(String profileId, String alertContentJson, String customDataJson, long startTimeUTC, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileId.name(), (Object)profileId);
            data.put(Parameter.alertContent.name(), (Object)new JSONObject(alertContentJson));
            if (StringUtil.IsOptionalParameterValid(customDataJson)) {
                data.put(Parameter.customData.name(), (Object)new JSONObject(customDataJson));
            }
            data.put(Parameter.startDateUTC.name(), startTimeUTC);
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SCHEDULE_NORMALIZED_NOTIFICATION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void scheduleNormalizedPushNotificationMinutes(String profileId, String alertContentJson, String customDataJson, int minutesFromNow, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileId.name(), (Object)profileId);
            data.put(Parameter.alertContent.name(), (Object)new JSONObject(alertContentJson));
            if (StringUtil.IsOptionalParameterValid(customDataJson)) {
                data.put(Parameter.customData.name(), (Object)new JSONObject(customDataJson));
            }
            data.put(Parameter.minutesFromNow.name(), minutesFromNow);
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SCHEDULE_NORMALIZED_NOTIFICATION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void scheduleRichPushNotificationUTC(String profileId, int notificationTemplateId, String substitutionsJson, long startTimeUTC, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileId.name(), (Object)profileId);
            data.put(Parameter.notificationTemplateId.name(), notificationTemplateId);
            if (StringUtil.IsOptionalParameterValid(substitutionsJson)) {
                data.put(Parameter.substitutions.name(), (Object)new JSONObject(substitutionsJson));
            }
            data.put(Parameter.startDateUTC.name(), startTimeUTC);
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SCHEDULE_RICH_NOTIFICATION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void scheduleRichPushNotificationMinutes(String profileId, int notificationTemplateId, String substitutionsJson, int minutesFromNow, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileId.name(), (Object)profileId);
            data.put(Parameter.notificationTemplateId.name(), notificationTemplateId);
            if (StringUtil.IsOptionalParameterValid(substitutionsJson)) {
                data.put(Parameter.substitutions.name(), (Object)new JSONObject(substitutionsJson));
            }
            data.put(Parameter.minutesFromNow.name(), minutesFromNow);
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SCHEDULE_RICH_NOTIFICATION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void sendNormalizedPushNotification(String toProfileId, String alertContentJson, String customDataJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.toPlayerId.name(), (Object)toProfileId);
            data.put(Parameter.alertContent.name(), (Object)new JSONObject(alertContentJson));
            if (StringUtil.IsOptionalParameterValid(customDataJson)) {
                data.put(Parameter.customData.name(), (Object)new JSONObject(customDataJson));
            }
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SEND_NORMALIZED, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void sendNormalizedPushNotificationBatch(String[] profileIds, String alertContentJson, String customDataJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileIds.name(), (Object)new JSONArray((Object)profileIds));
            data.put(Parameter.alertContent.name(), (Object)new JSONObject(alertContentJson));
            if (StringUtil.IsOptionalParameterValid(customDataJson)) {
                data.put(Parameter.customData.name(), (Object)new JSONObject(customDataJson));
            }
            ServerCall sc = new ServerCall(ServiceName.pushNotification, ServiceOperation.SEND_NORMALIZED_BATCH, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private static enum Parameter {
        deviceType,
        deviceToken,
        toPlayerId,
        profileId,
        message,
        notificationTemplateId,
        substitutions,
        groupId,
        alertContent,
        customData,
        profileIds,
        startDateUTC,
        minutesFromNow,
        fcmContent,
        iosContent,
        facebookContent;

    }
}

