/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class S3HandlingService {
    private BrainCloudClient _client;

    public S3HandlingService(BrainCloudClient client) {
        this._client = client;
    }

    public void getUpdatedFiles(String category, String fileDetailsJson, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (StringUtil.IsOptionalParameterValid(category)) {
                data.put(Parameter.category.name(), (Object)category);
            }
            if (StringUtil.IsOptionalParameterValid(fileDetailsJson)) {
                JSONArray jsonFiles = new JSONArray(fileDetailsJson);
                data.put(Parameter.fileDetails.name(), (Object)jsonFiles);
            }
            ServerCall serverCall = new ServerCall(ServiceName.s3Handling, ServiceOperation.GET_UPDATED_FILES, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getFileList(String category, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            if (StringUtil.IsOptionalParameterValid(category)) {
                data.put(Parameter.category.name(), (Object)category);
            }
            ServerCall serverCall = new ServerCall(ServiceName.s3Handling, ServiceOperation.GET_FILE_LIST, data, callback);
            this._client.sendRequest(serverCall);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getCDNUrl(String fileId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.fileId.name(), (Object)fileId);
            ServerCall sc = new ServerCall(ServiceName.s3Handling, ServiceOperation.GET_CDN_URL, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public static enum Parameter {
        category,
        fileDetails,
        fileId;

    }
}

