/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class ScriptService {
    private BrainCloudClient _client;

    public ScriptService(BrainCloudClient client) {
        this._client = client;
    }

    public void runScript(String scriptName, String jsonScriptData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.scriptName.name(), (Object)scriptName);
            if (StringUtil.IsOptionalParameterValid(jsonScriptData)) {
                JSONObject jsonData = new JSONObject(jsonScriptData);
                data.put(Parameter.scriptData.name(), (Object)jsonData);
            }
            ServerCall sc = new ServerCall(ServiceName.script, ServiceOperation.RUN, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void scheduleRunScriptUTC(String scriptName, String jsonScriptData, Date startTimeUTC, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.scriptName.name(), (Object)scriptName);
            if (StringUtil.IsOptionalParameterValid(jsonScriptData)) {
                JSONObject jsonData = new JSONObject(jsonScriptData);
                data.put(Parameter.scriptData.name(), (Object)jsonData);
            }
            data.put(Parameter.startDateUTC.name(), startTimeUTC.getTime());
            ServerCall sc = new ServerCall(ServiceName.script, ServiceOperation.SCHEDULE_CLOUD_SCRIPT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void scheduleRunScriptMillisUTC(String scriptName, String jsonScriptData, long startTimeUTC, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.scriptName.name(), (Object)scriptName);
            if (StringUtil.IsOptionalParameterValid(jsonScriptData)) {
                JSONObject jsonData = new JSONObject(jsonScriptData);
                data.put(Parameter.scriptData.name(), (Object)jsonData);
            }
            data.put(Parameter.startDateUTC.name(), startTimeUTC);
            ServerCall sc = new ServerCall(ServiceName.script, ServiceOperation.SCHEDULE_CLOUD_SCRIPT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void scheduleRunScriptMinutes(String scriptName, String jsonScriptData, int minutesFromNow, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.scriptName.name(), (Object)scriptName);
            if (StringUtil.IsOptionalParameterValid(jsonScriptData)) {
                JSONObject jsonData = new JSONObject(jsonScriptData);
                data.put(Parameter.scriptData.name(), (Object)jsonData);
            }
            data.put(Parameter.minutesFromNow.name(), minutesFromNow);
            ServerCall sc = new ServerCall(ServiceName.script, ServiceOperation.SCHEDULE_CLOUD_SCRIPT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void runParentScript(String scriptName, String scriptData, String parentLevel, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.scriptName.name(), (Object)scriptName);
            data.put(Parameter.parentLevel.name(), (Object)parentLevel);
            if (StringUtil.IsOptionalParameterValid(scriptData)) {
                JSONObject jsonData = new JSONObject(scriptData);
                data.put(Parameter.scriptData.name(), (Object)jsonData);
            }
            ServerCall sc = new ServerCall(ServiceName.script, ServiceOperation.RUN_PARENT_SCRIPT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getScheduledCloudScripts(Date startTimeUTC, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.startDateUTC.name(), startTimeUTC.getTime());
            ServerCall sc = new ServerCall(ServiceName.script, ServiceOperation.GET_SCHEDULED_CLOUD_SCRIPTS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getRunningOrQueuedCloudScripts(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.script, ServiceOperation.GET_RUNNING_OR_QUEUED_CLOUD_SCRIPTS, null, callback);
        this._client.sendRequest(sc);
    }

    public void cancelScheduledScript(String jobId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.jobId.name(), (Object)jobId);
            ServerCall sc = new ServerCall(ServiceName.script, ServiceOperation.CANCEL_SCHEDULED_SCRIPT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void runPeerScript(String scriptName, String jsonScriptData, String peer, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.scriptName.name(), (Object)scriptName);
            data.put(Parameter.peer.name(), (Object)peer);
            if (StringUtil.IsOptionalParameterValid(jsonScriptData)) {
                JSONObject jsonData = new JSONObject(jsonScriptData);
                data.put(Parameter.scriptData.name(), (Object)jsonData);
            }
            ServerCall sc = new ServerCall(ServiceName.script, ServiceOperation.RUN_PEER_SCRIPT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void runPeerScriptAsync(String scriptName, String jsonScriptData, String peer, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.scriptName.name(), (Object)scriptName);
            data.put(Parameter.peer.name(), (Object)peer);
            if (StringUtil.IsOptionalParameterValid(jsonScriptData)) {
                JSONObject jsonData = new JSONObject(jsonScriptData);
                data.put(Parameter.scriptData.name(), (Object)jsonData);
            }
            ServerCall sc = new ServerCall(ServiceName.script, ServiceOperation.RUN_PEER_SCRIPT_ASYNC, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public static enum Parameter {
        scriptName,
        scriptData,
        startDateUTC,
        minutesFromNow,
        parentLevel,
        jobId,
        peer;

    }
}

