/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import com.bitheads.braincloud.services.StringUtil;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SocialLeaderboardService {
    private BrainCloudClient _client;

    public SocialLeaderboardService(BrainCloudClient client) {
        this._client = client;
    }

    public void getSocialLeaderboard(String leaderboardId, boolean replaceName, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.replaceName.name(), replaceName);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_SOCIAL_LEADERBOARD, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getSocialLeaderboardByVersion(String leaderboardId, boolean replaceName, int versionId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.replaceName.name(), replaceName);
            data.put(Parameter.versionId.name(), versionId);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_SOCIAL_LEADERBOARD_BY_VERSION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getMultiSocialLeaderboard(String[] leaderboardIds, int leaderboardResultCount, boolean replaceName, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardIds.name(), (Object)leaderboardIds);
            data.put(Parameter.leaderboardResultCount.name(), leaderboardResultCount);
            data.put(Parameter.replaceName.name(), replaceName);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_MULTI_SOCIAL_LEADERBOARD, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGlobalLeaderboardPage(String leaderboardId, SortOrder sort, int startIndex, int endIndex, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.sort.name(), (Object)sort.name());
            data.put(Parameter.startIndex.name(), startIndex);
            data.put(Parameter.endIndex.name(), endIndex);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_GLOBAL_LEADERBOARD_PAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGlobalLeaderboardPageByVersion(String leaderboardId, SortOrder sort, int startIndex, int endIndex, int versionId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.sort.name(), (Object)sort.name());
            data.put(Parameter.startIndex.name(), startIndex);
            data.put(Parameter.endIndex.name(), endIndex);
            data.put(Parameter.versionId.name(), versionId);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_GLOBAL_LEADERBOARD_PAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGlobalLeaderboardView(String leaderboardId, SortOrder sort, int beforeCount, int afterCount, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.sort.name(), (Object)sort.name());
            data.put(Parameter.beforeCount.name(), beforeCount);
            data.put(Parameter.afterCount.name(), afterCount);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_GLOBAL_LEADERBOARD_VIEW, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGlobalLeaderboardViewByVersion(String leaderboardId, SortOrder sort, int beforeCount, int afterCount, int versionId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.sort.name(), (Object)sort.name());
            data.put(Parameter.beforeCount.name(), beforeCount);
            data.put(Parameter.afterCount.name(), afterCount);
            data.put(Parameter.versionId.name(), versionId);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_GLOBAL_LEADERBOARD_VIEW, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGlobalLeaderboardVersions(String leaderboardId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_GLOBAL_LEADERBOARD_VERSIONS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGlobalLeaderboardEntryCount(String leaderboardId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_GLOBAL_LEADERBOARD_ENTRY_COUNT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGlobalLeaderboardEntryCountByVersion(String leaderboardId, int versionId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.versionId.name(), versionId);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_GLOBAL_LEADERBOARD_ENTRY_COUNT, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postScoreToLeaderboard(String leaderboardId, long score, String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.score.name(), score);
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            }
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.POST_SCORE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postScoreToDynamicLeaderboard(String leaderboardId, long score, String jsonData, String leaderboardType, String rotationType, Date rotationReset, int retainedCount, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.score.name(), score);
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            }
            data.put(Parameter.leaderboardType.name(), (Object)leaderboardType);
            data.put(Parameter.rotationType.name(), (Object)rotationType);
            if (rotationReset != null) {
                data.put(Parameter.rotationResetTime.name(), rotationReset.getTime());
            }
            data.put(Parameter.retainedCount.name(), retainedCount);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.POST_SCORE_DYNAMIC, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postScoreToDynamicLeaderboardUTC(String leaderboardId, long score, String jsonData, String leaderboardType, String rotationType, long rotationResetUTC, int retainedCount, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.score.name(), score);
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            }
            data.put(Parameter.leaderboardType.name(), (Object)leaderboardType);
            data.put(Parameter.rotationType.name(), (Object)rotationType);
            data.put(Parameter.rotationResetTime.name(), rotationResetUTC);
            data.put(Parameter.retainedCount.name(), retainedCount);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.POST_SCORE_DYNAMIC, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postScoreToDynamicGroupLeaderboardDaysUTC(String leaderboardId, String groupId, long score, String jsonData, String leaderboardType, long rotationResetUTC, int retainedCount, int numDaysToRotate, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.score.name(), score);
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            }
            data.put(Parameter.leaderboardType.name(), (Object)leaderboardType);
            data.put(Parameter.rotationType.name(), (Object)"DAYS");
            data.put(Parameter.rotationResetTime.name(), rotationResetUTC);
            data.put(Parameter.retainedCount.name(), retainedCount);
            data.put(Parameter.numDaysToRotate.name(), numDaysToRotate);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.POST_GROUP_SCORE_DYNAMIC, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postScoreToDynamicLeaderboardDays(String leaderboardId, long score, String jsonData, String leaderboardType, Date rotationReset, int retainedCount, int numDaysToRotate, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.score.name(), score);
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            }
            data.put(Parameter.leaderboardType.name(), (Object)leaderboardType);
            data.put(Parameter.rotationType.name(), (Object)"DAYS");
            data.put(Parameter.numDaysToRotate.name(), numDaysToRotate);
            if (rotationReset != null) {
                data.put(Parameter.rotationResetTime.name(), rotationReset.getTime());
            }
            data.put(Parameter.retainedCount.name(), retainedCount);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.POST_SCORE_DYNAMIC, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postScoreToDynamicLeaderboardDaysUTC(String leaderboardId, long score, String jsonData, String leaderboardType, long rotationResetUTC, int retainedCount, int numDaysToRotate, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.score.name(), score);
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            }
            data.put(Parameter.leaderboardType.name(), (Object)leaderboardType);
            data.put(Parameter.rotationType.name(), (Object)"DAYS");
            data.put(Parameter.numDaysToRotate.name(), numDaysToRotate);
            data.put(Parameter.rotationResetTime.name(), rotationResetUTC);
            data.put(Parameter.retainedCount.name(), retainedCount);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.POST_SCORE_DYNAMIC, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void removePlayerScore(String leaderboardId, int versionId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.versionId.name(), versionId);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.REMOVE_PLAYER_SCORE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGroupSocialLeaderboard(String leaderboardId, String groupId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.groupId.name(), (Object)groupId);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_GROUP_SOCIAL_LEADERBOARD, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGroupSocialLeaderboardByVersion(String leaderboardId, String groupId, int versionId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.versionId.name(), versionId);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_GROUP_SOCIAL_LEADERBOARD_BY_VERSION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getPlayersSocialLeaderboard(String leaderboardId, String[] profileIds, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.profileIds.name(), (Object)new JSONArray((Object)profileIds));
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_PLAYERS_SOCIAL_LEADERBOARD, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getPlayersSocialLeaderboardByVersion(String leaderboardId, String[] profileIds, int versionId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.profileIds.name(), (Object)new JSONArray((Object)profileIds));
            data.put(Parameter.versionId.name(), versionId);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_PLAYERS_SOCIAL_LEADERBOARD_BY_VERSION, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void listAllLeaderboards(IServerCallback callback) {
        ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.LIST_ALL_LEADERBOARDS, null, callback);
        this._client.sendRequest(sc);
    }

    public void getPlayerScore(String leaderboardId, int versionId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.versionId.name(), versionId);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_PLAYER_SCORE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getPlayerScores(String leaderboardId, int versionId, int maxResults, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.versionId.name(), versionId);
            data.put(Parameter.maxResults.name(), maxResults);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_PLAYER_SCORES, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getPlayerScoresFromLeaderboards(String[] leaderboardIds, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardIds.name(), (Object)leaderboardIds);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_PLAYER_SCORES_FROM_LEADERBOARDS, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postScoreToGroupLeaderboard(String leaderboardId, String groupId, int score, String jsonData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.score.name(), score);
            if (StringUtil.IsOptionalParameterValid(jsonData)) {
                data.put(Parameter.data.name(), (Object)new JSONObject(jsonData));
            }
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.POST_GROUP_SCORE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postScoreToDynamicGroupLeaderboard(String leaderboardId, String groupId, long score, String data, String leaderboardType, String rotationType, Date rotationReset, int retainedCount, IServerCallback callback) {
        try {
            JSONObject message = new JSONObject();
            message.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            message.put(Parameter.groupId.name(), (Object)groupId);
            message.put(Parameter.score.name(), score);
            if (StringUtil.IsOptionalParameterValid(data)) {
                message.put(Parameter.data.name(), (Object)new JSONObject(data));
            }
            message.put(Parameter.leaderboardType.name(), (Object)leaderboardType);
            message.put(Parameter.rotationType.name(), (Object)rotationType);
            if (rotationReset != null) {
                message.put(Parameter.rotationResetTime.name(), rotationReset.getTime());
            }
            message.put(Parameter.retainedCount.name(), retainedCount);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.POST_GROUP_SCORE_DYNAMIC, message, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void postScoreToDynamicGroupLeaderboardUTC(String leaderboardId, String groupId, long score, String data, String leaderboardType, String rotationType, long rotationResetUTC, int retainedCount, IServerCallback callback) {
        try {
            JSONObject message = new JSONObject();
            message.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            message.put(Parameter.groupId.name(), (Object)groupId);
            message.put(Parameter.score.name(), score);
            if (StringUtil.IsOptionalParameterValid(data)) {
                message.put(Parameter.data.name(), (Object)new JSONObject(data));
            }
            message.put(Parameter.leaderboardType.name(), (Object)leaderboardType);
            message.put(Parameter.rotationType.name(), (Object)rotationType);
            message.put(Parameter.rotationResetTime.name(), rotationResetUTC);
            message.put(Parameter.retainedCount.name(), retainedCount);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.POST_GROUP_SCORE_DYNAMIC, message, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void removeGroupScore(String leaderboardId, String groupId, int versionId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.versionId.name(), versionId);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.REMOVE_GROUP_SCORE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGroupLeaderboardView(String leaderboardId, String groupId, SortOrder sort, int beforeCount, int afterCount, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.sort.name(), (Object)sort.name());
            data.put(Parameter.beforeCount.name(), beforeCount);
            data.put(Parameter.afterCount.name(), afterCount);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_GROUP_LEADERBOARD_VIEW, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    public void getGroupLeaderboardViewByVersion(String leaderboardId, String groupId, int versionId, SortOrder sort, int beforeCount, int afterCount, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.leaderboardId.name(), (Object)leaderboardId);
            data.put(Parameter.groupId.name(), (Object)groupId);
            data.put(Parameter.versionId.name(), versionId);
            data.put(Parameter.sort.name(), (Object)sort.name());
            data.put(Parameter.beforeCount.name(), beforeCount);
            data.put(Parameter.afterCount.name(), afterCount);
            ServerCall sc = new ServerCall(ServiceName.leaderboard, ServiceOperation.GET_GROUP_LEADERBOARD_VIEW, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private static enum Parameter {
        leaderboardId,
        leaderboardIds,
        maxResults,
        replaceName,
        score,
        data,
        eventName,
        eventMultiplier,
        leaderboardType,
        rotationType,
        rotationReset,
        rotationResetTime,
        retainedCount,
        sort,
        startIndex,
        endIndex,
        beforeCount,
        afterCount,
        includeLeaderboardSize,
        versionId,
        leaderboardResultCount,
        groupId,
        profileIds,
        numDaysToRotate;

    }

    public static enum SortOrder {
        HIGH_TO_LOW,
        LOW_TO_HIGH;

    }

    public static enum RotationType {
        NEVER,
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY;

    }

    public static enum SocialLeaderboardType {
        HIGH_VALUE,
        CUMULATIVE,
        LOW_VALUE,
        LAST_VALUE;

    }
}

