/*
 * Decompiled with CFR 0.152.
 */
package com.bitheads.braincloud.services;

import com.bitheads.braincloud.client.BrainCloudClient;
import com.bitheads.braincloud.client.IServerCallback;
import com.bitheads.braincloud.client.ServiceName;
import com.bitheads.braincloud.client.ServiceOperation;
import com.bitheads.braincloud.comms.ServerCall;
import org.json.JSONException;
import org.json.JSONObject;

public class UserItemsService {
    private BrainCloudClient _client;

    public UserItemsService(BrainCloudClient client) {
        this._client = client;
    }

    public void awardUserItem(String defId, int quantity, boolean includeDef, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.defId.name(), (Object)defId);
            data.put(Parameter.quantity.name(), quantity);
            data.put(Parameter.includeDef.name(), includeDef);
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.AWARD_USER_ITEM, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void dropUserItem(String itemId, int quantity, boolean includeDef, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.itemId.name(), (Object)itemId);
            data.put(Parameter.quantity.name(), quantity);
            data.put(Parameter.includeDef.name(), includeDef);
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.DROP_USER_ITEM, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getUserItemsPage(String context, boolean includeDef, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.context.name(), (Object)new JSONObject(context));
            data.put(Parameter.includeDef.name(), includeDef);
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.GET_USER_ITEMS_PAGE, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getUserItemsPageOffset(String context, int pageOffset, boolean includeDef, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.context.name(), (Object)context);
            data.put(Parameter.pageOffset.name(), pageOffset);
            data.put(Parameter.includeDef.name(), includeDef);
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.GET_USER_ITEMS_PAGE_OFFSET, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void getUserItem(String itemId, boolean includeDef, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.itemId.name(), (Object)itemId);
            data.put(Parameter.includeDef.name(), includeDef);
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.GET_USER_ITEM, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void giveUserItemTo(String profileId, String itemId, int version, int quantity, boolean immediate, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileId.name(), (Object)profileId);
            data.put(Parameter.itemId.name(), (Object)itemId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.quantity.name(), quantity);
            data.put(Parameter.immediate.name(), immediate);
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.GIVE_USER_ITEM_TO, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void purchaseUserItem(String defId, int quantity, String shopId, boolean includeDef, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.defId.name(), (Object)defId);
            data.put(Parameter.quantity.name(), quantity);
            data.put(Parameter.shopId.name(), (Object)shopId);
            data.put(Parameter.includeDef.name(), includeDef);
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.PURCHASE_USER_ITEM, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void receiveUserItemFrom(String profileId, String itemId, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.profileId.name(), (Object)profileId);
            data.put(Parameter.itemId.name(), (Object)itemId);
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.RECEIVE_USER_ITEM_FROM, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void sellUserItem(String itemId, int version, int quantity, String shopId, boolean includeDef, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.itemId.name(), (Object)itemId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.quantity.name(), quantity);
            data.put(Parameter.shopId.name(), (Object)shopId);
            data.put(Parameter.includeDef.name(), includeDef);
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.SELL_USER_ITEM, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void updateUserItemData(String itemId, int version, String newItemData, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.itemId.name(), (Object)itemId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.newItemData.name(), (Object)new JSONObject(newItemData));
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.UPDATE_USER_ITEM_DATA, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void useUserItem(String itemId, int version, String newItemData, boolean includeDef, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.itemId.name(), (Object)itemId);
            data.put(Parameter.version.name(), version);
            data.put(Parameter.newItemData.name(), (Object)new JSONObject(newItemData));
            data.put(Parameter.includeDef.name(), includeDef);
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.USE_USER_ITEM, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void publishUserItemToBlockchain(String itemId, int version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.itemId.name(), (Object)itemId);
            data.put(Parameter.version.name(), version);
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.PUBLISH_USER_ITEM_TO_BLOCKCHAIN, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void refreshBlockchainUserItems(IServerCallback callback) {
        JSONObject data = new JSONObject();
        ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.REFRESH_BLOCKCHAIN_USER_ITEMS, data, callback);
        this._client.sendRequest(sc);
    }

    public void removeUserItemFromBlockchain(String itemId, int version, IServerCallback callback) {
        try {
            JSONObject data = new JSONObject();
            data.put(Parameter.itemId.name(), (Object)itemId);
            data.put(Parameter.version.name(), version);
            ServerCall sc = new ServerCall(ServiceName.userItems, ServiceOperation.REMOVE_USER_ITEM_FROM_BLOCKCHAIN, data, callback);
            this._client.sendRequest(sc);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static enum Parameter {
        defId,
        quantity,
        includeDef,
        criteria,
        context,
        pageOffset,
        itemId,
        version,
        immediate,
        shopId,
        newItemData,
        profileId;

    }
}

