/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.simplegraph.java;

import com.bitplan.simplegraph.core.SimpleNode;
import com.bitplan.simplegraph.java.JavaSourceNode;
import com.bitplan.simplegraph.java.JavaSystem;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.comments.Comment;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.logging.Logger;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;

public class TestJavaSystem {
    public static boolean debug = false;
    protected static Logger LOGGER = Logger.getLogger("com.bitplan.simplegraph.java");

    @Test
    public void testJavaSystem() {
        JavaSystem js = new JavaSystem();
        JavaSourceNode jsn = (JavaSourceNode)js.moveTo("../simplegraph-java/src/test/java/com/bitplan/simplegraph/java/TestJavaSystem.java", new String[0]);
        debug = true;
        if (debug) {
            js.forAll(SimpleNode.printDebug);
            CompilationUnit cu = jsn.compilationUnit;
            cu.walk(node -> System.out.println(node.getClass().getName()));
        }
        MethodDeclaration md = (MethodDeclaration)((Vertex)js.g().V(new Object[0]).hasLabel("MethodDeclaration", new String[0]).has("name", (Object)"testJavaSystem").next()).property("node").value();
        Assert.assertTrue((boolean)md.getComment().isPresent());
        Assert.assertTrue((boolean)((Comment)md.getComment().get()).getContent().contains("test for the Java System"));
    }

    @Test
    public void testClasses() {
        JavaSystem js = new JavaSystem();
        JavaSourceNode jsn = (JavaSourceNode)js.moveTo("../simplegraph-java/src/test/java/com/bitplan/simplegraph/java/TestJavaSystem.java", new String[0]);
        List cdNodes = js.g().V(new Object[0]).hasLabel("ClassOrInterfaceDeclaration", new String[0]).toList();
        Assert.assertEquals((long)2L, (long)cdNodes.size());
        for (Vertex cdNode : cdNodes) {
            SimpleNode.printDebug.accept(cdNode);
        }
    }

    @Test
    public void testJavaParser() throws FileNotFoundException {
        File srcFile = new File("../simplegraph-powerpoint/src/main/java/com/bitplan/simplegraph/powerpoint/PowerPointSystem.java");
        Assert.assertTrue((boolean)srcFile.exists());
        CompilationUnit cu = JavaParser.parse((File)srcFile);
        if (debug) {
            cu.walk(node -> {
                if (node instanceof MethodDeclaration) {
                    MethodDeclaration md = (MethodDeclaration)node;
                    System.out.println(String.format("%s:%s", node.getClass().getSimpleName(), md.getNameAsString()));
                    System.out.println(node.toString());
                }
            });
        }
    }

    public static class AClass {
        public void aMethod() {
        }
    }
}

