/*
 * Decompiled with CFR 0.152.
 */
package com.blockscore.models;

import com.blockscore.models.Address;
import com.blockscore.models.CompanyDetails;
import com.blockscore.models.CorporationType;
import com.blockscore.models.base.BasicResponse;
import com.blockscore.net.BlockscoreApiClient;
import com.blockscore.net.BlockscoreRestAdapter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Company
extends BasicResponse {
    @JsonProperty(value="entity_name")
    @NotNull
    private String entityName;
    @JsonProperty(value="tax_id")
    @NotNull
    private String taxId;
    @JsonProperty(value="incorporation_state")
    @Nullable
    private String incorporationState;
    @JsonProperty(value="incorporation_country_code")
    @NotNull
    private String incorporationCountryCode;
    @JsonProperty(value="incorporation_type")
    @NotNull
    private String incorporationType;
    @JsonProperty(value="incorporation_day")
    @Nullable
    private Integer incorporationDay;
    @JsonProperty(value="incorporation_month")
    @Nullable
    private Integer incorporationMonth;
    @JsonProperty(value="incorporation_year")
    @Nullable
    private Integer incorporationYear;
    @JsonProperty(value="dbas")
    @Nullable
    private String dbas;
    @JsonProperty(value="registration_number")
    @Nullable
    private String registrationNumber;
    @JsonProperty(value="email")
    @Nullable
    private String email;
    @JsonProperty(value="url")
    @Nullable
    private String url;
    @JsonProperty(value="phone_number")
    @Nullable
    private String phoneNumber;
    @JsonProperty(value="ip_address")
    @Nullable
    private String ipAddress;
    @JsonProperty(value="note")
    @Nullable
    private String note;
    @JsonProperty(value="address_street1")
    @NotNull
    private String addressStreet1;
    @JsonProperty(value="address_street2")
    @Nullable
    private String addressStreet2;
    @JsonProperty(value="address_city")
    @NotNull
    private String addressCity;
    @JsonProperty(value="address_subdivision")
    @NotNull
    private String addressSubdivision;
    @JsonProperty(value="address_postal_code")
    @NotNull
    private String addressPostalCode;
    @JsonProperty(value="address_country_code")
    @NotNull
    private String addressCountryCode;
    @JsonProperty(value="details")
    @NotNull
    private CompanyDetails details;
    @JsonProperty(value="status")
    @NotNull
    private String status;

    private Company() {
    }

    @NotNull
    public String getEntityName() {
        return this.entityName;
    }

    @NotNull
    public String getTaxId() {
        return this.taxId;
    }

    @Nullable
    public String getIncorporationState() {
        return this.incorporationState;
    }

    @NotNull
    public String getIncorporationCountryCode() {
        return this.incorporationCountryCode;
    }

    @NotNull
    public CorporationType getIncorporationType() {
        return CorporationType.toEnum(this.incorporationType);
    }

    @Nullable
    public Date getIncorporationDate() {
        if (this.incorporationDay == null || this.incorporationMonth == null || this.incorporationYear == null) {
            return null;
        }
        GregorianCalendar calendarDay = new GregorianCalendar(this.incorporationYear, this.incorporationMonth, this.incorporationDay);
        return calendarDay.getTime();
    }

    @Nullable
    public String getDbas() {
        return this.dbas;
    }

    @Nullable
    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Nullable
    public String getNote() {
        return this.note;
    }

    @NotNull
    public Address getAddress() {
        return new Address(this.addressStreet1, this.addressStreet2, this.addressCity, this.addressSubdivision, this.addressPostalCode, this.addressCountryCode);
    }

    public boolean isValid() {
        return this.status.equalsIgnoreCase("valid");
    }

    @Nullable
    public CompanyDetails getDetails() {
        return this.details;
    }

    public static class Builder {
        private BlockscoreRestAdapter restAdapter;
        private Map<String, String> queryOptions;

        public Builder(BlockscoreApiClient client) {
            this.restAdapter = client.getAdapter();
            this.queryOptions = new HashMap<String, String>();
        }

        @NotNull
        public Builder setEntityName(@NotNull String entityName) {
            this.queryOptions.put("entity_name", entityName);
            return this;
        }

        @NotNull
        public Builder setTaxId(@NotNull String taxId) {
            this.queryOptions.put("tax_id", taxId);
            return this;
        }

        @NotNull
        public Builder setIncorporationState(@Nullable String incorporationState) {
            this.queryOptions.put("incorporation_state", incorporationState);
            return this;
        }

        @NotNull
        public Builder setIncorporationCountryCode(@NotNull String incorporationCountryCode) {
            this.queryOptions.put("incorporation_country_code", incorporationCountryCode);
            return this;
        }

        public Builder setIncorporationType(@NotNull CorporationType incorporationType) {
            this.queryOptions.put("incorporation_type", String.valueOf((Object)incorporationType));
            return this;
        }

        @NotNull
        public Builder setIncorporationDate(@Nullable Date incorporationDate) {
            if (incorporationDate == null) {
                return this;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(incorporationDate);
            this.queryOptions.put("incorporation_day", String.valueOf(calendar.get(5)));
            this.queryOptions.put("incorporation_month", String.valueOf(calendar.get(2) + 1));
            this.queryOptions.put("incorporation_year", String.valueOf(calendar.get(1)));
            return this;
        }

        public Builder setDbas(@Nullable String dbas) {
            this.queryOptions.put("dbas", dbas);
            return this;
        }

        public Builder setRegistrationNumber(@Nullable String registrationNumber) {
            this.queryOptions.put("registration_number", registrationNumber);
            return this;
        }

        public Builder setEmail(@Nullable String email) {
            this.queryOptions.put("email", email);
            return this;
        }

        public Builder setUrl(@Nullable String url) {
            this.queryOptions.put("url", url);
            return this;
        }

        @NotNull
        public Builder setPhoneNumber(@Nullable String phoneNumber) {
            this.queryOptions.put("phone_number", phoneNumber);
            return this;
        }

        @NotNull
        public Builder setIpAddress(@Nullable String ipAddress) {
            this.queryOptions.put("ip_address", ipAddress);
            return this;
        }

        @NotNull
        public Builder setNote(@Nullable String note) {
            this.queryOptions.put("note", note);
            return this;
        }

        public Builder setAddress(@NotNull Address address) {
            this.queryOptions.put("address_street1", address.getStreet1());
            this.queryOptions.put("address_street2", address.getStreet2());
            this.queryOptions.put("address_city", address.getCity());
            this.queryOptions.put("address_subdivision", address.getSubdivision());
            this.queryOptions.put("address_postal_code", address.getPostalCode());
            this.queryOptions.put("address_country_code", address.getCountryCode());
            return this;
        }

        public Company create() {
            Company company = this.restAdapter.createCompany(this.queryOptions);
            return company;
        }
    }
}

