/*
 * Decompiled with CFR 0.152.
 */
package com.blockscore.models;

import com.blockscore.models.Address;
import com.blockscore.models.PersonDetails;
import com.blockscore.models.QuestionSet;
import com.blockscore.models.base.BasicResponse;
import com.blockscore.net.BlockscoreApiClient;
import com.blockscore.net.BlockscoreRestAdapter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Person
extends BasicResponse {
    @JsonIgnore
    private BlockscoreRestAdapter restAdapter;
    @JsonProperty(value="name_first")
    @NotNull
    private String firstName;
    @JsonProperty(value="name_middle")
    @Nullable
    private String middleName;
    @JsonProperty(value="name_last")
    @NotNull
    private String lastName;
    @JsonProperty(value="document_type")
    @NotNull
    private String documentType;
    @JsonProperty(value="document_value")
    @NotNull
    private String documentValue;
    @JsonProperty(value="birth_day")
    @NotNull
    private Integer birthDay;
    @JsonProperty(value="birth_month")
    @NotNull
    private Integer birthMonth;
    @JsonProperty(value="birth_year")
    @NotNull
    private Integer birthYear;
    @JsonProperty(value="address_street1")
    @NotNull
    private String addressStreet1;
    @JsonProperty(value="address_street2")
    @Nullable
    private String addressStreet2;
    @JsonProperty(value="address_city")
    @NotNull
    private String addressCity;
    @JsonProperty(value="address_subdivision")
    @NotNull
    private String addressSubdivision;
    @JsonProperty(value="address_postal_code")
    @NotNull
    private String addressPostalCode;
    @JsonProperty(value="address_country_code")
    @NotNull
    private String addressCountryCode;
    @JsonProperty(value="phone_number")
    @Nullable
    private String phoneNumber;
    @JsonProperty(value="ip_address")
    @Nullable
    private String ipAddress;
    @JsonProperty(value="note")
    @NotNull
    private String note;
    @JsonProperty(value="status")
    @NotNull
    private String status;
    @JsonProperty(value="details")
    @NotNull
    private PersonDetails details;
    @JsonProperty(value="question_sets")
    @NotNull
    private List<String> questionSetIds;

    private Person() {
    }

    public void setAdapter(BlockscoreRestAdapter restAdapter) {
        this.restAdapter = restAdapter;
    }

    @NotNull
    public QuestionSet createQuestionSet() {
        return this.createQuestionSet(0L);
    }

    public QuestionSet createQuestionSet(long timeLimit) {
        HashMap<String, String> queryOptions = new HashMap<String, String>();
        queryOptions.put("person_id", this.getId());
        queryOptions.put("time_limit", String.valueOf(timeLimit));
        QuestionSet questionSet = this.restAdapter.createQuestionSet(queryOptions);
        questionSet.setAdapter(this.restAdapter);
        return questionSet;
    }

    public QuestionSet retrieveQuestionSet(@NotNull String questionSetId) {
        QuestionSet questionSet = this.restAdapter.retrieveQuestionSet(questionSetId);
        questionSet.setAdapter(this.restAdapter);
        return questionSet;
    }

    @NotNull
    public String getFirstName() {
        return this.firstName;
    }

    @Nullable
    public String getMiddleName() {
        return this.middleName;
    }

    @NotNull
    public String getLastName() {
        return this.lastName;
    }

    @NotNull
    public String getDocumentType() {
        return this.documentType;
    }

    @NotNull
    public String getDocumentValue() {
        return this.documentValue;
    }

    @NotNull
    public Date getDateOfBirth() {
        GregorianCalendar calendar = new GregorianCalendar(this.birthYear, this.birthMonth, this.birthDay);
        return calendar.getTime();
    }

    @NotNull
    public Address getAddress() {
        Address addressObject = new Address(this.addressStreet1, this.addressStreet2, this.addressCity, this.addressSubdivision, this.addressPostalCode, this.addressCountryCode);
        return addressObject;
    }

    @Nullable
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Nullable
    public String getNote() {
        return this.note;
    }

    public boolean isValid() {
        return this.status.equalsIgnoreCase("valid");
    }

    @NotNull
    public PersonDetails getDetails() {
        return this.details;
    }

    @NotNull
    public List<String> getQuestionSetIds() {
        return Collections.unmodifiableList(this.questionSetIds);
    }

    public static class Builder {
        private BlockscoreRestAdapter restAdapter;
        private Map<String, String> queryOptions;

        public Builder(BlockscoreApiClient client) {
            this.restAdapter = client.getAdapter();
            this.queryOptions = new HashMap<String, String>();
        }

        @NotNull
        public Builder setFirstName(@NotNull String firstName) {
            this.queryOptions.put("name_first", firstName);
            return this;
        }

        @NotNull
        public Builder setMiddleName(@Nullable String middleName) {
            this.queryOptions.put("name_middle", middleName);
            return this;
        }

        @NotNull
        public Builder setLastName(@NotNull String lastName) {
            this.queryOptions.put("name_last", lastName);
            return this;
        }

        @NotNull
        public Builder setDocumentType(@NotNull String documentType) {
            this.queryOptions.put("document_type", documentType);
            return this;
        }

        @NotNull
        public Builder setDocumentValue(@NotNull String documentValue) {
            this.queryOptions.put("document_value", documentValue);
            return this;
        }

        @NotNull
        public Builder setDateOfBirth(@NotNull Date dateOfBirth) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateOfBirth);
            this.queryOptions.put("birth_day", String.valueOf(calendar.get(5)));
            this.queryOptions.put("birth_month", String.valueOf(calendar.get(2) + 1));
            this.queryOptions.put("birth_year", String.valueOf(calendar.get(1)));
            return this;
        }

        @NotNull
        public Builder setAddress(@NotNull Address address) {
            this.queryOptions.put("address_street1", address.getStreet1());
            this.queryOptions.put("address_street2", address.getStreet2());
            this.queryOptions.put("address_city", address.getCity());
            this.queryOptions.put("address_subdivision", address.getSubdivision());
            this.queryOptions.put("address_postal_code", address.getPostalCode());
            this.queryOptions.put("address_country_code", address.getCountryCode());
            return this;
        }

        @NotNull
        public Builder setPhoneNumber(@Nullable String phoneNumber) {
            this.queryOptions.put("phone_number", phoneNumber);
            return this;
        }

        @NotNull
        public Builder setIpAddress(@Nullable String ipAddress) {
            this.queryOptions.put("ip_address", ipAddress);
            return this;
        }

        @NotNull
        public Builder setNote(@Nullable String note) {
            this.queryOptions.put("note", note);
            return this;
        }

        public Person create() {
            Person person = this.restAdapter.createPerson(this.queryOptions);
            person.setAdapter(this.restAdapter);
            return person;
        }
    }
}

