/*
 * Decompiled with CFR 0.152.
 */
package com.bytedanceapi.service.vod.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.bytedanceapi.error.SdkError;
import com.bytedanceapi.helper.Utils;
import com.bytedanceapi.model.beans.DomainInfo;
import com.bytedanceapi.model.beans.Functions;
import com.bytedanceapi.model.beans.ImgUrl;
import com.bytedanceapi.model.beans.ImgUrlOption;
import com.bytedanceapi.model.request.ApplyUploadRequest;
import com.bytedanceapi.model.request.CommitUploadRequest;
import com.bytedanceapi.model.request.CommitUploadRequestBody;
import com.bytedanceapi.model.request.GetOriginVideoPlayRequest;
import com.bytedanceapi.model.request.GetPlayInfoRequest;
import com.bytedanceapi.model.request.GetRedirectPlayRequest;
import com.bytedanceapi.model.request.SetVideoPublishStatusRequest;
import com.bytedanceapi.model.request.StartTranscodeRequest;
import com.bytedanceapi.model.request.StartTranscodeRequestBody;
import com.bytedanceapi.model.request.UploadMediaByUrlRequest;
import com.bytedanceapi.model.response.ApplyUploadResponse;
import com.bytedanceapi.model.response.CommitUploadResponse;
import com.bytedanceapi.model.response.GetDomainWeightsResponse;
import com.bytedanceapi.model.response.GetOriginVideoPlayResponse;
import com.bytedanceapi.model.response.GetPlayInfoResponse;
import com.bytedanceapi.model.response.RawResponse;
import com.bytedanceapi.model.response.SetVideoPublishStatusResponse;
import com.bytedanceapi.model.response.StartTranscodeResponse;
import com.bytedanceapi.model.response.UploadMediaByUrlResponse;
import com.bytedanceapi.service.BaseServiceImpl;
import com.bytedanceapi.service.vod.IVodService;
import com.bytedanceapi.service.vod.VodConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VodServiceImpl
extends BaseServiceImpl
implements IVodService {
    private static final int UPDATE_INTERVAL = 10;
    private long lastDomainUpdateTime = -1L;
    private Map<String, Map<String, Integer>> domainCache;
    private Map<String, Integer> fallbackDomainWeights;

    private VodServiceImpl() {
        super(VodConfig.serviceInfo, VodConfig.apiInfoList);
    }

    public static IVodService getInstance() {
        return new VodServiceImpl();
    }

    @Override
    public GetPlayInfoResponse getPlayInfo(GetPlayInfoRequest getPlayInfoRequest) throws Exception {
        RawResponse response = this.query("GetPlayInfo", Utils.paramsToMap(getPlayInfoRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetPlayInfoResponse getPlayInfoResp = (GetPlayInfoResponse)JSON.parseObject((byte[])response.getData(), GetPlayInfoResponse.class, (Feature[])new Feature[0]);
        getPlayInfoResp.getResponseMetadata().setService("vod");
        return getPlayInfoResp;
    }

    @Override
    public String getPlayAuthToken(Map<String, String> params) throws Exception {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Version", "v1");
        String getPlayInfoToken = this.getSignUrl("GetPlayInfo", params);
        ret.put("GetPlayInfoToken", getPlayInfoToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public GetOriginVideoPlayResponse getOriginVideoPlayInfo(GetOriginVideoPlayRequest getOriginVideoPlayRequest) throws Exception {
        RawResponse response = this.query("GetOriginVideoPlayInfo", Utils.paramsToMap(getOriginVideoPlayRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetOriginVideoPlayResponse getOriginVideoPlayResponse = (GetOriginVideoPlayResponse)JSON.parseObject((byte[])response.getData(), GetOriginVideoPlayResponse.class, (Feature[])new Feature[0]);
        getOriginVideoPlayResponse.getResponseMetadata().setService("vod");
        return getOriginVideoPlayResponse;
    }

    @Override
    public String getRedirectPlay(GetRedirectPlayRequest getRedirectPlayRequest) throws Exception {
        String uri = this.getSignUrl("RedirectPlay", Utils.paramsToMap(getRedirectPlayRequest));
        String proto = "http";
        String host = this.serviceInfo.getHost();
        return String.format("%s://%s/?%s", proto, host, uri);
    }

    @Override
    public StartTranscodeResponse startTranscode(StartTranscodeRequest startTranscodeRequest) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TemplateId", startTranscodeRequest.getTemplateId());
        StartTranscodeRequestBody startTranscodeRequestBody = new StartTranscodeRequestBody();
        startTranscodeRequestBody.setVid(startTranscodeRequest.getVid());
        startTranscodeRequestBody.setInput(startTranscodeRequest.getInput());
        startTranscodeRequestBody.setPriority(startTranscodeRequest.getPriority());
        RawResponse resp = this.json("StartTranscode", params, JSON.toJSONString((Object)startTranscodeRequestBody));
        if (resp.getCode() != SdkError.SUCCESS.getNumber()) {
            throw resp.getException();
        }
        return (StartTranscodeResponse)JSON.parseObject((byte[])resp.getData(), StartTranscodeResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public SetVideoPublishStatusResponse setVideoPublishStatus(SetVideoPublishStatusRequest setVideoPublishStatusRequest) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        RawResponse resp = this.json("SetVideoPublishStatus", params, JSON.toJSONString((Object)setVideoPublishStatusRequest));
        if (resp.getCode() != SdkError.SUCCESS.getNumber()) {
            throw resp.getException();
        }
        return (SetVideoPublishStatusResponse)JSON.parseObject((byte[])resp.getData(), SetVideoPublishStatusResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetDomainWeightsResponse getDomainWeights(String spaceName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SpaceName", spaceName);
        RawResponse response = this.query("GetCdnDomainWeights", params);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            return null;
        }
        GetDomainWeightsResponse getDomainWeightsResponse = (GetDomainWeightsResponse)JSON.parseObject((byte[])response.getData(), GetDomainWeightsResponse.class, (Feature[])new Feature[0]);
        if (getDomainWeightsResponse.getResponseMetadata().getError() != null) {
            return getDomainWeightsResponse;
        }
        HashMap<String, Map<String, Integer>> resMap = new HashMap<String, Map<String, Integer>>();
        JSONObject jsonObject = JSON.parseObject((String)getDomainWeightsResponse.getResult());
        for (Map.Entry entry : params.entrySet()) {
            HashMap innerMap = new HashMap();
            if (!jsonObject.containsKey(entry.getValue()) && ((String)entry.getKey()).equals("SpaceName")) {
                resMap.put((String)entry.getValue(), innerMap);
                continue;
            }
            JSONObject obj = jsonObject.getJSONObject((String)entry.getValue());
            for (Map.Entry e : obj.entrySet()) {
                innerMap.put(e.getKey(), Integer.parseInt(e.getValue().toString()));
            }
            resMap.put((String)entry.getValue(), innerMap);
        }
        getDomainWeightsResponse.setResultMap(resMap);
        getDomainWeightsResponse.getResponseMetadata().setService("vod");
        return getDomainWeightsResponse;
    }

    @Override
    public void setFallbackDomainWeights(Map<String, Integer> fallbackDomainWeights) {
        if (fallbackDomainWeights != null) {
            this.fallbackDomainWeights = fallbackDomainWeights;
        }
    }

    @Override
    public DomainInfo getDomainInfo(String spaceName) {
        if (this.fallbackDomainWeights == null) {
            this.fallbackDomainWeights = new HashMap<String, Integer>();
        }
        long now = System.currentTimeMillis() / 1000L;
        if (this.lastDomainUpdateTime == -1L || now - this.lastDomainUpdateTime > 10L) {
            try {
                GetDomainWeightsResponse getDomainWeightsResponse = this.getDomainWeights(spaceName);
                if (this.domainCache == null) {
                    this.domainCache = new HashMap<String, Map<String, Integer>>();
                }
                this.domainCache.put(spaceName, getDomainWeightsResponse.getResultMap().get(spaceName));
                this.lastDomainUpdateTime = now;
            }
            catch (Exception e) {
                if (this.domainCache == null) {
                    this.domainCache = new HashMap<String, Map<String, Integer>>();
                }
                this.domainCache.put(spaceName, this.fallbackDomainWeights);
            }
        }
        DomainInfo domainInfo = new DomainInfo();
        String mainDomain = Utils.randWeights(this.domainCache.get(spaceName), "");
        String backupDomain = Utils.randWeights(this.domainCache.get(spaceName), mainDomain);
        domainInfo.setMainDomain(mainDomain);
        domainInfo.setBackupDomain(backupDomain);
        return domainInfo;
    }

    @Override
    public ImgUrl getPosterUrl(String spaceName, String uri, ImgUrlOption imgUrlOption) {
        DomainInfo domainInfo = this.getDomainInfo(spaceName);
        String proto = "http";
        if (imgUrlOption.isHttps()) {
            proto = "https";
        }
        String format = "image";
        if (imgUrlOption.getFomat() != null) {
            format = imgUrlOption.getFomat();
        }
        String tpl = "tplv-vod-noop";
        if (imgUrlOption.getTpl() != null) {
            tpl = imgUrlOption.getTpl();
        }
        tpl = tpl == "tplv-vod-obj" || tpl == "tplv-vod-noop" ? imgUrlOption.getTpl() : String.format("%s:%d:%d", imgUrlOption.getTpl(), imgUrlOption.getW(), imgUrlOption.getH());
        ImgUrl imgUrl = new ImgUrl();
        imgUrl.setMainUrl(String.format("%s://%s/%s~%s.%s", proto, domainInfo.getMainDomain(), uri, tpl, format));
        imgUrl.setBackupUrl(String.format("%s://%s/%s~%s.%s", proto, domainInfo.getBackupDomain(), uri, tpl, format));
        return imgUrl;
    }

    @Override
    public ImgUrl getImageUrl(String spaceName, String uri, ImgUrlOption imgUrlOption) {
        String path;
        DomainInfo domainInfo = this.getDomainInfo(spaceName);
        String proto = "http";
        if (imgUrlOption.isHttps()) {
            proto = "https";
        }
        String format = "image";
        if (imgUrlOption.getFomat() != null) {
            format = imgUrlOption.getFomat();
        }
        String signKey = "";
        if (imgUrlOption.getSigKey() != null) {
            signKey = imgUrlOption.getSigKey();
        }
        String sigTxt = path = String.format("/%s~%s.%s", uri, imgUrlOption.getTpl(), format);
        Map<String, List<String>> kv = null;
        if (imgUrlOption.getKv() != null) {
            kv = imgUrlOption.getKv();
            if (signKey != null && kv.get("sig") != null) {
                return null;
            }
            sigTxt = String.format("%s?%s", path, Utils.encode(kv));
        }
        try {
            if (signKey != "") {
                String sign = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])Utils.hmacSHA1(signKey.getBytes(), sigTxt));
                sign = sign.replace("/", "_").replace("+", "-");
                if (kv == null) {
                    kv = new HashMap<String, List<String>>();
                }
                if (kv.get("sig") == null) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(sign);
                    kv.put("sig", list);
                } else {
                    kv.get("sig").add(sign);
                }
                path = String.format("%s?%s", path, Utils.encode(kv));
            } else {
                path = sigTxt;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ImgUrl imgUrl = new ImgUrl();
        imgUrl.setMainUrl(String.format("%s://%s%s", proto, domainInfo.getMainDomain(), path));
        imgUrl.setBackupUrl(String.format("%s://%s%s", proto, domainInfo.getBackupDomain(), path));
        return imgUrl;
    }

    @Override
    public String getUploadAuthToken(String space) throws Exception {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Version", "v1");
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("SpaceName", space);
        String applyUploadToken = this.getSignUrl("ApplyUpload", query);
        ret.put("ApplyUploadToken", applyUploadToken);
        String commitUploadToken = this.getSignUrl("CommitUpload", query);
        ret.put("CommitUploadToken", commitUploadToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public ApplyUploadResponse applyUpload(ApplyUploadRequest applyUploadRequest) throws Exception {
        RawResponse response = this.query("ApplyUpload", Utils.paramsToMap(applyUploadRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ApplyUploadResponse applyUploadResponse = (ApplyUploadResponse)JSON.parseObject((byte[])response.getData(), ApplyUploadResponse.class, (Feature[])new Feature[0]);
        applyUploadResponse.getResponseMetadata().setService("vod");
        return applyUploadResponse;
    }

    @Override
    public CommitUploadResponse commitUpload(CommitUploadRequest commitUploadRequest) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SpaceName", commitUploadRequest.getSpaceName());
        CommitUploadRequestBody commitUploadRequestBody = new CommitUploadRequestBody();
        commitUploadRequestBody.setCallbackArgs(commitUploadRequest.getCallbackArgs());
        commitUploadRequestBody.setFunctions(commitUploadRequest.getFunctions());
        commitUploadRequestBody.setSessionKey(commitUploadRequest.getSessionKey());
        RawResponse response = this.json("CommitUpload", params, JSON.toJSONString((Object)commitUploadRequestBody));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        CommitUploadResponse commitUploadResponse = (CommitUploadResponse)JSON.parseObject((byte[])response.getData(), CommitUploadResponse.class, (Feature[])new Feature[0]);
        commitUploadResponse.getResponseMetadata().setService("vod");
        return commitUploadResponse;
    }

    @Override
    public UploadMediaByUrlResponse uploadMediaByUrl(UploadMediaByUrlRequest uploadMediaByUrlRequest) throws Exception {
        RawResponse response = this.query("UploadMediaByUrl", Utils.paramsToMap(uploadMediaByUrlRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        UploadMediaByUrlResponse uploadMediaByUrlResponse = (UploadMediaByUrlResponse)JSON.parseObject((byte[])response.getData(), UploadMediaByUrlResponse.class, (Feature[])new Feature[0]);
        uploadMediaByUrlResponse.getResponseMetadata().setService("vod");
        return uploadMediaByUrlResponse;
    }

    @Override
    public CommitUploadResponse upload(String spaceName, String filePath, String fileType, List<Functions> functions) throws Exception {
        File file = new File(filePath);
        if (!file.isFile() || !file.exists()) {
            throw new Exception(SdkError.getErrorDesc(SdkError.ENOFILE));
        }
        long crc32 = Utils.crc32(filePath);
        if (crc32 == -1L) {
            throw new Exception(SdkError.getErrorDesc(SdkError.EINTERNAL));
        }
        String checkSum = String.format("%x", crc32);
        ApplyUploadRequest applyUploadRequest = new ApplyUploadRequest();
        applyUploadRequest.setSpaceName(spaceName);
        ApplyUploadResponse applyUploadResponse = this.applyUpload(applyUploadRequest);
        if (applyUploadResponse.getResponseMetadata().getError() != null || applyUploadResponse.getResult() == null || applyUploadResponse.getResult().getUploadAddress().getStoreInfos() == null) {
            throw new Exception(SdkError.getErrorDesc(SdkError.ERESP));
        }
        String oid = applyUploadResponse.getResult().getUploadAddress().getStoreInfos().get(0).getStoreUri();
        String sessionKey = applyUploadResponse.getResult().getUploadAddress().getSessionKey();
        String auth = applyUploadResponse.getResult().getUploadAddress().getStoreInfos().get(0).getAuth();
        String host = applyUploadResponse.getResult().getUploadAddress().getUploadHosts().get(0);
        String url = String.format("http://%s/%s", host, oid);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-CRC32", checkSum);
        headers.put("Authorization", auth);
        long startTime = System.currentTimeMillis();
        boolean uploadStatus = false;
        for (int i = 0; i < 3 && !(uploadStatus = this.put(url, filePath, headers)); ++i) {
        }
        if (!uploadStatus) {
            throw new Exception(SdkError.getErrorDesc(SdkError.EUPLOAD));
        }
        long endTime = System.currentTimeMillis();
        long cost = endTime - startTime;
        float avgSpeed = (float)file.length() / (float)cost;
        System.out.println(String.format("upload cost {%d} ms, avgSpeed: {%f} KB/s", cost, Float.valueOf(avgSpeed)));
        CommitUploadRequest commitUploadRequest = new CommitUploadRequest();
        commitUploadRequest.setCallbackArgs("");
        commitUploadRequest.setSessionKey(sessionKey);
        commitUploadRequest.setFunctions(functions);
        commitUploadRequest.setSpaceName(spaceName);
        CommitUploadResponse commitUploadResponse = this.commitUpload(commitUploadRequest);
        if (commitUploadResponse.getResponseMetadata().getError() != null || commitUploadResponse.getResult() == null) {
            throw new Exception(SdkError.getErrorDesc(SdkError.ERESP));
        }
        return commitUploadResponse;
    }
}

