/*
 * Decompiled with CFR 0.152.
 */
package com.bytedanceapi.service.vod.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.bytedanceapi.error.SdkError;
import com.bytedanceapi.helper.Utils;
import com.bytedanceapi.model.beans.DomainInfo;
import com.bytedanceapi.model.beans.Functions;
import com.bytedanceapi.model.beans.ImgUrl;
import com.bytedanceapi.model.beans.ImgUrlOption;
import com.bytedanceapi.model.beans.UploadCompleteInfo;
import com.bytedanceapi.model.request.ApplyUploadRequest;
import com.bytedanceapi.model.request.CommitUploadRequest;
import com.bytedanceapi.model.request.CommitUploadRequestBody;
import com.bytedanceapi.model.request.GetOriginVideoPlayRequest;
import com.bytedanceapi.model.request.GetPlayInfoRequest;
import com.bytedanceapi.model.request.GetRedirectPlayRequest;
import com.bytedanceapi.model.request.ModifyVideoInfoRequest;
import com.bytedanceapi.model.request.SetVideoPublishStatusRequest;
import com.bytedanceapi.model.request.StartTranscodeRequest;
import com.bytedanceapi.model.request.StartTranscodeRequestBody;
import com.bytedanceapi.model.request.UploadMediaByUrlRequest;
import com.bytedanceapi.model.response.ApplyUploadResponse;
import com.bytedanceapi.model.response.CommitUploadResponse;
import com.bytedanceapi.model.response.GetDomainWeightsResponse;
import com.bytedanceapi.model.response.GetOriginVideoPlayResponse;
import com.bytedanceapi.model.response.GetPlayInfoResponse;
import com.bytedanceapi.model.response.ModifyVideoInfoResponse;
import com.bytedanceapi.model.response.RawResponse;
import com.bytedanceapi.model.response.SetVideoPublishStatusResponse;
import com.bytedanceapi.model.response.StartTranscodeResponse;
import com.bytedanceapi.model.response.UploadMediaByUrlResponse;
import com.bytedanceapi.service.BaseServiceImpl;
import com.bytedanceapi.service.vod.IVodService;
import com.bytedanceapi.service.vod.VodConfig;
import java.io.File;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class VodServiceImpl
extends BaseServiceImpl
implements IVodService {
    private static final int UPDATE_INTERVAL = 10;
    private Map<String, Map<String, Integer>> domainCache = new HashMap<String, Map<String, Integer>>();
    private Map<String, Integer> fallbackDomainWeights;
    private ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(5);

    private VodServiceImpl() {
        super(VodConfig.serviceInfo, VodConfig.apiInfoList);
    }

    public static IVodService getInstance() {
        return new VodServiceImpl();
    }

    @Override
    public GetPlayInfoResponse getPlayInfo(GetPlayInfoRequest getPlayInfoRequest) throws Exception {
        RawResponse response = this.query("GetPlayInfo", Utils.paramsToMap(getPlayInfoRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetPlayInfoResponse getPlayInfoResp = (GetPlayInfoResponse)JSON.parseObject((byte[])response.getData(), GetPlayInfoResponse.class, (Feature[])new Feature[0]);
        getPlayInfoResp.getResponseMetadata().setService("vod");
        return getPlayInfoResp;
    }

    @Override
    public String getPlayAuthToken(Map<String, String> params) throws Exception {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Version", "v1");
        String getPlayInfoToken = this.getSignUrl("GetPlayInfo", params);
        ret.put("GetPlayInfoToken", getPlayInfoToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public GetOriginVideoPlayResponse getOriginVideoPlayInfo(GetOriginVideoPlayRequest getOriginVideoPlayRequest) throws Exception {
        RawResponse response = this.query("GetOriginVideoPlayInfo", Utils.paramsToMap(getOriginVideoPlayRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetOriginVideoPlayResponse getOriginVideoPlayResponse = (GetOriginVideoPlayResponse)JSON.parseObject((byte[])response.getData(), GetOriginVideoPlayResponse.class, (Feature[])new Feature[0]);
        getOriginVideoPlayResponse.getResponseMetadata().setService("vod");
        return getOriginVideoPlayResponse;
    }

    @Override
    public String getRedirectPlay(GetRedirectPlayRequest getRedirectPlayRequest) throws Exception {
        String uri = this.getSignUrl("RedirectPlay", Utils.paramsToMap(getRedirectPlayRequest));
        String proto = "http";
        String host = this.serviceInfo.getHost();
        return String.format("%s://%s/?%s", proto, host, uri);
    }

    @Override
    public StartTranscodeResponse startTranscode(StartTranscodeRequest startTranscodeRequest) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TemplateId", startTranscodeRequest.getTemplateId());
        StartTranscodeRequestBody startTranscodeRequestBody = new StartTranscodeRequestBody();
        startTranscodeRequestBody.setVid(startTranscodeRequest.getVid());
        startTranscodeRequestBody.setInput(startTranscodeRequest.getInput());
        startTranscodeRequestBody.setPriority(startTranscodeRequest.getPriority());
        RawResponse resp = this.json("StartTranscode", params, JSON.toJSONString((Object)startTranscodeRequestBody));
        if (resp.getCode() != SdkError.SUCCESS.getNumber()) {
            throw resp.getException();
        }
        return (StartTranscodeResponse)JSON.parseObject((byte[])resp.getData(), StartTranscodeResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public SetVideoPublishStatusResponse setVideoPublishStatus(SetVideoPublishStatusRequest setVideoPublishStatusRequest) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        RawResponse resp = this.json("SetVideoPublishStatus", params, JSON.toJSONString((Object)setVideoPublishStatusRequest));
        if (resp.getCode() != SdkError.SUCCESS.getNumber()) {
            throw resp.getException();
        }
        return (SetVideoPublishStatusResponse)JSON.parseObject((byte[])resp.getData(), SetVideoPublishStatusResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public GetDomainWeightsResponse getDomainWeights(String spaceName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SpaceName", spaceName);
        RawResponse response = this.query("GetCdnDomainWeights", params);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            return null;
        }
        GetDomainWeightsResponse getDomainWeightsResponse = (GetDomainWeightsResponse)JSON.parseObject((byte[])response.getData(), GetDomainWeightsResponse.class, (Feature[])new Feature[0]);
        if (getDomainWeightsResponse.getResponseMetadata().getError() != null) {
            return getDomainWeightsResponse;
        }
        HashMap<String, Map<String, Integer>> resMap = new HashMap<String, Map<String, Integer>>();
        JSONObject jsonObject = JSON.parseObject((String)getDomainWeightsResponse.getResult());
        for (Map.Entry entry : params.entrySet()) {
            HashMap innerMap = new HashMap();
            if (!jsonObject.containsKey(entry.getValue()) && ((String)entry.getKey()).equals("SpaceName")) {
                resMap.put((String)entry.getValue(), innerMap);
                continue;
            }
            JSONObject obj = jsonObject.getJSONObject((String)entry.getValue());
            for (Map.Entry e : obj.entrySet()) {
                innerMap.put(e.getKey(), Integer.parseInt(e.getValue().toString()));
            }
            resMap.put((String)entry.getValue(), innerMap);
        }
        getDomainWeightsResponse.setResultMap(resMap);
        getDomainWeightsResponse.getResponseMetadata().setService("vod");
        return getDomainWeightsResponse;
    }

    @Override
    public void setFallbackDomainWeights(Map<String, Integer> fallbackDomainWeights) {
        if (fallbackDomainWeights != null) {
            this.fallbackDomainWeights = fallbackDomainWeights;
        }
    }

    @Override
    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    @Override
    public DomainInfo getDomainInfo(String spaceName) {
        this.reentrantReadWriteLock.readLock().lock();
        if (!this.domainCache.containsKey(spaceName)) {
            this.reentrantReadWriteLock.readLock().unlock();
            this.reentrantReadWriteLock.writeLock().lock();
            if (!this.domainCache.containsKey(spaceName)) {
                Map<String, Integer> weightsMap;
                try {
                    GetDomainWeightsResponse getDomainWeightsResponse = this.getDomainWeights(spaceName);
                    weightsMap = getDomainWeightsResponse.getResultMap().get(spaceName);
                }
                catch (Exception e) {
                    weightsMap = this.fallbackDomainWeights;
                }
                this.domainCache.put(spaceName, weightsMap);
                this.reentrantReadWriteLock.writeLock().unlock();
                AsyncGetDomainWeightsTask asyncGetDomainWeightsTask = new AsyncGetDomainWeightsTask(spaceName, this);
                this.scheduledExecutorService.scheduleWithFixedDelay(asyncGetDomainWeightsTask, 10L, 10L, TimeUnit.SECONDS);
            } else {
                this.reentrantReadWriteLock.writeLock().unlock();
            }
        } else {
            this.reentrantReadWriteLock.readLock().unlock();
        }
        Map<String, Integer> cache = this.domainCache.get(spaceName);
        DomainInfo domainInfo = new DomainInfo();
        String mainDomain = Utils.randWeights(cache, "");
        String backupDomain = Utils.randWeights(cache, mainDomain);
        domainInfo.setMainDomain(mainDomain);
        domainInfo.setBackupDomain(backupDomain);
        return domainInfo;
    }

    @Override
    public ImgUrl getPosterUrl(String spaceName, String uri, ImgUrlOption imgUrlOption) {
        DomainInfo domainInfo = this.getDomainInfo(spaceName);
        String proto = "http";
        if (imgUrlOption.isHttps()) {
            proto = "https";
        }
        String format = "image";
        if (imgUrlOption.getFomat() != null) {
            format = imgUrlOption.getFomat();
        }
        String tpl = "tplv-vod-noop";
        if (imgUrlOption.getTpl() != null) {
            tpl = imgUrlOption.getTpl();
        }
        tpl = tpl == "tplv-vod-obj" || tpl == "tplv-vod-noop" ? imgUrlOption.getTpl() : String.format("%s:%d:%d", imgUrlOption.getTpl(), imgUrlOption.getW(), imgUrlOption.getH());
        ImgUrl imgUrl = new ImgUrl();
        imgUrl.setMainUrl(String.format("%s://%s/%s~%s.%s", proto, domainInfo.getMainDomain(), uri, tpl, format));
        imgUrl.setBackupUrl(String.format("%s://%s/%s~%s.%s", proto, domainInfo.getBackupDomain(), uri, tpl, format));
        return imgUrl;
    }

    @Override
    public String getUploadAuthToken(String space) throws Exception {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Version", "v1");
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("SpaceName", space);
        String applyUploadToken = this.getSignUrl("ApplyUpload", query);
        ret.put("ApplyUploadToken", applyUploadToken);
        String commitUploadToken = this.getSignUrl("CommitUpload", query);
        ret.put("CommitUploadToken", commitUploadToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public ApplyUploadResponse applyUpload(ApplyUploadRequest applyUploadRequest) throws Exception {
        RawResponse response = this.query("ApplyUpload", Utils.paramsToMap(applyUploadRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ApplyUploadResponse applyUploadResponse = (ApplyUploadResponse)JSON.parseObject((byte[])response.getData(), ApplyUploadResponse.class, (Feature[])new Feature[0]);
        applyUploadResponse.getResponseMetadata().setService("vod");
        return applyUploadResponse;
    }

    @Override
    public CommitUploadResponse commitUpload(CommitUploadRequest commitUploadRequest) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SpaceName", commitUploadRequest.getSpaceName());
        CommitUploadRequestBody commitUploadRequestBody = new CommitUploadRequestBody();
        commitUploadRequestBody.setCallbackArgs(commitUploadRequest.getCallbackArgs());
        commitUploadRequestBody.setFunctions(commitUploadRequest.getFunctions());
        commitUploadRequestBody.setSessionKey(commitUploadRequest.getSessionKey());
        RawResponse response = this.json("CommitUpload", params, JSON.toJSONString((Object)commitUploadRequestBody));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        CommitUploadResponse commitUploadResponse = (CommitUploadResponse)JSON.parseObject((byte[])response.getData(), CommitUploadResponse.class, (Feature[])new Feature[0]);
        commitUploadResponse.getResponseMetadata().setService("vod");
        return commitUploadResponse;
    }

    @Override
    public UploadMediaByUrlResponse uploadMediaByUrl(UploadMediaByUrlRequest uploadMediaByUrlRequest) throws Exception {
        RawResponse response = this.query("UploadMediaByUrl", Utils.paramsToMap(uploadMediaByUrlRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        UploadMediaByUrlResponse uploadMediaByUrlResponse = (UploadMediaByUrlResponse)JSON.parseObject((byte[])response.getData(), UploadMediaByUrlResponse.class, (Feature[])new Feature[0]);
        uploadMediaByUrlResponse.getResponseMetadata().setService("vod");
        return uploadMediaByUrlResponse;
    }

    @Override
    public ModifyVideoInfoResponse modifyVideoInfo(ModifyVideoInfoRequest modifyVideoInfoRequest) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        RawResponse response = this.json("ModifyVideoInfo", params, JSON.toJSONString((Object)modifyVideoInfoRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ModifyVideoInfoResponse modifyVideoInfoResponse = (ModifyVideoInfoResponse)JSON.parseObject((byte[])response.getData(), ModifyVideoInfoResponse.class, (Feature[])new Feature[0]);
        modifyVideoInfoResponse.getResponseMetadata().setService("vod");
        return modifyVideoInfoResponse;
    }

    private UploadCompleteInfo upload(String spaceName, String filePath) throws Exception {
        File file = new File(filePath);
        if (!file.isFile() || !file.exists()) {
            throw new Exception(SdkError.getErrorDesc(SdkError.ENOFILE));
        }
        long crc32 = Utils.crc32(filePath);
        if (crc32 == -1L) {
            throw new Exception("file crc32 error");
        }
        String checkSum = String.format("%x", crc32);
        ApplyUploadRequest applyUploadRequest = new ApplyUploadRequest();
        applyUploadRequest.setSpaceName(spaceName);
        ApplyUploadResponse applyUploadResponse = this.applyUpload(applyUploadRequest);
        if (applyUploadResponse.getResponseMetadata().getError() != null) {
            throw new Exception(applyUploadResponse.getResponseMetadata().getError().getMessage());
        }
        if (applyUploadResponse.getResult() == null || applyUploadResponse.getResult().getUploadAddress().getStoreInfos() == null) {
            throw new Exception("apply upload result is null");
        }
        String oid = applyUploadResponse.getResult().getUploadAddress().getStoreInfos().get(0).getStoreUri();
        String sessionKey = applyUploadResponse.getResult().getUploadAddress().getSessionKey();
        String auth = applyUploadResponse.getResult().getUploadAddress().getStoreInfos().get(0).getAuth();
        String host = applyUploadResponse.getResult().getUploadAddress().getUploadHosts().get(0);
        String url = String.format("http://%s/%s", host, oid);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-CRC32", checkSum);
        headers.put("Authorization", auth);
        long startTime = System.currentTimeMillis();
        boolean uploadStatus = false;
        for (int i = 0; i < 3 && !(uploadStatus = this.put(url, filePath, headers)); ++i) {
        }
        if (!uploadStatus) {
            throw new Exception(SdkError.getErrorDesc(SdkError.EUPLOAD));
        }
        long endTime = System.currentTimeMillis();
        long cost = endTime - startTime;
        float avgSpeed = (float)file.length() / (float)cost;
        System.out.println(String.format("upload {%s} cost {%d} ms, avgSpeed: {%f} KB/s", filePath, cost, Float.valueOf(avgSpeed)));
        UploadCompleteInfo uploadCompleteInfo = new UploadCompleteInfo(oid, sessionKey);
        return uploadCompleteInfo;
    }

    @Override
    public CommitUploadResponse uploadVideo(String spaceName, String filePath, String fileType, List<Functions> functions) throws Exception {
        UploadCompleteInfo uploadCompleteInfo = this.upload(spaceName, filePath);
        CommitUploadRequest commitUploadRequest = new CommitUploadRequest();
        commitUploadRequest.setCallbackArgs("");
        commitUploadRequest.setSessionKey(uploadCompleteInfo.getSessionKey());
        commitUploadRequest.setFunctions(functions);
        commitUploadRequest.setSpaceName(spaceName);
        CommitUploadResponse commitUploadResponse = this.commitUpload(commitUploadRequest);
        if (commitUploadResponse.getResponseMetadata().getError() != null) {
            throw new Exception(commitUploadResponse.getResponseMetadata().getError().getMessage());
        }
        return commitUploadResponse;
    }

    @Override
    public String uploadPoster(String vid, String spaceName, String filePath, String fileType) throws Exception {
        UploadCompleteInfo uploadCompleteInfo = this.upload(spaceName, filePath);
        String oid = uploadCompleteInfo.getOid();
        ModifyVideoInfoRequest modifyVideoInfoRequest = new ModifyVideoInfoRequest();
        modifyVideoInfoRequest.setSpaceName(spaceName);
        modifyVideoInfoRequest.setVid(vid);
        ModifyVideoInfoRequest.UserMetaInfo userMetaInfo = new ModifyVideoInfoRequest.UserMetaInfo();
        userMetaInfo.setPosterUri(oid);
        modifyVideoInfoRequest.setInfo(userMetaInfo);
        ModifyVideoInfoResponse modifyVideoInfoResponse = this.modifyVideoInfo(modifyVideoInfoRequest);
        if (modifyVideoInfoResponse.getResponseMetadata().getError() != null) {
            throw new Exception(modifyVideoInfoResponse.getResponseMetadata().getError().getMessage());
        }
        if (modifyVideoInfoResponse.getResult() == null || modifyVideoInfoResponse.getResult().getBaseResp() == null || modifyVideoInfoResponse.getResult().getBaseResp().getStatusCode() != 0) {
            throw new Exception("modify poster error" + modifyVideoInfoResponse.getResult().getBaseResp().getStatusMessage());
        }
        return oid;
    }

    private static class AsyncGetDomainWeightsTask
    implements Runnable {
        private String spaceName;
        private VodServiceImpl vodService;

        public AsyncGetDomainWeightsTask(String spaceName, VodServiceImpl vodService) {
            this.spaceName = spaceName;
            this.vodService = vodService;
        }

        @Override
        public void run() {
            Map<String, Integer> weightsMap;
            try {
                GetDomainWeightsResponse getDomainWeightsResponse = this.vodService.getDomainWeights(this.spaceName);
                weightsMap = getDomainWeightsResponse.getResultMap().get(this.spaceName);
            }
            catch (Exception e) {
                weightsMap = this.vodService.fallbackDomainWeights;
            }
            this.vodService.reentrantReadWriteLock.writeLock().lock();
            this.vodService.domainCache.put(this.spaceName, weightsMap);
            this.vodService.reentrantReadWriteLock.writeLock().unlock();
        }
    }
}

