/*
 * Decompiled with CFR 0.152.
 */
package com.bytedanceapi.auth.impl;

import com.bytedanceapi.auth.ISignerV4;
import com.bytedanceapi.auth.MedaData;
import com.bytedanceapi.helper.Utils;
import com.bytedanceapi.model.Credentials;
import com.bytedanceapi.service.SignableRequest;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.util.EntityUtils;

public class SignerV4Impl
implements ISignerV4 {
    private static final TimeZone tz = TimeZone.getTimeZone("UTC");
    private static final Set<String> H_INCLUDE = new HashSet<String>();

    @Override
    public void sign(SignableRequest request, Credentials credentials) throws Exception {
        this.signV4(request, credentials);
        request.setURI(request.getUriBuilder().build());
    }

    @Override
    public String signUrl(SignableRequest request, Credentials credentials) throws Exception {
        String formatDate = this.getCurrentFormatDate();
        String date = formatDate.substring(0, 8);
        MedaData meta = new MedaData();
        meta.setDate(date);
        meta.setService(credentials.getService());
        meta.setRegion(credentials.getRegion());
        meta.setSignedHeaders("");
        meta.setAlgorithm("AWS4-HMAC-SHA256");
        meta.setCredentialScope(String.join((CharSequence)"/", meta.getDate(), meta.getRegion(), meta.getService(), "aws4_request"));
        URIBuilder builder = request.getUriBuilder();
        builder.setParameter("X-Amz-Date", formatDate);
        builder.setParameter("X-Amz-NotSignBody", "");
        builder.setParameter("X-Amz-Credential", credentials.getAccessKeyID() + "/" + meta.getCredentialScope());
        builder.setParameter("X-Amz-Algorithm", meta.getAlgorithm());
        builder.setParameter("X-Amz-SignedHeaders", meta.getSignedHeaders());
        builder.setParameter("X-Amz-SignedQueries", "");
        ArrayList<String> keys = new ArrayList<String>();
        for (NameValuePair pair : builder.getQueryParams()) {
            keys.add(pair.getName());
        }
        keys.sort(Comparator.naturalOrder());
        builder.setParameter("X-Amz-SignedQueries", String.join((CharSequence)";", keys));
        String hashedCanonReq = this.hashedSimpleCanonicalRequestV4(request, meta);
        String stringToSign = String.join((CharSequence)"\n", meta.getAlgorithm(), formatDate, meta.getCredentialScope(), hashedCanonReq);
        byte[] signingKey = this.genSigningSecretKeyV4(credentials.getSecretAccessKey(), meta.getDate(), meta.getRegion(), meta.getService());
        String signature = this.signatureV4(signingKey, stringToSign);
        builder.setParameter("X-Amz-Signature", signature);
        return builder.build().toURL().getQuery();
    }

    private void signV4(SignableRequest request, Credentials credentials) throws Exception {
        URIBuilder builder = request.getUriBuilder();
        if (builder.getPath().equals("")) {
            builder.setPath(builder.getPath() + "/");
        }
        request.setHeader("Host", request.getUriBuilder().getHost());
        if (request.getHeaders("Content-Type") == null) {
            request.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        }
        String formatDate = this.getCurrentFormatDate();
        request.setHeader("X-Amz-Date", formatDate);
        MedaData meta = new MedaData();
        meta.setAlgorithm("AWS4-HMAC-SHA256");
        meta.setService(credentials.getService());
        meta.setRegion(credentials.getRegion());
        meta.setDate(this.toDate(formatDate));
        String hashedCanonReq = this.hashedCanonicalRequestV4(request, meta);
        meta.setCredentialScope(String.join((CharSequence)"/", meta.getDate(), meta.getRegion(), meta.getService(), "aws4_request"));
        String stringToSign = String.join((CharSequence)"\n", meta.getAlgorithm(), formatDate, meta.getCredentialScope(), hashedCanonReq);
        byte[] signingKey = this.genSigningSecretKeyV4(credentials.getSecretAccessKey(), meta.getDate(), meta.getRegion(), meta.getService());
        String signature = Hex.encodeHexString((byte[])Utils.hmacSHA256(signingKey, stringToSign));
        request.setHeader("Authorization", this.buildAuthHeaderV4(signature, meta, credentials));
    }

    private String hashedSimpleCanonicalRequestV4(SignableRequest request, MedaData meta) throws Exception {
        String payloadHash = Utils.hashSHA256(new byte[0]);
        URIBuilder builder = request.getUriBuilder();
        if (builder.getPath().equals("")) {
            builder.setPath("/");
        }
        String canonicalRequest = String.join((CharSequence)"\n", request.getMethod(), this.normUri(builder.getPath()), this.normQuery(builder.getQueryParams()), "\n", meta.getSignedHeaders(), payloadHash);
        return Utils.hashSHA256(canonicalRequest.getBytes());
    }

    private String hashedCanonicalRequestV4(SignableRequest request, MedaData meta) throws Exception {
        HttpEntity entity = request.getEntity();
        byte[] body = entity == null ? new byte[]{} : EntityUtils.toByteArray((HttpEntity)entity);
        String bodyHash = Utils.hashSHA256(body);
        request.setHeader("X-Amz-Content-Sha256", bodyHash);
        ArrayList<String> signedHeaders = new ArrayList<String>();
        for (Header header : request.getAllHeaders()) {
            String headerName = header.getName();
            if (!H_INCLUDE.contains(headerName) && !headerName.startsWith("X-Amz-")) continue;
            signedHeaders.add(headerName.toLowerCase());
        }
        signedHeaders.sort(Comparator.naturalOrder());
        StringBuilder signedHeadersToSignStr = new StringBuilder();
        for (String h : signedHeaders) {
            String[] split;
            String port;
            String value = request.getFirstHeader(h).getValue().trim();
            if (h.equals("host") && value.contains(":") && ((port = (split = value.split(":"))[1]).equals("80") || port.equals("443"))) {
                value = split[0];
            }
            signedHeadersToSignStr.append(h).append(":").append(value).append("\n");
        }
        meta.setSignedHeaders(String.join((CharSequence)";", signedHeaders));
        String canonicalRequest = String.join((CharSequence)"\n", request.getMethod(), this.normUri(request.getUriBuilder().getPath()), this.normQuery(request.getUriBuilder().getQueryParams()), signedHeadersToSignStr.toString(), meta.getSignedHeaders(), bodyHash);
        return Utils.hashSHA256(canonicalRequest.getBytes());
    }

    private String signatureV4(byte[] signingKey, String stringToSign) throws Exception {
        return Hex.encodeHexString((byte[])Utils.hmacSHA256(signingKey, stringToSign));
    }

    private byte[] genSigningSecretKeyV4(String secretKey, String date, String region, String service) throws Exception {
        byte[] kDate = Utils.hmacSHA256(("AWS4" + secretKey).getBytes(), date);
        byte[] kRegion = Utils.hmacSHA256(kDate, region);
        byte[] kService = Utils.hmacSHA256(kRegion, service);
        return Utils.hmacSHA256(kService, "aws4_request");
    }

    private String buildAuthHeaderV4(String signature, MedaData meta, Credentials credentials) {
        String credential = credentials.getAccessKeyID() + "/" + meta.getCredentialScope();
        return meta.getAlgorithm() + " Credential=" + credential + ", SignedHeaders=" + meta.getSignedHeaders() + ", Signature=" + signature;
    }

    private String getCurrentFormatDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        return df.format(new Date());
    }

    private String toDate(String timestamp) {
        return timestamp.substring(0, 8);
    }

    private String normUri(String path) {
        return URLEncoder.encode(path).replace("%2F", "/").replace("+", "%20");
    }

    private String normQuery(List<NameValuePair> params) {
        params.sort(Comparator.comparing(NameValuePair::getName));
        String query = URLEncodedUtils.format(params, (Charset)Consts.UTF_8);
        return query.replace("+", "%20");
    }

    static {
        H_INCLUDE.add("Content-Type");
        H_INCLUDE.add("Content-Md5");
        H_INCLUDE.add("Host");
    }
}

