/*
 * Decompiled with CFR 0.152.
 */
package com.bytedanceapi.util;

import com.alibaba.fastjson.JSON;
import com.bytedanceapi.model.Credentials;
import com.bytedanceapi.model.sts2.InnerToken;
import com.bytedanceapi.model.sts2.Policy;
import com.bytedanceapi.model.sts2.SecurityToken2;
import com.bytedanceapi.model.sts2.Statement;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomStringUtils;

public class Sts2Utils {
    public static String generateAccessKeyId(String prefix) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String uidBase64 = Base64.getEncoder().encodeToString(uuid.getBytes());
        return prefix + uidBase64.replace("=", "").replace("/", "").replace("+", "").replace("-", "");
    }

    public static String generateSecretKey() throws Exception {
        String randString32 = RandomStringUtils.randomAlphabetic((int)32);
        return Sts2Utils.aesEncryptCBC(randString32, "bytedance-isgood".getBytes("ISO-8859-1"));
    }

    public static byte[] encrypt(String data, String key) throws Exception {
        String ivString = key;
        byte[] iv = ivString.getBytes("ISO-8859-1");
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        int blockSize = cipher.getBlockSize();
        byte[] dataBytes = data.getBytes();
        int length = dataBytes.length;
        length += blockSize - length % blockSize;
        byte[] plaintext = new byte[length];
        System.arraycopy(dataBytes, 0, plaintext, 0, dataBytes.length);
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes("ISO-8859-1"), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)keySpec, ivSpec);
        return cipher.doFinal(plaintext);
    }

    public static String aesEncryptCBC(String sSrc, byte[] sKey) throws Exception {
        if (sKey == null) {
            throw new RuntimeException("Key\u4e3a\u7a7anull");
        }
        if (sKey.length != 16) {
            throw new RuntimeException("Key\u957f\u5ea6\u4e0d\u662f16\u4f4d");
        }
        byte[] encrypted = Sts2Utils.encrypt(sSrc, new String(sKey, "ISO-8859-1"));
        return Base64.getEncoder().encodeToString(encrypted);
    }

    public static InnerToken createInnerToken(Credentials credentials, SecurityToken2 sts2, Policy inlinePolicy, long t) throws Exception {
        InnerToken innerToken = new InnerToken();
        innerToken.setLtAccessKeyId(credentials.getAccessKeyID());
        innerToken.setAccessKeyId(sts2.getAccessKeyId());
        innerToken.setExpiredTime(t);
        byte[] key = Sts2Utils.genMD5Checksum(credentials.getSecretAccessKey().getBytes());
        innerToken.setSignedSecretAccessKey(Sts2Utils.aesEncryptCBC(sts2.getSecretAccessKey(), key));
        innerToken.setPolicyString(JSON.toJSONString((Object)inlinePolicy));
        String signStr = String.format("%s|%s|%d|%s|%s", innerToken.getLtAccessKeyId(), innerToken.getAccessKeyId(), innerToken.getExpiredTime(), innerToken.getSignedSecretAccessKey(), innerToken.getPolicyString());
        innerToken.setSignature(Sts2Utils.sha256Hex(key, signStr));
        return innerToken;
    }

    public static byte[] genMD5Checksum(byte[] content) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(content);
        return messageDigest.digest();
    }

    private static String sha256Hex(byte[] signingKey, String stringToSign) throws InvalidKeyException, NoSuchAlgorithmException {
        Charset UTF8 = Charset.forName("UTF-8");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(signingKey, "HmacSHA256"));
        return new String(Hex.encodeHex((byte[])mac.doFinal(stringToSign.getBytes(UTF8))));
    }

    public static Statement newAllowStatement(List<String> actions, List<String> resources) {
        Statement statement = new Statement();
        statement.setEffect("Allow");
        statement.setAction(actions);
        statement.setResource(resources);
        return statement;
    }

    public static Statement newDenyStatement(List<String> actions, List<String> resources) {
        Statement statement = new Statement();
        statement.setEffect("Deny");
        statement.setAction(actions);
        statement.setResource(resources);
        return statement;
    }
}

