
// Code generated by protoc-gen-volcengine-sdk
// source: byteplus/vod/service/service_vod.proto
// DO NOT EDIT!

package com.byteplus.service.vod.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.protobuf.util.JsonFormat;
import com.google.common.base.Predicates;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import com.github.rholder.retry.*;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import java.text.SimpleDateFormat;
import java.text.DateFormat;
public class VodServiceImpl extends com.byteplus.service.BaseServiceImpl implements com.byteplus.service.vod.IVodService {

    // 静态字段引用唯一实例:
    private static final VodServiceImpl AP_SINGAPORE_1_SERVICE = new VodServiceImpl();

    // 通过静态方法返回实例:
    public static com.byteplus.service.vod.IVodService getInstance() {
        return AP_SINGAPORE_1_SERVICE;
    }

    // private构造方法保证外部无法实例化:
    protected VodServiceImpl() {
        super(com.byteplus.service.vod.VodServiceConfig.ServiceInfoMap.get(com.byteplus.helper.Const.REGION_AP_SINGAPORE_1), com.byteplus.service.vod.VodServiceConfig.apiInfoList);
    }

    public static com.byteplus.service.vod.IVodService getInstance(String region) throws Exception {
        com.byteplus.model.ServiceInfo serviceInfo = com.byteplus.service.vod.VodServiceConfig.ServiceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Cant find the region, please check it carefully");
        }
        switch (region) {
            case com.byteplus.helper.Const.REGION_AP_SINGAPORE_1:
                return AP_SINGAPORE_1_SERVICE;
            default:
                throw new Exception("Cant find the region, please check it carefully");
        }
    }

    @Override
    public String getPrivateDrmAuthToken(com.byteplus.service.vod.model.request.VodGetPrivateDrmPlayAuthRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = com.byteplus.helper.Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0) {
            params.put("X-Expires", expireSeconds.toString());
        }
        return getSignUrl(com.byteplus.service.vod.Const.GetPrivateDrmPlayAuth, com.byteplus.helper.Utils.mapToPairList(params));
    }

    @Override
    public String createSha1HlsDrmAuthToken(Long expireSeconds) throws Exception {
        return createHlsDrmAuthToken(com.byteplus.service.vod.Const.DSAHmacSha1, expireSeconds);
    }

    public String createHlsDrmAuthToken(String dsa, Long expireSeconds) throws Exception {
        if (expireSeconds == null || expireSeconds <= 0) {
            throw new Exception("Invalid Expire");
        }
        String token = createAuth(dsa, expireSeconds);
        Map<String, String> params = new HashMap<>();
        params.put("DrmAuthToken", token);
        params.put("X-Expires", expireSeconds.toString());
        return getSignUrl(com.byteplus.service.vod.Const.GetHlsDecryptionKey, com.byteplus.helper.Utils.mapToPairList(params));
    }

    private String createAuth(String dsa, long expireSeconds) throws Exception {
        if (StringUtils.isBlank(getAccessKey())) {
            throw new Exception("Invalid Ak");
        }
        if (StringUtils.isBlank(getSecretKey())) {
            throw new Exception("Invalid Sk");
        }

        long deadline = System.currentTimeMillis() / 1000 + expireSeconds;
        TimeZone tz = TimeZone.getTimeZone("UTC");
        DateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        String deadlineDate = df.format(new Date(deadline * 1000));
        String timestamp = String.valueOf(deadline);
        byte[] kDate = com.byteplus.helper.Utils.hmacSHA256(getSecretKey().getBytes(), deadlineDate);
        byte[] kRegion = com.byteplus.helper.Utils.hmacSHA256(kDate, getRegion());
        byte[] kService = com.byteplus.helper.Utils.hmacSHA256(kRegion, "vod");
        byte[] kCredentials = com.byteplus.helper.Utils.hmacSHA256(kService, "request");
        String key = Hex.encodeHexString(kCredentials);
        String signDataString = StringUtils.join(dsa, "&", "2.0", "&", timestamp);
        String sign = "";
        switch (dsa) {
            case com.byteplus.service.vod.Const.DSAHmacSha1:
                sign = org.apache.commons.codec.binary.Base64.encodeBase64String(com.byteplus.helper.Utils.hmacSHA1(key.getBytes(), signDataString));
                break;
            case com.byteplus.service.vod.Const.DSAHmacSha256:
                sign = org.apache.commons.codec.binary.Base64.encodeBase64String(com.byteplus.helper.Utils.hmacSHA256(key.getBytes(), signDataString));
                break;
            default:
                sign = org.apache.commons.codec.binary.Base64.encodeBase64String("".getBytes());
                break;
        }
        return StringUtils.join(dsa, ":", "2.0", ":", timestamp, ":", getAccessKey(), ":", sign);
    }

    @Override
    public String getSubtitleAuthToken(com.byteplus.service.vod.model.request.VodGetSubtitleInfoListRequest input, Long expireSeconds) throws Exception {
        if(input.getVid() == "") {
            throw new Exception("传入的Vid为空");
        }
        Map<String, String> params = new HashMap<>();
        params.put("Vid", input.getVid());
        params.put("Status", "Published");
        if (expireSeconds != null && expireSeconds > 0) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getSubtitleAuthToken = getSignUrl(com.byteplus.service.vod.Const.GetSubtitleInfoList, com.byteplus.helper.Utils.mapToPairList(params));
        Map<String, String> ret = new HashMap<>();
        ret.put("GetSubtitleAuthToken", getSubtitleAuthToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public String getPlayAuthToken(com.byteplus.service.vod.model.request.VodGetPlayInfoRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = com.byteplus.helper.Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getPlayInfoToken = getSignUrl(com.byteplus.service.vod.Const.GetPlayInfo, com.byteplus.helper.Utils.mapToPairList(params));
        Map<String, String> ret = new HashMap<>();
        ret.put("GetPlayInfoToken", getPlayInfoToken);
        ret.put("TokenVersion", "V2");
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public String getThirdPartyDrmAuthToken(com.byteplus.service.vod.model.request.VodGetDrmLicenseRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = com.byteplus.helper.Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getDrmLicenseToken = getSignUrl(com.byteplus.service.vod.Const.GetDrmLicense, com.byteplus.helper.Utils.mapToPairList(params));
        Map<String, String> ret = new HashMap<>();
        ret.put("GetDrmLicenseToken", getDrmLicenseToken);
        ret.put("TokenVersion", "V2");
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public com.byteplus.model.sts2.SecurityToken2 getUploadSts2() throws Exception {
        return getUploadSts2WithExpire(com.byteplus.util.Time.Hour);
    }

    @Override
    public com.byteplus.model.sts2.SecurityToken2 getUploadSts2WithExpire(long expire) throws Exception {
        com.byteplus.model.sts2.Policy inlinePolicy = new com.byteplus.model.sts2.Policy();
        List<String> actions = new ArrayList<>();
        actions.add("vod:ApplyUploadInfo");
        actions.add("vod:CommitUploadInfo");

        List<String> resources = new ArrayList<>();
        com.byteplus.model.sts2.Statement statement = com.byteplus.util.Sts2Utils.newAllowStatement(actions, resources);
        inlinePolicy.addStatement(statement);
        return signSts2(inlinePolicy, expire);
    }

    @Override
    public com.byteplus.service.vod.model.response.VodCommitUploadInfoResponse uploadMedia(com.byteplus.service.vod.model.request.VodUploadMediaRequest vodUploadMediaRequest, com.byteplus.helper.VodUploadProgressListener listener) throws Exception {
        com.byteplus.model.beans.UploadCompleteInfo uploadCompleteInfo = uploadToB(vodUploadMediaRequest.getSpaceName(), vodUploadMediaRequest.getFilePath(), "media", vodUploadMediaRequest.getFileName(), vodUploadMediaRequest.getFileExtension(), vodUploadMediaRequest.getStorageClass(), listener);
        com.byteplus.service.vod.model.request.VodCommitUploadInfoRequest vodCommitUploadInfoRequest = com.byteplus.service.vod.model.request.VodCommitUploadInfoRequest.newBuilder()
                .setSpaceName(vodUploadMediaRequest.getSpaceName())
                .setSessionKey(uploadCompleteInfo.getSessionKey())
                .setFunctions(vodUploadMediaRequest.getFunctions())
                .setCallbackArgs(vodUploadMediaRequest.getCallbackArgs())
                .build();

        com.byteplus.service.vod.model.response.VodCommitUploadInfoResponse vodCommitUploadInfoResponse = commitUploadInfo(vodCommitUploadInfoRequest);
        if (!vodCommitUploadInfoResponse.getResponseMetadata().hasError()) {
            com.byteplus.helper.VodUploadProgressListenerHelper.sendVodUploadEvent(listener, com.byteplus.helper.VodUploadProgressEventType.UPLOAD_BYTES_EVENT, 1);
        }
        return vodCommitUploadInfoResponse;
    }

    private com.byteplus.model.beans.UploadCompleteInfo uploadToB(String spaceName, String filePath, String fileType, String fileName, String fileExtension, int storageClass, com.byteplus.helper.VodUploadProgressListener listener) throws Exception {
        java.io.File file = new java.io.File(filePath);
        if (!(file.isFile() && file.exists())) {
            throw new Exception(com.byteplus.error.SdkError.getErrorDesc(com.byteplus.error.SdkError.ENOFILE));
        }

        com.byteplus.helper.VodUploadProgressListenerHelper.sendVodUploadEvent(listener, com.byteplus.helper.VodUploadProgressEventType.FILE_SIZE_EVENT, file.length());

        com.byteplus.service.vod.model.request.VodApplyUploadInfoRequest vodApplyUploadInfoRequest = com.byteplus.service.vod.model.request.VodApplyUploadInfoRequest.newBuilder()
                .setSpaceName(spaceName)
                .setFileName(fileName)
                .setFileType(fileType)
                .setFileExtension(fileExtension)
                .setStorageClass(storageClass)
                .build();

        com.byteplus.service.vod.model.response.VodApplyUploadInfoResponse vodApplyUploadInfoResponse = applyUploadInfo(vodApplyUploadInfoRequest);
        if (vodApplyUploadInfoResponse.getResponseMetadata().hasError()) {
            throw new Exception(vodApplyUploadInfoResponse.getResponseMetadata().getError().getMessage());
        }
        com.byteplus.service.vod.model.business.VodUploadAddress vodUploadAddress = vodApplyUploadInfoResponse.getResult().getData().getUploadAddress();
        if (!vodApplyUploadInfoResponse.hasResult() || vodUploadAddress.getStoreInfosCount() == 0) {
            throw new Exception("apply upload result is null");
        }

        String oid = vodUploadAddress.getStoreInfos(0).getStoreUri();
        String sessionKey = vodUploadAddress.getSessionKey();
        String auth = vodUploadAddress.getStoreInfos(0).getAuth();
        String host = vodUploadAddress.getUploadHosts(0);
        List<com.byteplus.service.vod.model.business.VodHeaderPair> uploadHeaderList = vodUploadAddress.getUploadHeaderList();

        Retryer retryer = RetryerBuilder.newBuilder()
                .retryIfException()
                .retryIfResult(Predicates.equalTo(false))
                .retryIfResult(Predicates.isNull())
                .withWaitStrategy(WaitStrategies.exponentialWait())
                .withStopStrategy(StopStrategies.stopAfterAttempt(3))
                .build();


        if (file.length() < com.byteplus.service.vod.Const.MinChunkSize) {
            directUpload(host, oid, auth, uploadHeaderList, file, retryer, storageClass, listener);
        } else {
            chunkUpload(host, oid, auth, uploadHeaderList, file, true, retryer, storageClass, listener);
        }

        com.byteplus.model.beans.UploadCompleteInfo uploadCompleteInfo = new com.byteplus.model.beans.UploadCompleteInfo(oid, sessionKey);
        return uploadCompleteInfo;
    }

    private void directUpload(String host, String oid, String auth, List<com.byteplus.service.vod.model.business.VodHeaderPair> uploadHeaderList, File file, Retryer retryer, int storageClass, com.byteplus.helper.VodUploadProgressListener listener) throws Exception {
        String oidEncode = StringUtils.replace(oid, " ", "%20");
        String url = String.format("https://%s/%s", host, oidEncode);
        byte[] bytes = Files.readAllBytes(Paths.get(file.getPath()));
        long crc32 = com.byteplus.helper.Utils.crc32(bytes);
        String checkSum = String.format("%08x", crc32);
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", auth);
        headers.put("Content-CRC32", checkSum);
        uploadHeaderList.forEach(vodHeaderPair -> headers.put(vodHeaderPair.getKey(), vodHeaderPair.getValue()));

        if (storageClass == com.byteplus.service.vod.model.business.StorageClassType.Archive_VALUE) {
            headers.put("X-Upload-Storage-Class", "archive");
        }

        retryer.call(() -> putData(url, bytes, headers));
        com.byteplus.helper.VodUploadProgressListenerHelper.sendVodUploadEvent(listener, com.byteplus.helper.VodUploadProgressEventType.UPLOAD_BYTES_EVENT, file.length() - 1);
    }

    private void chunkUpload(String host, String oid, String auth, List<com.byteplus.service.vod.model.business.VodHeaderPair> uploadHeaderList, File file, boolean isLargeFile, Retryer retryer, int storageClass, com.byteplus.helper.VodUploadProgressListener listener) throws Exception {
        String uploadID = initUploadPart(host, oid, auth, isLargeFile, uploadHeaderList, retryer, storageClass);
        byte[] data = new byte[com.byteplus.service.vod.Const.MinChunkSize];
        List<String> parts = new ArrayList<>();
        long num = file.length() / com.byteplus.service.vod.Const.MinChunkSize;
        long lastNum = num - 1;
        long partNumber;
        String objectContentType = "";
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file))) {
            for (long i = 0; i < lastNum; i++) {
                bis.read(data);
                partNumber = isLargeFile ? i + 1 : i;
                UploadPartResponse uploadPartResponse = uploadPart(host, oid, auth, uploadID, partNumber, data, isLargeFile, retryer, storageClass);
                parts.add(uploadPartResponse.getCheckSum());
                if (partNumber == 1) {
                    objectContentType = uploadPartResponse.getObjectContentType();
                }
                com.byteplus.helper.VodUploadProgressListenerHelper.sendVodUploadEvent(listener, com.byteplus.helper.VodUploadProgressEventType.UPLOAD_BYTES_EVENT, data.length);
            }
            long readCount = (long) com.byteplus.service.vod.Const.MinChunkSize * lastNum;
            int len = (int) (file.length() - readCount);
            byte[] lastPart = new byte[len];
            bis.read(lastPart);
            partNumber = isLargeFile ? lastNum + 1 : lastNum;
            UploadPartResponse uploadPartResponse = uploadPart(host, oid, auth, uploadID, partNumber, lastPart, isLargeFile, retryer, storageClass);
            parts.add(uploadPartResponse.getCheckSum());
            if (partNumber == 1) {
                objectContentType = uploadPartResponse.getObjectContentType();
            }
            com.byteplus.helper.VodUploadProgressListenerHelper.sendVodUploadEvent(listener, com.byteplus.helper.VodUploadProgressEventType.UPLOAD_BYTES_EVENT, lastPart.length - 1);
        } catch (Exception e) {
            throw e;
        }
        uploadMergePart(host, oid, auth, uploadID, parts.stream().toArray(String[]::new), isLargeFile, retryer, storageClass, objectContentType);
    }

    private String initUploadPart(String host, String oid, String auth, boolean isLargeFile, List<com.byteplus.service.vod.model.business.VodHeaderPair> uploadHeaderList, Retryer retryer, int storageClass) throws ExecutionException, RetryException, IOException {
        String oidEncode = StringUtils.replace(oid, " ", "%20");
        String url = String.format("https://%s/%s?uploads", host, oidEncode);
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", auth);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        uploadHeaderList.forEach(vodHeaderPair -> headers.put(vodHeaderPair.getKey(), vodHeaderPair.getValue()));
        if (storageClass == com.byteplus.service.vod.model.business.StorageClassType.Archive_VALUE) {
            headers.put("X-Upload-Storage-Class", "archive");
        }
        HttpResponse httpResponse = (HttpResponse) (retryer.call(() -> putDataWithResponse(url, new byte[]{}, headers)));
        if (httpResponse == null) {
            throw new RuntimeException("init part error,response is empty");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("http code is " + httpResponse.getStatusLine().getStatusCode());
        }
        String entity = EntityUtils.toString(httpResponse.getEntity());
        JSONObject result = JSONObject.parseObject(entity);
        return result.getJSONObject("payload").getInnerMap().get("uploadID").toString();
    }

    @lombok.Builder
    @lombok.Data
    static class UploadPartResponse {
        private String checkSum;
        private String objectContentType;
    }

    private UploadPartResponse uploadPart(String host, String oid, String auth, String uploadID, long partNumber, byte[] data, boolean isLargeFile, Retryer retryer, int storageClass) throws Exception {
        String oidEncode = StringUtils.replace(oid, " ", "%20");
        String url = String.format("https://%s/%s?partNumber=%d&uploadID=%s", host, oidEncode, partNumber, uploadID);
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", auth);
        long crc32 = com.byteplus.helper.Utils.crc32(data);
        String checkSum = String.format("%08x", crc32);
        headers.put("Content-CRC32", checkSum);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        if (storageClass == com.byteplus.service.vod.model.business.StorageClassType.Archive_VALUE) {
            headers.put("X-Upload-Storage-Class", "archive");
        }

        HttpResponse httpResponse = (HttpResponse) (retryer.call(() -> putDataWithResponse(url, data, headers)));
        if (httpResponse == null) {
            throw new RuntimeException("init part error,response is empty");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("http code is " + httpResponse.getStatusLine().getStatusCode());
        }
        String entity = EntityUtils.toString(httpResponse.getEntity());
        JSONObject result = JSONObject.parseObject(entity);
        return UploadPartResponse.builder()
                .checkSum(checkSum)
                .objectContentType(result.getJSONObject("payload").getJSONObject("meta").getString("ObjectContentType"))
                .build();
    }

    private void uploadMergePart(String host, String oid, String auth, String uploadID, String[] checkSum, boolean isLargeFile, Retryer retryer, int storageClass, String objectContentType) throws ExecutionException, RetryException {
        String oidEncode = StringUtils.replace(oid, " ", "%20");
        String url = String.format("https://%s/%s?uploadID=%s&ObjectContentType=%s", host, oidEncode, uploadID, objectContentType);
        String body = IntStream.range(0, checkSum.length).mapToObj(i -> String.format("%d:%s", i, checkSum[i])).collect(Collectors.joining(",", "", ""));
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", auth);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        if (storageClass == com.byteplus.service.vod.model.business.StorageClassType.Archive_VALUE) {
            headers.put("X-Upload-Storage-Class", "archive");
        }
        retryer.call(() -> putData(url, body.getBytes(), headers));
    }

    @Override
    public com.byteplus.service.vod.model.response.VodCommitUploadInfoResponse uploadMaterial(com.byteplus.service.vod.model.request.VodUploadMaterialRequest vodUploadMaterialRequest, com.byteplus.helper.VodUploadProgressListener listener) throws Exception {
        com.byteplus.model.beans.UploadCompleteInfo uploadCompleteInfo = uploadToB(vodUploadMaterialRequest.getSpaceName(), vodUploadMaterialRequest.getFilePath(), vodUploadMaterialRequest.getFileType(), vodUploadMaterialRequest.getFileName(), vodUploadMaterialRequest.getFileExtension(), 0, listener);

        com.byteplus.service.vod.model.request.VodCommitUploadInfoRequest vodCommitUploadInfoRequest = com.byteplus.service.vod.model.request.VodCommitUploadInfoRequest.newBuilder()
                .setSpaceName(vodUploadMaterialRequest.getSpaceName())
                .setSessionKey(uploadCompleteInfo.getSessionKey())
                .setFunctions(vodUploadMaterialRequest.getFunctions())
                .setCallbackArgs(vodUploadMaterialRequest.getCallbackArgs())
                .build();

        com.byteplus.service.vod.model.response.VodCommitUploadInfoResponse vodCommitUploadInfoResponse = commitUploadInfo(vodCommitUploadInfoRequest);
        if (!vodCommitUploadInfoResponse.getResponseMetadata().hasError()) {
            com.byteplus.helper.VodUploadProgressListenerHelper.sendVodUploadEvent(listener, com.byteplus.helper.VodUploadProgressEventType.UPLOAD_BYTES_EVENT, 1);
        }
        return vodCommitUploadInfoResponse;
    }

    /**
     * submitDirectEditTaskAsync.
     *
     * @param input com.byteplus.service.vod.model.request.VodSubmitDirectEditTaskAsyncRequest
     * @return com.byteplus.service.vod.model.response.VodSubmitDirectEditTaskAsyncResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodSubmitDirectEditTaskAsyncResponse submitDirectEditTaskAsync(com.byteplus.service.vod.model.request.VodSubmitDirectEditTaskAsyncRequest input) throws Exception {
        String jsonData = JsonFormat.printer().print(input);
        Map<String, Object> inputMap = JSON.parseObject(jsonData);
        if (inputMap.containsKey("EditParam")) {
            Map<String, Object> editParam = JSON.parseObject(input.getEditParam().toString(StandardCharsets.UTF_8));
            inputMap.put("EditParam", editParam);
        }

        com.byteplus.model.response.RawResponse response = json(com.byteplus.service.vod.Const.SubmitDirectEditTaskAsync, new ArrayList<>(), JSON.toJSONString(inputMap));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodSubmitDirectEditTaskAsyncResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodSubmitDirectEditTaskAsyncResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getDirectEditResult.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetDirectEditResultRequest
     * @return com.byteplus.service.vod.model.response.VodGetDirectEditResultResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetDirectEditResultResponse getDirectEditResult(com.byteplus.service.vod.model.request.VodGetDirectEditResultRequest input) throws Exception {
        String jsonData = JsonFormat.printer().print(input);
        com.byteplus.model.response.RawResponse response = json(com.byteplus.service.vod.Const.GetDirectEditResult, new ArrayList<>(), jsonData);
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodServiceImpl.VodGetDirectEditResultResponse resp = JSON.parseObject(response.getData(), VodServiceImpl.VodGetDirectEditResultResponse.class);
        if (resp.result != null) {
            for ( int i = 0; i < resp.result.size(); i++) {
                Map<String, Object> value = resp.result.get(i);
                if (value.containsKey("EditParam")) {
                    Object editParam = value.get("EditParam");
                    byte[] editParamBytes = JSON.toJSONBytes(editParam);
                    value.put("EditParam", editParamBytes);
                    resp.result.set(i, value);
                }
            }
        }
        com.byteplus.service.vod.model.response.VodGetDirectEditResultResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetDirectEditResultResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(JSON.toJSONBytes(resp))), responseBuilder);
        return responseBuilder.build();
    }

    static class VodGetDirectEditResultResponse {
        @JSONField(name = "ResponseMetadata")
        public Map<String, Object> responseMetadata;
        @JSONField(name = "Result")
        public java.util.List<Map<String, Object>> result;
    }

    /**
     * getDirectEditProgress.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetDirectEditProgressRequest
     * @return com.byteplus.service.vod.model.response.VodGetDirectEditProgressResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetDirectEditProgressResponse getDirectEditProgress(com.byteplus.service.vod.model.request.VodGetDirectEditProgressRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.GetDirectEditProgress, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodServiceImpl.VodGetDirectEditProgressResponse resp = JSON.parseObject(response.getData(), VodServiceImpl.VodGetDirectEditProgressResponse.class);
        if (resp.result!=null){
            Result res = new Result();
            res.result = (Integer) resp.result;
            resp.result = res;
        }
        com.byteplus.service.vod.model.response.VodGetDirectEditProgressResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetDirectEditProgressResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(JSON.toJSONBytes(resp))), responseBuilder);
        return responseBuilder.build();
    }
    static class VodGetDirectEditProgressResponse {
        @JSONField(name = "ResponseMetadata")
        public Map<String, Object> responseMetadata;
        @JSONField(name = "Result")
        public Object result;
    }
    static class Result{
        @JSONField(name = "Result")
        public Integer result;
    }


    /**
     * getPlayInfo.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetPlayInfoRequest
     * @return com.byteplus.service.vod.model.response.VodGetPlayInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetPlayInfoResponse getPlayInfo(com.byteplus.service.vod.model.request.VodGetPlayInfoRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.GetPlayInfo, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodGetPlayInfoResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetPlayInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getPrivateDrmPlayAuth.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetPrivateDrmPlayAuthRequest
     * @return com.byteplus.service.vod.model.response.VodGetPrivateDrmPlayAuthResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetPrivateDrmPlayAuthResponse getPrivateDrmPlayAuth(com.byteplus.service.vod.model.request.VodGetPrivateDrmPlayAuthRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.GetPrivateDrmPlayAuth, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodGetPrivateDrmPlayAuthResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetPrivateDrmPlayAuthResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getPlayInfoWithLiveTimeShiftScene.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetPlayInfoWithLiveTimeShiftSceneRequest
     * @return com.byteplus.service.vod.model.response.VodGetPlayInfoWithLiveTimeShiftSceneResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetPlayInfoWithLiveTimeShiftSceneResponse getPlayInfoWithLiveTimeShiftScene(com.byteplus.service.vod.model.request.VodGetPlayInfoWithLiveTimeShiftSceneRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.GetPlayInfoWithLiveTimeShiftScene, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodGetPlayInfoWithLiveTimeShiftSceneResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetPlayInfoWithLiveTimeShiftSceneResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * uploadMediaByUrl.
     *
     * @param input com.byteplus.service.vod.model.request.VodUrlUploadRequest
     * @return com.byteplus.service.vod.model.response.VodUrlUploadResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodUrlUploadResponse uploadMediaByUrl(com.byteplus.service.vod.model.request.VodUrlUploadRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.UploadMediaByUrl, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodUrlUploadResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodUrlUploadResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * queryUploadTaskInfo.
     *
     * @param input com.byteplus.service.vod.model.request.VodQueryUploadTaskInfoRequest
     * @return com.byteplus.service.vod.model.response.VodQueryUploadTaskInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodQueryUploadTaskInfoResponse queryUploadTaskInfo(com.byteplus.service.vod.model.request.VodQueryUploadTaskInfoRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.QueryUploadTaskInfo, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodQueryUploadTaskInfoResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodQueryUploadTaskInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * applyUploadInfo.
     *
     * @param input com.byteplus.service.vod.model.request.VodApplyUploadInfoRequest
     * @return com.byteplus.service.vod.model.response.VodApplyUploadInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodApplyUploadInfoResponse applyUploadInfo(com.byteplus.service.vod.model.request.VodApplyUploadInfoRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ApplyUploadInfo, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodApplyUploadInfoResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodApplyUploadInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * commitUploadInfo.
     *
     * @param input com.byteplus.service.vod.model.request.VodCommitUploadInfoRequest
     * @return com.byteplus.service.vod.model.response.VodCommitUploadInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodCommitUploadInfoResponse commitUploadInfo(com.byteplus.service.vod.model.request.VodCommitUploadInfoRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.CommitUploadInfo, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodCommitUploadInfoResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodCommitUploadInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateMediaInfo.
     *
     * @param input com.byteplus.service.vod.model.request.VodUpdateMediaInfoRequest
     * @return com.byteplus.service.vod.model.response.VodUpdateMediaInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodUpdateMediaInfoResponse updateMediaInfo(com.byteplus.service.vod.model.request.VodUpdateMediaInfoRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.UpdateMediaInfo, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodUpdateMediaInfoResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodUpdateMediaInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateMediaPublishStatus.
     *
     * @param input com.byteplus.service.vod.model.request.VodUpdateMediaPublishStatusRequest
     * @return com.byteplus.service.vod.model.response.VodUpdateMediaPublishStatusResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodUpdateMediaPublishStatusResponse updateMediaPublishStatus(com.byteplus.service.vod.model.request.VodUpdateMediaPublishStatusRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.UpdateMediaPublishStatus, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodUpdateMediaPublishStatusResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodUpdateMediaPublishStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateMediaStorageClass.
     *
     * @param input com.byteplus.service.vod.model.request.VodUpdateMediaStorageClassRequest
     * @return com.byteplus.service.vod.model.response.VodUpdateMediaStorageClassResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodUpdateMediaStorageClassResponse updateMediaStorageClass(com.byteplus.service.vod.model.request.VodUpdateMediaStorageClassRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.UpdateMediaStorageClass, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodUpdateMediaStorageClassResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodUpdateMediaStorageClassResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getMediaInfos.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetMediaInfosRequest
     * @return com.byteplus.service.vod.model.response.VodGetMediaInfosResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetMediaInfosResponse getMediaInfos(com.byteplus.service.vod.model.request.VodGetMediaInfosRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.GetMediaInfos, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodGetMediaInfosResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetMediaInfosResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getRecommendedPoster.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetRecommendedPosterRequest
     * @return com.byteplus.service.vod.model.response.VodGetRecommendedPosterResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetRecommendedPosterResponse getRecommendedPoster(com.byteplus.service.vod.model.request.VodGetRecommendedPosterRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.GetRecommendedPoster, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodGetRecommendedPosterResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetRecommendedPosterResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * deleteMedia.
     *
     * @param input com.byteplus.service.vod.model.request.VodDeleteMediaRequest
     * @return com.byteplus.service.vod.model.response.VodDeleteMediaResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodDeleteMediaResponse deleteMedia(com.byteplus.service.vod.model.request.VodDeleteMediaRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.DeleteMedia, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodDeleteMediaResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodDeleteMediaResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * deleteTranscodes.
     *
     * @param input com.byteplus.service.vod.model.request.VodDeleteTranscodesRequest
     * @return com.byteplus.service.vod.model.response.VodDeleteTranscodesResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodDeleteTranscodesResponse deleteTranscodes(com.byteplus.service.vod.model.request.VodDeleteTranscodesRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.DeleteTranscodes, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodDeleteTranscodesResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodDeleteTranscodesResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getMediaList.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetMediaListRequest
     * @return com.byteplus.service.vod.model.response.VodGetMediaListResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetMediaListResponse getMediaList(com.byteplus.service.vod.model.request.VodGetMediaListRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.GetMediaList, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodGetMediaListResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetMediaListResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getSubtitleInfoList.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetSubtitleInfoListRequest
     * @return com.byteplus.service.vod.model.response.VodGetSubtitleInfoListResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetSubtitleInfoListResponse getSubtitleInfoList(com.byteplus.service.vod.model.request.VodGetSubtitleInfoListRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.GetSubtitleInfoList, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodGetSubtitleInfoListResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetSubtitleInfoListResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateSubtitleStatus.
     *
     * @param input com.byteplus.service.vod.model.request.VodUpdateSubtitleStatusRequest
     * @return com.byteplus.service.vod.model.response.VodUpdateSubtitleStatusResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodUpdateSubtitleStatusResponse updateSubtitleStatus(com.byteplus.service.vod.model.request.VodUpdateSubtitleStatusRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.UpdateSubtitleStatus, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodUpdateSubtitleStatusResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodUpdateSubtitleStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateSubtitleInfo.
     *
     * @param input com.byteplus.service.vod.model.request.VodUpdateSubtitleInfoRequest
     * @return com.byteplus.service.vod.model.response.VodUpdateSubtitleInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodUpdateSubtitleInfoResponse updateSubtitleInfo(com.byteplus.service.vod.model.request.VodUpdateSubtitleInfoRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.UpdateSubtitleInfo, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodUpdateSubtitleInfoResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodUpdateSubtitleInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * createPlaylist.
     *
     * @param input com.byteplus.service.vod.model.request.VodCreatePlaylistRequest
     * @return com.byteplus.service.vod.model.response.VodCreatePlaylistResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodCreatePlaylistResponse createPlaylist(com.byteplus.service.vod.model.request.VodCreatePlaylistRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.CreatePlaylist, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodCreatePlaylistResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodCreatePlaylistResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getPlaylists.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetPlaylistsRequest
     * @return com.byteplus.service.vod.model.response.VodGetPlaylistsResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetPlaylistsResponse getPlaylists(com.byteplus.service.vod.model.request.VodGetPlaylistsRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.GetPlaylists, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodGetPlaylistsResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetPlaylistsResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updatePlaylist.
     *
     * @param input com.byteplus.service.vod.model.request.VodUpdatePlaylistRequest
     * @return com.byteplus.service.vod.model.response.VodUpdatePlaylistResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodUpdatePlaylistResponse updatePlaylist(com.byteplus.service.vod.model.request.VodUpdatePlaylistRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.UpdatePlaylist, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodUpdatePlaylistResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodUpdatePlaylistResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * deletePlaylist.
     *
     * @param input com.byteplus.service.vod.model.request.VodDeletePlaylistRequest
     * @return com.byteplus.service.vod.model.response.VodDeletePlaylistResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodDeletePlaylistResponse deletePlaylist(com.byteplus.service.vod.model.request.VodDeletePlaylistRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.DeletePlaylist, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodDeletePlaylistResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodDeletePlaylistResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * createVideoClassification.
     *
     * @param input com.byteplus.service.vod.model.request.VodCreateVideoClassificationRequest
     * @return com.byteplus.service.vod.model.response.VodCreateVideoClassificationResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodCreateVideoClassificationResponse createVideoClassification(com.byteplus.service.vod.model.request.VodCreateVideoClassificationRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.CreateVideoClassification, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodCreateVideoClassificationResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodCreateVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateVideoClassification.
     *
     * @param input com.byteplus.service.vod.model.request.VodUpdateVideoClassificationRequest
     * @return com.byteplus.service.vod.model.response.VodUpdateVideoClassificationResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodUpdateVideoClassificationResponse updateVideoClassification(com.byteplus.service.vod.model.request.VodUpdateVideoClassificationRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.UpdateVideoClassification, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodUpdateVideoClassificationResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodUpdateVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * deleteVideoClassification.
     *
     * @param input com.byteplus.service.vod.model.request.VodDeleteVideoClassificationRequest
     * @return com.byteplus.service.vod.model.response.VodDeleteVideoClassificationResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodDeleteVideoClassificationResponse deleteVideoClassification(com.byteplus.service.vod.model.request.VodDeleteVideoClassificationRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.DeleteVideoClassification, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodDeleteVideoClassificationResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodDeleteVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listVideoClassifications.
     *
     * @param input com.byteplus.service.vod.model.request.VodListVideoClassificationsRequest
     * @return com.byteplus.service.vod.model.response.VodListVideoClassificationsResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodListVideoClassificationsResponse listVideoClassifications(com.byteplus.service.vod.model.request.VodListVideoClassificationsRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ListVideoClassifications, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodListVideoClassificationsResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodListVideoClassificationsResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listSnapshots.
     *
     * @param input com.byteplus.service.vod.model.request.VodListSnapshotsRequest
     * @return com.byteplus.service.vod.model.response.VodListSnapshotsResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodListSnapshotsResponse listSnapshots(com.byteplus.service.vod.model.request.VodListSnapshotsRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ListSnapshots, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodListSnapshotsResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodListSnapshotsResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * startWorkflow.
     *
     * @param input com.byteplus.service.vod.model.request.VodStartWorkflowRequest
     * @return com.byteplus.service.vod.model.response.VodStartWorkflowResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodStartWorkflowResponse startWorkflow(com.byteplus.service.vod.model.request.VodStartWorkflowRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.StartWorkflow, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodStartWorkflowResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodStartWorkflowResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * retrieveTranscodeResult.
     *
     * @param input com.byteplus.service.vod.model.request.VodRetrieveTranscodeResultRequest
     * @return com.byteplus.service.vod.model.response.VodRetrieveTranscodeResultResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodRetrieveTranscodeResultResponse retrieveTranscodeResult(com.byteplus.service.vod.model.request.VodRetrieveTranscodeResultRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.RetrieveTranscodeResult, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodRetrieveTranscodeResultResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodRetrieveTranscodeResultResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * GetWorkflowExecution.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetWorkflowExecutionStatusRequest
     * @return com.byteplus.service.vod.model.response.VodGetWorkflowExecutionStatusResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetWorkflowExecutionStatusResponse GetWorkflowExecution(com.byteplus.service.vod.model.request.VodGetWorkflowExecutionStatusRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.GetWorkflowExecution, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodGetWorkflowExecutionStatusResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetWorkflowExecutionStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * createSpace.
     *
     * @param input com.byteplus.service.vod.model.request.VodCreateSpaceRequest
     * @return com.byteplus.service.vod.model.response.VodCreateSpaceResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodCreateSpaceResponse createSpace(com.byteplus.service.vod.model.request.VodCreateSpaceRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.CreateSpace, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodCreateSpaceResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodCreateSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listSpace.
     *
     * @param input com.byteplus.service.vod.model.request.VodListSpaceRequest
     * @return com.byteplus.service.vod.model.response.VodListSpaceResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodListSpaceResponse listSpace(com.byteplus.service.vod.model.request.VodListSpaceRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ListSpace, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodListSpaceResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodListSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getSpaceDetail.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetSpaceDetailRequest
     * @return com.byteplus.service.vod.model.response.VodGetSpaceDetailResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetSpaceDetailResponse getSpaceDetail(com.byteplus.service.vod.model.request.VodGetSpaceDetailRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.GetSpaceDetail, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodGetSpaceDetailResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetSpaceDetailResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateSpaceUploadConfig.
     *
     * @param input com.byteplus.service.vod.model.request.VodUpdateSpaceUploadConfigRequest
     * @return com.byteplus.service.vod.model.response.VodUpdateSpaceUploadConfigResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodUpdateSpaceUploadConfigResponse updateSpaceUploadConfig(com.byteplus.service.vod.model.request.VodUpdateSpaceUploadConfigRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.UpdateSpaceUploadConfig, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodUpdateSpaceUploadConfigResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodUpdateSpaceUploadConfigResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodSpaceStorageData.
     *
     * @param input com.byteplus.service.vod.model.request.VodDescribeVodSpaceStorageDataRequest
     * @return com.byteplus.service.vod.model.response.VodDescribeVodSpaceStorageDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodDescribeVodSpaceStorageDataResponse describeVodSpaceStorageData(com.byteplus.service.vod.model.request.VodDescribeVodSpaceStorageDataRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.DescribeVodSpaceStorageData, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodDescribeVodSpaceStorageDataResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodDescribeVodSpaceStorageDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * startDomain.
     *
     * @param input com.byteplus.service.vod.model.request.VodStartDomainRequest
     * @return com.byteplus.service.vod.model.response.VodStartDomainResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodStartDomainResponse startDomain(com.byteplus.service.vod.model.request.VodStartDomainRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.StartDomain, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodStartDomainResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodStartDomainResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * stopDomain.
     *
     * @param input com.byteplus.service.vod.model.request.VodStopDomainRequest
     * @return com.byteplus.service.vod.model.response.VodStopDomainResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodStopDomainResponse stopDomain(com.byteplus.service.vod.model.request.VodStopDomainRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.StopDomain, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodStopDomainResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodStopDomainResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * addDomainToScheduler.
     *
     * @param input com.byteplus.service.vod.model.request.VodAddDomainToSchedulerRequest
     * @return com.byteplus.service.vod.model.response.VodAddDomainToSchedulerResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodAddDomainToSchedulerResponse addDomainToScheduler(com.byteplus.service.vod.model.request.VodAddDomainToSchedulerRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.AddDomainToScheduler, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodAddDomainToSchedulerResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodAddDomainToSchedulerResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * removeDomainFromScheduler.
     *
     * @param input com.byteplus.service.vod.model.request.VodRemoveDomainFromSchedulerRequest
     * @return com.byteplus.service.vod.model.response.VodRemoveDomainFromSchedulerResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodRemoveDomainFromSchedulerResponse removeDomainFromScheduler(com.byteplus.service.vod.model.request.VodRemoveDomainFromSchedulerRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.RemoveDomainFromScheduler, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodRemoveDomainFromSchedulerResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodRemoveDomainFromSchedulerResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateDomainPlayRule.
     *
     * @param input com.byteplus.service.vod.model.request.VodUpdateDomainPlayRuleRequestRequest
     * @return com.byteplus.service.vod.model.response.VodUpdateDomainPlayRuleResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodUpdateDomainPlayRuleResponse updateDomainPlayRule(com.byteplus.service.vod.model.request.VodUpdateDomainPlayRuleRequestRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.UpdateDomainPlayRule, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodUpdateDomainPlayRuleResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodUpdateDomainPlayRuleResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listDomain.
     *
     * @param input com.byteplus.service.vod.model.request.VodListDomainRequest
     * @return com.byteplus.service.vod.model.response.VodListDomainResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodListDomainResponse listDomain(com.byteplus.service.vod.model.request.VodListDomainRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ListDomain, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodListDomainResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodListDomainResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * createCdnRefreshTask.
     *
     * @param input com.byteplus.service.vod.model.request.VodCreateCdnRefreshTaskRequest
     * @return com.byteplus.service.vod.model.response.VodCreateCdnRefreshTaskResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodCreateCdnRefreshTaskResponse createCdnRefreshTask(com.byteplus.service.vod.model.request.VodCreateCdnRefreshTaskRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.CreateCdnRefreshTask, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodCreateCdnRefreshTaskResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodCreateCdnRefreshTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * createCdnPreloadTask.
     *
     * @param input com.byteplus.service.vod.model.request.VodCreateCdnPreloadTaskRequest
     * @return com.byteplus.service.vod.model.response.VodCreateCdnPreloadTaskResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodCreateCdnPreloadTaskResponse createCdnPreloadTask(com.byteplus.service.vod.model.request.VodCreateCdnPreloadTaskRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.CreateCdnPreloadTask, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodCreateCdnPreloadTaskResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodCreateCdnPreloadTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnTasks.
     *
     * @param input com.byteplus.service.vod.model.request.VodListCdnTasksRequest
     * @return com.byteplus.service.vod.model.response.VodListCdnTasksResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodListCdnTasksResponse listCdnTasks(com.byteplus.service.vod.model.request.VodListCdnTasksRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ListCdnTasks, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodListCdnTasksResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodListCdnTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnAccessLog.
     *
     * @param input com.byteplus.service.vod.model.request.VodListCdnAccessLogRequest
     * @return com.byteplus.service.vod.model.response.VodListCdnAccessLogResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodListCdnAccessLogResponse listCdnAccessLog(com.byteplus.service.vod.model.request.VodListCdnAccessLogRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ListCdnAccessLog, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodListCdnAccessLogResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodListCdnAccessLogResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnTopAccessUrl.
     *
     * @param input com.byteplus.service.vod.model.request.VodListCdnTopAccessUrlRequest
     * @return com.byteplus.service.vod.model.response.VodListCdnTopAccessUrlResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodListCdnTopAccessUrlResponse listCdnTopAccessUrl(com.byteplus.service.vod.model.request.VodListCdnTopAccessUrlRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ListCdnTopAccessUrl, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodListCdnTopAccessUrlResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodListCdnTopAccessUrlResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodDomainBandwidthData.
     *
     * @param input com.byteplus.service.vod.model.request.VodDescribeVodDomainBandwidthDataRequest
     * @return com.byteplus.service.vod.model.response.VodDescribeVodDomainBandwidthDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodDescribeVodDomainBandwidthDataResponse describeVodDomainBandwidthData(com.byteplus.service.vod.model.request.VodDescribeVodDomainBandwidthDataRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.DescribeVodDomainBandwidthData, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodDescribeVodDomainBandwidthDataResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodDescribeVodDomainBandwidthDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnUsageData.
     *
     * @param input com.byteplus.service.vod.model.request.VodListCdnUsageDataRequest
     * @return com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse listCdnUsageData(com.byteplus.service.vod.model.request.VodListCdnUsageDataRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ListCdnUsageData, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnUsageDataDetail.
     *
     * @param input com.byteplus.service.vod.model.request.VodListCdnUsageDataDetailRequest
     * @return com.byteplus.service.vod.model.response.VodListCdnUsageDataDetailResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodListCdnUsageDataDetailResponse listCdnUsageDataDetail(com.byteplus.service.vod.model.request.VodListCdnUsageDataDetailRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ListCdnUsageDataDetail, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodListCdnUsageDataDetailResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodListCdnUsageDataDetailResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnStatusData.
     *
     * @param input com.byteplus.service.vod.model.request.VodListCdnStatusDataRequest
     * @return com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse listCdnStatusData(com.byteplus.service.vod.model.request.VodListCdnStatusDataRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ListCdnStatusData, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnStatusDataDetail.
     *
     * @param input com.byteplus.service.vod.model.request.VodListCdnStatusDataDetailRequest
     * @return com.byteplus.service.vod.model.response.VodListCdnStatusDataDetailResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodListCdnStatusDataDetailResponse listCdnStatusDataDetail(com.byteplus.service.vod.model.request.VodListCdnStatusDataDetailRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ListCdnStatusDataDetail, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodListCdnStatusDataDetailResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodListCdnStatusDataDetailResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeIpInfo.
     *
     * @param input com.byteplus.service.vod.model.request.VodDescribeIPInfoRequest
     * @return com.byteplus.service.vod.model.response.VodDescribeIPInfoResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodDescribeIPInfoResponse describeIpInfo(com.byteplus.service.vod.model.request.VodDescribeIPInfoRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.DescribeIpInfo, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodDescribeIPInfoResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodDescribeIPInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodDomainTrafficData.
     *
     * @param input com.byteplus.service.vod.model.request.VodDescribeVodDomainTrafficDataRequest
     * @return com.byteplus.service.vod.model.response.VodDescribeVodDomainTrafficDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodDescribeVodDomainTrafficDataResponse describeVodDomainTrafficData(com.byteplus.service.vod.model.request.VodDescribeVodDomainTrafficDataRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.DescribeVodDomainTrafficData, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodDescribeVodDomainTrafficDataResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodDescribeVodDomainTrafficDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * listCdnPvData.
     *
     * @param input com.byteplus.service.vod.model.request.VodListCdnPvDataRequest
     * @return com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse listCdnPvData(com.byteplus.service.vod.model.request.VodListCdnPvDataRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.ListCdnPvData, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * submitBlockTasks.
     *
     * @param input com.byteplus.service.vod.model.request.VodSubmitBlockTasksRequest
     * @return com.byteplus.service.vod.model.response.VodSubmitBlockTasksResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodSubmitBlockTasksResponse submitBlockTasks(com.byteplus.service.vod.model.request.VodSubmitBlockTasksRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = post(com.byteplus.service.vod.Const.SubmitBlockTasks, new ArrayList<>(), com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodSubmitBlockTasksResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodSubmitBlockTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * getContentBlockTasks.
     *
     * @param input com.byteplus.service.vod.model.request.VodGetContentBlockTasksRequest
     * @return com.byteplus.service.vod.model.response.VodGetContentBlockTasksResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodGetContentBlockTasksResponse getContentBlockTasks(com.byteplus.service.vod.model.request.VodGetContentBlockTasksRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = post(com.byteplus.service.vod.Const.GetContentBlockTasks, new ArrayList<>(), com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodGetContentBlockTasksResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodGetContentBlockTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * createDomain.
     *
     * @param input com.byteplus.service.vod.model.request.VodCreateDomainV2Request
     * @return com.byteplus.service.vod.model.response.VodCreateDomainV2Response
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodCreateDomainV2Response createDomain(com.byteplus.service.vod.model.request.VodCreateDomainV2Request input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.CreateDomain, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodCreateDomainV2Response.Builder responseBuilder = com.byteplus.service.vod.model.response.VodCreateDomainV2Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * updateDomainExpire.
     *
     * @param input com.byteplus.service.vod.model.request.VodUpdateDomainExpireV2Request
     * @return com.byteplus.service.vod.model.response.VodUpdateDomainExpireV2Response
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodUpdateDomainExpireV2Response updateDomainExpire(com.byteplus.service.vod.model.request.VodUpdateDomainExpireV2Request input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.UpdateDomainExpire, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodUpdateDomainExpireV2Response.Builder responseBuilder = com.byteplus.service.vod.model.response.VodUpdateDomainExpireV2Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * addOrUpdateCertificate.
     *
     * @param input com.byteplus.service.vod.model.request.AddOrUpdateCertificateV2Request
     * @return com.byteplus.service.vod.model.response.AddOrUpdateCertificateV2Response
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.AddOrUpdateCertificateV2Response addOrUpdateCertificate(com.byteplus.service.vod.model.request.AddOrUpdateCertificateV2Request input) throws Exception {
        com.byteplus.model.response.RawResponse response = post(com.byteplus.service.vod.Const.AddOrUpdateCertificate, new ArrayList<>(), com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.AddOrUpdateCertificateV2Response.Builder responseBuilder = com.byteplus.service.vod.model.response.AddOrUpdateCertificateV2Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * addCallbackSubscription.
     *
     * @param input com.byteplus.service.vod.model.request.VodAddCallbackSubscriptionRequest
     * @return com.byteplus.service.vod.model.response.VodAddCallbackSubscriptionResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodAddCallbackSubscriptionResponse addCallbackSubscription(com.byteplus.service.vod.model.request.VodAddCallbackSubscriptionRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.AddCallbackSubscription, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodAddCallbackSubscriptionResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodAddCallbackSubscriptionResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * setCallbackEvent.
     *
     * @param input com.byteplus.service.vod.model.request.VodSetCallbackEventRequest
     * @return com.byteplus.service.vod.model.response.VodSetCallbackEventResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.VodSetCallbackEventResponse setCallbackEvent(com.byteplus.service.vod.model.request.VodSetCallbackEventRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.SetCallbackEvent, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.VodSetCallbackEventResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.VodSetCallbackEventResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodSpaceTranscodeData.
     *
     * @param input com.byteplus.service.vod.model.request.DescribeVodSpaceTranscodeDataRequest
     * @return com.byteplus.service.vod.model.response.DescribeVodSpaceTranscodeDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.DescribeVodSpaceTranscodeDataResponse describeVodSpaceTranscodeData(com.byteplus.service.vod.model.request.DescribeVodSpaceTranscodeDataRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.DescribeVodSpaceTranscodeData, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.DescribeVodSpaceTranscodeDataResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.DescribeVodSpaceTranscodeDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


    /**
     * describeVodSnapshotData.
     *
     * @param input com.byteplus.service.vod.model.request.DescribeVodSnapshotDataRequest
     * @return com.byteplus.service.vod.model.response.DescribeVodSnapshotDataResponse
     * @throws Exception the exception
     */
    @Override
    public com.byteplus.service.vod.model.response.DescribeVodSnapshotDataResponse describeVodSnapshotData(com.byteplus.service.vod.model.request.DescribeVodSnapshotDataRequest input) throws Exception {
        com.byteplus.model.response.RawResponse response = query(com.byteplus.service.vod.Const.DescribeVodSnapshotData, com.byteplus.helper.Utils.mapToPairList(com.byteplus.helper.Utils.protoBufferToMap(input, true)));
        if (response.getCode() != com.byteplus.error.SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        com.byteplus.service.vod.model.response.DescribeVodSnapshotDataResponse.Builder responseBuilder = com.byteplus.service.vod.model.response.DescribeVodSnapshotDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(new InputStreamReader(new ByteArrayInputStream(response.getData())), responseBuilder);
        return responseBuilder.build();
    }


}  // end of service interface
