/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CompactLinkedMap;
import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.CalendarConversions;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.InstantConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

final class DateConversions {
    private DateConversions() {
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return Instant.ofEpochMilli(DateConversions.toLong(from, converter)).atZone(converter.getOptions().getZoneId());
    }

    static long toLong(Object from, Converter converter) {
        return ((Date)from).getTime();
    }

    static double toDouble(Object from, Converter converter) {
        Date date = (Date)from;
        return (double)date.getTime() / 1000.0;
    }

    static java.sql.Date toSqlDate(Object from, Converter converter) {
        return new java.sql.Date(DateConversions.toLong(from, converter));
    }

    static Date toDate(Object from, Converter converter) {
        return new Date(DateConversions.toLong(from, converter));
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return new Timestamp(DateConversions.toLong(from, converter));
    }

    static Calendar toCalendar(Object from, Converter converter) {
        return CalendarConversions.create(DateConversions.toLong(from, converter), converter);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Date date = (Date)from;
        long epochMillis = date.getTime();
        return new BigDecimal(epochMillis).divide(BigDecimalConversions.GRAND, 9, RoundingMode.DOWN);
    }

    static Instant toInstant(Object from, Converter converter) {
        Date date = (Date)from;
        if (date instanceof java.sql.Date) {
            return new Date(date.getTime()).toInstant();
        }
        return date.toInstant();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return DateConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return DateConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        Instant instant = DateConversions.toInstant(from, converter);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, converter.getOptions().getZoneId());
        return localDateTime.toLocalTime();
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Instant instant = DateConversions.toInstant(from, converter);
        return InstantConversions.toBigInteger(instant, converter);
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(DateConversions.toLong(from, converter));
    }

    static String sqlDateToString(Object from, Converter converter) {
        java.sql.Date sqlDate = (java.sql.Date)from;
        return DateConversions.toString(new Date(sqlDate.getTime()), converter);
    }

    static String toString(Object from, Converter converter) {
        Date date = (Date)from;
        ZonedDateTime zonedDateTime = date.toInstant().atZone(converter.getOptions().getZoneId());
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").appendOffset("+HH:MM", "Z").toFormatter();
        return zonedDateTime.format(formatter);
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Date date = (Date)from;
        CompactLinkedMap<String, Object> map = new CompactLinkedMap<String, Object>();
        map.put("_v", date.getTime());
        return map;
    }
}

