/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.InstantConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

final class LocalDateConversions {
    private LocalDateConversions() {
    }

    static Instant toInstant(Object from, Converter converter) {
        return LocalDateConversions.toZonedDateTime(from, converter).toInstant();
    }

    static long toLong(Object from, Converter converter) {
        return LocalDateConversions.toInstant(from, converter).toEpochMilli();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return LocalDateConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return LocalDateConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        return LocalDateConversions.toZonedDateTime(from, converter).toLocalTime();
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        ZoneId zoneId = converter.getOptions().getZoneId();
        return ((LocalDate)from).atStartOfDay(zoneId);
    }

    static double toDouble(Object from, Converter converter) {
        return (double)LocalDateConversions.toInstant(from, converter).toEpochMilli() / 1000.0;
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(LocalDateConversions.toLong(from, converter));
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return new Timestamp(LocalDateConversions.toLong(from, converter));
    }

    static Calendar toCalendar(Object from, Converter converter) {
        ZonedDateTime time = LocalDateConversions.toZonedDateTime(from, converter);
        Calendar calendar = Calendar.getInstance(converter.getOptions().getTimeZone());
        calendar.setTimeInMillis(time.toInstant().toEpochMilli());
        return calendar;
    }

    static java.sql.Date toSqlDate(Object from, Converter converter) {
        return new java.sql.Date(LocalDateConversions.toLong(from, converter));
    }

    static Date toDate(Object from, Converter converter) {
        return new Date(LocalDateConversions.toLong(from, converter));
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Instant instant = LocalDateConversions.toInstant(from, converter);
        return InstantConversions.toBigInteger(instant, converter);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Instant instant = LocalDateConversions.toInstant(from, converter);
        return InstantConversions.toBigDecimal(instant, converter);
    }

    static String toString(Object from, Converter converter) {
        LocalDate localDate = (LocalDate)from;
        return localDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }
}

