/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;

final class ArrayConversions {
    private ArrayConversions() {
    }

    static Object arrayToArray(Object sourceArray, Class<?> targetArrayType, Converter converter) {
        int length = Array.getLength(sourceArray);
        Class<?> targetComponentType = targetArrayType.getComponentType();
        Object targetArray = Array.newInstance(targetComponentType, length);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(sourceArray, i);
            Object convertedValue = value != null && value.getClass().isArray() ? ArrayConversions.arrayToArray(value, targetComponentType, converter) : (value == null || targetComponentType.isAssignableFrom(value.getClass()) ? value : converter.convert(value, targetComponentType));
            Array.set(targetArray, i, convertedValue);
        }
        return targetArray;
    }

    static Object collectionToArray(Collection<?> collection, Class<?> arrayType, Converter converter) {
        Class<?> componentType = arrayType.getComponentType();
        Object array = Array.newInstance(componentType, collection.size());
        int index = 0;
        for (Object item : collection) {
            Object convertedValue = item instanceof Collection && componentType.isArray() ? ArrayConversions.collectionToArray((Collection)item, componentType, converter) : (item == null || componentType.isAssignableFrom(item.getClass()) ? item : converter.convert(item, componentType));
            Array.set(array, index++, convertedValue);
        }
        return array;
    }

    static Object enumSetToArray(EnumSet<?> enumSet, Class<?> targetArrayType) {
        Class<?> componentType = targetArrayType.getComponentType();
        Object array = Array.newInstance(componentType, enumSet.size());
        int i = 0;
        if (componentType == String.class) {
            for (Enum value : enumSet) {
                Array.set(array, i++, value.name());
            }
        } else if (componentType == Integer.class || componentType == Integer.TYPE || componentType == Long.class || componentType == Long.TYPE) {
            for (Enum value : enumSet) {
                Array.set(array, i++, value.ordinal());
            }
        } else if (componentType == Short.class || componentType == Short.TYPE) {
            for (Enum value : enumSet) {
                int ordinal = value.ordinal();
                if (ordinal > Short.MAX_VALUE) {
                    throw new IllegalArgumentException("Enum ordinal too large for short: " + ordinal);
                }
                Array.set(array, i++, (short)ordinal);
            }
        } else if (componentType == Byte.class || componentType == Byte.TYPE) {
            for (Enum value : enumSet) {
                int ordinal = value.ordinal();
                if (ordinal > 127) {
                    throw new IllegalArgumentException("Enum ordinal too large for byte: " + ordinal);
                }
                Array.set(array, i++, (byte)ordinal);
            }
        } else if (componentType == Class.class) {
            for (Enum value : enumSet) {
                Array.set(array, i++, value.getDeclaringClass());
            }
        } else {
            for (Enum value : enumSet) {
                Array.set(array, i++, value);
            }
        }
        return array;
    }

    static Color toColor(Object from, Converter converter) {
        int[] array = (int[])from;
        if (array.length < 3 || array.length > 4) {
            throw new IllegalArgumentException("Color array must have 3 (RGB) or 4 (RGBA) elements, got: " + array.length);
        }
        int r = array[0];
        int g = array[1];
        int b = array[2];
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            throw new IllegalArgumentException("RGB values must be between 0-255, got: [" + r + ", " + g + ", " + b + "]");
        }
        if (array.length == 4) {
            int a = array[3];
            if (a < 0 || a > 255) {
                throw new IllegalArgumentException("Alpha value must be between 0-255, got: " + a);
            }
            return new Color(r, g, b, a);
        }
        return new Color(r, g, b);
    }

    static Dimension toDimension(Object from, Converter converter) {
        int[] array = (int[])from;
        if (array.length != 2) {
            throw new IllegalArgumentException("Dimension array must have exactly 2 elements [width, height], got: " + array.length);
        }
        int width = array[0];
        int height = array[1];
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Width and height must be non-negative, got: [" + width + ", " + height + "]");
        }
        return new Dimension(width, height);
    }

    static Point toPoint(Object from, Converter converter) {
        int[] array = (int[])from;
        if (array.length != 2) {
            throw new IllegalArgumentException("Point array must have exactly 2 elements [x, y], got: " + array.length);
        }
        int x = array[0];
        int y = array[1];
        return new Point(x, y);
    }

    static Rectangle toRectangle(Object from, Converter converter) {
        int[] array = (int[])from;
        if (array.length != 4) {
            throw new IllegalArgumentException("Rectangle array must have exactly 4 elements [x, y, width, height], got: " + array.length);
        }
        int x = array[0];
        int y = array[1];
        int width = array[2];
        int height = array[3];
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Width and height must be non-negative, got: [width=" + width + ", height=" + height + "]");
        }
        return new Rectangle(x, y, width, height);
    }

    static Insets toInsets(Object from, Converter converter) {
        int[] array = (int[])from;
        if (array.length != 4) {
            throw new IllegalArgumentException("Insets array must have exactly 4 elements [top, left, bottom, right], got: " + array.length);
        }
        int top = array[0];
        int left = array[1];
        int bottom = array[2];
        int right = array[3];
        return new Insets(top, left, bottom, right);
    }

    static File charArrayToFile(Object from, Converter converter) {
        char[] array = (char[])from;
        String path = new String(array);
        return converter.convert(path, File.class);
    }

    static File byteArrayToFile(Object from, Converter converter) {
        byte[] array = (byte[])from;
        String path = new String(array, StandardCharsets.UTF_8);
        return converter.convert(path, File.class);
    }

    static Path charArrayToPath(Object from, Converter converter) {
        char[] array = (char[])from;
        String path = new String(array);
        return converter.convert(path, Path.class);
    }

    static Path byteArrayToPath(Object from, Converter converter) {
        byte[] array = (byte[])from;
        String path = new String(array, StandardCharsets.UTF_8);
        return converter.convert(path, Path.class);
    }
}

