/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.BigIntegerConversions;
import com.cedarsoftware.util.convert.CalendarConversions;
import com.cedarsoftware.util.convert.CommonValues;
import com.cedarsoftware.util.convert.Converter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class NumberConversions {
    private NumberConversions() {
    }

    static byte toByte(Object from, Converter converter) {
        return ((Number)from).byteValue();
    }

    static Byte toByteZero(Object from, Converter converter) {
        return CommonValues.BYTE_ZERO;
    }

    static short toShort(Object from, Converter converter) {
        return ((Number)from).shortValue();
    }

    static Short toShortZero(Object from, Converter converter) {
        return CommonValues.SHORT_ZERO;
    }

    static int toInt(Object from, Converter converter) {
        return ((Number)from).intValue();
    }

    static Integer toIntZero(Object from, Converter converter) {
        return CommonValues.INTEGER_ZERO;
    }

    static long toLong(Object from, Converter converter) {
        return ((Number)from).longValue();
    }

    static Long toLongZero(Object from, Converter converter) {
        return CommonValues.LONG_ZERO;
    }

    static float toFloat(Object from, Converter converter) {
        return ((Number)from).floatValue();
    }

    static Float toFloatZero(Object from, Converter converter) {
        return CommonValues.FLOAT_ZERO;
    }

    static String floatToString(Object from, Converter converter) {
        float x = ((Float)from).floatValue();
        if (x == 0.0f) {
            return "0";
        }
        return from.toString();
    }

    static double toDouble(Object from, Converter converter) {
        return ((Number)from).doubleValue();
    }

    static Double toDoubleZero(Object from, Converter converter) {
        return CommonValues.DOUBLE_ZERO;
    }

    static String doubleToString(Object from, Converter converter) {
        double x = (Double)from;
        if (x == 0.0) {
            return "0";
        }
        return from.toString();
    }

    static BigDecimal integerTypeToBigDecimal(Object from, Converter converter) {
        return BigDecimal.valueOf(NumberConversions.toLong(from, converter));
    }

    static BigInteger integerTypeToBigInteger(Object from, Converter converter) {
        return BigInteger.valueOf(NumberConversions.toLong(from, converter));
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(NumberConversions.toLong(from, converter));
    }

    static AtomicInteger toAtomicInteger(Object from, Converter converter) {
        return new AtomicInteger(NumberConversions.toInt(from, converter));
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return new AtomicBoolean(NumberConversions.toLong(from, converter) != 0L);
    }

    static BigDecimal floatingPointToBigDecimal(Object from, Converter converter) {
        return BigDecimal.valueOf(NumberConversions.toDouble(from, converter));
    }

    static BigInteger floatingPointToBigInteger(Object from, Converter converter) {
        double d = NumberConversions.toDouble(from, converter);
        String s = String.format("%.0f", d > 0.0 ? Math.floor(d) : Math.ceil(d));
        return new BigInteger(s);
    }

    static boolean isIntTypeNotZero(Object from, Converter converter) {
        return NumberConversions.toLong(from, converter) != 0L;
    }

    static boolean isFloatTypeNotZero(Object from, Converter converter) {
        return NumberConversions.toDouble(from, converter) != 0.0;
    }

    static boolean isBigIntegerNotZero(Object from, Converter converter) {
        return ((BigInteger)from).compareTo(BigInteger.ZERO) != 0;
    }

    static boolean isBigDecimalNotZero(Object from, Converter converter) {
        return ((BigDecimal)from).compareTo(BigDecimal.ZERO) != 0;
    }

    static char toCharacter(Object from, Converter converter) {
        long value = NumberConversions.toLong(from, converter);
        if (value >= 0L && value <= 65535L) {
            return (char)value;
        }
        throw new IllegalArgumentException("Value '" + value + "' out of range to be converted to character.");
    }

    static java.util.Date toDate(Object from, Converter converter) {
        return new java.util.Date(NumberConversions.toLong(from, converter));
    }

    static Duration toDuration(Object from, Converter converter) {
        Number num = (Number)from;
        if (num instanceof Long || num instanceof Integer || num instanceof BigInteger || num instanceof AtomicLong || num instanceof AtomicInteger) {
            String systemPrecision = System.getProperty("cedarsoftware.converter.duration.long.precision");
            String precision = systemPrecision;
            if (precision == null) {
                precision = (String)converter.getOptions().getCustomOption("duration.long.precision");
            }
            if ("nanos".equals(precision)) {
                return Duration.ofNanos(num.longValue());
            }
            return Duration.ofMillis(num.longValue());
        }
        if (num instanceof BigDecimal) {
            BigDecimal seconds = (BigDecimal)num;
            long wholeSecs = seconds.longValue();
            long nanos = seconds.subtract(BigDecimal.valueOf(wholeSecs)).multiply(BigDecimal.valueOf(1000000000L)).longValue();
            return Duration.ofSeconds(wholeSecs, nanos);
        }
        if (num instanceof Double || num instanceof Float) {
            BigDecimal seconds = BigDecimal.valueOf(num.doubleValue());
            long wholeSecs = seconds.longValue();
            long nanos = seconds.subtract(BigDecimal.valueOf(wholeSecs)).multiply(BigDecimal.valueOf(1000000000L)).longValue();
            return Duration.ofSeconds(wholeSecs, nanos);
        }
        BigDecimal seconds = new BigDecimal(num.toString());
        long wholeSecs = seconds.longValue();
        long nanos = seconds.subtract(BigDecimal.valueOf(wholeSecs)).multiply(BigDecimal.valueOf(1000000000L)).longValue();
        return Duration.ofSeconds(wholeSecs, nanos);
    }

    static Instant toInstant(Object from, Converter converter) {
        long value = NumberConversions.toLong(from, converter);
        String systemPrecision = System.getProperty("cedarsoftware.converter.modern.time.long.precision");
        String precision = systemPrecision;
        if (precision == null) {
            precision = (String)converter.getOptions().getCustomOption("modern.time.long.precision");
        }
        if ("nanos".equals(precision)) {
            return Instant.ofEpochSecond(value / 1000000000L, value % 1000000000L);
        }
        return Instant.ofEpochMilli(value);
    }

    static Duration longNanosToDuration(Object from, Converter converter) {
        long value = NumberConversions.toLong(from, converter);
        String systemPrecision = System.getProperty("cedarsoftware.converter.duration.long.precision");
        String precision = systemPrecision;
        if (precision == null) {
            precision = (String)converter.getOptions().getCustomOption("duration.long.precision");
        }
        if ("nanos".equals(precision)) {
            return Duration.ofNanos(value);
        }
        return Duration.ofMillis(value);
    }

    static Instant longNanosToInstant(Object from, Converter converter) {
        long value = NumberConversions.toLong(from, converter);
        String systemPrecision = System.getProperty("cedarsoftware.converter.modern.time.long.precision");
        String precision = systemPrecision;
        if (precision == null) {
            precision = (String)converter.getOptions().getCustomOption("modern.time.long.precision");
        }
        if ("nanos".equals(precision)) {
            return Instant.ofEpochSecond(value / 1000000000L, value % 1000000000L);
        }
        return Instant.ofEpochMilli(value);
    }

    static Duration atomicLongNanosToDuration(Object from, Converter converter) {
        long value = NumberConversions.toLong(from, converter);
        String systemPrecision = System.getProperty("cedarsoftware.converter.duration.long.precision");
        String precision = systemPrecision;
        if (precision == null) {
            precision = (String)converter.getOptions().getCustomOption("duration.long.precision");
        }
        if ("nanos".equals(precision)) {
            return Duration.ofNanos(value);
        }
        return Duration.ofMillis(value);
    }

    static Instant atomicLongNanosToInstant(Object from, Converter converter) {
        long value = NumberConversions.toLong(from, converter);
        String systemPrecision = System.getProperty("cedarsoftware.converter.modern.time.long.precision");
        String precision = systemPrecision;
        if (precision == null) {
            precision = (String)converter.getOptions().getCustomOption("modern.time.long.precision");
        }
        if ("nanos".equals(precision)) {
            return Instant.ofEpochSecond(value / 1000000000L, value % 1000000000L);
        }
        return Instant.ofEpochMilli(value);
    }

    static Date toSqlDate(Object from, Converter converter) {
        return Date.valueOf(Instant.ofEpochMilli(((Number)from).longValue()).atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return new Timestamp(NumberConversions.toLong(from, converter));
    }

    static Calendar toCalendar(Object from, Converter converter) {
        return CalendarConversions.create(NumberConversions.toLong(from, converter), converter);
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        long value = ((Number)from).longValue();
        String systemPrecision = System.getProperty("cedarsoftware.converter.localtime.long.precision");
        String precision = systemPrecision;
        if (precision == null) {
            precision = (String)converter.getOptions().getCustomOption("localtime.long.precision");
        }
        if ("nanos".equals(precision)) {
            try {
                return LocalTime.ofNanoOfDay(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Input value [" + value + "] for conversion to LocalTime must be >= 0 && <= 86399999999999", e);
            }
        }
        try {
            return LocalTime.ofNanoOfDay(value * 1000000L);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Input value [" + value + "] for conversion to LocalTime must be >= 0 && <= 86399999", e);
        }
    }

    static LocalTime longNanosToLocalTime(Object from, Converter converter) {
        long value = ((Number)from).longValue();
        String systemPrecision = System.getProperty("cedarsoftware.converter.localtime.long.precision");
        String precision = systemPrecision;
        if (precision == null) {
            precision = (String)converter.getOptions().getCustomOption("localtime.long.precision");
        }
        if ("nanos".equals(precision)) {
            if (value < 0L || value > 86399999999999L) {
                throw new IllegalArgumentException("Input value [" + value + "] for conversion to LocalTime must be >= 0 && <= 86399999999999");
            }
            try {
                return LocalTime.ofNanoOfDay(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Input value [" + value + "] for conversion to LocalTime must be >= 0 && <= 86399999999999", e);
            }
        }
        if (value < 0L || value > 86399999L) {
            throw new IllegalArgumentException("Input value [" + value + "] for conversion to LocalTime must be >= 0 && <= 86399999");
        }
        try {
            long seconds = value / 1000L;
            long millis = value % 1000L;
            return LocalTime.ofSecondOfDay(seconds).plusNanos(millis * 1000000L);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Input value [" + value + "] for conversion to LocalTime must be >= 0 && <= 86399999", e);
        }
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return NumberConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return NumberConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return NumberConversions.toInstant(from, converter).atZone(converter.getOptions().getZoneId());
    }

    static OffsetTime toOffsetTime(Object from, Converter converter) {
        if (from instanceof Integer || from instanceof Long || from instanceof AtomicLong || from instanceof AtomicInteger) {
            long number = ((Number)from).longValue();
            Instant instant = Instant.ofEpochMilli(number);
            return OffsetTime.ofInstant(instant, converter.getOptions().getZoneId());
        }
        if (from instanceof BigDecimal) {
            return BigDecimalConversions.toOffsetTime(from, converter);
        }
        if (from instanceof BigInteger) {
            return BigIntegerConversions.toOffsetTime(from, converter);
        }
        throw new IllegalArgumentException("Unsupported value: " + from + " requested to be converted to an OffsetTime.");
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        return NumberConversions.toZonedDateTime(from, converter).toOffsetDateTime();
    }

    static Year toYear(Object from, Converter converter) {
        Number number = (Number)from;
        return Year.of(number.shortValue());
    }

    static Year nullToYear(Object from, Converter converter) {
        return Year.of(0);
    }

    static Color toColor(Object from, Converter converter) {
        Number number = (Number)from;
        int rgb = number.intValue();
        if ((rgb & 0xFF000000) != 0) {
            return new Color(rgb, true);
        }
        return new Color(rgb);
    }

    static Dimension toDimension(Object from, Converter converter) {
        Number number = (Number)from;
        int size = number.intValue();
        if (size < 0) {
            throw new IllegalArgumentException("Dimension size must be non-negative, got: " + size);
        }
        return new Dimension(size, size);
    }

    static Point toPoint(Object from, Converter converter) {
        Number number = (Number)from;
        int coordinate = number.intValue();
        return new Point(coordinate, coordinate);
    }

    static Dimension atomicBooleanToDimension(Object from, Converter converter) {
        AtomicBoolean atomic = (AtomicBoolean)from;
        return converter.convert(atomic.get(), Dimension.class);
    }

    static Point atomicBooleanToPoint(Object from, Converter converter) {
        AtomicBoolean atomic = (AtomicBoolean)from;
        return converter.convert(atomic.get(), Point.class);
    }

    static Dimension booleanToDimension(Object from, Converter converter) {
        Boolean bool = (Boolean)from;
        return bool != false ? new Dimension(1, 1) : new Dimension(0, 0);
    }

    static Point booleanToPoint(Object from, Converter converter) {
        Boolean bool = (Boolean)from;
        return bool != false ? new Point(1, 1) : new Point(0, 0);
    }

    static Rectangle booleanToRectangle(Object from, Converter converter) {
        Boolean bool = (Boolean)from;
        return bool != false ? new Rectangle(1, 1, 1, 1) : new Rectangle(0, 0, 0, 0);
    }

    static Rectangle longToRectangle(Object from, Converter converter) {
        Long number = (Long)from;
        if (number < 0L) {
            throw new IllegalArgumentException("Rectangle area must be non-negative, got: " + number);
        }
        int side = (int)Math.sqrt(number.longValue());
        return new Rectangle(0, 0, side, side);
    }

    static Rectangle integerToRectangle(Object from, Converter converter) {
        Integer number = (Integer)from;
        if (number < 0) {
            throw new IllegalArgumentException("Rectangle area must be non-negative, got: " + number);
        }
        int side = (int)Math.sqrt(number.intValue());
        return new Rectangle(0, 0, side, side);
    }

    static Rectangle bigIntegerToRectangle(Object from, Converter converter) {
        BigInteger bigInt = (BigInteger)from;
        if (bigInt.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Rectangle area must be non-negative, got: " + bigInt);
        }
        long longValue = bigInt.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 ? Integer.MAX_VALUE : bigInt.longValue();
        int side = (int)Math.sqrt(longValue);
        return new Rectangle(0, 0, side, side);
    }

    static Rectangle atomicBooleanToRectangle(Object from, Converter converter) {
        AtomicBoolean atomic = (AtomicBoolean)from;
        return converter.convert(atomic.get(), Rectangle.class);
    }

    static Insets longToInsets(Object from, Converter converter) {
        Long number = (Long)from;
        int value = number.intValue();
        return new Insets(value, value, value, value);
    }

    static Insets integerToInsets(Object from, Converter converter) {
        Integer number = (Integer)from;
        return new Insets(number, number, number, number);
    }

    static Insets bigIntegerToInsets(Object from, Converter converter) {
        BigInteger bigInt = (BigInteger)from;
        int value = bigInt.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 ? Integer.MAX_VALUE : bigInt.intValue();
        return new Insets(value, value, value, value);
    }

    static Insets booleanToInsets(Object from, Converter converter) {
        Boolean bool = (Boolean)from;
        return bool != false ? new Insets(1, 1, 1, 1) : new Insets(0, 0, 0, 0);
    }

    static Insets atomicBooleanToInsets(Object from, Converter converter) {
        AtomicBoolean atomic = (AtomicBoolean)from;
        return converter.convert(atomic.get(), Insets.class);
    }

    static Point bigDecimalToPoint(Object from, Converter converter) {
        BigDecimal bigDecimal = (BigDecimal)from;
        int coordinate = bigDecimal.intValue();
        return new Point(coordinate, coordinate);
    }

    static Dimension bigDecimalToDimension(Object from, Converter converter) {
        BigDecimal bigDecimal = (BigDecimal)from;
        int size = bigDecimal.intValue();
        if (size < 0) {
            throw new IllegalArgumentException("Dimension size must be non-negative, got: " + size);
        }
        return new Dimension(size, size);
    }

    static Rectangle bigDecimalToRectangle(Object from, Converter converter) {
        BigDecimal bigDecimal = (BigDecimal)from;
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("Rectangle area must be non-negative, got: " + bigDecimal);
        }
        double doubleValue = bigDecimal.doubleValue();
        int side = (int)Math.sqrt(doubleValue);
        return new Rectangle(0, 0, side, side);
    }

    static Insets bigDecimalToInsets(Object from, Converter converter) {
        BigDecimal bigDecimal = (BigDecimal)from;
        int value = bigDecimal.intValue();
        return new Insets(value, value, value, value);
    }

    static MonthDay toMonthDay(Object from, Converter converter) {
        Number number = (Number)from;
        int value = number.intValue();
        if (value < 0) {
            throw new IllegalArgumentException("Cannot convert negative number to MonthDay: " + value);
        }
        int month = value / 100;
        int day = value % 100;
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month in MMDD format: " + month + " (from " + value + ")");
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Invalid day in MMDD format: " + day + " (from " + value + ")");
        }
        try {
            return MonthDay.of(month, day);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid MMDD format: " + value + " - " + e.getMessage(), e);
        }
    }
}

