/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.Arrays;

public final class ByteUtilities {
    private static final int DEFAULT_MAX_HEX_STRING_LENGTH = 1000000;
    private static final int DEFAULT_MAX_ARRAY_SIZE = 10000000;
    static final char[] HEX_ARRAY;
    private static final int[] HEX_LOOKUP;
    private static final byte[] GZIP_MAGIC;

    private static boolean isSecurityEnabled() {
        return Boolean.parseBoolean(System.getProperty("byteutilities.security.enabled", "false"));
    }

    private static int getMaxHexStringLength() {
        if (!ByteUtilities.isSecurityEnabled()) {
            return 0;
        }
        String value = System.getProperty("byteutilities.max.hex.string.length");
        if (value == null) {
            return 1000000;
        }
        try {
            int limit = Integer.parseInt(value);
            return limit <= 0 ? 0 : limit;
        }
        catch (NumberFormatException e) {
            return 1000000;
        }
    }

    private static int getMaxArraySize() {
        if (!ByteUtilities.isSecurityEnabled()) {
            return 0;
        }
        String value = System.getProperty("byteutilities.max.array.size");
        if (value == null) {
            return 10000000;
        }
        try {
            int limit = Integer.parseInt(value);
            return limit <= 0 ? 0 : limit;
        }
        catch (NumberFormatException e) {
            return 10000000;
        }
    }

    private ByteUtilities() {
    }

    public static char toHexChar(int value) {
        return HEX_ARRAY[value & 0xF];
    }

    public static byte[] decode(String s) {
        return ByteUtilities.decode((CharSequence)s);
    }

    public static byte[] decode(CharSequence s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        int maxHexLength = ByteUtilities.getMaxHexStringLength();
        if (maxHexLength > 0 && len > maxHexLength) {
            throw new SecurityException("Hex string length exceeds maximum allowed: " + maxHexLength);
        }
        if ((len & 1) != 0) {
            return null;
        }
        byte[] bytes = new byte[len >> 1];
        int j = 0;
        for (int i = 0; i < len; i += 2) {
            char c1 = s.charAt(i);
            char c2 = s.charAt(i + 1);
            if (c1 >= HEX_LOOKUP.length || c2 >= HEX_LOOKUP.length) {
                return null;
            }
            int hi = HEX_LOOKUP[c1];
            int lo = HEX_LOOKUP[c2];
            if (hi == -1 || lo == -1) {
                return null;
            }
            bytes[j++] = (byte)(hi << 4 | lo);
        }
        return bytes;
    }

    public static String encode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int maxArraySize = ByteUtilities.getMaxArraySize();
        if (maxArraySize > 0 && bytes.length > maxArraySize) {
            throw new SecurityException("Byte array size exceeds maximum allowed: " + maxArraySize);
        }
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[j++] = HEX_ARRAY[v >>> 4];
            hexChars[j++] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static boolean isGzipped(byte[] bytes) {
        return ByteUtilities.isGzipped(bytes, 0);
    }

    public static boolean isGzipped(byte[] bytes, int offset) {
        if (bytes == null || offset < 0 || offset >= bytes.length) {
            return false;
        }
        return bytes.length - offset >= 2 && bytes[offset] == GZIP_MAGIC[0] && bytes[offset + 1] == GZIP_MAGIC[1];
    }

    static {
        int c;
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        HEX_LOOKUP = new int[128];
        Arrays.fill(HEX_LOOKUP, -1);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            ByteUtilities.HEX_LOOKUP[c] = c - 48;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            ByteUtilities.HEX_LOOKUP[c] = 10 + (c - 65);
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            ByteUtilities.HEX_LOOKUP[c] = 10 + (c - 97);
        }
        GZIP_MAGIC = new byte[]{31, -117};
    }
}

