/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ExceptionUtilities;
import java.io.IOException;
import java.io.Reader;

public class FastReader
extends Reader {
    private Reader in;
    private final char[] buf;
    private final int bufferSize;
    private final int pushbackBufferSize;
    private int position;
    private int limit;
    private final char[] pushbackBuffer;
    private int pushbackPosition;
    private int line = 1;
    private int col = 0;

    public FastReader(Reader in) {
        this(in, 16384, 16);
    }

    public FastReader(Reader in, int bufferSize, int pushbackBufferSize) {
        super((Object)in);
        if (bufferSize <= 0 || pushbackBufferSize < 0) {
            throw new IllegalArgumentException("Buffer sizes must be positive");
        }
        this.in = in;
        this.bufferSize = bufferSize;
        this.pushbackBufferSize = pushbackBufferSize;
        this.buf = new char[bufferSize];
        this.pushbackBuffer = new char[pushbackBufferSize];
        this.position = 0;
        this.limit = 0;
        this.pushbackPosition = pushbackBufferSize;
    }

    private void fill() {
        if (this.position >= this.limit) {
            try {
                this.limit = this.in.read(this.buf, 0, this.bufferSize);
            }
            catch (IOException e) {
                ExceptionUtilities.uncheckedThrow(e);
            }
            if (this.limit > 0) {
                this.position = 0;
            }
        }
    }

    public void pushback(char ch) {
        if (this.pushbackPosition == 0) {
            ExceptionUtilities.uncheckedThrow(new IOException("Pushback buffer is full"));
        }
        this.pushbackBuffer[--this.pushbackPosition] = ch;
        if (ch == '\n') {
            --this.line;
        } else {
            --this.col;
        }
    }

    protected void movePosition(char ch) {
        if (ch == '\n') {
            ++this.line;
            this.col = 0;
        } else {
            ++this.col;
        }
    }

    @Override
    public int read() {
        if (this.in == null) {
            ExceptionUtilities.uncheckedThrow(new IOException("in is null"));
        }
        if (this.pushbackPosition < this.pushbackBufferSize) {
            char ch = this.pushbackBuffer[this.pushbackPosition++];
            this.movePosition(ch);
            return ch;
        }
        this.fill();
        if (this.limit == -1) {
            return -1;
        }
        char ch = this.buf[this.position++];
        this.movePosition(ch);
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.in == null) {
            ExceptionUtilities.uncheckedThrow(new IOException("in is null"));
        }
        int bytesRead = 0;
        while (len > 0) {
            int toRead;
            int available = this.pushbackBufferSize - this.pushbackPosition;
            if (available > 0) {
                toRead = Math.min(available, len);
                System.arraycopy(this.pushbackBuffer, this.pushbackPosition, cbuf, off, toRead);
                this.pushbackPosition += toRead;
                off += toRead;
                len -= toRead;
                bytesRead += toRead;
                continue;
            }
            this.fill();
            if (this.limit == -1) {
                return bytesRead > 0 ? bytesRead : -1;
            }
            toRead = Math.min(this.limit - this.position, len);
            System.arraycopy(this.buf, this.position, cbuf, off, toRead);
            this.position += toRead;
            off += toRead;
            len -= toRead;
            bytesRead += toRead;
        }
        return bytesRead;
    }

    @Override
    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                ExceptionUtilities.uncheckedThrow(e);
            }
            this.in = null;
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public String getLastSnippet() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.position; ++i) {
            s.append(this.buf[i]);
        }
        return s.toString();
    }
}

