/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.internal;

import com.chargebee.internal.ClazzUtil;
import com.chargebee.internal.Resource;
import com.chargebee.models.Addon;
import com.chargebee.models.Address;
import com.chargebee.models.Card;
import com.chargebee.models.Comment;
import com.chargebee.models.Coupon;
import com.chargebee.models.CouponCode;
import com.chargebee.models.CreditNote;
import com.chargebee.models.Customer;
import com.chargebee.models.Download;
import com.chargebee.models.Estimate;
import com.chargebee.models.Event;
import com.chargebee.models.HostedPage;
import com.chargebee.models.Invoice;
import com.chargebee.models.Order;
import com.chargebee.models.Plan;
import com.chargebee.models.PortalSession;
import com.chargebee.models.Subscription;
import com.chargebee.models.Transaction;
import com.chargebee.org.json.JSONArray;
import com.chargebee.org.json.JSONException;
import com.chargebee.org.json.JSONObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultBase {
    private JSONObject jsonObj;

    public ResultBase(JSONObject jsonObj) {
        this.jsonObj = jsonObj;
    }

    public Subscription subscription() {
        return (Subscription)this.get("subscription");
    }

    public Customer customer() {
        return (Customer)this.get("customer");
    }

    public Card card() {
        return (Card)this.get("card");
    }

    public Invoice invoice() {
        return (Invoice)this.get("invoice");
    }

    public CreditNote creditNote() {
        return (CreditNote)this.get("credit_note");
    }

    public Order order() {
        return (Order)this.get("order");
    }

    public Transaction transaction() {
        return (Transaction)this.get("transaction");
    }

    public HostedPage hostedPage() {
        return (HostedPage)this.get("hosted_page");
    }

    public Estimate estimate() {
        return (Estimate)this.get("estimate");
    }

    public Plan plan() {
        return (Plan)this.get("plan");
    }

    public Addon addon() {
        return (Addon)this.get("addon");
    }

    public Coupon coupon() {
        return (Coupon)this.get("coupon");
    }

    public CouponCode couponCode() {
        return (CouponCode)this.get("coupon_code");
    }

    public Address address() {
        return (Address)this.get("address");
    }

    public Event event() {
        return (Event)this.get("event");
    }

    public Comment comment() {
        return (Comment)this.get("comment");
    }

    public Download download() {
        return (Download)this.get("download");
    }

    public PortalSession portalSession() {
        return (PortalSession)this.get("portal_session");
    }

    public List<CreditNote> creditNotes() {
        return this.getList("credit_notes", "credit_note");
    }

    private List<? extends Resource> getList(String pluralName, String singularName) {
        JSONArray listModels = this.jsonObj.optJSONArray(pluralName);
        if (listModels == null) {
            return null;
        }
        try {
            ArrayList<Resource> list = new ArrayList<Resource>();
            for (int i = 0; i < listModels.length(); ++i) {
                JSONObject modelJson = listModels.getJSONObject(i);
                list.add(this._get(singularName, modelJson));
            }
            return list;
        }
        catch (JSONException jsonExp) {
            throw new RuntimeException(jsonExp);
        }
    }

    private Resource get(String key) {
        JSONObject modelJson = this.jsonObj.optJSONObject(key);
        return this._get(key, modelJson);
    }

    private Resource _get(String key, JSONObject modelJson) {
        if (modelJson == null) {
            return null;
        }
        Class modelClaz = ClazzUtil.getClaz(key);
        return (Resource)ClazzUtil.createInstance(modelClaz, modelJson);
    }

    public String toString() {
        try {
            return this.jsonObj.toString(2);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }
}

