/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.AutoCollection;
import com.chargebee.models.enums.EntityCode;
import com.chargebee.models.enums.Gateway;
import com.chargebee.models.enums.Taxability;
import com.chargebee.models.enums.Type;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Customer
extends Resource<Customer> {
    public Customer(String jsonStr) {
        super(jsonStr);
    }

    public Customer(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String firstName() {
        return this.optString("first_name");
    }

    public String lastName() {
        return this.optString("last_name");
    }

    public String email() {
        return this.optString("email");
    }

    public String phone() {
        return this.optString("phone");
    }

    public String company() {
        return this.optString("company");
    }

    public String vatNumber() {
        return this.optString("vat_number");
    }

    public AutoCollection autoCollection() {
        return this.reqEnum("auto_collection", AutoCollection.class);
    }

    public Boolean allowDirectDebit() {
        return this.reqBoolean("allow_direct_debit");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public String createdFromIp() {
        return this.optString("created_from_ip");
    }

    public Taxability taxability() {
        return this.optEnum("taxability", Taxability.class);
    }

    public EntityCode entityCode() {
        return this.optEnum("entity_code", EntityCode.class);
    }

    public String exemptNumber() {
        return this.optString("exempt_number");
    }

    @Deprecated
    public CardStatus cardStatus() {
        return this.optEnum("card_status", CardStatus.class);
    }

    public FraudFlag fraudFlag() {
        return this.optEnum("fraud_flag", FraudFlag.class);
    }

    public BillingAddress billingAddress() {
        return this.optSubResource("billing_address", BillingAddress.class);
    }

    public List<Contact> contacts() {
        return this.optList("contacts", Contact.class);
    }

    public PaymentMethod paymentMethod() {
        return this.optSubResource("payment_method", PaymentMethod.class);
    }

    public String invoiceNotes() {
        return this.optString("invoice_notes");
    }

    public Integer promotionalCredits() {
        return this.reqInteger("promotional_credits");
    }

    public Integer refundableCredits() {
        return this.reqInteger("refundable_credits");
    }

    public Integer excessPayments() {
        return this.reqInteger("excess_payments");
    }

    public JSONObject metaData() {
        return this.optJSONObject("meta_data");
    }

    public static CreateRequest create() throws IOException {
        String uri = Customer.uri("customers");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static CustomerListRequest list() throws IOException {
        String uri = Customer.uri("customers");
        return new CustomerListRequest(uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = Customer.uri("customers", Customer.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static UpdateRequest update(String id) throws IOException {
        String uri = Customer.uri("customers", Customer.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdatePaymentMethodRequest updatePaymentMethod(String id) throws IOException {
        String uri = Customer.uri("customers", Customer.nullCheck(id), "update_payment_method");
        return new UpdatePaymentMethodRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateBillingInfoRequest updateBillingInfo(String id) throws IOException {
        String uri = Customer.uri("customers", Customer.nullCheck(id), "update_billing_info");
        return new UpdateBillingInfoRequest(HttpUtil.Method.POST, uri);
    }

    public static AddContactRequest addContact(String id) throws IOException {
        String uri = Customer.uri("customers", Customer.nullCheck(id), "add_contact");
        return new AddContactRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateContactRequest updateContact(String id) throws IOException {
        String uri = Customer.uri("customers", Customer.nullCheck(id), "update_contact");
        return new UpdateContactRequest(HttpUtil.Method.POST, uri);
    }

    public static DeleteContactRequest deleteContact(String id) throws IOException {
        String uri = Customer.uri("customers", Customer.nullCheck(id), "delete_contact");
        return new DeleteContactRequest(HttpUtil.Method.POST, uri);
    }

    public static AddPromotionalCreditsRequest addPromotionalCredits(String id) throws IOException {
        String uri = Customer.uri("customers", Customer.nullCheck(id), "add_promotional_credits");
        return new AddPromotionalCreditsRequest(HttpUtil.Method.POST, uri);
    }

    public static DeductPromotionalCreditsRequest deductPromotionalCredits(String id) throws IOException {
        String uri = Customer.uri("customers", Customer.nullCheck(id), "deduct_promotional_credits");
        return new DeductPromotionalCreditsRequest(HttpUtil.Method.POST, uri);
    }

    public static SetPromotionalCreditsRequest setPromotionalCredits(String id) throws IOException {
        String uri = Customer.uri("customers", Customer.nullCheck(id), "set_promotional_credits");
        return new SetPromotionalCreditsRequest(HttpUtil.Method.POST, uri);
    }

    public static RecordExcessPaymentRequest recordExcessPayment(String id) throws IOException {
        String uri = Customer.uri("customers", Customer.nullCheck(id), "record_excess_payment");
        return new RecordExcessPaymentRequest(HttpUtil.Method.POST, uri);
    }

    public static DeleteRequest delete(String id) throws IOException {
        String uri = Customer.uri("customers", Customer.nullCheck(id), "delete");
        return new DeleteRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteRequest
    extends Request<DeleteRequest> {
        private DeleteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeleteRequest deletePaymentMethod(Boolean deletePaymentMethod) {
            this.params.addOpt("delete_payment_method", deletePaymentMethod);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecordExcessPaymentRequest
    extends Request<RecordExcessPaymentRequest> {
        private RecordExcessPaymentRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RecordExcessPaymentRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public RecordExcessPaymentRequest transactionAmount(Integer transactionAmount) {
            this.params.add("transaction[amount]", transactionAmount);
            return this;
        }

        public RecordExcessPaymentRequest transactionCurrencyCode(String transactionCurrencyCode) {
            this.params.addOpt("transaction[currency_code]", transactionCurrencyCode);
            return this;
        }

        public RecordExcessPaymentRequest transactionDate(Timestamp transactionDate) {
            this.params.add("transaction[date]", transactionDate);
            return this;
        }

        public RecordExcessPaymentRequest transactionPaymentMethod(com.chargebee.models.enums.PaymentMethod transactionPaymentMethod) {
            this.params.add("transaction[payment_method]", (Object)transactionPaymentMethod);
            return this;
        }

        public RecordExcessPaymentRequest transactionReferenceNumber(String transactionReferenceNumber) {
            this.params.addOpt("transaction[reference_number]", transactionReferenceNumber);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetPromotionalCreditsRequest
    extends Request<SetPromotionalCreditsRequest> {
        private SetPromotionalCreditsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public SetPromotionalCreditsRequest amount(Integer amount) {
            this.params.add("amount", amount);
            return this;
        }

        public SetPromotionalCreditsRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public SetPromotionalCreditsRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeductPromotionalCreditsRequest
    extends Request<DeductPromotionalCreditsRequest> {
        private DeductPromotionalCreditsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeductPromotionalCreditsRequest amount(Integer amount) {
            this.params.add("amount", amount);
            return this;
        }

        public DeductPromotionalCreditsRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public DeductPromotionalCreditsRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddPromotionalCreditsRequest
    extends Request<AddPromotionalCreditsRequest> {
        private AddPromotionalCreditsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddPromotionalCreditsRequest amount(Integer amount) {
            this.params.add("amount", amount);
            return this;
        }

        public AddPromotionalCreditsRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public AddPromotionalCreditsRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteContactRequest
    extends Request<DeleteContactRequest> {
        private DeleteContactRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeleteContactRequest contactId(String contactId) {
            this.params.add("contact[id]", contactId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateContactRequest
    extends Request<UpdateContactRequest> {
        private UpdateContactRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateContactRequest contactId(String contactId) {
            this.params.add("contact[id]", contactId);
            return this;
        }

        public UpdateContactRequest contactFirstName(String contactFirstName) {
            this.params.addOpt("contact[first_name]", contactFirstName);
            return this;
        }

        public UpdateContactRequest contactLastName(String contactLastName) {
            this.params.addOpt("contact[last_name]", contactLastName);
            return this;
        }

        public UpdateContactRequest contactEmail(String contactEmail) {
            this.params.addOpt("contact[email]", contactEmail);
            return this;
        }

        public UpdateContactRequest contactPhone(String contactPhone) {
            this.params.addOpt("contact[phone]", contactPhone);
            return this;
        }

        public UpdateContactRequest contactLabel(String contactLabel) {
            this.params.addOpt("contact[label]", contactLabel);
            return this;
        }

        public UpdateContactRequest contactEnabled(Boolean contactEnabled) {
            this.params.addOpt("contact[enabled]", contactEnabled);
            return this;
        }

        public UpdateContactRequest contactSendBillingEmail(Boolean contactSendBillingEmail) {
            this.params.addOpt("contact[send_billing_email]", contactSendBillingEmail);
            return this;
        }

        public UpdateContactRequest contactSendAccountEmail(Boolean contactSendAccountEmail) {
            this.params.addOpt("contact[send_account_email]", contactSendAccountEmail);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddContactRequest
    extends Request<AddContactRequest> {
        private AddContactRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddContactRequest contactId(String contactId) {
            this.params.addOpt("contact[id]", contactId);
            return this;
        }

        public AddContactRequest contactFirstName(String contactFirstName) {
            this.params.addOpt("contact[first_name]", contactFirstName);
            return this;
        }

        public AddContactRequest contactLastName(String contactLastName) {
            this.params.addOpt("contact[last_name]", contactLastName);
            return this;
        }

        public AddContactRequest contactEmail(String contactEmail) {
            this.params.add("contact[email]", contactEmail);
            return this;
        }

        public AddContactRequest contactPhone(String contactPhone) {
            this.params.addOpt("contact[phone]", contactPhone);
            return this;
        }

        public AddContactRequest contactLabel(String contactLabel) {
            this.params.addOpt("contact[label]", contactLabel);
            return this;
        }

        public AddContactRequest contactEnabled(Boolean contactEnabled) {
            this.params.addOpt("contact[enabled]", contactEnabled);
            return this;
        }

        public AddContactRequest contactSendBillingEmail(Boolean contactSendBillingEmail) {
            this.params.addOpt("contact[send_billing_email]", contactSendBillingEmail);
            return this;
        }

        public AddContactRequest contactSendAccountEmail(Boolean contactSendAccountEmail) {
            this.params.addOpt("contact[send_account_email]", contactSendAccountEmail);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateBillingInfoRequest
    extends Request<UpdateBillingInfoRequest> {
        private UpdateBillingInfoRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateBillingInfoRequest vatNumber(String vatNumber) {
            this.params.addOpt("vat_number", vatNumber);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public UpdateBillingInfoRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdatePaymentMethodRequest
    extends Request<UpdatePaymentMethodRequest> {
        private UpdatePaymentMethodRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdatePaymentMethodRequest paymentMethodType(Type paymentMethodType) {
            this.params.add("payment_method[type]", (Object)paymentMethodType);
            return this;
        }

        public UpdatePaymentMethodRequest paymentMethodGateway(Gateway paymentMethodGateway) {
            this.params.addOpt("payment_method[gateway]", (Object)paymentMethodGateway);
            return this;
        }

        public UpdatePaymentMethodRequest paymentMethodReferenceId(String paymentMethodReferenceId) {
            this.params.addOpt("payment_method[reference_id]", paymentMethodReferenceId);
            return this;
        }

        public UpdatePaymentMethodRequest paymentMethodTmpToken(String paymentMethodTmpToken) {
            this.params.addOpt("payment_method[tmp_token]", paymentMethodTmpToken);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest firstName(String firstName) {
            this.params.addOpt("first_name", firstName);
            return this;
        }

        public UpdateRequest lastName(String lastName) {
            this.params.addOpt("last_name", lastName);
            return this;
        }

        public UpdateRequest email(String email) {
            this.params.addOpt("email", email);
            return this;
        }

        public UpdateRequest phone(String phone) {
            this.params.addOpt("phone", phone);
            return this;
        }

        public UpdateRequest company(String company) {
            this.params.addOpt("company", company);
            return this;
        }

        public UpdateRequest autoCollection(AutoCollection autoCollection) {
            this.params.addOpt("auto_collection", (Object)autoCollection);
            return this;
        }

        public UpdateRequest allowDirectDebit(Boolean allowDirectDebit) {
            this.params.addOpt("allow_direct_debit", allowDirectDebit);
            return this;
        }

        public UpdateRequest taxability(Taxability taxability) {
            this.params.addOpt("taxability", (Object)taxability);
            return this;
        }

        public UpdateRequest entityCode(EntityCode entityCode) {
            this.params.addOpt("entity_code", (Object)entityCode);
            return this;
        }

        public UpdateRequest exemptNumber(String exemptNumber) {
            this.params.addOpt("exempt_number", exemptNumber);
            return this;
        }

        public UpdateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public UpdateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CustomerListRequest
    extends ListRequest<CustomerListRequest> {
        private CustomerListRequest(String uri) {
            super(uri);
        }

        public StringFilter<CustomerListRequest> id() {
            return new StringFilter<CustomerListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<CustomerListRequest> firstName() {
            return new StringFilter<CustomerListRequest>("first_name", this).supportsPresenceOperator(true);
        }

        public StringFilter<CustomerListRequest> lastName() {
            return new StringFilter<CustomerListRequest>("last_name", this).supportsPresenceOperator(true);
        }

        public StringFilter<CustomerListRequest> email() {
            return new StringFilter<CustomerListRequest>("email", this).supportsPresenceOperator(true);
        }

        public StringFilter<CustomerListRequest> company() {
            return new StringFilter<CustomerListRequest>("company", this).supportsPresenceOperator(true);
        }

        public EnumFilter<AutoCollection, CustomerListRequest> autoCollection() {
            return new EnumFilter<AutoCollection, CustomerListRequest>("auto_collection", this);
        }

        public EnumFilter<Taxability, CustomerListRequest> taxability() {
            return new EnumFilter<Taxability, CustomerListRequest>("taxability", this);
        }

        public TimestampFilter<CustomerListRequest> createdAt() {
            return new TimestampFilter<CustomerListRequest>("created_at", this);
        }

        public CustomerListRequest sortByCreatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "created_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CreateRequest firstName(String firstName) {
            this.params.addOpt("first_name", firstName);
            return this;
        }

        public CreateRequest lastName(String lastName) {
            this.params.addOpt("last_name", lastName);
            return this;
        }

        public CreateRequest email(String email) {
            this.params.addOpt("email", email);
            return this;
        }

        public CreateRequest phone(String phone) {
            this.params.addOpt("phone", phone);
            return this;
        }

        public CreateRequest company(String company) {
            this.params.addOpt("company", company);
            return this;
        }

        public CreateRequest autoCollection(AutoCollection autoCollection) {
            this.params.addOpt("auto_collection", (Object)autoCollection);
            return this;
        }

        public CreateRequest allowDirectDebit(Boolean allowDirectDebit) {
            this.params.addOpt("allow_direct_debit", allowDirectDebit);
            return this;
        }

        public CreateRequest vatNumber(String vatNumber) {
            this.params.addOpt("vat_number", vatNumber);
            return this;
        }

        public CreateRequest taxability(Taxability taxability) {
            this.params.addOpt("taxability", (Object)taxability);
            return this;
        }

        public CreateRequest entityCode(EntityCode entityCode) {
            this.params.addOpt("entity_code", (Object)entityCode);
            return this;
        }

        public CreateRequest exemptNumber(String exemptNumber) {
            this.params.addOpt("exempt_number", exemptNumber);
            return this;
        }

        public CreateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        @Deprecated
        public CreateRequest createdFromIp(String createdFromIp) {
            this.params.addOpt("created_from_ip", createdFromIp);
            return this;
        }

        public CreateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public CreateRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CreateRequest cardTmpToken(String cardTmpToken) {
            this.params.addOpt("card[tmp_token]", cardTmpToken);
            return this;
        }

        public CreateRequest paymentMethodType(Type paymentMethodType) {
            this.params.addOpt("payment_method[type]", (Object)paymentMethodType);
            return this;
        }

        public CreateRequest paymentMethodGateway(Gateway paymentMethodGateway) {
            this.params.addOpt("payment_method[gateway]", (Object)paymentMethodGateway);
            return this;
        }

        public CreateRequest paymentMethodReferenceId(String paymentMethodReferenceId) {
            this.params.addOpt("payment_method[reference_id]", paymentMethodReferenceId);
            return this;
        }

        public CreateRequest paymentMethodTmpToken(String paymentMethodTmpToken) {
            this.params.addOpt("payment_method[tmp_token]", paymentMethodTmpToken);
            return this;
        }

        public CreateRequest cardFirstName(String cardFirstName) {
            this.params.addOpt("card[first_name]", cardFirstName);
            return this;
        }

        public CreateRequest cardLastName(String cardLastName) {
            this.params.addOpt("card[last_name]", cardLastName);
            return this;
        }

        public CreateRequest cardNumber(String cardNumber) {
            this.params.addOpt("card[number]", cardNumber);
            return this;
        }

        public CreateRequest cardExpiryMonth(Integer cardExpiryMonth) {
            this.params.addOpt("card[expiry_month]", cardExpiryMonth);
            return this;
        }

        public CreateRequest cardExpiryYear(Integer cardExpiryYear) {
            this.params.addOpt("card[expiry_year]", cardExpiryYear);
            return this;
        }

        public CreateRequest cardCvv(String cardCvv) {
            this.params.addOpt("card[cvv]", cardCvv);
            return this;
        }

        public CreateRequest cardBillingAddr1(String cardBillingAddr1) {
            this.params.addOpt("card[billing_addr1]", cardBillingAddr1);
            return this;
        }

        public CreateRequest cardBillingAddr2(String cardBillingAddr2) {
            this.params.addOpt("card[billing_addr2]", cardBillingAddr2);
            return this;
        }

        public CreateRequest cardBillingCity(String cardBillingCity) {
            this.params.addOpt("card[billing_city]", cardBillingCity);
            return this;
        }

        public CreateRequest cardBillingStateCode(String cardBillingStateCode) {
            this.params.addOpt("card[billing_state_code]", cardBillingStateCode);
            return this;
        }

        public CreateRequest cardBillingState(String cardBillingState) {
            this.params.addOpt("card[billing_state]", cardBillingState);
            return this;
        }

        public CreateRequest cardBillingZip(String cardBillingZip) {
            this.params.addOpt("card[billing_zip]", cardBillingZip);
            return this;
        }

        public CreateRequest cardBillingCountry(String cardBillingCountry) {
            this.params.addOpt("card[billing_country]", cardBillingCountry);
            return this;
        }

        @Deprecated
        public CreateRequest cardIpAddress(String cardIpAddress) {
            this.params.addOpt("card[ip_address]", cardIpAddress);
            return this;
        }

        public CreateRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public CreateRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public CreateRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public CreateRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public CreateRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public CreateRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public CreateRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public CreateRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public CreateRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public CreateRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public CreateRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public CreateRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public CreateRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public CreateRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PaymentMethod
    extends Resource<PaymentMethod> {
        public PaymentMethod(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Type type() {
            return this.reqEnum("type", Type.class);
        }

        public Gateway gateway() {
            return this.reqEnum("gateway", Gateway.class);
        }

        public Status status() {
            return this.reqEnum("status", Status.class);
        }

        public String referenceId() {
            return this.optString("reference_id");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Status {
            VALID,
            EXPIRING,
            EXPIRED,
            INVALID,
            PENDING_VERIFICATION,
            _UNKNOWN;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            CARD,
            PAYPAL_EXPRESS_CHECKOUT,
            AMAZON_PAYMENTS,
            DIRECT_DEBIT,
            _UNKNOWN;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Contact
    extends Resource<Contact> {
        public Contact(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.reqString("email");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String label() {
            return this.optString("label");
        }

        public Boolean enabled() {
            return this.reqBoolean("enabled");
        }

        public Boolean sendAccountEmail() {
            return this.reqBoolean("send_account_email");
        }

        public Boolean sendBillingEmail() {
            return this.reqBoolean("send_billing_email");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BillingAddress
    extends Resource<BillingAddress> {
        public BillingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FraudFlag {
        SAFE,
        SUSPICIOUS,
        FRAUDULENT,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum CardStatus {
        NO_CARD,
        VALID,
        EXPIRING,
        EXPIRED,
        _UNKNOWN;

    }
}

