/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.BooleanFilter;
import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.AutoCollection;
import com.chargebee.models.enums.EntityCode;
import com.chargebee.models.enums.Gateway;
import com.chargebee.models.enums.Taxability;
import com.chargebee.models.enums.Type;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscription
extends Resource<Subscription> {
    public Subscription(String jsonStr) {
        super(jsonStr);
    }

    public Subscription(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public String planId() {
        return this.reqString("plan_id");
    }

    public Integer planQuantity() {
        return this.reqInteger("plan_quantity");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Timestamp startDate() {
        return this.optTimestamp("start_date");
    }

    public Timestamp trialStart() {
        return this.optTimestamp("trial_start");
    }

    public Timestamp trialEnd() {
        return this.optTimestamp("trial_end");
    }

    public Timestamp currentTermStart() {
        return this.optTimestamp("current_term_start");
    }

    public Timestamp currentTermEnd() {
        return this.optTimestamp("current_term_end");
    }

    public Integer remainingBillingCycles() {
        return this.optInteger("remaining_billing_cycles");
    }

    public String poNumber() {
        return this.optString("po_number");
    }

    public Timestamp createdAt() {
        return this.optTimestamp("created_at");
    }

    public Timestamp startedAt() {
        return this.optTimestamp("started_at");
    }

    public Timestamp activatedAt() {
        return this.optTimestamp("activated_at");
    }

    public Timestamp cancelledAt() {
        return this.optTimestamp("cancelled_at");
    }

    public CancelReason cancelReason() {
        return this.optEnum("cancel_reason", CancelReason.class);
    }

    public String affiliateToken() {
        return this.optString("affiliate_token");
    }

    public String createdFromIp() {
        return this.optString("created_from_ip");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Boolean hasScheduledChanges() {
        return this.reqBoolean("has_scheduled_changes");
    }

    public Integer dueInvoicesCount() {
        return this.optInteger("due_invoices_count");
    }

    public Timestamp dueSince() {
        return this.optTimestamp("due_since");
    }

    public Integer totalDues() {
        return this.optInteger("total_dues");
    }

    public List<Addon> addons() {
        return this.optList("addons", Addon.class);
    }

    @Deprecated
    public String coupon() {
        return this.optString("coupon");
    }

    public List<Coupon> coupons() {
        return this.optList("coupons", Coupon.class);
    }

    public ShippingAddress shippingAddress() {
        return this.optSubResource("shipping_address", ShippingAddress.class);
    }

    public String invoiceNotes() {
        return this.optString("invoice_notes");
    }

    public JSONObject metaData() {
        return this.optJSONObject("meta_data");
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public static CreateRequest create() throws IOException {
        String uri = Subscription.uri("subscriptions");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateForCustomerRequest createForCustomer(String id) throws IOException {
        String uri = Subscription.uri("customers", Subscription.nullCheck(id), "subscriptions");
        return new CreateForCustomerRequest(HttpUtil.Method.POST, uri);
    }

    public static SubscriptionListRequest list() throws IOException {
        String uri = Subscription.uri("subscriptions");
        return new SubscriptionListRequest(uri);
    }

    @Deprecated
    public static ListRequest subscriptionsForCustomer(String id) throws IOException {
        String uri = Subscription.uri("customers", Subscription.nullCheck(id), "subscriptions");
        return new ListRequest(uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request retrieveWithScheduledChanges(String id) throws IOException {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "retrieve_with_scheduled_changes");
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request removeScheduledChanges(String id) throws IOException {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "remove_scheduled_changes");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static RemoveScheduledCancellationRequest removeScheduledCancellation(String id) throws IOException {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "remove_scheduled_cancellation");
        return new RemoveScheduledCancellationRequest(HttpUtil.Method.POST, uri);
    }

    public static RemoveCouponsRequest removeCoupons(String id) throws IOException {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "remove_coupons");
        return new RemoveCouponsRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateRequest update(String id) throws IOException {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static ChangeTermEndRequest changeTermEnd(String id) throws IOException {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "change_term_end");
        return new ChangeTermEndRequest(HttpUtil.Method.POST, uri);
    }

    public static CancelRequest cancel(String id) throws IOException {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "cancel");
        return new CancelRequest(HttpUtil.Method.POST, uri);
    }

    public static ReactivateRequest reactivate(String id) throws IOException {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "reactivate");
        return new ReactivateRequest(HttpUtil.Method.POST, uri);
    }

    public static AddChargeAtTermEndRequest addChargeAtTermEnd(String id) throws IOException {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "add_charge_at_term_end");
        return new AddChargeAtTermEndRequest(HttpUtil.Method.POST, uri);
    }

    public static ChargeAddonAtTermEndRequest chargeAddonAtTermEnd(String id) throws IOException {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "charge_addon_at_term_end");
        return new ChargeAddonAtTermEndRequest(HttpUtil.Method.POST, uri);
    }

    public static Request delete(String id) throws IOException {
        String uri = Subscription.uri("subscriptions", Subscription.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChargeAddonAtTermEndRequest
    extends Request<ChargeAddonAtTermEndRequest> {
        private ChargeAddonAtTermEndRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChargeAddonAtTermEndRequest addonId(String addonId) {
            this.params.add("addon_id", addonId);
            return this;
        }

        public ChargeAddonAtTermEndRequest addonQuantity(Integer addonQuantity) {
            this.params.addOpt("addon_quantity", addonQuantity);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddChargeAtTermEndRequest
    extends Request<AddChargeAtTermEndRequest> {
        private AddChargeAtTermEndRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddChargeAtTermEndRequest amount(Integer amount) {
            this.params.add("amount", amount);
            return this;
        }

        public AddChargeAtTermEndRequest description(String description) {
            this.params.add("description", description);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReactivateRequest
    extends Request<ReactivateRequest> {
        private ReactivateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ReactivateRequest trialEnd(Timestamp trialEnd) {
            this.params.addOpt("trial_end", trialEnd);
            return this;
        }

        public ReactivateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        @Deprecated
        public ReactivateRequest trialPeriodDays(Integer trialPeriodDays) {
            this.params.addOpt("trial_period_days", trialPeriodDays);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelRequest
    extends Request<CancelRequest> {
        private CancelRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CancelRequest endOfTerm(Boolean endOfTerm) {
            this.params.addOpt("end_of_term", endOfTerm);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeTermEndRequest
    extends Request<ChangeTermEndRequest> {
        private ChangeTermEndRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChangeTermEndRequest termEndsAt(Timestamp termEndsAt) {
            this.params.add("term_ends_at", termEndsAt);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest planId(String planId) {
            this.params.addOpt("plan_id", planId);
            return this;
        }

        public UpdateRequest planQuantity(Integer planQuantity) {
            this.params.addOpt("plan_quantity", planQuantity);
            return this;
        }

        public UpdateRequest startDate(Timestamp startDate) {
            this.params.addOpt("start_date", startDate);
            return this;
        }

        public UpdateRequest trialEnd(Timestamp trialEnd) {
            this.params.addOpt("trial_end", trialEnd);
            return this;
        }

        public UpdateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public UpdateRequest replaceAddonList(Boolean replaceAddonList) {
            this.params.addOpt("replace_addon_list", replaceAddonList);
            return this;
        }

        public UpdateRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public UpdateRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public UpdateRequest prorate(Boolean prorate) {
            this.params.addOpt("prorate", prorate);
            return this;
        }

        public UpdateRequest endOfTerm(Boolean endOfTerm) {
            this.params.addOpt("end_of_term", endOfTerm);
            return this;
        }

        public UpdateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public UpdateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public UpdateRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public UpdateRequest cardTmpToken(String cardTmpToken) {
            this.params.addOpt("card[tmp_token]", cardTmpToken);
            return this;
        }

        public UpdateRequest paymentMethodType(Type paymentMethodType) {
            this.params.addOpt("payment_method[type]", (Object)paymentMethodType);
            return this;
        }

        public UpdateRequest paymentMethodGateway(Gateway paymentMethodGateway) {
            this.params.addOpt("payment_method[gateway]", (Object)paymentMethodGateway);
            return this;
        }

        public UpdateRequest paymentMethodReferenceId(String paymentMethodReferenceId) {
            this.params.addOpt("payment_method[reference_id]", paymentMethodReferenceId);
            return this;
        }

        public UpdateRequest paymentMethodTmpToken(String paymentMethodTmpToken) {
            this.params.addOpt("payment_method[tmp_token]", paymentMethodTmpToken);
            return this;
        }

        public UpdateRequest cardFirstName(String cardFirstName) {
            this.params.addOpt("card[first_name]", cardFirstName);
            return this;
        }

        public UpdateRequest cardLastName(String cardLastName) {
            this.params.addOpt("card[last_name]", cardLastName);
            return this;
        }

        public UpdateRequest cardNumber(String cardNumber) {
            this.params.addOpt("card[number]", cardNumber);
            return this;
        }

        public UpdateRequest cardExpiryMonth(Integer cardExpiryMonth) {
            this.params.addOpt("card[expiry_month]", cardExpiryMonth);
            return this;
        }

        public UpdateRequest cardExpiryYear(Integer cardExpiryYear) {
            this.params.addOpt("card[expiry_year]", cardExpiryYear);
            return this;
        }

        public UpdateRequest cardCvv(String cardCvv) {
            this.params.addOpt("card[cvv]", cardCvv);
            return this;
        }

        public UpdateRequest cardBillingAddr1(String cardBillingAddr1) {
            this.params.addOpt("card[billing_addr1]", cardBillingAddr1);
            return this;
        }

        public UpdateRequest cardBillingAddr2(String cardBillingAddr2) {
            this.params.addOpt("card[billing_addr2]", cardBillingAddr2);
            return this;
        }

        public UpdateRequest cardBillingCity(String cardBillingCity) {
            this.params.addOpt("card[billing_city]", cardBillingCity);
            return this;
        }

        public UpdateRequest cardBillingStateCode(String cardBillingStateCode) {
            this.params.addOpt("card[billing_state_code]", cardBillingStateCode);
            return this;
        }

        public UpdateRequest cardBillingState(String cardBillingState) {
            this.params.addOpt("card[billing_state]", cardBillingState);
            return this;
        }

        public UpdateRequest cardBillingZip(String cardBillingZip) {
            this.params.addOpt("card[billing_zip]", cardBillingZip);
            return this;
        }

        public UpdateRequest cardBillingCountry(String cardBillingCountry) {
            this.params.addOpt("card[billing_country]", cardBillingCountry);
            return this;
        }

        @Deprecated
        public UpdateRequest cardIpAddress(String cardIpAddress) {
            this.params.addOpt("card[ip_address]", cardIpAddress);
            return this;
        }

        public UpdateRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public UpdateRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public UpdateRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public UpdateRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public UpdateRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public UpdateRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public UpdateRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public UpdateRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public UpdateRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public UpdateRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public UpdateRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public UpdateRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public UpdateRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public UpdateRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public UpdateRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public UpdateRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public UpdateRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public UpdateRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public UpdateRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public UpdateRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public UpdateRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public UpdateRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public UpdateRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public UpdateRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public UpdateRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public UpdateRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public UpdateRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public UpdateRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public UpdateRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public UpdateRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public UpdateRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveCouponsRequest
    extends Request<RemoveCouponsRequest> {
        private RemoveCouponsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RemoveCouponsRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public RemoveCouponsRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveScheduledCancellationRequest
    extends Request<RemoveScheduledCancellationRequest> {
        private RemoveScheduledCancellationRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RemoveScheduledCancellationRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubscriptionListRequest
    extends ListRequest<SubscriptionListRequest> {
        private SubscriptionListRequest(String uri) {
            super(uri);
        }

        public SubscriptionListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        public StringFilter<SubscriptionListRequest> id() {
            return new StringFilter<SubscriptionListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<SubscriptionListRequest> customerId() {
            return new StringFilter<SubscriptionListRequest>("customer_id", this).supportsMultiOperators(true);
        }

        public StringFilter<SubscriptionListRequest> planId() {
            return new StringFilter<SubscriptionListRequest>("plan_id", this).supportsMultiOperators(true);
        }

        public EnumFilter<Status, SubscriptionListRequest> status() {
            return new EnumFilter<Status, SubscriptionListRequest>("status", this);
        }

        public EnumFilter<CancelReason, SubscriptionListRequest> cancelReason() {
            return new EnumFilter("cancel_reason", this).supportsPresenceOperator(true);
        }

        public NumberFilter<Integer, SubscriptionListRequest> remainingBillingCycles() {
            return new NumberFilter("remaining_billing_cycles", this).supportsPresenceOperator(true);
        }

        public TimestampFilter<SubscriptionListRequest> createdAt() {
            return new TimestampFilter<SubscriptionListRequest>("created_at", this);
        }

        public BooleanFilter<SubscriptionListRequest> hasScheduledChanges() {
            return new BooleanFilter<SubscriptionListRequest>("has_scheduled_changes", this);
        }

        public TimestampFilter<SubscriptionListRequest> updatedAt() {
            return new TimestampFilter<SubscriptionListRequest>("updated_at", this);
        }

        public SubscriptionListRequest sortByCreatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "created_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateForCustomerRequest
    extends Request<CreateForCustomerRequest> {
        private CreateForCustomerRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateForCustomerRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CreateForCustomerRequest planId(String planId) {
            this.params.add("plan_id", planId);
            return this;
        }

        public CreateForCustomerRequest planQuantity(Integer planQuantity) {
            this.params.addOpt("plan_quantity", planQuantity);
            return this;
        }

        public CreateForCustomerRequest startDate(Timestamp startDate) {
            this.params.addOpt("start_date", startDate);
            return this;
        }

        public CreateForCustomerRequest trialEnd(Timestamp trialEnd) {
            this.params.addOpt("trial_end", trialEnd);
            return this;
        }

        public CreateForCustomerRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateForCustomerRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CreateForCustomerRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public CreateForCustomerRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public CreateForCustomerRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public CreateForCustomerRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateForCustomerRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateForCustomerRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateForCustomerRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateForCustomerRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateForCustomerRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateForCustomerRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateForCustomerRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateForCustomerRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateForCustomerRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateForCustomerRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateForCustomerRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateForCustomerRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateForCustomerRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateForCustomerRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateForCustomerRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CreateRequest planId(String planId) {
            this.params.add("plan_id", planId);
            return this;
        }

        public CreateRequest planQuantity(Integer planQuantity) {
            this.params.addOpt("plan_quantity", planQuantity);
            return this;
        }

        public CreateRequest startDate(Timestamp startDate) {
            this.params.addOpt("start_date", startDate);
            return this;
        }

        public CreateRequest trialEnd(Timestamp trialEnd) {
            this.params.addOpt("trial_end", trialEnd);
            return this;
        }

        public CreateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CreateRequest poNumber(String poNumber) {
            this.params.addOpt("po_number", poNumber);
            return this;
        }

        public CreateRequest affiliateToken(String affiliateToken) {
            this.params.addOpt("affiliate_token", affiliateToken);
            return this;
        }

        @Deprecated
        public CreateRequest createdFromIp(String createdFromIp) {
            this.params.addOpt("created_from_ip", createdFromIp);
            return this;
        }

        public CreateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public CreateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public CreateRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        public CreateRequest customerEmail(String customerEmail) {
            this.params.addOpt("customer[email]", customerEmail);
            return this;
        }

        public CreateRequest customerFirstName(String customerFirstName) {
            this.params.addOpt("customer[first_name]", customerFirstName);
            return this;
        }

        public CreateRequest customerLastName(String customerLastName) {
            this.params.addOpt("customer[last_name]", customerLastName);
            return this;
        }

        public CreateRequest customerCompany(String customerCompany) {
            this.params.addOpt("customer[company]", customerCompany);
            return this;
        }

        public CreateRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public CreateRequest customerEntityCode(EntityCode customerEntityCode) {
            this.params.addOpt("customer[entity_code]", (Object)customerEntityCode);
            return this;
        }

        public CreateRequest customerExemptNumber(String customerExemptNumber) {
            this.params.addOpt("customer[exempt_number]", customerExemptNumber);
            return this;
        }

        public CreateRequest customerPhone(String customerPhone) {
            this.params.addOpt("customer[phone]", customerPhone);
            return this;
        }

        public CreateRequest customerAutoCollection(AutoCollection customerAutoCollection) {
            this.params.addOpt("customer[auto_collection]", (Object)customerAutoCollection);
            return this;
        }

        public CreateRequest customerAllowDirectDebit(Boolean customerAllowDirectDebit) {
            this.params.addOpt("customer[allow_direct_debit]", customerAllowDirectDebit);
            return this;
        }

        public CreateRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CreateRequest cardTmpToken(String cardTmpToken) {
            this.params.addOpt("card[tmp_token]", cardTmpToken);
            return this;
        }

        public CreateRequest paymentMethodType(Type paymentMethodType) {
            this.params.addOpt("payment_method[type]", (Object)paymentMethodType);
            return this;
        }

        public CreateRequest paymentMethodGateway(Gateway paymentMethodGateway) {
            this.params.addOpt("payment_method[gateway]", (Object)paymentMethodGateway);
            return this;
        }

        public CreateRequest paymentMethodReferenceId(String paymentMethodReferenceId) {
            this.params.addOpt("payment_method[reference_id]", paymentMethodReferenceId);
            return this;
        }

        public CreateRequest cardFirstName(String cardFirstName) {
            this.params.addOpt("card[first_name]", cardFirstName);
            return this;
        }

        public CreateRequest cardLastName(String cardLastName) {
            this.params.addOpt("card[last_name]", cardLastName);
            return this;
        }

        public CreateRequest cardNumber(String cardNumber) {
            this.params.addOpt("card[number]", cardNumber);
            return this;
        }

        public CreateRequest cardExpiryMonth(Integer cardExpiryMonth) {
            this.params.addOpt("card[expiry_month]", cardExpiryMonth);
            return this;
        }

        public CreateRequest cardExpiryYear(Integer cardExpiryYear) {
            this.params.addOpt("card[expiry_year]", cardExpiryYear);
            return this;
        }

        public CreateRequest cardCvv(String cardCvv) {
            this.params.addOpt("card[cvv]", cardCvv);
            return this;
        }

        public CreateRequest cardBillingAddr1(String cardBillingAddr1) {
            this.params.addOpt("card[billing_addr1]", cardBillingAddr1);
            return this;
        }

        public CreateRequest cardBillingAddr2(String cardBillingAddr2) {
            this.params.addOpt("card[billing_addr2]", cardBillingAddr2);
            return this;
        }

        public CreateRequest cardBillingCity(String cardBillingCity) {
            this.params.addOpt("card[billing_city]", cardBillingCity);
            return this;
        }

        public CreateRequest cardBillingStateCode(String cardBillingStateCode) {
            this.params.addOpt("card[billing_state_code]", cardBillingStateCode);
            return this;
        }

        public CreateRequest cardBillingState(String cardBillingState) {
            this.params.addOpt("card[billing_state]", cardBillingState);
            return this;
        }

        public CreateRequest cardBillingZip(String cardBillingZip) {
            this.params.addOpt("card[billing_zip]", cardBillingZip);
            return this;
        }

        public CreateRequest cardBillingCountry(String cardBillingCountry) {
            this.params.addOpt("card[billing_country]", cardBillingCountry);
            return this;
        }

        @Deprecated
        public CreateRequest cardIpAddress(String cardIpAddress) {
            this.params.addOpt("card[ip_address]", cardIpAddress);
            return this;
        }

        public CreateRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public CreateRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public CreateRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public CreateRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public CreateRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public CreateRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public CreateRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public CreateRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public CreateRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public CreateRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public CreateRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public CreateRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public CreateRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public CreateRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public CreateRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CreateRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CreateRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CreateRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CreateRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CreateRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CreateRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public CreateRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShippingAddress
    extends Resource<ShippingAddress> {
        public ShippingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Coupon
    extends Resource<Coupon> {
        public Coupon(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String couponId() {
            return this.reqString("coupon_id");
        }

        public Timestamp applyTill() {
            return this.optTimestamp("apply_till");
        }

        public Integer appliedCount() {
            return this.reqInteger("applied_count");
        }

        public String couponCode() {
            return this.optString("coupon_code");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Addon
    extends Resource<Addon> {
        public Addon(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CancelReason {
        NOT_PAID,
        NO_CARD,
        FRAUD_REVIEW_FAILED,
        NON_COMPLIANT_EU_CUSTOMER,
        TAX_CALCULATION_FAILED,
        CURRENCY_INCOMPATIBLE_WITH_GATEWAY,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        FUTURE,
        IN_TRIAL,
        ACTIVE,
        NON_RENEWING,
        CANCELLED,
        _UNKNOWN;

    }
}

