/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.internal;

import com.chargebee.Environment;
import com.chargebee.Result;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.RequestBase;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request<U extends Request>
extends RequestBase<U> {
    private final HttpUtil.Method httpMeth;

    public Request(HttpUtil.Method httpMeth, String uri) {
        this.uri = uri;
        this.httpMeth = httpMeth;
    }

    public U param(String paramName, Object value) {
        this.params.add(paramName, value);
        return (U)this;
    }

    public final Result request() throws IOException {
        return this.request(Environment.defaultConfig());
    }

    public final Result request(Environment env) throws IOException {
        if (env == null) {
            throw new RuntimeException("Environment cannot be null");
        }
        String url = env.apiBaseUrl() + this.uri;
        switch (this.httpMeth) {
            case GET: {
                return HttpUtil.get(url, this.params(), this.headers, env);
            }
            case POST: {
                return HttpUtil.post(url, this.params(), this.headers, env);
            }
        }
        throw new RuntimeException("Not handled type [" + (Object)((Object)this.httpMeth) + "]");
    }
}

