/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Addon
extends Resource<Addon> {
    public Addon(String jsonStr) {
        super(jsonStr);
    }

    public Addon(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.reqString("name");
    }

    public String invoiceName() {
        return this.optString("invoice_name");
    }

    public String description() {
        return this.optString("description");
    }

    public Type type() {
        return this.reqEnum("type", Type.class);
    }

    public ChargeType chargeType() {
        return this.reqEnum("charge_type", ChargeType.class);
    }

    public Integer price() {
        return this.reqInteger("price");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Integer period() {
        return this.optInteger("period");
    }

    public PeriodUnit periodUnit() {
        return this.reqEnum("period_unit", PeriodUnit.class);
    }

    public String unit() {
        return this.optString("unit");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Timestamp archivedAt() {
        return this.optTimestamp("archived_at");
    }

    public Boolean enabledInPortal() {
        return this.reqBoolean("enabled_in_portal");
    }

    public String taxCode() {
        return this.optString("tax_code");
    }

    public String sku() {
        return this.optString("sku");
    }

    public String accountingCode() {
        return this.optString("accounting_code");
    }

    public String accountingCategory1() {
        return this.optString("accounting_category1");
    }

    public String accountingCategory2() {
        return this.optString("accounting_category2");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public String invoiceNotes() {
        return this.optString("invoice_notes");
    }

    public Boolean taxable() {
        return this.optBoolean("taxable");
    }

    public String taxProfileId() {
        return this.optString("tax_profile_id");
    }

    public JSONObject metaData() {
        return this.optJSONObject("meta_data");
    }

    public static CreateRequest create() throws IOException {
        String uri = Addon.uri("addons");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateRequest update(String id) throws IOException {
        String uri = Addon.uri("addons", Addon.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static AddonListRequest list() throws IOException {
        String uri = Addon.uri("addons");
        return new AddonListRequest(uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = Addon.uri("addons", Addon.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request delete(String id) throws IOException {
        String uri = Addon.uri("addons", Addon.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static CopyRequest copy() throws IOException {
        String uri = Addon.uri("addons", "copy");
        return new CopyRequest(HttpUtil.Method.POST, uri);
    }

    public static Request unarchive(String id) throws IOException {
        String uri = Addon.uri("addons", Addon.nullCheck(id), "unarchive");
        return new Request(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CopyRequest
    extends Request<CopyRequest> {
        private CopyRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CopyRequest fromSite(String fromSite) {
            this.params.add("from_site", fromSite);
            return this;
        }

        public CopyRequest idAtFromSite(String idAtFromSite) {
            this.params.add("id_at_from_site", idAtFromSite);
            return this;
        }

        public CopyRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CopyRequest forSiteMerging(Boolean forSiteMerging) {
            this.params.addOpt("for_site_merging", forSiteMerging);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddonListRequest
    extends ListRequest<AddonListRequest> {
        private AddonListRequest(String uri) {
            super(uri);
        }

        public StringFilter<AddonListRequest> id() {
            return new StringFilter<AddonListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<AddonListRequest> name() {
            return new StringFilter<AddonListRequest>("name", this).supportsMultiOperators(true);
        }

        public EnumFilter<Type, AddonListRequest> type() {
            return new EnumFilter<Type, AddonListRequest>("type", this);
        }

        public EnumFilter<ChargeType, AddonListRequest> chargeType() {
            return new EnumFilter<ChargeType, AddonListRequest>("charge_type", this);
        }

        public NumberFilter<Integer, AddonListRequest> price() {
            return new NumberFilter<Integer, AddonListRequest>("price", this);
        }

        public NumberFilter<Integer, AddonListRequest> period() {
            return new NumberFilter<Integer, AddonListRequest>("period", this);
        }

        public EnumFilter<PeriodUnit, AddonListRequest> periodUnit() {
            return new EnumFilter<PeriodUnit, AddonListRequest>("period_unit", this);
        }

        public EnumFilter<Status, AddonListRequest> status() {
            return new EnumFilter<Status, AddonListRequest>("status", this);
        }

        public TimestampFilter<AddonListRequest> updatedAt() {
            return new TimestampFilter<AddonListRequest>("updated_at", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public UpdateRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public UpdateRequest invoiceName(String invoiceName) {
            this.params.addOpt("invoice_name", invoiceName);
            return this;
        }

        public UpdateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public UpdateRequest chargeType(ChargeType chargeType) {
            this.params.addOpt("charge_type", (Object)chargeType);
            return this;
        }

        public UpdateRequest price(Integer price) {
            this.params.addOpt("price", price);
            return this;
        }

        public UpdateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public UpdateRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public UpdateRequest periodUnit(PeriodUnit periodUnit) {
            this.params.addOpt("period_unit", (Object)periodUnit);
            return this;
        }

        public UpdateRequest type(Type type) {
            this.params.addOpt("type", (Object)type);
            return this;
        }

        public UpdateRequest unit(String unit) {
            this.params.addOpt("unit", unit);
            return this;
        }

        public UpdateRequest enabledInPortal(Boolean enabledInPortal) {
            this.params.addOpt("enabled_in_portal", enabledInPortal);
            return this;
        }

        public UpdateRequest taxable(Boolean taxable) {
            this.params.addOpt("taxable", taxable);
            return this;
        }

        public UpdateRequest taxProfileId(String taxProfileId) {
            this.params.addOpt("tax_profile_id", taxProfileId);
            return this;
        }

        public UpdateRequest taxCode(String taxCode) {
            this.params.addOpt("tax_code", taxCode);
            return this;
        }

        public UpdateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public UpdateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public UpdateRequest sku(String sku) {
            this.params.addOpt("sku", sku);
            return this;
        }

        public UpdateRequest accountingCode(String accountingCode) {
            this.params.addOpt("accounting_code", accountingCode);
            return this;
        }

        public UpdateRequest accountingCategory1(String accountingCategory1) {
            this.params.addOpt("accounting_category1", accountingCategory1);
            return this;
        }

        public UpdateRequest accountingCategory2(String accountingCategory2) {
            this.params.addOpt("accounting_category2", accountingCategory2);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public CreateRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateRequest invoiceName(String invoiceName) {
            this.params.addOpt("invoice_name", invoiceName);
            return this;
        }

        public CreateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public CreateRequest chargeType(ChargeType chargeType) {
            this.params.add("charge_type", (Object)chargeType);
            return this;
        }

        public CreateRequest price(Integer price) {
            this.params.addOpt("price", price);
            return this;
        }

        public CreateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public CreateRequest periodUnit(PeriodUnit periodUnit) {
            this.params.addOpt("period_unit", (Object)periodUnit);
            return this;
        }

        public CreateRequest type(Type type) {
            this.params.add("type", (Object)type);
            return this;
        }

        public CreateRequest unit(String unit) {
            this.params.addOpt("unit", unit);
            return this;
        }

        public CreateRequest enabledInPortal(Boolean enabledInPortal) {
            this.params.addOpt("enabled_in_portal", enabledInPortal);
            return this;
        }

        public CreateRequest taxable(Boolean taxable) {
            this.params.addOpt("taxable", taxable);
            return this;
        }

        public CreateRequest taxProfileId(String taxProfileId) {
            this.params.addOpt("tax_profile_id", taxProfileId);
            return this;
        }

        public CreateRequest taxCode(String taxCode) {
            this.params.addOpt("tax_code", taxCode);
            return this;
        }

        public CreateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public CreateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        public CreateRequest sku(String sku) {
            this.params.addOpt("sku", sku);
            return this;
        }

        public CreateRequest accountingCode(String accountingCode) {
            this.params.addOpt("accounting_code", accountingCode);
            return this;
        }

        public CreateRequest accountingCategory1(String accountingCategory1) {
            this.params.addOpt("accounting_category1", accountingCategory1);
            return this;
        }

        public CreateRequest accountingCategory2(String accountingCategory2) {
            this.params.addOpt("accounting_category2", accountingCategory2);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ACTIVE,
        ARCHIVED,
        DELETED,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PeriodUnit {
        WEEK,
        MONTH,
        YEAR,
        NOT_APPLICABLE,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChargeType {
        RECURRING,
        NON_RECURRING,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ON_OFF,
        QUANTITY,
        _UNKNOWN;

    }
}

