/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plan
extends Resource<Plan> {
    public Plan(String jsonStr) {
        super(jsonStr);
    }

    public Plan(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String name() {
        return this.reqString("name");
    }

    public String invoiceName() {
        return this.optString("invoice_name");
    }

    public String description() {
        return this.optString("description");
    }

    public Integer price() {
        return this.reqInteger("price");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Integer period() {
        return this.reqInteger("period");
    }

    public PeriodUnit periodUnit() {
        return this.reqEnum("period_unit", PeriodUnit.class);
    }

    public Integer trialPeriod() {
        return this.optInteger("trial_period");
    }

    public TrialPeriodUnit trialPeriodUnit() {
        return this.optEnum("trial_period_unit", TrialPeriodUnit.class);
    }

    public ChargeModel chargeModel() {
        return this.reqEnum("charge_model", ChargeModel.class);
    }

    public Integer freeQuantity() {
        return this.reqInteger("free_quantity");
    }

    public Integer setupCost() {
        return this.optInteger("setup_cost");
    }

    @Deprecated
    public Double downgradePenalty() {
        return this.optDouble("downgrade_penalty");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public Timestamp archivedAt() {
        return this.optTimestamp("archived_at");
    }

    public Integer billingCycles() {
        return this.optInteger("billing_cycles");
    }

    public String redirectUrl() {
        return this.optString("redirect_url");
    }

    public Boolean enabledInHostedPages() {
        return this.reqBoolean("enabled_in_hosted_pages");
    }

    public Boolean enabledInPortal() {
        return this.reqBoolean("enabled_in_portal");
    }

    public String taxCode() {
        return this.optString("tax_code");
    }

    public String sku() {
        return this.optString("sku");
    }

    public String accountingCode() {
        return this.optString("accounting_code");
    }

    public String accountingCategory1() {
        return this.optString("accounting_category1");
    }

    public String accountingCategory2() {
        return this.optString("accounting_category2");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public String invoiceNotes() {
        return this.optString("invoice_notes");
    }

    public Boolean taxable() {
        return this.optBoolean("taxable");
    }

    public String taxProfileId() {
        return this.optString("tax_profile_id");
    }

    public JSONObject metaData() {
        return this.optJSONObject("meta_data");
    }

    public static CreateRequest create() throws IOException {
        String uri = Plan.uri("plans");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdateRequest update(String id) throws IOException {
        String uri = Plan.uri("plans", Plan.nullCheck(id));
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    public static PlanListRequest list() throws IOException {
        String uri = Plan.uri("plans");
        return new PlanListRequest(uri);
    }

    public static Request retrieve(String id) throws IOException {
        String uri = Plan.uri("plans", Plan.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static Request delete(String id) throws IOException {
        String uri = Plan.uri("plans", Plan.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static CopyRequest copy() throws IOException {
        String uri = Plan.uri("plans", "copy");
        return new CopyRequest(HttpUtil.Method.POST, uri);
    }

    public static Request unarchive(String id) throws IOException {
        String uri = Plan.uri("plans", Plan.nullCheck(id), "unarchive");
        return new Request(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CopyRequest
    extends Request<CopyRequest> {
        private CopyRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CopyRequest fromSite(String fromSite) {
            this.params.add("from_site", fromSite);
            return this;
        }

        public CopyRequest idAtFromSite(String idAtFromSite) {
            this.params.add("id_at_from_site", idAtFromSite);
            return this;
        }

        public CopyRequest id(String id) {
            this.params.addOpt("id", id);
            return this;
        }

        public CopyRequest forSiteMerging(Boolean forSiteMerging) {
            this.params.addOpt("for_site_merging", forSiteMerging);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlanListRequest
    extends ListRequest<PlanListRequest> {
        private PlanListRequest(String uri) {
            super(uri);
        }

        public StringFilter<PlanListRequest> id() {
            return new StringFilter<PlanListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<PlanListRequest> name() {
            return new StringFilter<PlanListRequest>("name", this).supportsMultiOperators(true);
        }

        public NumberFilter<Integer, PlanListRequest> price() {
            return new NumberFilter<Integer, PlanListRequest>("price", this);
        }

        public NumberFilter<Integer, PlanListRequest> period() {
            return new NumberFilter<Integer, PlanListRequest>("period", this);
        }

        public EnumFilter<PeriodUnit, PlanListRequest> periodUnit() {
            return new EnumFilter<PeriodUnit, PlanListRequest>("period_unit", this);
        }

        public NumberFilter<Integer, PlanListRequest> trialPeriod() {
            return new NumberFilter("trial_period", this).supportsPresenceOperator(true);
        }

        public EnumFilter<TrialPeriodUnit, PlanListRequest> trialPeriodUnit() {
            return new EnumFilter<TrialPeriodUnit, PlanListRequest>("trial_period_unit", this);
        }

        public EnumFilter<ChargeModel, PlanListRequest> chargeModel() {
            return new EnumFilter<ChargeModel, PlanListRequest>("charge_model", this);
        }

        public EnumFilter<Status, PlanListRequest> status() {
            return new EnumFilter<Status, PlanListRequest>("status", this);
        }

        public TimestampFilter<PlanListRequest> updatedAt() {
            return new TimestampFilter<PlanListRequest>("updated_at", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest name(String name) {
            this.params.addOpt("name", name);
            return this;
        }

        public UpdateRequest invoiceName(String invoiceName) {
            this.params.addOpt("invoice_name", invoiceName);
            return this;
        }

        public UpdateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public UpdateRequest trialPeriod(Integer trialPeriod) {
            this.params.addOpt("trial_period", trialPeriod);
            return this;
        }

        public UpdateRequest trialPeriodUnit(TrialPeriodUnit trialPeriodUnit) {
            this.params.addOpt("trial_period_unit", (Object)trialPeriodUnit);
            return this;
        }

        public UpdateRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public UpdateRequest periodUnit(PeriodUnit periodUnit) {
            this.params.addOpt("period_unit", (Object)periodUnit);
            return this;
        }

        public UpdateRequest setupCost(Integer setupCost) {
            this.params.addOpt("setup_cost", setupCost);
            return this;
        }

        public UpdateRequest price(Integer price) {
            this.params.addOpt("price", price);
            return this;
        }

        public UpdateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public UpdateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public UpdateRequest chargeModel(ChargeModel chargeModel) {
            this.params.addOpt("charge_model", (Object)chargeModel);
            return this;
        }

        public UpdateRequest freeQuantity(Integer freeQuantity) {
            this.params.addOpt("free_quantity", freeQuantity);
            return this;
        }

        @Deprecated
        public UpdateRequest downgradePenalty(Double downgradePenalty) {
            this.params.addOpt("downgrade_penalty", downgradePenalty);
            return this;
        }

        public UpdateRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public UpdateRequest enabledInHostedPages(Boolean enabledInHostedPages) {
            this.params.addOpt("enabled_in_hosted_pages", enabledInHostedPages);
            return this;
        }

        public UpdateRequest enabledInPortal(Boolean enabledInPortal) {
            this.params.addOpt("enabled_in_portal", enabledInPortal);
            return this;
        }

        public UpdateRequest taxable(Boolean taxable) {
            this.params.addOpt("taxable", taxable);
            return this;
        }

        public UpdateRequest taxProfileId(String taxProfileId) {
            this.params.addOpt("tax_profile_id", taxProfileId);
            return this;
        }

        public UpdateRequest taxCode(String taxCode) {
            this.params.addOpt("tax_code", taxCode);
            return this;
        }

        public UpdateRequest sku(String sku) {
            this.params.addOpt("sku", sku);
            return this;
        }

        public UpdateRequest accountingCode(String accountingCode) {
            this.params.addOpt("accounting_code", accountingCode);
            return this;
        }

        public UpdateRequest accountingCategory1(String accountingCategory1) {
            this.params.addOpt("accounting_category1", accountingCategory1);
            return this;
        }

        public UpdateRequest accountingCategory2(String accountingCategory2) {
            this.params.addOpt("accounting_category2", accountingCategory2);
            return this;
        }

        public UpdateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public UpdateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public CreateRequest name(String name) {
            this.params.add("name", name);
            return this;
        }

        public CreateRequest invoiceName(String invoiceName) {
            this.params.addOpt("invoice_name", invoiceName);
            return this;
        }

        public CreateRequest description(String description) {
            this.params.addOpt("description", description);
            return this;
        }

        public CreateRequest trialPeriod(Integer trialPeriod) {
            this.params.addOpt("trial_period", trialPeriod);
            return this;
        }

        public CreateRequest trialPeriodUnit(TrialPeriodUnit trialPeriodUnit) {
            this.params.addOpt("trial_period_unit", (Object)trialPeriodUnit);
            return this;
        }

        public CreateRequest period(Integer period) {
            this.params.addOpt("period", period);
            return this;
        }

        public CreateRequest periodUnit(PeriodUnit periodUnit) {
            this.params.addOpt("period_unit", (Object)periodUnit);
            return this;
        }

        public CreateRequest setupCost(Integer setupCost) {
            this.params.addOpt("setup_cost", setupCost);
            return this;
        }

        public CreateRequest price(Integer price) {
            this.params.addOpt("price", price);
            return this;
        }

        public CreateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateRequest chargeModel(ChargeModel chargeModel) {
            this.params.addOpt("charge_model", (Object)chargeModel);
            return this;
        }

        public CreateRequest freeQuantity(Integer freeQuantity) {
            this.params.addOpt("free_quantity", freeQuantity);
            return this;
        }

        @Deprecated
        public CreateRequest downgradePenalty(Double downgradePenalty) {
            this.params.addOpt("downgrade_penalty", downgradePenalty);
            return this;
        }

        public CreateRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CreateRequest enabledInHostedPages(Boolean enabledInHostedPages) {
            this.params.addOpt("enabled_in_hosted_pages", enabledInHostedPages);
            return this;
        }

        public CreateRequest enabledInPortal(Boolean enabledInPortal) {
            this.params.addOpt("enabled_in_portal", enabledInPortal);
            return this;
        }

        public CreateRequest taxable(Boolean taxable) {
            this.params.addOpt("taxable", taxable);
            return this;
        }

        public CreateRequest taxProfileId(String taxProfileId) {
            this.params.addOpt("tax_profile_id", taxProfileId);
            return this;
        }

        public CreateRequest taxCode(String taxCode) {
            this.params.addOpt("tax_code", taxCode);
            return this;
        }

        public CreateRequest sku(String sku) {
            this.params.addOpt("sku", sku);
            return this;
        }

        public CreateRequest accountingCode(String accountingCode) {
            this.params.addOpt("accounting_code", accountingCode);
            return this;
        }

        public CreateRequest accountingCategory1(String accountingCategory1) {
            this.params.addOpt("accounting_category1", accountingCategory1);
            return this;
        }

        public CreateRequest accountingCategory2(String accountingCategory2) {
            this.params.addOpt("accounting_category2", accountingCategory2);
            return this;
        }

        public CreateRequest invoiceNotes(String invoiceNotes) {
            this.params.addOpt("invoice_notes", invoiceNotes);
            return this;
        }

        public CreateRequest metaData(JSONObject metaData) {
            this.params.addOpt("meta_data", metaData);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ACTIVE,
        ARCHIVED,
        DELETED,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChargeModel {
        FLAT_FEE,
        PER_UNIT,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TrialPeriodUnit {
        DAY,
        MONTH,
        _UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PeriodUnit {
        WEEK,
        MONTH,
        YEAR,
        _UNKNOWN;

    }
}

