/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.internal;

import com.chargebee.Environment;
import com.chargebee.ListResult;
import com.chargebee.RequestWrap;
import com.chargebee.filters.BooleanFilter;
import com.chargebee.filters.DateFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.RequestBase;
import java.io.IOException;
import java.util.Date;

public class ListRequest<U extends ListRequest>
extends RequestBase<U> {
    public ListRequest(String uri) {
        this.uri = uri;
    }

    public U limit(int limit) {
        this.params.addOpt("limit", limit);
        return (U)this;
    }

    public U offset(String offset) {
        this.params.addOpt("offset", offset);
        return (U)this;
    }

    public StringFilter<U> stringFilterParam(String paramName) {
        return new StringFilter<ListRequest>(paramName, this).supportsPresenceOperator(true).supportsMultiOperators(true);
    }

    public BooleanFilter<U> booleanFilterParam(String paramName) {
        return new BooleanFilter<ListRequest>(paramName, this).supportsPresenceOperator(true);
    }

    public NumberFilter<Long, U> longFilterParam(String paramName) {
        return new NumberFilter(paramName, this).supportsPresenceOperator(true);
    }

    public TimestampFilter<U> timestampFilterParam(String paramName) {
        return new TimestampFilter<ListRequest>(paramName, this).supportsPresenceOperator(true);
    }

    public DateFilter<Date, U> dateFilterParam(String paramName) {
        return new DateFilter(paramName, this).supportsPresenceOperator(true);
    }

    public final ListResult request() throws Exception {
        return this.request(Environment.defaultConfig());
    }

    public final ListResult request(Environment env) throws IOException, Exception {
        RequestWrap<ListRequest> c = new RequestWrap<ListRequest>(env, this){

            @Override
            public ListResult call() throws Exception {
                return ListRequest._request(this.env, (ListRequest)this.request);
            }
        };
        return (ListResult)(env.reqInterceptor() != null ? env.reqInterceptor().handleRequest((RequestWrap<? extends RequestBase>)c) : c.call());
    }

    private static ListResult _request(Environment env, ListRequest req) throws IOException {
        if (env == null) {
            throw new RuntimeException("Environment cannot be null");
        }
        String url = env.apiBaseUrl() + req.uri;
        return HttpUtil.getList(url, req.params(), req.headers, env);
    }

    @Override
    public Params params() {
        return this.params;
    }
}

