/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.NumberFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.Invoice;
import com.chargebee.models.Transaction;
import com.chargebee.models.enums.Channel;
import com.chargebee.models.enums.DispositionType;
import com.chargebee.models.enums.PaymentMethod;
import com.chargebee.models.enums.PriceType;
import com.chargebee.models.enums.PricingModel;
import com.chargebee.models.enums.TaxExemptReason;
import com.chargebee.models.enums.TaxJurisType;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class CreditNote
extends Resource<CreditNote> {
    public CreditNote(String jsonStr) {
        super(jsonStr);
    }

    public CreditNote(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String customerId() {
        return this.reqString("customer_id");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public String referenceInvoiceId() {
        return this.reqString("reference_invoice_id");
    }

    public Type type() {
        return this.reqEnum("type", Type.class);
    }

    public ReasonCode reasonCode() {
        return this.optEnum("reason_code", ReasonCode.class);
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public String vatNumber() {
        return this.optString("vat_number");
    }

    public Timestamp date() {
        return this.optTimestamp("date");
    }

    public PriceType priceType() {
        return this.reqEnum("price_type", PriceType.class);
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Integer total() {
        return this.optInteger("total");
    }

    public Integer amountAllocated() {
        return this.optInteger("amount_allocated");
    }

    public Integer amountRefunded() {
        return this.optInteger("amount_refunded");
    }

    public Integer amountAvailable() {
        return this.optInteger("amount_available");
    }

    public Timestamp refundedAt() {
        return this.optTimestamp("refunded_at");
    }

    public Timestamp voidedAt() {
        return this.optTimestamp("voided_at");
    }

    public Timestamp generatedAt() {
        return this.optTimestamp("generated_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Channel channel() {
        return this.optEnum("channel", Channel.class);
    }

    public Einvoice einvoice() {
        return this.optSubResource("einvoice", Einvoice.class);
    }

    public Integer subTotal() {
        return this.reqInteger("sub_total");
    }

    public Integer subTotalInLocalCurrency() {
        return this.optInteger("sub_total_in_local_currency");
    }

    public Integer totalInLocalCurrency() {
        return this.optInteger("total_in_local_currency");
    }

    public String localCurrencyCode() {
        return this.optString("local_currency_code");
    }

    public Integer roundOffAmount() {
        return this.optInteger("round_off_amount");
    }

    public Integer fractionalCorrection() {
        return this.optInteger("fractional_correction");
    }

    public List<LineItem> lineItems() {
        return this.optList("line_items", LineItem.class);
    }

    public List<Discount> discounts() {
        return this.optList("discounts", Discount.class);
    }

    public List<LineItemDiscount> lineItemDiscounts() {
        return this.optList("line_item_discounts", LineItemDiscount.class);
    }

    public List<LineItemTier> lineItemTiers() {
        return this.optList("line_item_tiers", LineItemTier.class);
    }

    public List<Tax> taxes() {
        return this.optList("taxes", Tax.class);
    }

    public List<LineItemTax> lineItemTaxes() {
        return this.optList("line_item_taxes", LineItemTax.class);
    }

    public List<LinkedRefund> linkedRefunds() {
        return this.optList("linked_refunds", LinkedRefund.class);
    }

    public List<Allocation> allocations() {
        return this.optList("allocations", Allocation.class);
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public String createReasonCode() {
        return this.optString("create_reason_code");
    }

    public String vatNumberPrefix() {
        return this.optString("vat_number_prefix");
    }

    public String businessEntityId() {
        return this.reqString("business_entity_id");
    }

    public ShippingAddress shippingAddress() {
        return this.optSubResource("shipping_address", ShippingAddress.class);
    }

    public BillingAddress billingAddress() {
        return this.optSubResource("billing_address", BillingAddress.class);
    }

    public static CreateRequest create() {
        String uri = CreditNote.uri("credit_notes");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static PdfRequest pdf(String id) {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "pdf");
        return new PdfRequest(HttpUtil.Method.POST, uri);
    }

    public static Request downloadEinvoice(String id) {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "download_einvoice");
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static RefundRequest refund(String id) {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "refund");
        return new RefundRequest(HttpUtil.Method.POST, uri);
    }

    public static RecordRefundRequest recordRefund(String id) {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "record_refund");
        return new RecordRefundRequest(HttpUtil.Method.POST, uri);
    }

    public static VoidCreditNoteRequest voidCreditNote(String id) {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "void");
        return new VoidCreditNoteRequest(HttpUtil.Method.POST, uri);
    }

    public static CreditNoteListRequest list() {
        String uri = CreditNote.uri("credit_notes");
        return new CreditNoteListRequest(uri);
    }

    @Deprecated
    public static ListRequest creditNotesForCustomer(String id) {
        String uri = CreditNote.uri("customers", CreditNote.nullCheck(id), "credit_notes");
        return new ListRequest(uri);
    }

    public static DeleteRequest delete(String id) {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "delete");
        return new DeleteRequest(HttpUtil.Method.POST, uri);
    }

    public static RemoveTaxWithheldRefundRequest removeTaxWithheldRefund(String id) {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "remove_tax_withheld_refund");
        return new RemoveTaxWithheldRefundRequest(HttpUtil.Method.POST, uri);
    }

    public static Request resendEinvoice(String id) {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "resend_einvoice");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static Request sendEinvoice(String id) {
        String uri = CreditNote.uri("credit_notes", CreditNote.nullCheck(id), "send_einvoice");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static ImportCreditNoteRequest importCreditNote() {
        String uri = CreditNote.uri("credit_notes", "import_credit_note");
        return new ImportCreditNoteRequest(HttpUtil.Method.POST, uri);
    }

    public static class ImportCreditNoteRequest
    extends Request<ImportCreditNoteRequest> {
        private ImportCreditNoteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ImportCreditNoteRequest id(String id) {
            this.params.add("id", id);
            return this;
        }

        public ImportCreditNoteRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        public ImportCreditNoteRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public ImportCreditNoteRequest referenceInvoiceId(String referenceInvoiceId) {
            this.params.add("reference_invoice_id", referenceInvoiceId);
            return this;
        }

        public ImportCreditNoteRequest type(Type type) {
            this.params.add("type", (Object)type);
            return this;
        }

        public ImportCreditNoteRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public ImportCreditNoteRequest createReasonCode(String createReasonCode) {
            this.params.add("create_reason_code", createReasonCode);
            return this;
        }

        public ImportCreditNoteRequest date(Timestamp date) {
            this.params.addOpt("date", date);
            return this;
        }

        public ImportCreditNoteRequest status(Status status) {
            this.params.addOpt("status", (Object)status);
            return this;
        }

        public ImportCreditNoteRequest total(Integer total) {
            this.params.addOpt("total", total);
            return this;
        }

        public ImportCreditNoteRequest refundedAt(Timestamp refundedAt) {
            this.params.addOpt("refunded_at", refundedAt);
            return this;
        }

        public ImportCreditNoteRequest voidedAt(Timestamp voidedAt) {
            this.params.addOpt("voided_at", voidedAt);
            return this;
        }

        public ImportCreditNoteRequest subTotal(Integer subTotal) {
            this.params.addOpt("sub_total", subTotal);
            return this;
        }

        public ImportCreditNoteRequest roundOffAmount(Integer roundOffAmount) {
            this.params.addOpt("round_off_amount", roundOffAmount);
            return this;
        }

        public ImportCreditNoteRequest fractionalCorrection(Integer fractionalCorrection) {
            this.params.addOpt("fractional_correction", fractionalCorrection);
            return this;
        }

        public ImportCreditNoteRequest vatNumberPrefix(String vatNumberPrefix) {
            this.params.addOpt("vat_number_prefix", vatNumberPrefix);
            return this;
        }

        public ImportCreditNoteRequest lineItemReferenceLineItemId(int index, String lineItemReferenceLineItemId) {
            this.params.addOpt("line_items[reference_line_item_id][" + index + "]", lineItemReferenceLineItemId);
            return this;
        }

        public ImportCreditNoteRequest lineItemId(int index, String lineItemId) {
            this.params.addOpt("line_items[id][" + index + "]", lineItemId);
            return this;
        }

        public ImportCreditNoteRequest lineItemDateFrom(int index, Timestamp lineItemDateFrom) {
            this.params.addOpt("line_items[date_from][" + index + "]", lineItemDateFrom);
            return this;
        }

        public ImportCreditNoteRequest lineItemDateTo(int index, Timestamp lineItemDateTo) {
            this.params.addOpt("line_items[date_to][" + index + "]", lineItemDateTo);
            return this;
        }

        public ImportCreditNoteRequest lineItemSubscriptionId(int index, String lineItemSubscriptionId) {
            this.params.addOpt("line_items[subscription_id][" + index + "]", lineItemSubscriptionId);
            return this;
        }

        public ImportCreditNoteRequest lineItemDescription(int index, String lineItemDescription) {
            this.params.add("line_items[description][" + index + "]", lineItemDescription);
            return this;
        }

        public ImportCreditNoteRequest lineItemUnitAmount(int index, Integer lineItemUnitAmount) {
            this.params.addOpt("line_items[unit_amount][" + index + "]", lineItemUnitAmount);
            return this;
        }

        public ImportCreditNoteRequest lineItemQuantity(int index, Integer lineItemQuantity) {
            this.params.addOpt("line_items[quantity][" + index + "]", lineItemQuantity);
            return this;
        }

        public ImportCreditNoteRequest lineItemAmount(int index, Integer lineItemAmount) {
            this.params.addOpt("line_items[amount][" + index + "]", lineItemAmount);
            return this;
        }

        public ImportCreditNoteRequest lineItemUnitAmountInDecimal(int index, String lineItemUnitAmountInDecimal) {
            this.params.addOpt("line_items[unit_amount_in_decimal][" + index + "]", lineItemUnitAmountInDecimal);
            return this;
        }

        public ImportCreditNoteRequest lineItemQuantityInDecimal(int index, String lineItemQuantityInDecimal) {
            this.params.addOpt("line_items[quantity_in_decimal][" + index + "]", lineItemQuantityInDecimal);
            return this;
        }

        public ImportCreditNoteRequest lineItemAmountInDecimal(int index, String lineItemAmountInDecimal) {
            this.params.addOpt("line_items[amount_in_decimal][" + index + "]", lineItemAmountInDecimal);
            return this;
        }

        public ImportCreditNoteRequest lineItemEntityType(int index, LineItem.EntityType lineItemEntityType) {
            this.params.addOpt("line_items[entity_type][" + index + "]", (Object)lineItemEntityType);
            return this;
        }

        public ImportCreditNoteRequest lineItemEntityId(int index, String lineItemEntityId) {
            this.params.addOpt("line_items[entity_id][" + index + "]", lineItemEntityId);
            return this;
        }

        public ImportCreditNoteRequest lineItemItemLevelDiscount1EntityId(int index, String lineItemItemLevelDiscount1EntityId) {
            this.params.addOpt("line_items[item_level_discount1_entity_id][" + index + "]", lineItemItemLevelDiscount1EntityId);
            return this;
        }

        public ImportCreditNoteRequest lineItemItemLevelDiscount1Amount(int index, Integer lineItemItemLevelDiscount1Amount) {
            this.params.addOpt("line_items[item_level_discount1_amount][" + index + "]", lineItemItemLevelDiscount1Amount);
            return this;
        }

        public ImportCreditNoteRequest lineItemItemLevelDiscount2EntityId(int index, String lineItemItemLevelDiscount2EntityId) {
            this.params.addOpt("line_items[item_level_discount2_entity_id][" + index + "]", lineItemItemLevelDiscount2EntityId);
            return this;
        }

        public ImportCreditNoteRequest lineItemItemLevelDiscount2Amount(int index, Integer lineItemItemLevelDiscount2Amount) {
            this.params.addOpt("line_items[item_level_discount2_amount][" + index + "]", lineItemItemLevelDiscount2Amount);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax1Name(int index, String lineItemTax1Name) {
            this.params.addOpt("line_items[tax1_name][" + index + "]", lineItemTax1Name);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax1Amount(int index, Integer lineItemTax1Amount) {
            this.params.addOpt("line_items[tax1_amount][" + index + "]", lineItemTax1Amount);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax2Name(int index, String lineItemTax2Name) {
            this.params.addOpt("line_items[tax2_name][" + index + "]", lineItemTax2Name);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax2Amount(int index, Integer lineItemTax2Amount) {
            this.params.addOpt("line_items[tax2_amount][" + index + "]", lineItemTax2Amount);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax3Name(int index, String lineItemTax3Name) {
            this.params.addOpt("line_items[tax3_name][" + index + "]", lineItemTax3Name);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax3Amount(int index, Integer lineItemTax3Amount) {
            this.params.addOpt("line_items[tax3_amount][" + index + "]", lineItemTax3Amount);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax4Name(int index, String lineItemTax4Name) {
            this.params.addOpt("line_items[tax4_name][" + index + "]", lineItemTax4Name);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax4Amount(int index, Integer lineItemTax4Amount) {
            this.params.addOpt("line_items[tax4_amount][" + index + "]", lineItemTax4Amount);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax5Name(int index, String lineItemTax5Name) {
            this.params.addOpt("line_items[tax5_name][" + index + "]", lineItemTax5Name);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax5Amount(int index, Integer lineItemTax5Amount) {
            this.params.addOpt("line_items[tax5_amount][" + index + "]", lineItemTax5Amount);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax6Name(int index, String lineItemTax6Name) {
            this.params.addOpt("line_items[tax6_name][" + index + "]", lineItemTax6Name);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax6Amount(int index, Integer lineItemTax6Amount) {
            this.params.addOpt("line_items[tax6_amount][" + index + "]", lineItemTax6Amount);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax7Name(int index, String lineItemTax7Name) {
            this.params.addOpt("line_items[tax7_name][" + index + "]", lineItemTax7Name);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax7Amount(int index, Integer lineItemTax7Amount) {
            this.params.addOpt("line_items[tax7_amount][" + index + "]", lineItemTax7Amount);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax8Name(int index, String lineItemTax8Name) {
            this.params.addOpt("line_items[tax8_name][" + index + "]", lineItemTax8Name);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax8Amount(int index, Integer lineItemTax8Amount) {
            this.params.addOpt("line_items[tax8_amount][" + index + "]", lineItemTax8Amount);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax9Name(int index, String lineItemTax9Name) {
            this.params.addOpt("line_items[tax9_name][" + index + "]", lineItemTax9Name);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax9Amount(int index, Integer lineItemTax9Amount) {
            this.params.addOpt("line_items[tax9_amount][" + index + "]", lineItemTax9Amount);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax10Name(int index, String lineItemTax10Name) {
            this.params.addOpt("line_items[tax10_name][" + index + "]", lineItemTax10Name);
            return this;
        }

        public ImportCreditNoteRequest lineItemTax10Amount(int index, Integer lineItemTax10Amount) {
            this.params.addOpt("line_items[tax10_amount][" + index + "]", lineItemTax10Amount);
            return this;
        }

        public ImportCreditNoteRequest lineItemTierLineItemId(int index, String lineItemTierLineItemId) {
            this.params.add("line_item_tiers[line_item_id][" + index + "]", lineItemTierLineItemId);
            return this;
        }

        public ImportCreditNoteRequest lineItemTierStartingUnit(int index, Integer lineItemTierStartingUnit) {
            this.params.addOpt("line_item_tiers[starting_unit][" + index + "]", lineItemTierStartingUnit);
            return this;
        }

        public ImportCreditNoteRequest lineItemTierEndingUnit(int index, Integer lineItemTierEndingUnit) {
            this.params.addOpt("line_item_tiers[ending_unit][" + index + "]", lineItemTierEndingUnit);
            return this;
        }

        public ImportCreditNoteRequest lineItemTierQuantityUsed(int index, Integer lineItemTierQuantityUsed) {
            this.params.addOpt("line_item_tiers[quantity_used][" + index + "]", lineItemTierQuantityUsed);
            return this;
        }

        public ImportCreditNoteRequest lineItemTierUnitAmount(int index, Integer lineItemTierUnitAmount) {
            this.params.addOpt("line_item_tiers[unit_amount][" + index + "]", lineItemTierUnitAmount);
            return this;
        }

        public ImportCreditNoteRequest lineItemTierStartingUnitInDecimal(int index, String lineItemTierStartingUnitInDecimal) {
            this.params.addOpt("line_item_tiers[starting_unit_in_decimal][" + index + "]", lineItemTierStartingUnitInDecimal);
            return this;
        }

        public ImportCreditNoteRequest lineItemTierEndingUnitInDecimal(int index, String lineItemTierEndingUnitInDecimal) {
            this.params.addOpt("line_item_tiers[ending_unit_in_decimal][" + index + "]", lineItemTierEndingUnitInDecimal);
            return this;
        }

        public ImportCreditNoteRequest lineItemTierQuantityUsedInDecimal(int index, String lineItemTierQuantityUsedInDecimal) {
            this.params.addOpt("line_item_tiers[quantity_used_in_decimal][" + index + "]", lineItemTierQuantityUsedInDecimal);
            return this;
        }

        public ImportCreditNoteRequest lineItemTierUnitAmountInDecimal(int index, String lineItemTierUnitAmountInDecimal) {
            this.params.addOpt("line_item_tiers[unit_amount_in_decimal][" + index + "]", lineItemTierUnitAmountInDecimal);
            return this;
        }

        public ImportCreditNoteRequest discountLineItemId(int index, String discountLineItemId) {
            this.params.addOpt("discounts[line_item_id][" + index + "]", discountLineItemId);
            return this;
        }

        public ImportCreditNoteRequest discountEntityType(int index, Discount.EntityType discountEntityType) {
            this.params.add("discounts[entity_type][" + index + "]", (Object)discountEntityType);
            return this;
        }

        public ImportCreditNoteRequest discountEntityId(int index, String discountEntityId) {
            this.params.addOpt("discounts[entity_id][" + index + "]", discountEntityId);
            return this;
        }

        public ImportCreditNoteRequest discountDescription(int index, String discountDescription) {
            this.params.addOpt("discounts[description][" + index + "]", discountDescription);
            return this;
        }

        public ImportCreditNoteRequest discountAmount(int index, Integer discountAmount) {
            this.params.add("discounts[amount][" + index + "]", discountAmount);
            return this;
        }

        public ImportCreditNoteRequest taxName(int index, String taxName) {
            this.params.add("taxes[name][" + index + "]", taxName);
            return this;
        }

        public ImportCreditNoteRequest taxRate(int index, Double taxRate) {
            this.params.add("taxes[rate][" + index + "]", taxRate);
            return this;
        }

        public ImportCreditNoteRequest taxAmount(int index, Integer taxAmount) {
            this.params.addOpt("taxes[amount][" + index + "]", taxAmount);
            return this;
        }

        public ImportCreditNoteRequest taxDescription(int index, String taxDescription) {
            this.params.addOpt("taxes[description][" + index + "]", taxDescription);
            return this;
        }

        public ImportCreditNoteRequest taxJurisType(int index, TaxJurisType taxJurisType) {
            this.params.addOpt("taxes[juris_type][" + index + "]", (Object)taxJurisType);
            return this;
        }

        public ImportCreditNoteRequest taxJurisName(int index, String taxJurisName) {
            this.params.addOpt("taxes[juris_name][" + index + "]", taxJurisName);
            return this;
        }

        public ImportCreditNoteRequest taxJurisCode(int index, String taxJurisCode) {
            this.params.addOpt("taxes[juris_code][" + index + "]", taxJurisCode);
            return this;
        }

        public ImportCreditNoteRequest allocationInvoiceId(int index, String allocationInvoiceId) {
            this.params.add("allocations[invoice_id][" + index + "]", allocationInvoiceId);
            return this;
        }

        public ImportCreditNoteRequest allocationAllocatedAmount(int index, Integer allocationAllocatedAmount) {
            this.params.add("allocations[allocated_amount][" + index + "]", allocationAllocatedAmount);
            return this;
        }

        public ImportCreditNoteRequest allocationAllocatedAt(int index, Timestamp allocationAllocatedAt) {
            this.params.add("allocations[allocated_at][" + index + "]", allocationAllocatedAt);
            return this;
        }

        public ImportCreditNoteRequest linkedRefundAmount(int index, Integer linkedRefundAmount) {
            this.params.add("linked_refunds[amount][" + index + "]", linkedRefundAmount);
            return this;
        }

        public ImportCreditNoteRequest linkedRefundPaymentMethod(int index, PaymentMethod linkedRefundPaymentMethod) {
            this.params.add("linked_refunds[payment_method][" + index + "]", (Object)linkedRefundPaymentMethod);
            return this;
        }

        public ImportCreditNoteRequest linkedRefundDate(int index, Timestamp linkedRefundDate) {
            this.params.add("linked_refunds[date][" + index + "]", linkedRefundDate);
            return this;
        }

        public ImportCreditNoteRequest linkedRefundReferenceNumber(int index, String linkedRefundReferenceNumber) {
            this.params.addOpt("linked_refunds[reference_number][" + index + "]", linkedRefundReferenceNumber);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RemoveTaxWithheldRefundRequest
    extends Request<RemoveTaxWithheldRefundRequest> {
        private RemoveTaxWithheldRefundRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RemoveTaxWithheldRefundRequest taxWithheldId(String taxWithheldId) {
            this.params.add("tax_withheld[id]", taxWithheldId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class DeleteRequest
    extends Request<DeleteRequest> {
        private DeleteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public DeleteRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreditNoteListRequest
    extends ListRequest<CreditNoteListRequest> {
        private CreditNoteListRequest(String uri) {
            super(uri);
        }

        public CreditNoteListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        public StringFilter<CreditNoteListRequest> id() {
            return new StringFilter<CreditNoteListRequest>("id", this).supportsMultiOperators(true);
        }

        public StringFilter<CreditNoteListRequest> customerId() {
            return new StringFilter<CreditNoteListRequest>("customer_id", this).supportsMultiOperators(true);
        }

        public StringFilter<CreditNoteListRequest> subscriptionId() {
            return new StringFilter<CreditNoteListRequest>("subscription_id", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<CreditNoteListRequest> referenceInvoiceId() {
            return new StringFilter<CreditNoteListRequest>("reference_invoice_id", this).supportsMultiOperators(true);
        }

        public EnumFilter<Type, CreditNoteListRequest> type() {
            return new EnumFilter<Type, CreditNoteListRequest>("type", this);
        }

        public EnumFilter<ReasonCode, CreditNoteListRequest> reasonCode() {
            return new EnumFilter<ReasonCode, CreditNoteListRequest>("reason_code", this);
        }

        public StringFilter<CreditNoteListRequest> createReasonCode() {
            return new StringFilter<CreditNoteListRequest>("create_reason_code", this).supportsMultiOperators(true);
        }

        public EnumFilter<Status, CreditNoteListRequest> status() {
            return new EnumFilter<Status, CreditNoteListRequest>("status", this);
        }

        public TimestampFilter<CreditNoteListRequest> date() {
            return new TimestampFilter<CreditNoteListRequest>("date", this);
        }

        public NumberFilter<Integer, CreditNoteListRequest> total() {
            return new NumberFilter<Integer, CreditNoteListRequest>("total", this);
        }

        public EnumFilter<PriceType, CreditNoteListRequest> priceType() {
            return new EnumFilter<PriceType, CreditNoteListRequest>("price_type", this);
        }

        public NumberFilter<Integer, CreditNoteListRequest> amountAllocated() {
            return new NumberFilter<Integer, CreditNoteListRequest>("amount_allocated", this);
        }

        public NumberFilter<Integer, CreditNoteListRequest> amountRefunded() {
            return new NumberFilter<Integer, CreditNoteListRequest>("amount_refunded", this);
        }

        public NumberFilter<Integer, CreditNoteListRequest> amountAvailable() {
            return new NumberFilter<Integer, CreditNoteListRequest>("amount_available", this);
        }

        public TimestampFilter<CreditNoteListRequest> voidedAt() {
            return new TimestampFilter<CreditNoteListRequest>("voided_at", this);
        }

        public TimestampFilter<CreditNoteListRequest> updatedAt() {
            return new TimestampFilter<CreditNoteListRequest>("updated_at", this);
        }

        public CreditNoteListRequest sortByDate(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "date");
            return this;
        }

        public EnumFilter<Channel, CreditNoteListRequest> channel() {
            return new EnumFilter<Channel, CreditNoteListRequest>("channel", this);
        }

        public EnumFilter<Einvoice.Status, CreditNoteListRequest> einvoiceStatus() {
            return new EnumFilter<Einvoice.Status, CreditNoteListRequest>("einvoice[status]", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class VoidCreditNoteRequest
    extends Request<VoidCreditNoteRequest> {
        private VoidCreditNoteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public VoidCreditNoteRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RecordRefundRequest
    extends Request<RecordRefundRequest> {
        private RecordRefundRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RecordRefundRequest refundReasonCode(String refundReasonCode) {
            this.params.addOpt("refund_reason_code", refundReasonCode);
            return this;
        }

        public RecordRefundRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public RecordRefundRequest transactionAmount(Integer transactionAmount) {
            this.params.addOpt("transaction[amount]", transactionAmount);
            return this;
        }

        public RecordRefundRequest transactionPaymentMethod(PaymentMethod transactionPaymentMethod) {
            this.params.add("transaction[payment_method]", (Object)transactionPaymentMethod);
            return this;
        }

        public RecordRefundRequest transactionReferenceNumber(String transactionReferenceNumber) {
            this.params.addOpt("transaction[reference_number]", transactionReferenceNumber);
            return this;
        }

        public RecordRefundRequest transactionDate(Timestamp transactionDate) {
            this.params.add("transaction[date]", transactionDate);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RefundRequest
    extends Request<RefundRequest> {
        private RefundRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RefundRequest refundAmount(Integer refundAmount) {
            this.params.addOpt("refund_amount", refundAmount);
            return this;
        }

        public RefundRequest customerNotes(String customerNotes) {
            this.params.addOpt("customer_notes", customerNotes);
            return this;
        }

        public RefundRequest refundReasonCode(String refundReasonCode) {
            this.params.addOpt("refund_reason_code", refundReasonCode);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class PdfRequest
    extends Request<PdfRequest> {
        private PdfRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public PdfRequest dispositionType(DispositionType dispositionType) {
            this.params.addOpt("disposition_type", (Object)dispositionType);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest referenceInvoiceId(String referenceInvoiceId) {
            this.params.add("reference_invoice_id", referenceInvoiceId);
            return this;
        }

        public CreateRequest total(Integer total) {
            this.params.addOpt("total", total);
            return this;
        }

        public CreateRequest type(Type type) {
            this.params.add("type", (Object)type);
            return this;
        }

        public CreateRequest reasonCode(ReasonCode reasonCode) {
            this.params.addOpt("reason_code", (Object)reasonCode);
            return this;
        }

        public CreateRequest createReasonCode(String createReasonCode) {
            this.params.addOpt("create_reason_code", createReasonCode);
            return this;
        }

        public CreateRequest date(Timestamp date) {
            this.params.addOpt("date", date);
            return this;
        }

        public CreateRequest customerNotes(String customerNotes) {
            this.params.addOpt("customer_notes", customerNotes);
            return this;
        }

        public CreateRequest comment(String comment) {
            this.params.addOpt("comment", comment);
            return this;
        }

        public CreateRequest lineItemReferenceLineItemId(int index, String lineItemReferenceLineItemId) {
            this.params.add("line_items[reference_line_item_id][" + index + "]", lineItemReferenceLineItemId);
            return this;
        }

        public CreateRequest lineItemUnitAmount(int index, Integer lineItemUnitAmount) {
            this.params.addOpt("line_items[unit_amount][" + index + "]", lineItemUnitAmount);
            return this;
        }

        public CreateRequest lineItemUnitAmountInDecimal(int index, String lineItemUnitAmountInDecimal) {
            this.params.addOpt("line_items[unit_amount_in_decimal][" + index + "]", lineItemUnitAmountInDecimal);
            return this;
        }

        public CreateRequest lineItemQuantity(int index, Integer lineItemQuantity) {
            this.params.addOpt("line_items[quantity][" + index + "]", lineItemQuantity);
            return this;
        }

        public CreateRequest lineItemQuantityInDecimal(int index, String lineItemQuantityInDecimal) {
            this.params.addOpt("line_items[quantity_in_decimal][" + index + "]", lineItemQuantityInDecimal);
            return this;
        }

        public CreateRequest lineItemAmount(int index, Integer lineItemAmount) {
            this.params.addOpt("line_items[amount][" + index + "]", lineItemAmount);
            return this;
        }

        public CreateRequest lineItemDateFrom(int index, Timestamp lineItemDateFrom) {
            this.params.addOpt("line_items[date_from][" + index + "]", lineItemDateFrom);
            return this;
        }

        public CreateRequest lineItemDateTo(int index, Timestamp lineItemDateTo) {
            this.params.addOpt("line_items[date_to][" + index + "]", lineItemDateTo);
            return this;
        }

        public CreateRequest lineItemDescription(int index, String lineItemDescription) {
            this.params.addOpt("line_items[description][" + index + "]", lineItemDescription);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class BillingAddress
    extends Resource<BillingAddress> {
        public BillingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }
    }

    public static class ShippingAddress
    extends Resource<ShippingAddress> {
        public ShippingAddress(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String firstName() {
            return this.optString("first_name");
        }

        public String lastName() {
            return this.optString("last_name");
        }

        public String email() {
            return this.optString("email");
        }

        public String company() {
            return this.optString("company");
        }

        public String phone() {
            return this.optString("phone");
        }

        public String line1() {
            return this.optString("line1");
        }

        public String line2() {
            return this.optString("line2");
        }

        public String line3() {
            return this.optString("line3");
        }

        public String city() {
            return this.optString("city");
        }

        public String stateCode() {
            return this.optString("state_code");
        }

        public String state() {
            return this.optString("state");
        }

        public String country() {
            return this.optString("country");
        }

        public String zip() {
            return this.optString("zip");
        }

        public ValidationStatus validationStatus() {
            return this.optEnum("validation_status", ValidationStatus.class);
        }

        public Integer index() {
            return this.reqInteger("index");
        }
    }

    public static class Allocation
    extends Resource<Allocation> {
        public Allocation(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String invoiceId() {
            return this.reqString("invoice_id");
        }

        public Integer allocatedAmount() {
            return this.reqInteger("allocated_amount");
        }

        public Timestamp allocatedAt() {
            return this.reqTimestamp("allocated_at");
        }

        public Timestamp invoiceDate() {
            return this.optTimestamp("invoice_date");
        }

        public Invoice.Status invoiceStatus() {
            return this.reqEnum("invoice_status", Invoice.Status.class);
        }
    }

    public static class LinkedRefund
    extends Resource<LinkedRefund> {
        public LinkedRefund(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String txnId() {
            return this.reqString("txn_id");
        }

        public Integer appliedAmount() {
            return this.reqInteger("applied_amount");
        }

        public Timestamp appliedAt() {
            return this.reqTimestamp("applied_at");
        }

        public Transaction.Status txnStatus() {
            return this.optEnum("txn_status", Transaction.Status.class);
        }

        public Timestamp txnDate() {
            return this.optTimestamp("txn_date");
        }

        public Integer txnAmount() {
            return this.optInteger("txn_amount");
        }

        public String refundReasonCode() {
            return this.optString("refund_reason_code");
        }
    }

    public static class LineItemTax
    extends Resource<LineItemTax> {
        public LineItemTax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.optString("line_item_id");
        }

        public String taxName() {
            return this.reqString("tax_name");
        }

        public Double taxRate() {
            return this.reqDouble("tax_rate");
        }

        public Boolean isPartialTaxApplied() {
            return this.optBoolean("is_partial_tax_applied");
        }

        public Boolean isNonComplianceTax() {
            return this.optBoolean("is_non_compliance_tax");
        }

        public Integer taxableAmount() {
            return this.reqInteger("taxable_amount");
        }

        public Integer taxAmount() {
            return this.reqInteger("tax_amount");
        }

        public TaxJurisType taxJurisType() {
            return this.optEnum("tax_juris_type", TaxJurisType.class);
        }

        public String taxJurisName() {
            return this.optString("tax_juris_name");
        }

        public String taxJurisCode() {
            return this.optString("tax_juris_code");
        }

        public Integer taxAmountInLocalCurrency() {
            return this.optInteger("tax_amount_in_local_currency");
        }

        public String localCurrencyCode() {
            return this.optString("local_currency_code");
        }
    }

    public static class Tax
    extends Resource<Tax> {
        public Tax(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String name() {
            return this.reqString("name");
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.optString("description");
        }
    }

    public static class LineItemTier
    extends Resource<LineItemTier> {
        public LineItemTier(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.optString("line_item_id");
        }

        public Integer startingUnit() {
            return this.reqInteger("starting_unit");
        }

        public Integer endingUnit() {
            return this.optInteger("ending_unit");
        }

        public Integer quantityUsed() {
            return this.reqInteger("quantity_used");
        }

        public Integer unitAmount() {
            return this.reqInteger("unit_amount");
        }

        public String startingUnitInDecimal() {
            return this.optString("starting_unit_in_decimal");
        }

        public String endingUnitInDecimal() {
            return this.optString("ending_unit_in_decimal");
        }

        public String quantityUsedInDecimal() {
            return this.optString("quantity_used_in_decimal");
        }

        public String unitAmountInDecimal() {
            return this.optString("unit_amount_in_decimal");
        }
    }

    public static class LineItemDiscount
    extends Resource<LineItemDiscount> {
        public LineItemDiscount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String lineItemId() {
            return this.reqString("line_item_id");
        }

        public DiscountType discountType() {
            return this.reqEnum("discount_type", DiscountType.class);
        }

        public String couponId() {
            return this.optString("coupon_id");
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public Integer discountAmount() {
            return this.reqInteger("discount_amount");
        }

        public static enum DiscountType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            ITEM_LEVEL_DISCOUNT,
            DOCUMENT_LEVEL_DISCOUNT,
            _UNKNOWN;

        }
    }

    public static class Discount
    extends Resource<Discount> {
        public Discount(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer amount() {
            return this.reqInteger("amount");
        }

        public String description() {
            return this.optString("description");
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public String couponSetCode() {
            return this.optString("coupon_set_code");
        }

        public static enum EntityType {
            ITEM_LEVEL_COUPON,
            DOCUMENT_LEVEL_COUPON,
            PROMOTIONAL_CREDITS,
            PRORATED_CREDITS,
            ITEM_LEVEL_DISCOUNT,
            DOCUMENT_LEVEL_DISCOUNT,
            _UNKNOWN;

        }
    }

    public static class LineItem
    extends Resource<LineItem> {
        public LineItem(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.optString("id");
        }

        public String subscriptionId() {
            return this.optString("subscription_id");
        }

        public Timestamp dateFrom() {
            return this.reqTimestamp("date_from");
        }

        public Timestamp dateTo() {
            return this.reqTimestamp("date_to");
        }

        public Integer unitAmount() {
            return this.reqInteger("unit_amount");
        }

        public Integer quantity() {
            return this.optInteger("quantity");
        }

        public Integer amount() {
            return this.optInteger("amount");
        }

        public PricingModel pricingModel() {
            return this.optEnum("pricing_model", PricingModel.class);
        }

        public Boolean isTaxed() {
            return this.reqBoolean("is_taxed");
        }

        public Integer taxAmount() {
            return this.optInteger("tax_amount");
        }

        public Double taxRate() {
            return this.optDouble("tax_rate");
        }

        public String unitAmountInDecimal() {
            return this.optString("unit_amount_in_decimal");
        }

        public String quantityInDecimal() {
            return this.optString("quantity_in_decimal");
        }

        public String amountInDecimal() {
            return this.optString("amount_in_decimal");
        }

        public Integer discountAmount() {
            return this.optInteger("discount_amount");
        }

        public Integer itemLevelDiscountAmount() {
            return this.optInteger("item_level_discount_amount");
        }

        public String referenceLineItemId() {
            return this.optString("reference_line_item_id");
        }

        public String description() {
            return this.reqString("description");
        }

        public String entityDescription() {
            return this.optString("entity_description");
        }

        public EntityType entityType() {
            return this.reqEnum("entity_type", EntityType.class);
        }

        public TaxExemptReason taxExemptReason() {
            return this.optEnum("tax_exempt_reason", TaxExemptReason.class);
        }

        public String entityId() {
            return this.optString("entity_id");
        }

        public String customerId() {
            return this.optString("customer_id");
        }

        public static enum EntityType {
            PLAN_SETUP,
            PLAN,
            ADDON,
            ADHOC,
            PLAN_ITEM_PRICE,
            ADDON_ITEM_PRICE,
            CHARGE_ITEM_PRICE,
            _UNKNOWN;

        }
    }

    public static class Einvoice
    extends Resource<Einvoice> {
        public Einvoice(JSONObject jsonObj) {
            super(jsonObj);
        }

        public String id() {
            return this.reqString("id");
        }

        public String referenceNumber() {
            return this.optString("reference_number");
        }

        public Status status() {
            return this.reqEnum("status", Status.class);
        }

        public String message() {
            return this.optString("message");
        }

        public static enum Status {
            SCHEDULED,
            SKIPPED,
            IN_PROGRESS,
            SUCCESS,
            FAILED,
            REGISTERED,
            _UNKNOWN;

        }
    }

    public static enum Status {
        ADJUSTED,
        REFUNDED,
        REFUND_DUE,
        VOIDED,
        _UNKNOWN;

    }

    public static enum ReasonCode {
        WRITE_OFF,
        SUBSCRIPTION_CHANGE,
        SUBSCRIPTION_CANCELLATION,
        SUBSCRIPTION_PAUSE,
        CHARGEBACK,
        PRODUCT_UNSATISFACTORY,
        SERVICE_UNSATISFACTORY,
        ORDER_CHANGE,
        ORDER_CANCELLATION,
        WAIVER,
        OTHER,
        FRAUDULENT,
        _UNKNOWN;

    }

    public static enum Type {
        ADJUSTMENT,
        REFUNDABLE,
        _UNKNOWN;

    }
}

