/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.filters.TimestampFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.internal.ResultBase;
import com.chargebee.models.ContractTerm;
import com.chargebee.models.enums.ApplyOn;
import com.chargebee.models.enums.AutoCollection;
import com.chargebee.models.enums.AvalaraSaleType;
import com.chargebee.models.enums.BillingAlignmentMode;
import com.chargebee.models.enums.ChargeOn;
import com.chargebee.models.enums.ChargeOnEvent;
import com.chargebee.models.enums.ChargeOnOption;
import com.chargebee.models.enums.DurationType;
import com.chargebee.models.enums.Gateway;
import com.chargebee.models.enums.ItemType;
import com.chargebee.models.enums.Layout;
import com.chargebee.models.enums.OfflinePaymentMethod;
import com.chargebee.models.enums.OnEvent;
import com.chargebee.models.enums.Operation;
import com.chargebee.models.enums.OperationType;
import com.chargebee.models.enums.PeriodUnit;
import com.chargebee.models.enums.Taxability;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

public class HostedPage
extends Resource<HostedPage> {
    public HostedPage(String jsonStr) {
        super(jsonStr);
    }

    public HostedPage(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.optString("id");
    }

    public Type type() {
        return this.optEnum("type", Type.class);
    }

    public String url() {
        return this.optString("url");
    }

    public State state() {
        return this.optEnum("state", State.class);
    }

    @Deprecated
    public FailureReason failureReason() {
        return this.optEnum("failure_reason", FailureReason.class);
    }

    public String passThruContent() {
        return this.optString("pass_thru_content");
    }

    public Boolean embed() {
        return this.reqBoolean("embed");
    }

    public Timestamp createdAt() {
        return this.optTimestamp("created_at");
    }

    public Timestamp expiresAt() {
        return this.optTimestamp("expires_at");
    }

    public Timestamp updatedAt() {
        return this.optTimestamp("updated_at");
    }

    public Long resourceVersion() {
        return this.optLong("resource_version");
    }

    public JSONObject checkoutInfo() {
        return this.optJSONObject("checkout_info");
    }

    public String businessEntityId() {
        return this.optString("business_entity_id");
    }

    public static CheckoutNewRequest checkoutNew() {
        String uri = HostedPage.uri("hosted_pages", "checkout_new");
        return new CheckoutNewRequest(HttpUtil.Method.POST, uri);
    }

    public static CheckoutOneTimeRequest checkoutOneTime() {
        String uri = HostedPage.uri("hosted_pages", "checkout_one_time");
        return new CheckoutOneTimeRequest(HttpUtil.Method.POST, uri);
    }

    public static CheckoutOneTimeForItemsRequest checkoutOneTimeForItems() {
        String uri = HostedPage.uri("hosted_pages", "checkout_one_time_for_items");
        return new CheckoutOneTimeForItemsRequest(HttpUtil.Method.POST, uri);
    }

    public static CheckoutNewForItemsRequest checkoutNewForItems() {
        String uri = HostedPage.uri("hosted_pages", "checkout_new_for_items");
        return new CheckoutNewForItemsRequest(HttpUtil.Method.POST, uri);
    }

    public static CheckoutExistingRequest checkoutExisting() {
        String uri = HostedPage.uri("hosted_pages", "checkout_existing");
        return new CheckoutExistingRequest(HttpUtil.Method.POST, uri);
    }

    public static CheckoutExistingForItemsRequest checkoutExistingForItems() {
        String uri = HostedPage.uri("hosted_pages", "checkout_existing_for_items");
        return new CheckoutExistingForItemsRequest(HttpUtil.Method.POST, uri);
    }

    @Deprecated
    public static UpdateCardRequest updateCard() {
        String uri = HostedPage.uri("hosted_pages", "update_card");
        return new UpdateCardRequest(HttpUtil.Method.POST, uri);
    }

    public static UpdatePaymentMethodRequest updatePaymentMethod() {
        String uri = HostedPage.uri("hosted_pages", "update_payment_method");
        return new UpdatePaymentMethodRequest(HttpUtil.Method.POST, uri);
    }

    public static ManagePaymentSourcesRequest managePaymentSources() {
        String uri = HostedPage.uri("hosted_pages", "manage_payment_sources");
        return new ManagePaymentSourcesRequest(HttpUtil.Method.POST, uri);
    }

    public static CollectNowRequest collectNow() {
        String uri = HostedPage.uri("hosted_pages", "collect_now");
        return new CollectNowRequest(HttpUtil.Method.POST, uri);
    }

    public static AcceptQuoteRequest acceptQuote() {
        String uri = HostedPage.uri("hosted_pages", "accept_quote");
        return new AcceptQuoteRequest(HttpUtil.Method.POST, uri);
    }

    public static ExtendSubscriptionRequest extendSubscription() {
        String uri = HostedPage.uri("hosted_pages", "extend_subscription");
        return new ExtendSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static CheckoutGiftRequest checkoutGift() {
        String uri = HostedPage.uri("hosted_pages", "checkout_gift");
        return new CheckoutGiftRequest(HttpUtil.Method.POST, uri);
    }

    public static CheckoutGiftForItemsRequest checkoutGiftForItems() {
        String uri = HostedPage.uri("hosted_pages", "checkout_gift_for_items");
        return new CheckoutGiftForItemsRequest(HttpUtil.Method.POST, uri);
    }

    public static ClaimGiftRequest claimGift() {
        String uri = HostedPage.uri("hosted_pages", "claim_gift");
        return new ClaimGiftRequest(HttpUtil.Method.POST, uri);
    }

    public static RetrieveAgreementPdfRequest retrieveAgreementPdf() {
        String uri = HostedPage.uri("hosted_pages", "retrieve_agreement_pdf");
        return new RetrieveAgreementPdfRequest(HttpUtil.Method.POST, uri);
    }

    public static Request acknowledge(String id) {
        String uri = HostedPage.uri("hosted_pages", HostedPage.nullCheck(id), "acknowledge");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = HostedPage.uri("hosted_pages", HostedPage.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static HostedPageListRequest list() {
        String uri = HostedPage.uri("hosted_pages");
        return new HostedPageListRequest(uri);
    }

    public static PreCancelRequest preCancel() {
        String uri = HostedPage.uri("hosted_pages", "pre_cancel");
        return new PreCancelRequest(HttpUtil.Method.POST, uri);
    }

    public Content content() {
        if (this.optJSONObject("content") == null) {
            return null;
        }
        return new Content(this.optJSONObject("content"));
    }

    public static class PreCancelRequest
    extends Request<PreCancelRequest> {
        private PreCancelRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public PreCancelRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public PreCancelRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public PreCancelRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public PreCancelRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription[id]", subscriptionId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class HostedPageListRequest
    extends ListRequest<HostedPageListRequest> {
        private HostedPageListRequest(String uri) {
            super(uri);
        }

        public StringFilter<HostedPageListRequest> id() {
            return new StringFilter<HostedPageListRequest>("id", this).supportsMultiOperators(true);
        }

        public EnumFilter<Type, HostedPageListRequest> type() {
            return new EnumFilter<Type, HostedPageListRequest>("type", this);
        }

        public EnumFilter<State, HostedPageListRequest> state() {
            return new EnumFilter<State, HostedPageListRequest>("state", this);
        }

        public TimestampFilter<HostedPageListRequest> updatedAt() {
            return new TimestampFilter<HostedPageListRequest>("updated_at", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class RetrieveAgreementPdfRequest
    extends Request<RetrieveAgreementPdfRequest> {
        private RetrieveAgreementPdfRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RetrieveAgreementPdfRequest paymentSourceId(String paymentSourceId) {
            this.params.add("payment_source_id", paymentSourceId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ClaimGiftRequest
    extends Request<ClaimGiftRequest> {
        private ClaimGiftRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ClaimGiftRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public ClaimGiftRequest giftId(String giftId) {
            this.params.add("gift[id]", giftId);
            return this;
        }

        public ClaimGiftRequest customerLocale(String customerLocale) {
            this.params.addOpt("customer[locale]", customerLocale);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CheckoutGiftForItemsRequest
    extends Request<CheckoutGiftForItemsRequest> {
        private CheckoutGiftForItemsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CheckoutGiftForItemsRequest businessEntityId(String businessEntityId) {
            this.params.addOpt("business_entity_id", businessEntityId);
            return this;
        }

        public CheckoutGiftForItemsRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CheckoutGiftForItemsRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutGiftForItemsRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutGiftForItemsRequest gifterCustomerId(String gifterCustomerId) {
            this.params.addOpt("gifter[customer_id]", gifterCustomerId);
            return this;
        }

        public CheckoutGiftForItemsRequest gifterLocale(String gifterLocale) {
            this.params.addOpt("gifter[locale]", gifterLocale);
            return this;
        }

        public CheckoutGiftForItemsRequest subscriptionItemItemPriceId(int index, String subscriptionItemItemPriceId) {
            this.params.addOpt("subscription_items[item_price_id][" + index + "]", subscriptionItemItemPriceId);
            return this;
        }

        public CheckoutGiftForItemsRequest subscriptionItemQuantity(int index, Integer subscriptionItemQuantity) {
            this.params.addOpt("subscription_items[quantity][" + index + "]", subscriptionItemQuantity);
            return this;
        }

        public CheckoutGiftForItemsRequest subscriptionItemQuantityInDecimal(int index, String subscriptionItemQuantityInDecimal) {
            this.params.addOpt("subscription_items[quantity_in_decimal][" + index + "]", subscriptionItemQuantityInDecimal);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CheckoutGiftRequest
    extends Request<CheckoutGiftRequest> {
        private CheckoutGiftRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CheckoutGiftRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CheckoutGiftRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutGiftRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutGiftRequest gifterCustomerId(String gifterCustomerId) {
            this.params.addOpt("gifter[customer_id]", gifterCustomerId);
            return this;
        }

        public CheckoutGiftRequest gifterLocale(String gifterLocale) {
            this.params.addOpt("gifter[locale]", gifterLocale);
            return this;
        }

        public CheckoutGiftRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.add("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public CheckoutGiftRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public CheckoutGiftRequest subscriptionPlanQuantityInDecimal(String subscriptionPlanQuantityInDecimal) {
            this.params.addOpt("subscription[plan_quantity_in_decimal]", subscriptionPlanQuantityInDecimal);
            return this;
        }

        @Deprecated
        public CheckoutGiftRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public CheckoutGiftRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CheckoutGiftRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CheckoutGiftRequest addonQuantityInDecimal(int index, String addonQuantityInDecimal) {
            this.params.addOpt("addons[quantity_in_decimal][" + index + "]", addonQuantityInDecimal);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ExtendSubscriptionRequest
    extends Request<ExtendSubscriptionRequest> {
        private ExtendSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ExtendSubscriptionRequest expiry(Integer expiry) {
            this.params.addOpt("expiry", expiry);
            return this;
        }

        public ExtendSubscriptionRequest billingCycle(Integer billingCycle) {
            this.params.addOpt("billing_cycle", billingCycle);
            return this;
        }

        public ExtendSubscriptionRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription[id]", subscriptionId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class AcceptQuoteRequest
    extends Request<AcceptQuoteRequest> {
        private AcceptQuoteRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AcceptQuoteRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public AcceptQuoteRequest quoteId(String quoteId) {
            this.params.add("quote[id]", quoteId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CollectNowRequest
    extends Request<CollectNowRequest> {
        private CollectNowRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CollectNowRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CollectNowRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CollectNowRequest customerId(String customerId) {
            this.params.add("customer[id]", customerId);
            return this;
        }

        @Deprecated
        public CollectNowRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CollectNowRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ManagePaymentSourcesRequest
    extends Request<ManagePaymentSourcesRequest> {
        private ManagePaymentSourcesRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ManagePaymentSourcesRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public ManagePaymentSourcesRequest customerId(String customerId) {
            this.params.add("customer[id]", customerId);
            return this;
        }

        @Deprecated
        public ManagePaymentSourcesRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public ManagePaymentSourcesRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdatePaymentMethodRequest
    extends Request<UpdatePaymentMethodRequest> {
        private UpdatePaymentMethodRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdatePaymentMethodRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public UpdatePaymentMethodRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public UpdatePaymentMethodRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public UpdatePaymentMethodRequest embed(Boolean embed) {
            this.params.addOpt("embed", embed);
            return this;
        }

        public UpdatePaymentMethodRequest iframeMessaging(Boolean iframeMessaging) {
            this.params.addOpt("iframe_messaging", iframeMessaging);
            return this;
        }

        public UpdatePaymentMethodRequest customerId(String customerId) {
            this.params.add("customer[id]", customerId);
            return this;
        }

        @Deprecated
        public UpdatePaymentMethodRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        @Deprecated
        public UpdatePaymentMethodRequest customerVatNumberPrefix(String customerVatNumberPrefix) {
            this.params.addOpt("customer[vat_number_prefix]", customerVatNumberPrefix);
            return this;
        }

        @Deprecated
        public UpdatePaymentMethodRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public UpdatePaymentMethodRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class UpdateCardRequest
    extends Request<UpdateCardRequest> {
        private UpdateCardRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateCardRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public UpdateCardRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public UpdateCardRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public UpdateCardRequest embed(Boolean embed) {
            this.params.addOpt("embed", embed);
            return this;
        }

        public UpdateCardRequest iframeMessaging(Boolean iframeMessaging) {
            this.params.addOpt("iframe_messaging", iframeMessaging);
            return this;
        }

        public UpdateCardRequest customerId(String customerId) {
            this.params.add("customer[id]", customerId);
            return this;
        }

        @Deprecated
        public UpdateCardRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        @Deprecated
        public UpdateCardRequest customerVatNumberPrefix(String customerVatNumberPrefix) {
            this.params.addOpt("customer[vat_number_prefix]", customerVatNumberPrefix);
            return this;
        }

        @Deprecated
        public UpdateCardRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public UpdateCardRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CheckoutExistingForItemsRequest
    extends Request<CheckoutExistingForItemsRequest> {
        private CheckoutExistingForItemsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CheckoutExistingForItemsRequest layout(Layout layout) {
            this.params.addOpt("layout", (Object)layout);
            return this;
        }

        public CheckoutExistingForItemsRequest mandatoryItemsToRemove(List<String> mandatoryItemsToRemove) {
            this.params.addOpt("mandatory_items_to_remove", mandatoryItemsToRemove);
            return this;
        }

        public CheckoutExistingForItemsRequest mandatoryItemsToRemove(String ... mandatoryItemsToRemove) {
            this.params.addOpt("mandatory_items_to_remove", mandatoryItemsToRemove);
            return this;
        }

        public CheckoutExistingForItemsRequest replaceItemsList(Boolean replaceItemsList) {
            this.params.addOpt("replace_items_list", replaceItemsList);
            return this;
        }

        public CheckoutExistingForItemsRequest invoiceDate(Timestamp invoiceDate) {
            this.params.addOpt("invoice_date", invoiceDate);
            return this;
        }

        public CheckoutExistingForItemsRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CheckoutExistingForItemsRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CheckoutExistingForItemsRequest reactivateFrom(Timestamp reactivateFrom) {
            this.params.addOpt("reactivate_from", reactivateFrom);
            return this;
        }

        public CheckoutExistingForItemsRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CheckoutExistingForItemsRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutExistingForItemsRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutExistingForItemsRequest reactivate(Boolean reactivate) {
            this.params.addOpt("reactivate", reactivate);
            return this;
        }

        public CheckoutExistingForItemsRequest forceTermReset(Boolean forceTermReset) {
            this.params.addOpt("force_term_reset", forceTermReset);
            return this;
        }

        public CheckoutExistingForItemsRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CheckoutExistingForItemsRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public CheckoutExistingForItemsRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public CheckoutExistingForItemsRequest allowOfflinePaymentMethods(Boolean allowOfflinePaymentMethods) {
            this.params.addOpt("allow_offline_payment_methods", allowOfflinePaymentMethods);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription[id]", subscriptionId);
            return this;
        }

        @Deprecated
        public CheckoutExistingForItemsRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        @Deprecated
        public CheckoutExistingForItemsRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionAutoCollection(AutoCollection subscriptionAutoCollection) {
            this.params.addOpt("subscription[auto_collection]", (Object)subscriptionAutoCollection);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionOfflinePaymentMethod(OfflinePaymentMethod subscriptionOfflinePaymentMethod) {
            this.params.addOpt("subscription[offline_payment_method]", (Object)subscriptionOfflinePaymentMethod);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionInvoiceNotes(String subscriptionInvoiceNotes) {
            this.params.addOpt("subscription[invoice_notes]", subscriptionInvoiceNotes);
            return this;
        }

        public CheckoutExistingForItemsRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public CheckoutExistingForItemsRequest customerVatNumberPrefix(String customerVatNumberPrefix) {
            this.params.addOpt("customer[vat_number_prefix]", customerVatNumberPrefix);
            return this;
        }

        public CheckoutExistingForItemsRequest customerIsEinvoiceEnabled(Boolean customerIsEinvoiceEnabled) {
            this.params.addOpt("customer[is_einvoice_enabled]", customerIsEinvoiceEnabled);
            return this;
        }

        public CheckoutExistingForItemsRequest customerEntityIdentifierScheme(String customerEntityIdentifierScheme) {
            this.params.addOpt("customer[entity_identifier_scheme]", customerEntityIdentifierScheme);
            return this;
        }

        public CheckoutExistingForItemsRequest customerEntityIdentifierStandard(String customerEntityIdentifierStandard) {
            this.params.addOpt("customer[entity_identifier_standard]", customerEntityIdentifierStandard);
            return this;
        }

        @Deprecated
        public CheckoutExistingForItemsRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CheckoutExistingForItemsRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        public CheckoutExistingForItemsRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public CheckoutExistingForItemsRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionContractTermBillingCycleOnRenewal(Integer subscriptionContractTermBillingCycleOnRenewal) {
            this.params.addOpt("subscription[contract_term_billing_cycle_on_renewal]", subscriptionContractTermBillingCycleOnRenewal);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionItemItemPriceId(int index, String subscriptionItemItemPriceId) {
            this.params.add("subscription_items[item_price_id][" + index + "]", subscriptionItemItemPriceId);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionItemQuantity(int index, Integer subscriptionItemQuantity) {
            this.params.addOpt("subscription_items[quantity][" + index + "]", subscriptionItemQuantity);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionItemQuantityInDecimal(int index, String subscriptionItemQuantityInDecimal) {
            this.params.addOpt("subscription_items[quantity_in_decimal][" + index + "]", subscriptionItemQuantityInDecimal);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionItemUnitPrice(int index, Integer subscriptionItemUnitPrice) {
            this.params.addOpt("subscription_items[unit_price][" + index + "]", subscriptionItemUnitPrice);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionItemUnitPriceInDecimal(int index, String subscriptionItemUnitPriceInDecimal) {
            this.params.addOpt("subscription_items[unit_price_in_decimal][" + index + "]", subscriptionItemUnitPriceInDecimal);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionItemBillingCycles(int index, Integer subscriptionItemBillingCycles) {
            this.params.addOpt("subscription_items[billing_cycles][" + index + "]", subscriptionItemBillingCycles);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionItemTrialEnd(int index, Timestamp subscriptionItemTrialEnd) {
            this.params.addOpt("subscription_items[trial_end][" + index + "]", subscriptionItemTrialEnd);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionItemServicePeriodDays(int index, Integer subscriptionItemServicePeriodDays) {
            this.params.addOpt("subscription_items[service_period_days][" + index + "]", subscriptionItemServicePeriodDays);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionItemChargeOnEvent(int index, ChargeOnEvent subscriptionItemChargeOnEvent) {
            this.params.addOpt("subscription_items[charge_on_event][" + index + "]", (Object)subscriptionItemChargeOnEvent);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionItemChargeOnce(int index, Boolean subscriptionItemChargeOnce) {
            this.params.addOpt("subscription_items[charge_once][" + index + "]", subscriptionItemChargeOnce);
            return this;
        }

        public CheckoutExistingForItemsRequest subscriptionItemChargeOnOption(int index, ChargeOnOption subscriptionItemChargeOnOption) {
            this.params.addOpt("subscription_items[charge_on_option][" + index + "]", (Object)subscriptionItemChargeOnOption);
            return this;
        }

        @Deprecated
        public CheckoutExistingForItemsRequest subscriptionItemItemType(int index, ItemType subscriptionItemItemType) {
            this.params.addOpt("subscription_items[item_type][" + index + "]", (Object)subscriptionItemItemType);
            return this;
        }

        public CheckoutExistingForItemsRequest discountApplyOn(int index, ApplyOn discountApplyOn) {
            this.params.add("discounts[apply_on][" + index + "]", (Object)discountApplyOn);
            return this;
        }

        public CheckoutExistingForItemsRequest discountDurationType(int index, DurationType discountDurationType) {
            this.params.add("discounts[duration_type][" + index + "]", (Object)discountDurationType);
            return this;
        }

        public CheckoutExistingForItemsRequest discountPercentage(int index, Double discountPercentage) {
            this.params.addOpt("discounts[percentage][" + index + "]", discountPercentage);
            return this;
        }

        public CheckoutExistingForItemsRequest discountAmount(int index, Integer discountAmount) {
            this.params.addOpt("discounts[amount][" + index + "]", discountAmount);
            return this;
        }

        public CheckoutExistingForItemsRequest discountPeriod(int index, Integer discountPeriod) {
            this.params.addOpt("discounts[period][" + index + "]", discountPeriod);
            return this;
        }

        public CheckoutExistingForItemsRequest discountPeriodUnit(int index, PeriodUnit discountPeriodUnit) {
            this.params.addOpt("discounts[period_unit][" + index + "]", (Object)discountPeriodUnit);
            return this;
        }

        public CheckoutExistingForItemsRequest discountIncludedInMrr(int index, Boolean discountIncludedInMrr) {
            this.params.addOpt("discounts[included_in_mrr][" + index + "]", discountIncludedInMrr);
            return this;
        }

        public CheckoutExistingForItemsRequest discountItemPriceId(int index, String discountItemPriceId) {
            this.params.addOpt("discounts[item_price_id][" + index + "]", discountItemPriceId);
            return this;
        }

        public CheckoutExistingForItemsRequest discountOperationType(int index, OperationType discountOperationType) {
            this.params.add("discounts[operation_type][" + index + "]", (Object)discountOperationType);
            return this;
        }

        public CheckoutExistingForItemsRequest discountId(int index, String discountId) {
            this.params.addOpt("discounts[id][" + index + "]", discountId);
            return this;
        }

        public CheckoutExistingForItemsRequest itemTierItemPriceId(int index, String itemTierItemPriceId) {
            this.params.addOpt("item_tiers[item_price_id][" + index + "]", itemTierItemPriceId);
            return this;
        }

        public CheckoutExistingForItemsRequest itemTierStartingUnit(int index, Integer itemTierStartingUnit) {
            this.params.addOpt("item_tiers[starting_unit][" + index + "]", itemTierStartingUnit);
            return this;
        }

        public CheckoutExistingForItemsRequest itemTierEndingUnit(int index, Integer itemTierEndingUnit) {
            this.params.addOpt("item_tiers[ending_unit][" + index + "]", itemTierEndingUnit);
            return this;
        }

        public CheckoutExistingForItemsRequest itemTierPrice(int index, Integer itemTierPrice) {
            this.params.addOpt("item_tiers[price][" + index + "]", itemTierPrice);
            return this;
        }

        public CheckoutExistingForItemsRequest itemTierStartingUnitInDecimal(int index, String itemTierStartingUnitInDecimal) {
            this.params.addOpt("item_tiers[starting_unit_in_decimal][" + index + "]", itemTierStartingUnitInDecimal);
            return this;
        }

        public CheckoutExistingForItemsRequest itemTierEndingUnitInDecimal(int index, String itemTierEndingUnitInDecimal) {
            this.params.addOpt("item_tiers[ending_unit_in_decimal][" + index + "]", itemTierEndingUnitInDecimal);
            return this;
        }

        public CheckoutExistingForItemsRequest itemTierPriceInDecimal(int index, String itemTierPriceInDecimal) {
            this.params.addOpt("item_tiers[price_in_decimal][" + index + "]", itemTierPriceInDecimal);
            return this;
        }

        public CheckoutExistingForItemsRequest entityIdentifierId(int index, String entityIdentifierId) {
            this.params.addOpt("entity_identifiers[id][" + index + "]", entityIdentifierId);
            return this;
        }

        public CheckoutExistingForItemsRequest entityIdentifierScheme(int index, String entityIdentifierScheme) {
            this.params.addOpt("entity_identifiers[scheme][" + index + "]", entityIdentifierScheme);
            return this;
        }

        public CheckoutExistingForItemsRequest entityIdentifierValue(int index, String entityIdentifierValue) {
            this.params.addOpt("entity_identifiers[value][" + index + "]", entityIdentifierValue);
            return this;
        }

        public CheckoutExistingForItemsRequest entityIdentifierOperation(int index, Operation entityIdentifierOperation) {
            this.params.addOpt("entity_identifiers[operation][" + index + "]", (Object)entityIdentifierOperation);
            return this;
        }

        public CheckoutExistingForItemsRequest entityIdentifierStandard(int index, String entityIdentifierStandard) {
            this.params.addOpt("entity_identifiers[standard][" + index + "]", entityIdentifierStandard);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CheckoutExistingRequest
    extends Request<CheckoutExistingRequest> {
        private CheckoutExistingRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CheckoutExistingRequest replaceAddonList(Boolean replaceAddonList) {
            this.params.addOpt("replace_addon_list", replaceAddonList);
            return this;
        }

        public CheckoutExistingRequest mandatoryAddonsToRemove(List<String> mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CheckoutExistingRequest mandatoryAddonsToRemove(String ... mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CheckoutExistingRequest invoiceDate(Timestamp invoiceDate) {
            this.params.addOpt("invoice_date", invoiceDate);
            return this;
        }

        public CheckoutExistingRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CheckoutExistingRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CheckoutExistingRequest reactivateFrom(Timestamp reactivateFrom) {
            this.params.addOpt("reactivate_from", reactivateFrom);
            return this;
        }

        public CheckoutExistingRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CheckoutExistingRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutExistingRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutExistingRequest reactivate(Boolean reactivate) {
            this.params.addOpt("reactivate", reactivate);
            return this;
        }

        public CheckoutExistingRequest forceTermReset(Boolean forceTermReset) {
            this.params.addOpt("force_term_reset", forceTermReset);
            return this;
        }

        public CheckoutExistingRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CheckoutExistingRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public CheckoutExistingRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public CheckoutExistingRequest embed(Boolean embed) {
            this.params.addOpt("embed", embed);
            return this;
        }

        public CheckoutExistingRequest iframeMessaging(Boolean iframeMessaging) {
            this.params.addOpt("iframe_messaging", iframeMessaging);
            return this;
        }

        public CheckoutExistingRequest allowOfflinePaymentMethods(Boolean allowOfflinePaymentMethods) {
            this.params.addOpt("allow_offline_payment_methods", allowOfflinePaymentMethods);
            return this;
        }

        public CheckoutExistingRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription[id]", subscriptionId);
            return this;
        }

        public CheckoutExistingRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.addOpt("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public CheckoutExistingRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public CheckoutExistingRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public CheckoutExistingRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public CheckoutExistingRequest subscriptionPlanQuantityInDecimal(String subscriptionPlanQuantityInDecimal) {
            this.params.addOpt("subscription[plan_quantity_in_decimal]", subscriptionPlanQuantityInDecimal);
            return this;
        }

        public CheckoutExistingRequest subscriptionPlanUnitPriceInDecimal(String subscriptionPlanUnitPriceInDecimal) {
            this.params.addOpt("subscription[plan_unit_price_in_decimal]", subscriptionPlanUnitPriceInDecimal);
            return this;
        }

        public CheckoutExistingRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public CheckoutExistingRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        @Deprecated
        public CheckoutExistingRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public CheckoutExistingRequest subscriptionAutoCollection(AutoCollection subscriptionAutoCollection) {
            this.params.addOpt("subscription[auto_collection]", (Object)subscriptionAutoCollection);
            return this;
        }

        public CheckoutExistingRequest subscriptionOfflinePaymentMethod(OfflinePaymentMethod subscriptionOfflinePaymentMethod) {
            this.params.addOpt("subscription[offline_payment_method]", (Object)subscriptionOfflinePaymentMethod);
            return this;
        }

        public CheckoutExistingRequest subscriptionInvoiceNotes(String subscriptionInvoiceNotes) {
            this.params.addOpt("subscription[invoice_notes]", subscriptionInvoiceNotes);
            return this;
        }

        public CheckoutExistingRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public CheckoutExistingRequest customerVatNumberPrefix(String customerVatNumberPrefix) {
            this.params.addOpt("customer[vat_number_prefix]", customerVatNumberPrefix);
            return this;
        }

        @Deprecated
        public CheckoutExistingRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CheckoutExistingRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        public CheckoutExistingRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public CheckoutExistingRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public CheckoutExistingRequest subscriptionContractTermBillingCycleOnRenewal(Integer subscriptionContractTermBillingCycleOnRenewal) {
            this.params.addOpt("subscription[contract_term_billing_cycle_on_renewal]", subscriptionContractTermBillingCycleOnRenewal);
            return this;
        }

        public CheckoutExistingRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CheckoutExistingRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CheckoutExistingRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CheckoutExistingRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public CheckoutExistingRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public CheckoutExistingRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public CheckoutExistingRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public CheckoutExistingRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public CheckoutExistingRequest eventBasedAddonChargeOn(int index, ChargeOn eventBasedAddonChargeOn) {
            this.params.addOpt("event_based_addons[charge_on][" + index + "]", (Object)eventBasedAddonChargeOn);
            return this;
        }

        public CheckoutExistingRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public CheckoutExistingRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public CheckoutExistingRequest addonQuantityInDecimal(int index, String addonQuantityInDecimal) {
            this.params.addOpt("addons[quantity_in_decimal][" + index + "]", addonQuantityInDecimal);
            return this;
        }

        public CheckoutExistingRequest addonUnitPriceInDecimal(int index, String addonUnitPriceInDecimal) {
            this.params.addOpt("addons[unit_price_in_decimal][" + index + "]", addonUnitPriceInDecimal);
            return this;
        }

        public CheckoutExistingRequest eventBasedAddonQuantityInDecimal(int index, String eventBasedAddonQuantityInDecimal) {
            this.params.addOpt("event_based_addons[quantity_in_decimal][" + index + "]", eventBasedAddonQuantityInDecimal);
            return this;
        }

        public CheckoutExistingRequest eventBasedAddonUnitPriceInDecimal(int index, String eventBasedAddonUnitPriceInDecimal) {
            this.params.addOpt("event_based_addons[unit_price_in_decimal][" + index + "]", eventBasedAddonUnitPriceInDecimal);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CheckoutNewForItemsRequest
    extends Request<CheckoutNewForItemsRequest> {
        private CheckoutNewForItemsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CheckoutNewForItemsRequest layout(Layout layout) {
            this.params.addOpt("layout", (Object)layout);
            return this;
        }

        public CheckoutNewForItemsRequest businessEntityId(String businessEntityId) {
            this.params.addOpt("business_entity_id", businessEntityId);
            return this;
        }

        public CheckoutNewForItemsRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CheckoutNewForItemsRequest mandatoryItemsToRemove(List<String> mandatoryItemsToRemove) {
            this.params.addOpt("mandatory_items_to_remove", mandatoryItemsToRemove);
            return this;
        }

        public CheckoutNewForItemsRequest mandatoryItemsToRemove(String ... mandatoryItemsToRemove) {
            this.params.addOpt("mandatory_items_to_remove", mandatoryItemsToRemove);
            return this;
        }

        public CheckoutNewForItemsRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CheckoutNewForItemsRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CheckoutNewForItemsRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutNewForItemsRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutNewForItemsRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CheckoutNewForItemsRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public CheckoutNewForItemsRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public CheckoutNewForItemsRequest allowOfflinePaymentMethods(Boolean allowOfflinePaymentMethods) {
            this.params.addOpt("allow_offline_payment_methods", allowOfflinePaymentMethods);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription[id]", subscriptionId);
            return this;
        }

        public CheckoutNewForItemsRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        public CheckoutNewForItemsRequest customerEmail(String customerEmail) {
            this.params.addOpt("customer[email]", customerEmail);
            return this;
        }

        public CheckoutNewForItemsRequest customerFirstName(String customerFirstName) {
            this.params.addOpt("customer[first_name]", customerFirstName);
            return this;
        }

        public CheckoutNewForItemsRequest customerLastName(String customerLastName) {
            this.params.addOpt("customer[last_name]", customerLastName);
            return this;
        }

        public CheckoutNewForItemsRequest customerCompany(String customerCompany) {
            this.params.addOpt("customer[company]", customerCompany);
            return this;
        }

        public CheckoutNewForItemsRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public CheckoutNewForItemsRequest customerLocale(String customerLocale) {
            this.params.addOpt("customer[locale]", customerLocale);
            return this;
        }

        public CheckoutNewForItemsRequest customerPhone(String customerPhone) {
            this.params.addOpt("customer[phone]", customerPhone);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        @Deprecated
        public CheckoutNewForItemsRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionAutoCollection(AutoCollection subscriptionAutoCollection) {
            this.params.addOpt("subscription[auto_collection]", (Object)subscriptionAutoCollection);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionOfflinePaymentMethod(OfflinePaymentMethod subscriptionOfflinePaymentMethod) {
            this.params.addOpt("subscription[offline_payment_method]", (Object)subscriptionOfflinePaymentMethod);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionInvoiceNotes(String subscriptionInvoiceNotes) {
            this.params.addOpt("subscription[invoice_notes]", subscriptionInvoiceNotes);
            return this;
        }

        @Deprecated
        public CheckoutNewForItemsRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CheckoutNewForItemsRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        public CheckoutNewForItemsRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public CheckoutNewForItemsRequest customerVatNumberPrefix(String customerVatNumberPrefix) {
            this.params.addOpt("customer[vat_number_prefix]", customerVatNumberPrefix);
            return this;
        }

        public CheckoutNewForItemsRequest customerIsEinvoiceEnabled(Boolean customerIsEinvoiceEnabled) {
            this.params.addOpt("customer[is_einvoice_enabled]", customerIsEinvoiceEnabled);
            return this;
        }

        public CheckoutNewForItemsRequest customerEntityIdentifierScheme(String customerEntityIdentifierScheme) {
            this.params.addOpt("customer[entity_identifier_scheme]", customerEntityIdentifierScheme);
            return this;
        }

        public CheckoutNewForItemsRequest customerEntityIdentifierStandard(String customerEntityIdentifierStandard) {
            this.params.addOpt("customer[entity_identifier_standard]", customerEntityIdentifierStandard);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public CheckoutNewForItemsRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CheckoutNewForItemsRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CheckoutNewForItemsRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public CheckoutNewForItemsRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionContractTermBillingCycleOnRenewal(Integer subscriptionContractTermBillingCycleOnRenewal) {
            this.params.addOpt("subscription[contract_term_billing_cycle_on_renewal]", subscriptionContractTermBillingCycleOnRenewal);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionAffiliateToken(String subscriptionAffiliateToken) {
            this.params.addOpt("subscription[affiliate_token]", subscriptionAffiliateToken);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionItemItemPriceId(int index, String subscriptionItemItemPriceId) {
            this.params.add("subscription_items[item_price_id][" + index + "]", subscriptionItemItemPriceId);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionItemQuantity(int index, Integer subscriptionItemQuantity) {
            this.params.addOpt("subscription_items[quantity][" + index + "]", subscriptionItemQuantity);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionItemQuantityInDecimal(int index, String subscriptionItemQuantityInDecimal) {
            this.params.addOpt("subscription_items[quantity_in_decimal][" + index + "]", subscriptionItemQuantityInDecimal);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionItemUnitPrice(int index, Integer subscriptionItemUnitPrice) {
            this.params.addOpt("subscription_items[unit_price][" + index + "]", subscriptionItemUnitPrice);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionItemUnitPriceInDecimal(int index, String subscriptionItemUnitPriceInDecimal) {
            this.params.addOpt("subscription_items[unit_price_in_decimal][" + index + "]", subscriptionItemUnitPriceInDecimal);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionItemBillingCycles(int index, Integer subscriptionItemBillingCycles) {
            this.params.addOpt("subscription_items[billing_cycles][" + index + "]", subscriptionItemBillingCycles);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionItemTrialEnd(int index, Timestamp subscriptionItemTrialEnd) {
            this.params.addOpt("subscription_items[trial_end][" + index + "]", subscriptionItemTrialEnd);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionItemServicePeriodDays(int index, Integer subscriptionItemServicePeriodDays) {
            this.params.addOpt("subscription_items[service_period_days][" + index + "]", subscriptionItemServicePeriodDays);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionItemChargeOnEvent(int index, ChargeOnEvent subscriptionItemChargeOnEvent) {
            this.params.addOpt("subscription_items[charge_on_event][" + index + "]", (Object)subscriptionItemChargeOnEvent);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionItemChargeOnce(int index, Boolean subscriptionItemChargeOnce) {
            this.params.addOpt("subscription_items[charge_once][" + index + "]", subscriptionItemChargeOnce);
            return this;
        }

        @Deprecated
        public CheckoutNewForItemsRequest subscriptionItemItemType(int index, ItemType subscriptionItemItemType) {
            this.params.addOpt("subscription_items[item_type][" + index + "]", (Object)subscriptionItemItemType);
            return this;
        }

        public CheckoutNewForItemsRequest discountApplyOn(int index, ApplyOn discountApplyOn) {
            this.params.add("discounts[apply_on][" + index + "]", (Object)discountApplyOn);
            return this;
        }

        public CheckoutNewForItemsRequest discountDurationType(int index, DurationType discountDurationType) {
            this.params.add("discounts[duration_type][" + index + "]", (Object)discountDurationType);
            return this;
        }

        public CheckoutNewForItemsRequest discountPercentage(int index, Double discountPercentage) {
            this.params.addOpt("discounts[percentage][" + index + "]", discountPercentage);
            return this;
        }

        public CheckoutNewForItemsRequest discountAmount(int index, Integer discountAmount) {
            this.params.addOpt("discounts[amount][" + index + "]", discountAmount);
            return this;
        }

        public CheckoutNewForItemsRequest discountPeriod(int index, Integer discountPeriod) {
            this.params.addOpt("discounts[period][" + index + "]", discountPeriod);
            return this;
        }

        public CheckoutNewForItemsRequest discountPeriodUnit(int index, PeriodUnit discountPeriodUnit) {
            this.params.addOpt("discounts[period_unit][" + index + "]", (Object)discountPeriodUnit);
            return this;
        }

        public CheckoutNewForItemsRequest discountIncludedInMrr(int index, Boolean discountIncludedInMrr) {
            this.params.addOpt("discounts[included_in_mrr][" + index + "]", discountIncludedInMrr);
            return this;
        }

        public CheckoutNewForItemsRequest discountItemPriceId(int index, String discountItemPriceId) {
            this.params.addOpt("discounts[item_price_id][" + index + "]", discountItemPriceId);
            return this;
        }

        public CheckoutNewForItemsRequest subscriptionItemChargeOnOption(int index, ChargeOnOption subscriptionItemChargeOnOption) {
            this.params.addOpt("subscription_items[charge_on_option][" + index + "]", (Object)subscriptionItemChargeOnOption);
            return this;
        }

        public CheckoutNewForItemsRequest itemTierItemPriceId(int index, String itemTierItemPriceId) {
            this.params.addOpt("item_tiers[item_price_id][" + index + "]", itemTierItemPriceId);
            return this;
        }

        public CheckoutNewForItemsRequest itemTierStartingUnit(int index, Integer itemTierStartingUnit) {
            this.params.addOpt("item_tiers[starting_unit][" + index + "]", itemTierStartingUnit);
            return this;
        }

        public CheckoutNewForItemsRequest itemTierEndingUnit(int index, Integer itemTierEndingUnit) {
            this.params.addOpt("item_tiers[ending_unit][" + index + "]", itemTierEndingUnit);
            return this;
        }

        public CheckoutNewForItemsRequest itemTierPrice(int index, Integer itemTierPrice) {
            this.params.addOpt("item_tiers[price][" + index + "]", itemTierPrice);
            return this;
        }

        public CheckoutNewForItemsRequest itemTierStartingUnitInDecimal(int index, String itemTierStartingUnitInDecimal) {
            this.params.addOpt("item_tiers[starting_unit_in_decimal][" + index + "]", itemTierStartingUnitInDecimal);
            return this;
        }

        public CheckoutNewForItemsRequest itemTierEndingUnitInDecimal(int index, String itemTierEndingUnitInDecimal) {
            this.params.addOpt("item_tiers[ending_unit_in_decimal][" + index + "]", itemTierEndingUnitInDecimal);
            return this;
        }

        public CheckoutNewForItemsRequest itemTierPriceInDecimal(int index, String itemTierPriceInDecimal) {
            this.params.addOpt("item_tiers[price_in_decimal][" + index + "]", itemTierPriceInDecimal);
            return this;
        }

        public CheckoutNewForItemsRequest entityIdentifierId(int index, String entityIdentifierId) {
            this.params.addOpt("entity_identifiers[id][" + index + "]", entityIdentifierId);
            return this;
        }

        public CheckoutNewForItemsRequest entityIdentifierScheme(int index, String entityIdentifierScheme) {
            this.params.addOpt("entity_identifiers[scheme][" + index + "]", entityIdentifierScheme);
            return this;
        }

        public CheckoutNewForItemsRequest entityIdentifierValue(int index, String entityIdentifierValue) {
            this.params.addOpt("entity_identifiers[value][" + index + "]", entityIdentifierValue);
            return this;
        }

        public CheckoutNewForItemsRequest entityIdentifierOperation(int index, Operation entityIdentifierOperation) {
            this.params.addOpt("entity_identifiers[operation][" + index + "]", (Object)entityIdentifierOperation);
            return this;
        }

        public CheckoutNewForItemsRequest entityIdentifierStandard(int index, String entityIdentifierStandard) {
            this.params.addOpt("entity_identifiers[standard][" + index + "]", entityIdentifierStandard);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CheckoutOneTimeForItemsRequest
    extends Request<CheckoutOneTimeForItemsRequest> {
        private CheckoutOneTimeForItemsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CheckoutOneTimeForItemsRequest businessEntityId(String businessEntityId) {
            this.params.addOpt("business_entity_id", businessEntityId);
            return this;
        }

        public CheckoutOneTimeForItemsRequest layout(Layout layout) {
            this.params.addOpt("layout", (Object)layout);
            return this;
        }

        public CheckoutOneTimeForItemsRequest invoiceNote(String invoiceNote) {
            this.params.addOpt("invoice_note", invoiceNote);
            return this;
        }

        @Deprecated
        public CheckoutOneTimeForItemsRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CheckoutOneTimeForItemsRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutOneTimeForItemsRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutOneTimeForItemsRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CheckoutOneTimeForItemsRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CheckoutOneTimeForItemsRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public CheckoutOneTimeForItemsRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerEmail(String customerEmail) {
            this.params.addOpt("customer[email]", customerEmail);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerFirstName(String customerFirstName) {
            this.params.addOpt("customer[first_name]", customerFirstName);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerLastName(String customerLastName) {
            this.params.addOpt("customer[last_name]", customerLastName);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerCompany(String customerCompany) {
            this.params.addOpt("customer[company]", customerCompany);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerLocale(String customerLocale) {
            this.params.addOpt("customer[locale]", customerLocale);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerPhone(String customerPhone) {
            this.params.addOpt("customer[phone]", customerPhone);
            return this;
        }

        public CheckoutOneTimeForItemsRequest invoicePoNumber(String invoicePoNumber) {
            this.params.addOpt("invoice[po_number]", invoicePoNumber);
            return this;
        }

        @Deprecated
        public CheckoutOneTimeForItemsRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CheckoutOneTimeForItemsRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerVatNumberPrefix(String customerVatNumberPrefix) {
            this.params.addOpt("customer[vat_number_prefix]", customerVatNumberPrefix);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerIsEinvoiceEnabled(Boolean customerIsEinvoiceEnabled) {
            this.params.addOpt("customer[is_einvoice_enabled]", customerIsEinvoiceEnabled);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerEntityIdentifierScheme(String customerEntityIdentifierScheme) {
            this.params.addOpt("customer[entity_identifier_scheme]", customerEntityIdentifierScheme);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerEntityIdentifierStandard(String customerEntityIdentifierStandard) {
            this.params.addOpt("customer[entity_identifier_standard]", customerEntityIdentifierStandard);
            return this;
        }

        public CheckoutOneTimeForItemsRequest customerConsolidatedInvoicing(Boolean customerConsolidatedInvoicing) {
            this.params.addOpt("customer[consolidated_invoicing]", customerConsolidatedInvoicing);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public CheckoutOneTimeForItemsRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CheckoutOneTimeForItemsRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemPriceItemPriceId(int index, String itemPriceItemPriceId) {
            this.params.addOpt("item_prices[item_price_id][" + index + "]", itemPriceItemPriceId);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemPriceQuantity(int index, Integer itemPriceQuantity) {
            this.params.addOpt("item_prices[quantity][" + index + "]", itemPriceQuantity);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemPriceQuantityInDecimal(int index, String itemPriceQuantityInDecimal) {
            this.params.addOpt("item_prices[quantity_in_decimal][" + index + "]", itemPriceQuantityInDecimal);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemPriceUnitPrice(int index, Integer itemPriceUnitPrice) {
            this.params.addOpt("item_prices[unit_price][" + index + "]", itemPriceUnitPrice);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemPriceUnitPriceInDecimal(int index, String itemPriceUnitPriceInDecimal) {
            this.params.addOpt("item_prices[unit_price_in_decimal][" + index + "]", itemPriceUnitPriceInDecimal);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemPriceDateFrom(int index, Timestamp itemPriceDateFrom) {
            this.params.addOpt("item_prices[date_from][" + index + "]", itemPriceDateFrom);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemPriceDateTo(int index, Timestamp itemPriceDateTo) {
            this.params.addOpt("item_prices[date_to][" + index + "]", itemPriceDateTo);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemTierItemPriceId(int index, String itemTierItemPriceId) {
            this.params.addOpt("item_tiers[item_price_id][" + index + "]", itemTierItemPriceId);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemTierStartingUnit(int index, Integer itemTierStartingUnit) {
            this.params.addOpt("item_tiers[starting_unit][" + index + "]", itemTierStartingUnit);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemTierEndingUnit(int index, Integer itemTierEndingUnit) {
            this.params.addOpt("item_tiers[ending_unit][" + index + "]", itemTierEndingUnit);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemTierPrice(int index, Integer itemTierPrice) {
            this.params.addOpt("item_tiers[price][" + index + "]", itemTierPrice);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemTierStartingUnitInDecimal(int index, String itemTierStartingUnitInDecimal) {
            this.params.addOpt("item_tiers[starting_unit_in_decimal][" + index + "]", itemTierStartingUnitInDecimal);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemTierEndingUnitInDecimal(int index, String itemTierEndingUnitInDecimal) {
            this.params.addOpt("item_tiers[ending_unit_in_decimal][" + index + "]", itemTierEndingUnitInDecimal);
            return this;
        }

        public CheckoutOneTimeForItemsRequest itemTierPriceInDecimal(int index, String itemTierPriceInDecimal) {
            this.params.addOpt("item_tiers[price_in_decimal][" + index + "]", itemTierPriceInDecimal);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeAmount(int index, Integer chargeAmount) {
            this.params.addOpt("charges[amount][" + index + "]", chargeAmount);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeAmountInDecimal(int index, String chargeAmountInDecimal) {
            this.params.addOpt("charges[amount_in_decimal][" + index + "]", chargeAmountInDecimal);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeDescription(int index, String chargeDescription) {
            this.params.addOpt("charges[description][" + index + "]", chargeDescription);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeTaxable(int index, Boolean chargeTaxable) {
            this.params.addOpt("charges[taxable][" + index + "]", chargeTaxable);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeTaxProfileId(int index, String chargeTaxProfileId) {
            this.params.addOpt("charges[tax_profile_id][" + index + "]", chargeTaxProfileId);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeAvalaraTaxCode(int index, String chargeAvalaraTaxCode) {
            this.params.addOpt("charges[avalara_tax_code][" + index + "]", chargeAvalaraTaxCode);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeHsnCode(int index, String chargeHsnCode) {
            this.params.addOpt("charges[hsn_code][" + index + "]", chargeHsnCode);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeTaxjarProductCode(int index, String chargeTaxjarProductCode) {
            this.params.addOpt("charges[taxjar_product_code][" + index + "]", chargeTaxjarProductCode);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeAvalaraSaleType(int index, AvalaraSaleType chargeAvalaraSaleType) {
            this.params.addOpt("charges[avalara_sale_type][" + index + "]", (Object)chargeAvalaraSaleType);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeAvalaraTransactionType(int index, Integer chargeAvalaraTransactionType) {
            this.params.addOpt("charges[avalara_transaction_type][" + index + "]", chargeAvalaraTransactionType);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeAvalaraServiceType(int index, Integer chargeAvalaraServiceType) {
            this.params.addOpt("charges[avalara_service_type][" + index + "]", chargeAvalaraServiceType);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeDateFrom(int index, Timestamp chargeDateFrom) {
            this.params.addOpt("charges[date_from][" + index + "]", chargeDateFrom);
            return this;
        }

        public CheckoutOneTimeForItemsRequest chargeDateTo(int index, Timestamp chargeDateTo) {
            this.params.addOpt("charges[date_to][" + index + "]", chargeDateTo);
            return this;
        }

        public CheckoutOneTimeForItemsRequest discountPercentage(int index, Double discountPercentage) {
            this.params.addOpt("discounts[percentage][" + index + "]", discountPercentage);
            return this;
        }

        public CheckoutOneTimeForItemsRequest discountAmount(int index, Integer discountAmount) {
            this.params.addOpt("discounts[amount][" + index + "]", discountAmount);
            return this;
        }

        public CheckoutOneTimeForItemsRequest discountApplyOn(int index, ApplyOn discountApplyOn) {
            this.params.add("discounts[apply_on][" + index + "]", (Object)discountApplyOn);
            return this;
        }

        public CheckoutOneTimeForItemsRequest discountItemPriceId(int index, String discountItemPriceId) {
            this.params.addOpt("discounts[item_price_id][" + index + "]", discountItemPriceId);
            return this;
        }

        public CheckoutOneTimeForItemsRequest entityIdentifierId(int index, String entityIdentifierId) {
            this.params.addOpt("entity_identifiers[id][" + index + "]", entityIdentifierId);
            return this;
        }

        public CheckoutOneTimeForItemsRequest entityIdentifierScheme(int index, String entityIdentifierScheme) {
            this.params.addOpt("entity_identifiers[scheme][" + index + "]", entityIdentifierScheme);
            return this;
        }

        public CheckoutOneTimeForItemsRequest entityIdentifierValue(int index, String entityIdentifierValue) {
            this.params.addOpt("entity_identifiers[value][" + index + "]", entityIdentifierValue);
            return this;
        }

        public CheckoutOneTimeForItemsRequest entityIdentifierOperation(int index, Operation entityIdentifierOperation) {
            this.params.addOpt("entity_identifiers[operation][" + index + "]", (Object)entityIdentifierOperation);
            return this;
        }

        public CheckoutOneTimeForItemsRequest entityIdentifierStandard(int index, String entityIdentifierStandard) {
            this.params.addOpt("entity_identifiers[standard][" + index + "]", entityIdentifierStandard);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CheckoutOneTimeRequest
    extends Request<CheckoutOneTimeRequest> {
        private CheckoutOneTimeRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CheckoutOneTimeRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CheckoutOneTimeRequest invoiceNote(String invoiceNote) {
            this.params.addOpt("invoice_note", invoiceNote);
            return this;
        }

        @Deprecated
        public CheckoutOneTimeRequest coupon(String coupon) {
            this.params.addOpt("coupon", coupon);
            return this;
        }

        public CheckoutOneTimeRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutOneTimeRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutOneTimeRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CheckoutOneTimeRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public CheckoutOneTimeRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public CheckoutOneTimeRequest embed(Boolean embed) {
            this.params.addOpt("embed", embed);
            return this;
        }

        public CheckoutOneTimeRequest iframeMessaging(Boolean iframeMessaging) {
            this.params.addOpt("iframe_messaging", iframeMessaging);
            return this;
        }

        public CheckoutOneTimeRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        public CheckoutOneTimeRequest customerEmail(String customerEmail) {
            this.params.addOpt("customer[email]", customerEmail);
            return this;
        }

        public CheckoutOneTimeRequest customerFirstName(String customerFirstName) {
            this.params.addOpt("customer[first_name]", customerFirstName);
            return this;
        }

        public CheckoutOneTimeRequest customerLastName(String customerLastName) {
            this.params.addOpt("customer[last_name]", customerLastName);
            return this;
        }

        public CheckoutOneTimeRequest customerCompany(String customerCompany) {
            this.params.addOpt("customer[company]", customerCompany);
            return this;
        }

        public CheckoutOneTimeRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public CheckoutOneTimeRequest customerLocale(String customerLocale) {
            this.params.addOpt("customer[locale]", customerLocale);
            return this;
        }

        public CheckoutOneTimeRequest customerPhone(String customerPhone) {
            this.params.addOpt("customer[phone]", customerPhone);
            return this;
        }

        public CheckoutOneTimeRequest invoicePoNumber(String invoicePoNumber) {
            this.params.addOpt("invoice[po_number]", invoicePoNumber);
            return this;
        }

        @Deprecated
        public CheckoutOneTimeRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CheckoutOneTimeRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        public CheckoutOneTimeRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public CheckoutOneTimeRequest customerVatNumberPrefix(String customerVatNumberPrefix) {
            this.params.addOpt("customer[vat_number_prefix]", customerVatNumberPrefix);
            return this;
        }

        public CheckoutOneTimeRequest customerConsolidatedInvoicing(Boolean customerConsolidatedInvoicing) {
            this.params.addOpt("customer[consolidated_invoicing]", customerConsolidatedInvoicing);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public CheckoutOneTimeRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CheckoutOneTimeRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CheckoutOneTimeRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CheckoutOneTimeRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CheckoutOneTimeRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CheckoutOneTimeRequest addonQuantityInDecimal(int index, String addonQuantityInDecimal) {
            this.params.addOpt("addons[quantity_in_decimal][" + index + "]", addonQuantityInDecimal);
            return this;
        }

        public CheckoutOneTimeRequest addonUnitPriceInDecimal(int index, String addonUnitPriceInDecimal) {
            this.params.addOpt("addons[unit_price_in_decimal][" + index + "]", addonUnitPriceInDecimal);
            return this;
        }

        public CheckoutOneTimeRequest addonDateFrom(int index, Timestamp addonDateFrom) {
            this.params.addOpt("addons[date_from][" + index + "]", addonDateFrom);
            return this;
        }

        public CheckoutOneTimeRequest addonDateTo(int index, Timestamp addonDateTo) {
            this.params.addOpt("addons[date_to][" + index + "]", addonDateTo);
            return this;
        }

        public CheckoutOneTimeRequest chargeAmount(int index, Integer chargeAmount) {
            this.params.addOpt("charges[amount][" + index + "]", chargeAmount);
            return this;
        }

        public CheckoutOneTimeRequest chargeAmountInDecimal(int index, String chargeAmountInDecimal) {
            this.params.addOpt("charges[amount_in_decimal][" + index + "]", chargeAmountInDecimal);
            return this;
        }

        public CheckoutOneTimeRequest chargeDescription(int index, String chargeDescription) {
            this.params.addOpt("charges[description][" + index + "]", chargeDescription);
            return this;
        }

        public CheckoutOneTimeRequest chargeTaxable(int index, Boolean chargeTaxable) {
            this.params.addOpt("charges[taxable][" + index + "]", chargeTaxable);
            return this;
        }

        public CheckoutOneTimeRequest chargeTaxProfileId(int index, String chargeTaxProfileId) {
            this.params.addOpt("charges[tax_profile_id][" + index + "]", chargeTaxProfileId);
            return this;
        }

        public CheckoutOneTimeRequest chargeAvalaraTaxCode(int index, String chargeAvalaraTaxCode) {
            this.params.addOpt("charges[avalara_tax_code][" + index + "]", chargeAvalaraTaxCode);
            return this;
        }

        public CheckoutOneTimeRequest chargeHsnCode(int index, String chargeHsnCode) {
            this.params.addOpt("charges[hsn_code][" + index + "]", chargeHsnCode);
            return this;
        }

        public CheckoutOneTimeRequest chargeTaxjarProductCode(int index, String chargeTaxjarProductCode) {
            this.params.addOpt("charges[taxjar_product_code][" + index + "]", chargeTaxjarProductCode);
            return this;
        }

        public CheckoutOneTimeRequest chargeAvalaraSaleType(int index, AvalaraSaleType chargeAvalaraSaleType) {
            this.params.addOpt("charges[avalara_sale_type][" + index + "]", (Object)chargeAvalaraSaleType);
            return this;
        }

        public CheckoutOneTimeRequest chargeAvalaraTransactionType(int index, Integer chargeAvalaraTransactionType) {
            this.params.addOpt("charges[avalara_transaction_type][" + index + "]", chargeAvalaraTransactionType);
            return this;
        }

        public CheckoutOneTimeRequest chargeAvalaraServiceType(int index, Integer chargeAvalaraServiceType) {
            this.params.addOpt("charges[avalara_service_type][" + index + "]", chargeAvalaraServiceType);
            return this;
        }

        public CheckoutOneTimeRequest chargeDateFrom(int index, Timestamp chargeDateFrom) {
            this.params.addOpt("charges[date_from][" + index + "]", chargeDateFrom);
            return this;
        }

        public CheckoutOneTimeRequest chargeDateTo(int index, Timestamp chargeDateTo) {
            this.params.addOpt("charges[date_to][" + index + "]", chargeDateTo);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class CheckoutNewRequest
    extends Request<CheckoutNewRequest> {
        private CheckoutNewRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CheckoutNewRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CheckoutNewRequest mandatoryAddonsToRemove(List<String> mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CheckoutNewRequest mandatoryAddonsToRemove(String ... mandatoryAddonsToRemove) {
            this.params.addOpt("mandatory_addons_to_remove", mandatoryAddonsToRemove);
            return this;
        }

        public CheckoutNewRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CheckoutNewRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CheckoutNewRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutNewRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CheckoutNewRequest redirectUrl(String redirectUrl) {
            this.params.addOpt("redirect_url", redirectUrl);
            return this;
        }

        public CheckoutNewRequest cancelUrl(String cancelUrl) {
            this.params.addOpt("cancel_url", cancelUrl);
            return this;
        }

        public CheckoutNewRequest passThruContent(String passThruContent) {
            this.params.addOpt("pass_thru_content", passThruContent);
            return this;
        }

        public CheckoutNewRequest embed(Boolean embed) {
            this.params.addOpt("embed", embed);
            return this;
        }

        public CheckoutNewRequest iframeMessaging(Boolean iframeMessaging) {
            this.params.addOpt("iframe_messaging", iframeMessaging);
            return this;
        }

        public CheckoutNewRequest allowOfflinePaymentMethods(Boolean allowOfflinePaymentMethods) {
            this.params.addOpt("allow_offline_payment_methods", allowOfflinePaymentMethods);
            return this;
        }

        public CheckoutNewRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription[id]", subscriptionId);
            return this;
        }

        public CheckoutNewRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        public CheckoutNewRequest customerEmail(String customerEmail) {
            this.params.addOpt("customer[email]", customerEmail);
            return this;
        }

        public CheckoutNewRequest customerFirstName(String customerFirstName) {
            this.params.addOpt("customer[first_name]", customerFirstName);
            return this;
        }

        public CheckoutNewRequest customerLastName(String customerLastName) {
            this.params.addOpt("customer[last_name]", customerLastName);
            return this;
        }

        public CheckoutNewRequest customerCompany(String customerCompany) {
            this.params.addOpt("customer[company]", customerCompany);
            return this;
        }

        public CheckoutNewRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public CheckoutNewRequest customerLocale(String customerLocale) {
            this.params.addOpt("customer[locale]", customerLocale);
            return this;
        }

        public CheckoutNewRequest customerPhone(String customerPhone) {
            this.params.addOpt("customer[phone]", customerPhone);
            return this;
        }

        public CheckoutNewRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.add("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public CheckoutNewRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public CheckoutNewRequest subscriptionPlanQuantityInDecimal(String subscriptionPlanQuantityInDecimal) {
            this.params.addOpt("subscription[plan_quantity_in_decimal]", subscriptionPlanQuantityInDecimal);
            return this;
        }

        public CheckoutNewRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public CheckoutNewRequest subscriptionPlanUnitPriceInDecimal(String subscriptionPlanUnitPriceInDecimal) {
            this.params.addOpt("subscription[plan_unit_price_in_decimal]", subscriptionPlanUnitPriceInDecimal);
            return this;
        }

        public CheckoutNewRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public CheckoutNewRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        public CheckoutNewRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        @Deprecated
        public CheckoutNewRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public CheckoutNewRequest subscriptionAutoCollection(AutoCollection subscriptionAutoCollection) {
            this.params.addOpt("subscription[auto_collection]", (Object)subscriptionAutoCollection);
            return this;
        }

        public CheckoutNewRequest subscriptionOfflinePaymentMethod(OfflinePaymentMethod subscriptionOfflinePaymentMethod) {
            this.params.addOpt("subscription[offline_payment_method]", (Object)subscriptionOfflinePaymentMethod);
            return this;
        }

        public CheckoutNewRequest subscriptionInvoiceNotes(String subscriptionInvoiceNotes) {
            this.params.addOpt("subscription[invoice_notes]", subscriptionInvoiceNotes);
            return this;
        }

        @Deprecated
        public CheckoutNewRequest cardGateway(Gateway cardGateway) {
            this.params.addOpt("card[gateway]", (Object)cardGateway);
            return this;
        }

        public CheckoutNewRequest cardGatewayAccountId(String cardGatewayAccountId) {
            this.params.addOpt("card[gateway_account_id]", cardGatewayAccountId);
            return this;
        }

        public CheckoutNewRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public CheckoutNewRequest customerVatNumberPrefix(String customerVatNumberPrefix) {
            this.params.addOpt("customer[vat_number_prefix]", customerVatNumberPrefix);
            return this;
        }

        public CheckoutNewRequest customerConsolidatedInvoicing(Boolean customerConsolidatedInvoicing) {
            this.params.addOpt("customer[consolidated_invoicing]", customerConsolidatedInvoicing);
            return this;
        }

        public CheckoutNewRequest billingAddressFirstName(String billingAddressFirstName) {
            this.params.addOpt("billing_address[first_name]", billingAddressFirstName);
            return this;
        }

        public CheckoutNewRequest billingAddressLastName(String billingAddressLastName) {
            this.params.addOpt("billing_address[last_name]", billingAddressLastName);
            return this;
        }

        public CheckoutNewRequest billingAddressEmail(String billingAddressEmail) {
            this.params.addOpt("billing_address[email]", billingAddressEmail);
            return this;
        }

        public CheckoutNewRequest billingAddressCompany(String billingAddressCompany) {
            this.params.addOpt("billing_address[company]", billingAddressCompany);
            return this;
        }

        public CheckoutNewRequest billingAddressPhone(String billingAddressPhone) {
            this.params.addOpt("billing_address[phone]", billingAddressPhone);
            return this;
        }

        public CheckoutNewRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public CheckoutNewRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public CheckoutNewRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public CheckoutNewRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public CheckoutNewRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public CheckoutNewRequest billingAddressState(String billingAddressState) {
            this.params.addOpt("billing_address[state]", billingAddressState);
            return this;
        }

        public CheckoutNewRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public CheckoutNewRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public CheckoutNewRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public CheckoutNewRequest shippingAddressFirstName(String shippingAddressFirstName) {
            this.params.addOpt("shipping_address[first_name]", shippingAddressFirstName);
            return this;
        }

        public CheckoutNewRequest shippingAddressLastName(String shippingAddressLastName) {
            this.params.addOpt("shipping_address[last_name]", shippingAddressLastName);
            return this;
        }

        public CheckoutNewRequest shippingAddressEmail(String shippingAddressEmail) {
            this.params.addOpt("shipping_address[email]", shippingAddressEmail);
            return this;
        }

        public CheckoutNewRequest shippingAddressCompany(String shippingAddressCompany) {
            this.params.addOpt("shipping_address[company]", shippingAddressCompany);
            return this;
        }

        public CheckoutNewRequest shippingAddressPhone(String shippingAddressPhone) {
            this.params.addOpt("shipping_address[phone]", shippingAddressPhone);
            return this;
        }

        public CheckoutNewRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CheckoutNewRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CheckoutNewRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CheckoutNewRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CheckoutNewRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CheckoutNewRequest shippingAddressState(String shippingAddressState) {
            this.params.addOpt("shipping_address[state]", shippingAddressState);
            return this;
        }

        public CheckoutNewRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CheckoutNewRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CheckoutNewRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CheckoutNewRequest subscriptionAffiliateToken(String subscriptionAffiliateToken) {
            this.params.addOpt("subscription[affiliate_token]", subscriptionAffiliateToken);
            return this;
        }

        public CheckoutNewRequest contractTermActionAtTermEnd(ContractTerm.ActionAtTermEnd contractTermActionAtTermEnd) {
            this.params.addOpt("contract_term[action_at_term_end]", (Object)contractTermActionAtTermEnd);
            return this;
        }

        public CheckoutNewRequest contractTermCancellationCutoffPeriod(Integer contractTermCancellationCutoffPeriod) {
            this.params.addOpt("contract_term[cancellation_cutoff_period]", contractTermCancellationCutoffPeriod);
            return this;
        }

        public CheckoutNewRequest subscriptionContractTermBillingCycleOnRenewal(Integer subscriptionContractTermBillingCycleOnRenewal) {
            this.params.addOpt("subscription[contract_term_billing_cycle_on_renewal]", subscriptionContractTermBillingCycleOnRenewal);
            return this;
        }

        public CheckoutNewRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CheckoutNewRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CheckoutNewRequest addonQuantityInDecimal(int index, String addonQuantityInDecimal) {
            this.params.addOpt("addons[quantity_in_decimal][" + index + "]", addonQuantityInDecimal);
            return this;
        }

        public CheckoutNewRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CheckoutNewRequest addonUnitPriceInDecimal(int index, String addonUnitPriceInDecimal) {
            this.params.addOpt("addons[unit_price_in_decimal][" + index + "]", addonUnitPriceInDecimal);
            return this;
        }

        public CheckoutNewRequest addonBillingCycles(int index, Integer addonBillingCycles) {
            this.params.addOpt("addons[billing_cycles][" + index + "]", addonBillingCycles);
            return this;
        }

        public CheckoutNewRequest eventBasedAddonId(int index, String eventBasedAddonId) {
            this.params.addOpt("event_based_addons[id][" + index + "]", eventBasedAddonId);
            return this;
        }

        public CheckoutNewRequest eventBasedAddonQuantity(int index, Integer eventBasedAddonQuantity) {
            this.params.addOpt("event_based_addons[quantity][" + index + "]", eventBasedAddonQuantity);
            return this;
        }

        public CheckoutNewRequest eventBasedAddonUnitPrice(int index, Integer eventBasedAddonUnitPrice) {
            this.params.addOpt("event_based_addons[unit_price][" + index + "]", eventBasedAddonUnitPrice);
            return this;
        }

        public CheckoutNewRequest eventBasedAddonQuantityInDecimal(int index, String eventBasedAddonQuantityInDecimal) {
            this.params.addOpt("event_based_addons[quantity_in_decimal][" + index + "]", eventBasedAddonQuantityInDecimal);
            return this;
        }

        public CheckoutNewRequest eventBasedAddonUnitPriceInDecimal(int index, String eventBasedAddonUnitPriceInDecimal) {
            this.params.addOpt("event_based_addons[unit_price_in_decimal][" + index + "]", eventBasedAddonUnitPriceInDecimal);
            return this;
        }

        public CheckoutNewRequest eventBasedAddonServicePeriodInDays(int index, Integer eventBasedAddonServicePeriodInDays) {
            this.params.addOpt("event_based_addons[service_period_in_days][" + index + "]", eventBasedAddonServicePeriodInDays);
            return this;
        }

        public CheckoutNewRequest eventBasedAddonOnEvent(int index, OnEvent eventBasedAddonOnEvent) {
            this.params.addOpt("event_based_addons[on_event][" + index + "]", (Object)eventBasedAddonOnEvent);
            return this;
        }

        public CheckoutNewRequest eventBasedAddonChargeOnce(int index, Boolean eventBasedAddonChargeOnce) {
            this.params.addOpt("event_based_addons[charge_once][" + index + "]", eventBasedAddonChargeOnce);
            return this;
        }

        public CheckoutNewRequest eventBasedAddonChargeOn(int index, ChargeOn eventBasedAddonChargeOn) {
            this.params.addOpt("event_based_addons[charge_on][" + index + "]", (Object)eventBasedAddonChargeOn);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class Content
    extends ResultBase {
        public Content(JSONObject jsonObj) {
            super(jsonObj);
        }
    }

    @Deprecated
    public static enum FailureReason {
        CARD_ERROR,
        SERVER_ERROR,
        _UNKNOWN;

    }

    public static enum State {
        CREATED,
        REQUESTED,
        SUCCEEDED,
        CANCELLED,
        FAILED,
        ACKNOWLEDGED,
        _UNKNOWN;

    }

    public static enum Type {
        CHECKOUT_NEW,
        CHECKOUT_EXISTING,
        UPDATE_CARD,
        UPDATE_PAYMENT_METHOD,
        MANAGE_PAYMENT_SOURCES,
        COLLECT_NOW,
        EXTEND_SUBSCRIPTION,
        CHECKOUT_GIFT,
        CLAIM_GIFT,
        CHECKOUT_ONE_TIME,
        PRE_CANCEL,
        _UNKNOWN;

    }
}

