/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

public class InAppSubscription
extends Resource<InAppSubscription> {
    public InAppSubscription(String jsonStr) {
        super(jsonStr);
    }

    public InAppSubscription(JSONObject jsonObj) {
        super(jsonObj);
    }

    @Deprecated
    public String appId() {
        return this.reqString("app_id");
    }

    public String subscriptionId() {
        return this.reqString("subscription_id");
    }

    public String customerId() {
        return this.optString("customer_id");
    }

    public String planId() {
        return this.optString("plan_id");
    }

    public StoreStatus storeStatus() {
        return this.optEnum("store_status", StoreStatus.class);
    }

    public String invoiceId() {
        return this.optString("invoice_id");
    }

    public static ProcessReceiptRequest processReceipt(String id) {
        String uri = InAppSubscription.uri("in_app_subscriptions", InAppSubscription.nullCheck(id), "process_purchase_command");
        return new ProcessReceiptRequest(HttpUtil.Method.POST, uri);
    }

    public static ImportReceiptRequest importReceipt(String id) {
        String uri = InAppSubscription.uri("in_app_subscriptions", InAppSubscription.nullCheck(id), "import_receipt");
        return new ImportReceiptRequest(HttpUtil.Method.POST, uri);
    }

    public static ImportSubscriptionRequest importSubscription(String id) {
        String uri = InAppSubscription.uri("in_app_subscriptions", InAppSubscription.nullCheck(id), "import_subscription");
        return new ImportSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static RetrieveStoreSubsRequest retrieveStoreSubs(String id) {
        String uri = InAppSubscription.uri("in_app_subscriptions", InAppSubscription.nullCheck(id), "retrieve");
        return new RetrieveStoreSubsRequest(HttpUtil.Method.POST, uri);
    }

    public static class RetrieveStoreSubsRequest
    extends Request<RetrieveStoreSubsRequest> {
        private RetrieveStoreSubsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RetrieveStoreSubsRequest receipt(String receipt) {
            this.params.add("receipt", receipt);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ImportSubscriptionRequest
    extends Request<ImportSubscriptionRequest> {
        private ImportSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ImportSubscriptionRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription[id]", subscriptionId);
            return this;
        }

        public ImportSubscriptionRequest subscriptionStartedAt(Timestamp subscriptionStartedAt) {
            this.params.add("subscription[started_at]", subscriptionStartedAt);
            return this;
        }

        public ImportSubscriptionRequest subscriptionTermStart(Timestamp subscriptionTermStart) {
            this.params.add("subscription[term_start]", subscriptionTermStart);
            return this;
        }

        public ImportSubscriptionRequest subscriptionTermEnd(Timestamp subscriptionTermEnd) {
            this.params.add("subscription[term_end]", subscriptionTermEnd);
            return this;
        }

        public ImportSubscriptionRequest subscriptionProductId(String subscriptionProductId) {
            this.params.add("subscription[product_id]", subscriptionProductId);
            return this;
        }

        public ImportSubscriptionRequest subscriptionCurrencyCode(String subscriptionCurrencyCode) {
            this.params.add("subscription[currency_code]", subscriptionCurrencyCode);
            return this;
        }

        public ImportSubscriptionRequest subscriptionTransactionId(String subscriptionTransactionId) {
            this.params.add("subscription[transaction_id]", subscriptionTransactionId);
            return this;
        }

        public ImportSubscriptionRequest subscriptionIsTrial(Boolean subscriptionIsTrial) {
            this.params.addOpt("subscription[is_trial]", subscriptionIsTrial);
            return this;
        }

        public ImportSubscriptionRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        public ImportSubscriptionRequest customerEmail(String customerEmail) {
            this.params.addOpt("customer[email]", customerEmail);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ImportReceiptRequest
    extends Request<ImportReceiptRequest> {
        private ImportReceiptRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ImportReceiptRequest receipt(String receipt) {
            this.params.add("receipt", receipt);
            return this;
        }

        public ImportReceiptRequest productCurrencyCode(String productCurrencyCode) {
            this.params.add("product[currency_code]", productCurrencyCode);
            return this;
        }

        public ImportReceiptRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        public ImportReceiptRequest customerEmail(String customerEmail) {
            this.params.addOpt("customer[email]", customerEmail);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ProcessReceiptRequest
    extends Request<ProcessReceiptRequest> {
        private ProcessReceiptRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ProcessReceiptRequest receipt(String receipt) {
            this.params.add("receipt", receipt);
            return this;
        }

        public ProcessReceiptRequest productId(String productId) {
            this.params.add("product[id]", productId);
            return this;
        }

        public ProcessReceiptRequest productCurrencyCode(String productCurrencyCode) {
            this.params.add("product[currency_code]", productCurrencyCode);
            return this;
        }

        public ProcessReceiptRequest productPrice(Integer productPrice) {
            this.params.add("product[price]", productPrice);
            return this;
        }

        public ProcessReceiptRequest productName(String productName) {
            this.params.addOpt("product[name]", productName);
            return this;
        }

        public ProcessReceiptRequest productPriceInDecimal(String productPriceInDecimal) {
            this.params.addOpt("product[price_in_decimal]", productPriceInDecimal);
            return this;
        }

        public ProcessReceiptRequest productPeriod(String productPeriod) {
            this.params.addOpt("product[period]", productPeriod);
            return this;
        }

        public ProcessReceiptRequest productPeriodUnit(String productPeriodUnit) {
            this.params.addOpt("product[period_unit]", productPeriodUnit);
            return this;
        }

        public ProcessReceiptRequest customerId(String customerId) {
            this.params.addOpt("customer[id]", customerId);
            return this;
        }

        public ProcessReceiptRequest customerEmail(String customerEmail) {
            this.params.addOpt("customer[email]", customerEmail);
            return this;
        }

        public ProcessReceiptRequest customerFirstName(String customerFirstName) {
            this.params.addOpt("customer[first_name]", customerFirstName);
            return this;
        }

        public ProcessReceiptRequest customerLastName(String customerLastName) {
            this.params.addOpt("customer[last_name]", customerLastName);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static enum StoreStatus {
        IN_TRIAL,
        ACTIVE,
        CANCELLED,
        _UNKNOWN;

    }
}

