/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.CreditNoteEstimate;
import com.chargebee.models.InvoiceEstimate;
import com.chargebee.models.SubscriptionEstimate;
import com.chargebee.models.UnbilledCharge;
import com.chargebee.models.enums.BillingAlignmentMode;
import com.chargebee.models.enums.EntityCode;
import com.chargebee.models.enums.Taxability;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Estimate
extends Resource<Estimate> {
    public Estimate(String jsonStr) {
        super(jsonStr);
    }

    public Estimate(JSONObject jsonObj) {
        super(jsonObj);
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public SubscriptionEstimate subscriptionEstimate() {
        return this.optSubResource("subscription_estimate", SubscriptionEstimate.class);
    }

    public InvoiceEstimate invoiceEstimate() {
        return this.optSubResource("invoice_estimate", InvoiceEstimate.class);
    }

    public List<InvoiceEstimate> invoiceEstimates() {
        return this.optList("invoice_estimates", InvoiceEstimate.class);
    }

    public InvoiceEstimate nextInvoiceEstimate() {
        return this.optSubResource("next_invoice_estimate", InvoiceEstimate.class);
    }

    public List<CreditNoteEstimate> creditNoteEstimates() {
        return this.optList("credit_note_estimates", CreditNoteEstimate.class);
    }

    public List<UnbilledCharge> unbilledChargeEstimates() {
        return this.optList("unbilled_charge_estimates", UnbilledCharge.class);
    }

    public static CreateSubscriptionRequest createSubscription() throws IOException {
        String uri = Estimate.uri("estimates", "create_subscription");
        return new CreateSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static CreateSubForCustomerEstimateRequest createSubForCustomerEstimate(String id) throws IOException {
        String uri = Estimate.uri("customers", Estimate.nullCheck(id), "create_subscription_estimate");
        return new CreateSubForCustomerEstimateRequest(HttpUtil.Method.GET, uri);
    }

    public static UpdateSubscriptionRequest updateSubscription() throws IOException {
        String uri = Estimate.uri("estimates", "update_subscription");
        return new UpdateSubscriptionRequest(HttpUtil.Method.POST, uri);
    }

    public static RenewalEstimateRequest renewalEstimate(String id) throws IOException {
        String uri = Estimate.uri("subscriptions", Estimate.nullCheck(id), "renewal_estimate");
        return new RenewalEstimateRequest(HttpUtil.Method.GET, uri);
    }

    public static Request upcomingInvoicesEstimate(String id) throws IOException {
        String uri = Estimate.uri("customers", Estimate.nullCheck(id), "upcoming_invoices_estimate");
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static ChangeTermEndRequest changeTermEnd(String id) throws IOException {
        String uri = Estimate.uri("subscriptions", Estimate.nullCheck(id), "change_term_end_estimate");
        return new ChangeTermEndRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeTermEndRequest
    extends Request<ChangeTermEndRequest> {
        private ChangeTermEndRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public ChangeTermEndRequest termEndsAt(Timestamp termEndsAt) {
            this.params.addOpt("term_ends_at", termEndsAt);
            return this;
        }

        public ChangeTermEndRequest prorate(Boolean prorate) {
            this.params.addOpt("prorate", prorate);
            return this;
        }

        public ChangeTermEndRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenewalEstimateRequest
    extends Request<RenewalEstimateRequest> {
        private RenewalEstimateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RenewalEstimateRequest includeDelayedCharges(Boolean includeDelayedCharges) {
            this.params.addOpt("include_delayed_charges", includeDelayedCharges);
            return this;
        }

        public RenewalEstimateRequest useExistingBalances(Boolean useExistingBalances) {
            this.params.addOpt("use_existing_balances", useExistingBalances);
            return this;
        }

        public RenewalEstimateRequest ignoreScheduledCancellation(Boolean ignoreScheduledCancellation) {
            this.params.addOpt("ignore_scheduled_cancellation", ignoreScheduledCancellation);
            return this;
        }

        public RenewalEstimateRequest ignoreScheduledChanges(Boolean ignoreScheduledChanges) {
            this.params.addOpt("ignore_scheduled_changes", ignoreScheduledChanges);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateSubscriptionRequest
    extends Request<UpdateSubscriptionRequest> {
        private UpdateSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateSubscriptionRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public UpdateSubscriptionRequest replaceAddonList(Boolean replaceAddonList) {
            this.params.addOpt("replace_addon_list", replaceAddonList);
            return this;
        }

        public UpdateSubscriptionRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public UpdateSubscriptionRequest reactivateFrom(Timestamp reactivateFrom) {
            this.params.addOpt("reactivate_from", reactivateFrom);
            return this;
        }

        public UpdateSubscriptionRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public UpdateSubscriptionRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public UpdateSubscriptionRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public UpdateSubscriptionRequest replaceCouponList(Boolean replaceCouponList) {
            this.params.addOpt("replace_coupon_list", replaceCouponList);
            return this;
        }

        public UpdateSubscriptionRequest prorate(Boolean prorate) {
            this.params.addOpt("prorate", prorate);
            return this;
        }

        public UpdateSubscriptionRequest endOfTerm(Boolean endOfTerm) {
            this.params.addOpt("end_of_term", endOfTerm);
            return this;
        }

        public UpdateSubscriptionRequest forceTermReset(Boolean forceTermReset) {
            this.params.addOpt("force_term_reset", forceTermReset);
            return this;
        }

        public UpdateSubscriptionRequest reactivate(Boolean reactivate) {
            this.params.addOpt("reactivate", reactivate);
            return this;
        }

        public UpdateSubscriptionRequest includeDelayedCharges(Boolean includeDelayedCharges) {
            this.params.addOpt("include_delayed_charges", includeDelayedCharges);
            return this;
        }

        public UpdateSubscriptionRequest useExistingBalances(Boolean useExistingBalances) {
            this.params.addOpt("use_existing_balances", useExistingBalances);
            return this;
        }

        public UpdateSubscriptionRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription[id]", subscriptionId);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.addOpt("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public UpdateSubscriptionRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        @Deprecated
        public UpdateSubscriptionRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public UpdateSubscriptionRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public UpdateSubscriptionRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public UpdateSubscriptionRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        @Deprecated
        public UpdateSubscriptionRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public UpdateSubscriptionRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public UpdateSubscriptionRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public UpdateSubscriptionRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public UpdateSubscriptionRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateSubForCustomerEstimateRequest
    extends Request<CreateSubForCustomerEstimateRequest> {
        private CreateSubForCustomerEstimateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateSubForCustomerEstimateRequest useExistingBalances(Boolean useExistingBalances) {
            this.params.addOpt("use_existing_balances", useExistingBalances);
            return this;
        }

        public CreateSubForCustomerEstimateRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        public CreateSubForCustomerEstimateRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateSubForCustomerEstimateRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CreateSubForCustomerEstimateRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CreateSubForCustomerEstimateRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateSubForCustomerEstimateRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription[id]", subscriptionId);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.add("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public CreateSubForCustomerEstimateRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateSubForCustomerEstimateRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateSubForCustomerEstimateRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateSubForCustomerEstimateRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateSubForCustomerEstimateRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CreateSubForCustomerEstimateRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateSubscriptionRequest
    extends Request<CreateSubscriptionRequest> {
        private CreateSubscriptionRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateSubscriptionRequest billingCycles(Integer billingCycles) {
            this.params.addOpt("billing_cycles", billingCycles);
            return this;
        }

        public CreateSubscriptionRequest termsToCharge(Integer termsToCharge) {
            this.params.addOpt("terms_to_charge", termsToCharge);
            return this;
        }

        public CreateSubscriptionRequest billingAlignmentMode(BillingAlignmentMode billingAlignmentMode) {
            this.params.addOpt("billing_alignment_mode", (Object)billingAlignmentMode);
            return this;
        }

        public CreateSubscriptionRequest couponIds(List<String> couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateSubscriptionRequest couponIds(String ... couponIds) {
            this.params.addOpt("coupon_ids", couponIds);
            return this;
        }

        public CreateSubscriptionRequest invoiceImmediately(Boolean invoiceImmediately) {
            this.params.addOpt("invoice_immediately", invoiceImmediately);
            return this;
        }

        public CreateSubscriptionRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription[id]", subscriptionId);
            return this;
        }

        public CreateSubscriptionRequest subscriptionPlanId(String subscriptionPlanId) {
            this.params.add("subscription[plan_id]", subscriptionPlanId);
            return this;
        }

        public CreateSubscriptionRequest subscriptionPlanQuantity(Integer subscriptionPlanQuantity) {
            this.params.addOpt("subscription[plan_quantity]", subscriptionPlanQuantity);
            return this;
        }

        public CreateSubscriptionRequest subscriptionPlanUnitPrice(Integer subscriptionPlanUnitPrice) {
            this.params.addOpt("subscription[plan_unit_price]", subscriptionPlanUnitPrice);
            return this;
        }

        public CreateSubscriptionRequest subscriptionSetupFee(Integer subscriptionSetupFee) {
            this.params.addOpt("subscription[setup_fee]", subscriptionSetupFee);
            return this;
        }

        public CreateSubscriptionRequest subscriptionStartDate(Timestamp subscriptionStartDate) {
            this.params.addOpt("subscription[start_date]", subscriptionStartDate);
            return this;
        }

        public CreateSubscriptionRequest subscriptionTrialEnd(Timestamp subscriptionTrialEnd) {
            this.params.addOpt("subscription[trial_end]", subscriptionTrialEnd);
            return this;
        }

        @Deprecated
        public CreateSubscriptionRequest subscriptionCoupon(String subscriptionCoupon) {
            this.params.addOpt("subscription[coupon]", subscriptionCoupon);
            return this;
        }

        public CreateSubscriptionRequest billingAddressLine1(String billingAddressLine1) {
            this.params.addOpt("billing_address[line1]", billingAddressLine1);
            return this;
        }

        public CreateSubscriptionRequest billingAddressLine2(String billingAddressLine2) {
            this.params.addOpt("billing_address[line2]", billingAddressLine2);
            return this;
        }

        public CreateSubscriptionRequest billingAddressLine3(String billingAddressLine3) {
            this.params.addOpt("billing_address[line3]", billingAddressLine3);
            return this;
        }

        public CreateSubscriptionRequest billingAddressCity(String billingAddressCity) {
            this.params.addOpt("billing_address[city]", billingAddressCity);
            return this;
        }

        public CreateSubscriptionRequest billingAddressStateCode(String billingAddressStateCode) {
            this.params.addOpt("billing_address[state_code]", billingAddressStateCode);
            return this;
        }

        public CreateSubscriptionRequest billingAddressZip(String billingAddressZip) {
            this.params.addOpt("billing_address[zip]", billingAddressZip);
            return this;
        }

        public CreateSubscriptionRequest billingAddressCountry(String billingAddressCountry) {
            this.params.addOpt("billing_address[country]", billingAddressCountry);
            return this;
        }

        public CreateSubscriptionRequest billingAddressValidationStatus(ValidationStatus billingAddressValidationStatus) {
            this.params.addOpt("billing_address[validation_status]", (Object)billingAddressValidationStatus);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressLine1(String shippingAddressLine1) {
            this.params.addOpt("shipping_address[line1]", shippingAddressLine1);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressLine2(String shippingAddressLine2) {
            this.params.addOpt("shipping_address[line2]", shippingAddressLine2);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressLine3(String shippingAddressLine3) {
            this.params.addOpt("shipping_address[line3]", shippingAddressLine3);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressCity(String shippingAddressCity) {
            this.params.addOpt("shipping_address[city]", shippingAddressCity);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressStateCode(String shippingAddressStateCode) {
            this.params.addOpt("shipping_address[state_code]", shippingAddressStateCode);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressZip(String shippingAddressZip) {
            this.params.addOpt("shipping_address[zip]", shippingAddressZip);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressCountry(String shippingAddressCountry) {
            this.params.addOpt("shipping_address[country]", shippingAddressCountry);
            return this;
        }

        public CreateSubscriptionRequest shippingAddressValidationStatus(ValidationStatus shippingAddressValidationStatus) {
            this.params.addOpt("shipping_address[validation_status]", (Object)shippingAddressValidationStatus);
            return this;
        }

        public CreateSubscriptionRequest customerVatNumber(String customerVatNumber) {
            this.params.addOpt("customer[vat_number]", customerVatNumber);
            return this;
        }

        public CreateSubscriptionRequest customerTaxability(Taxability customerTaxability) {
            this.params.addOpt("customer[taxability]", (Object)customerTaxability);
            return this;
        }

        public CreateSubscriptionRequest customerEntityCode(EntityCode customerEntityCode) {
            this.params.addOpt("customer[entity_code]", (Object)customerEntityCode);
            return this;
        }

        public CreateSubscriptionRequest customerExemptNumber(String customerExemptNumber) {
            this.params.addOpt("customer[exempt_number]", customerExemptNumber);
            return this;
        }

        public CreateSubscriptionRequest addonId(int index, String addonId) {
            this.params.addOpt("addons[id][" + index + "]", addonId);
            return this;
        }

        public CreateSubscriptionRequest addonQuantity(int index, Integer addonQuantity) {
            this.params.addOpt("addons[quantity][" + index + "]", addonQuantity);
            return this;
        }

        public CreateSubscriptionRequest addonUnitPrice(int index, Integer addonUnitPrice) {
            this.params.addOpt("addons[unit_price][" + index + "]", addonUnitPrice);
            return this;
        }

        public CreateSubscriptionRequest addonTrialEnd(int index, Timestamp addonTrialEnd) {
            this.params.addOpt("addons[trial_end][" + index + "]", addonTrialEnd);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }
}

