/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.internal;

import com.chargebee.gdata.PercentEscaper;
import com.chargebee.internal.ClazzUtil;
import com.chargebee.org.json.JSONArray;
import com.chargebee.org.json.JSONException;
import com.chargebee.org.json.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource<T> {
    private static final Logger logger = Logger.getLogger(Resource.class.getName());
    public JSONObject jsonObj;
    private static final String unknown = "_UNKNOWN";

    public Resource(JSONObject jsonObj) {
        this.jsonObj = jsonObj;
    }

    public Resource(String jsonStr) {
        try {
            this.jsonObj = new JSONObject(jsonStr);
        }
        catch (JSONException jexp) {
            throw new RuntimeException(jexp);
        }
    }

    public Resource(InputStream is) throws IOException {
        this(new BufferedReader(new InputStreamReader(is)));
    }

    public Resource(BufferedReader rd) throws IOException {
        this(Resource.getAsString(rd));
    }

    private static String getAsString(BufferedReader rd) throws IOException {
        StringBuilder buf = new StringBuilder();
        String line = null;
        while ((line = rd.readLine()) != null) {
            buf.append(line);
        }
        return buf.toString();
    }

    public String reqString(String key) {
        return this.assertReqProp(key, this.optString(key));
    }

    public String optString(String key) {
        return this.optional(key, String.class);
    }

    public Boolean reqBoolean(String key) {
        return this.assertReqProp(key, this.optBoolean(key));
    }

    public Boolean optBoolean(String key) {
        return this.optional(key, Boolean.class);
    }

    public Integer reqInteger(String key) {
        return this.assertReqProp(key, this.optInteger(key));
    }

    public Integer optInteger(String key) {
        Integer value = this.optional(key, Integer.class);
        try {
            return value != null ? value : null;
        }
        catch (Exception ex) {
            throw this.conversionException(key);
        }
    }

    public BigDecimal reqBigDecimal(String key) {
        return this.assertReqProp(key, this.optBigDecimal(key));
    }

    public BigDecimal optBigDecimal(String key) {
        BigDecimal value = this.optional(key, BigDecimal.class);
        try {
            return value != null ? value : null;
        }
        catch (Exception ex) {
            throw this.conversionException(key);
        }
    }

    public Double reqDouble(String key) {
        return this.assertReqProp(key, this.optDouble(key));
    }

    public Double optDouble(String key) {
        Double value = this.optional(key, Double.class);
        try {
            return value != null ? value : null;
        }
        catch (Exception ex) {
            throw this.conversionException(key);
        }
    }

    public Long reqLong(String key) {
        return this.assertReqProp(key, this.optLong(key));
    }

    public Long optLong(String key) {
        Object val = this.jsonObj.opt(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof Integer) {
            return ((Integer)val).longValue();
        }
        throw new RuntimeException("Wrong type. Expecing Long type but got " + val.getClass().getSimpleName());
    }

    public JSONObject reqJSONObject(String key) {
        return this.assertReqProp(key, this.optJSONObject(key));
    }

    public JSONObject optJSONObject(String key) {
        return this.optional(key, JSONObject.class);
    }

    public Timestamp reqTimestamp(String key) {
        return this.assertReqProp(key, this.optTimestamp(key));
    }

    public Timestamp optTimestamp(String key) {
        Integer unxTime = this.optional(key, Integer.class);
        return unxTime != null ? new Timestamp((long)unxTime.intValue() * 1000L) : null;
    }

    public <E extends Enum> E reqEnum(String key, Class<E> enumClass) {
        return (E)((Enum)this.assertReqProp(key, this.optEnum(key, enumClass)));
    }

    public <E extends Enum> E optEnum(String key, Class<E> enumClass) {
        String value = this.optString(key);
        if (value == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass, value.toUpperCase());
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, " The property {0} has unexpected value {1}", new Object[]{key, value});
            return Enum.valueOf(enumClass, unknown);
        }
    }

    public <S extends Resource> List<S> reqList(String key, Class<S> claz) {
        List<S> list = this.optList(key, claz);
        if (list.isEmpty()) {
            throw new RuntimeException("The sub-resource [" + key + "] is not present");
        }
        return list;
    }

    public <S> List<S> optList(String key, Class<S> claz) {
        JSONArray arr = this.jsonObj.optJSONArray(key);
        if (arr == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> toRet = new ArrayList<String>(arr.length());
        for (int i = 0; i < arr.length(); ++i) {
            if (claz == String.class) {
                toRet.add(arr.optString(i));
                continue;
            }
            if (Number.class.isAssignableFrom(claz)) {
                String s = arr.optString(i);
                if (s == null) {
                    toRet.add(null);
                    continue;
                }
                toRet.add((String)ClazzUtil.createNumberInstance(claz, s));
                continue;
            }
            JSONObject json = arr.optJSONObject(i);
            toRet.add((String)ClazzUtil.createInstance(claz, json));
        }
        return toRet;
    }

    public <S extends Resource> S reqSubResource(String key, Class<S> claz) {
        return (S)((Resource)this.assertReqProp(key, this.optSubResource(key, claz)));
    }

    public <S extends Resource> S optSubResource(String key, Class<S> claz) {
        JSONObject resAsJson = this.jsonObj.optJSONObject(key);
        if (resAsJson == null) {
            return null;
        }
        return (S)((Resource)ClazzUtil.createInstance(claz, resAsJson));
    }

    private <T> T optional(String key, Class<T> type) {
        Object val = this.jsonObj.opt(key);
        if (val == null) {
            return null;
        }
        if (!type.isAssignableFrom(val.getClass())) {
            if (BigDecimal.class == type && val instanceof Number) {
                return (T)new BigDecimal(String.valueOf(val));
            }
            if (Double.class == type && val instanceof Number) {
                return (T)new Double(((Number)val).doubleValue());
            }
            if (Float.class == type && val instanceof Number) {
                return (T)new Float(((Number)val).floatValue());
            }
            throw new RuntimeException("Type mismatch for property " + key + " . Expected " + type.getName() + " but contains " + val.getClass().getName());
        }
        return (T)val;
    }

    public String toJson() {
        return this.jsonObj.toString();
    }

    public String toString() {
        try {
            return this.jsonObj.toString(2);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    private <T> T assertReqProp(String key, T val) {
        if (val == null) {
            throw new RuntimeException("The property [" + key + "] is not present ");
        }
        return val;
    }

    private RuntimeException conversionException(String key) {
        return new RuntimeException("The property " + key + " not in the required format");
    }

    protected static String nullCheck(String id) {
        if (id == null || id.isEmpty()) {
            throw new RuntimeException("id cannot be null/empty");
        }
        return id;
    }

    protected static String uri(String ... paths) {
        StringBuilder strBuf = new StringBuilder();
        for (String path : paths) {
            try {
                strBuf.append('/').append(new PercentEscaper("-_.!~*'()@:$&,;=", false).escape(path));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return strBuf.toString();
    }

    protected static void apiVersionCheck(JSONObject jsonObj) {
        if (!jsonObj.has("api_version")) {
            return;
        }
        String apiVersion = jsonObj.optString("api_version");
        if (apiVersion != null && !jsonObj.optString("api_version").equalsIgnoreCase("v2")) {
            throw new RuntimeException("API version [" + apiVersion.toUpperCase() + "] in response does not match " + "with client library API version [" + "v2".toUpperCase() + "]");
        }
    }
}

