/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.internal;

import com.chargebee.APIException;
import com.chargebee.Environment;
import com.chargebee.ListResult;
import com.chargebee.Result;
import com.chargebee.exceptions.InvalidRequestException;
import com.chargebee.exceptions.OperationFailedException;
import com.chargebee.exceptions.PaymentException;
import com.chargebee.internal.Params;
import com.chargebee.internal.StringJoiner;
import com.chargebee.org.apache.commons.codec.binary.Base64;
import com.chargebee.org.json.JSONException;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class HttpUtil {
    public static Result get(String url, Params params, Map<String, String> headers, Environment env) throws IOException {
        if (params != null && !params.isEmpty()) {
            url = url + '?' + HttpUtil.toQueryStr(params);
        }
        HttpURLConnection conn = HttpUtil.createConnection(url, Method.GET, headers, env);
        Resp resp = HttpUtil.sendRequest(conn);
        return resp.toResult();
    }

    public static ListResult getList(String url, Params params, Map<String, String> headers, Environment env) throws IOException {
        if (params != null && !params.isEmpty()) {
            url = url + '?' + HttpUtil.toQueryStr(params, true);
        }
        HttpURLConnection conn = HttpUtil.createConnection(url, Method.GET, headers, env);
        Resp resp = HttpUtil.sendRequest(conn);
        return resp.toListResult();
    }

    public static Result post(String url, Params params, Map<String, String> headers, Environment env) throws IOException {
        return HttpUtil.doFormSubmit(url, Method.POST, HttpUtil.toQueryStr(params), headers, env);
    }

    public static String toQueryStr(Params map) {
        return HttpUtil.toQueryStr(map, false);
    }

    public static String toQueryStr(Params map, boolean isListReq) {
        StringJoiner buf = new StringJoiner("&");
        for (Map.Entry<String, Object> entry : map.entries()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                List l = (List)value;
                if (isListReq) {
                    String keyValPair = HttpUtil.enc(entry.getKey()) + "=" + HttpUtil.enc(l.isEmpty() ? "" : l.toString());
                    buf.add(keyValPair);
                    continue;
                }
                for (int i = 0; i < l.size(); ++i) {
                    String val = (String)l.get(i);
                    String keyValPair = HttpUtil.enc(entry.getKey() + "[" + i + "]") + "=" + HttpUtil.enc(val != null ? val : "");
                    buf.add(keyValPair);
                }
                continue;
            }
            String keyValPair = HttpUtil.enc(entry.getKey()) + "=" + HttpUtil.enc((String)value);
            buf.add(keyValPair);
        }
        return buf.toString();
    }

    private static String enc(String val) {
        try {
            return URLEncoder.encode(val, "UTF-8");
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    private static Result doFormSubmit(String url, Method m, String queryStr, Map<String, String> headers, Environment env) throws IOException {
        HttpURLConnection conn = HttpUtil.createConnection(url, m, headers, env);
        HttpUtil.writeContent(conn, queryStr);
        Resp resp = HttpUtil.sendRequest(conn);
        return resp.toResult();
    }

    private static void writeContent(HttpURLConnection conn, String queryStr) throws IOException {
        if (queryStr == null) {
            return;
        }
        try (OutputStream os = conn.getOutputStream();){
            os.write(queryStr.getBytes("UTF-8"));
        }
    }

    private static HttpURLConnection createConnection(String url, Method m, Map<String, String> headers, Environment config) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod(m.name());
        HttpUtil.setTimeouts(conn, config);
        HttpUtil.addHeaders(conn, config);
        HttpUtil.addCustomHeaders(conn, headers);
        HttpUtil.setContentType(conn, m);
        if (m == Method.POST) {
            conn.setDoOutput(true);
        }
        conn.setUseCaches(false);
        return conn;
    }

    private static Resp sendRequest(HttpURLConnection conn) throws IOException {
        int httpRespCode = conn.getResponseCode();
        Map<String, List<String>> responseHeaders = conn.getHeaderFields();
        if (httpRespCode == 204) {
            throw new RuntimeException("Got http_no_content response");
        }
        boolean error = httpRespCode < 200 || httpRespCode > 299;
        String content = HttpUtil.getContentAsString(conn, error);
        JSONObject jsonResp = HttpUtil.getContentAsJSON(content);
        if (error) {
            try {
                jsonResp.getString("api_error_code");
                String type = jsonResp.optString("type");
                String excpetionMessage = jsonResp.getString("message");
                if ("payment".equals(type)) {
                    throw new PaymentException(httpRespCode, excpetionMessage, jsonResp);
                }
                if ("operation_failed".equals(type)) {
                    throw new OperationFailedException(httpRespCode, excpetionMessage, jsonResp);
                }
                if ("invalid_request".equals(type)) {
                    throw new InvalidRequestException(httpRespCode, excpetionMessage, jsonResp);
                }
                throw new APIException(httpRespCode, excpetionMessage, jsonResp);
            }
            catch (APIException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error when parsing the error response. Probably not ChargeBee' error response. The content is \n " + content, ex);
            }
        }
        return new Resp(httpRespCode, jsonResp, responseHeaders);
    }

    private static void setTimeouts(URLConnection conn, Environment config) {
        conn.setConnectTimeout(config.connectTimeout);
        conn.setReadTimeout(config.readTimeout);
    }

    private static void setContentType(HttpURLConnection conn, Method m) {
        if (m == Method.POST) {
            HttpUtil.addHeader(conn, "Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        }
    }

    private static void addHeaders(HttpURLConnection conn, Environment config) {
        HttpUtil.addHeader(conn, "Accept-Charset", "UTF-8");
        HttpUtil.addHeader(conn, "User-Agent", String.format("Chargebee-Java-Client v%s", "2.30.0"));
        HttpUtil.addHeader(conn, "Authorization", HttpUtil.getAuthValue(config));
        HttpUtil.addHeader(conn, "Accept", "application/json");
        HttpUtil.addHeader(conn, "OS-Version", String.format("%s  %s  %s", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")));
        HttpUtil.addHeader(conn, "Lang-Version", System.getProperty("java.version"));
    }

    private static void addCustomHeaders(HttpURLConnection conn, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            HttpUtil.addHeader(conn, entry.getKey(), entry.getValue());
        }
    }

    private static void addHeader(HttpURLConnection conn, String headerName, String value) {
        conn.setRequestProperty(headerName, value);
    }

    private static String getAuthValue(Environment config) {
        return "Basic " + Base64.encodeBase64String((config.apiKey + ":").getBytes()).replaceAll("\r?", "").replaceAll("\n?", "");
    }

    private static JSONObject getContentAsJSON(String content) throws IOException {
        JSONObject obj;
        try {
            obj = new JSONObject(content);
        }
        catch (JSONException exp) {
            if (content.contains("503")) {
                throw new RuntimeException("Sorry, the server is currently unable to handle the request due to a temporary overload or scheduled maintenance. Please retry after sometime. \n type: internal_temporary_error, \n http_status_code: 503, \n error_code: internal_temporary_error,\n content: " + content, exp);
            }
            if (content.contains("504")) {
                throw new RuntimeException("The server did not receive a timely response from an upstream server, request aborted. If this problem persists, contact us at support@chargebee.com. \n type: gateway_timeout, \n http_status_code: 504, \n error_code: gateway_timeout,\n content: " + content, exp);
            }
            throw new RuntimeException("Sorry, something went wrong when trying to process the request. If this problem persists, contact us at support@chargebee.com. \n type: internal_error, \n http_status_code: 500, \n error_code: internal_error,\n " + content, exp);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContentAsString(HttpURLConnection conn, boolean error) throws IOException {
        InputStream resp;
        InputStream inputStream = resp = error ? conn.getErrorStream() : conn.getInputStream();
        if (resp == null) {
            throw new RuntimeException("Got Empty Response ");
        }
        try {
            String content;
            int bytesRead;
            if ("gzip".equalsIgnoreCase(conn.getContentEncoding())) {
                resp = new GZIPInputStream(resp);
            }
            InputStreamReader inp = new InputStreamReader(resp, "UTF-8");
            StringBuilder buf = new StringBuilder();
            char[] buffer = new char[1024];
            while ((bytesRead = inp.read(buffer, 0, buffer.length)) >= 0) {
                buf.append(buffer, 0, bytesRead);
            }
            String string = content = buf.toString();
            return string;
        }
        finally {
            resp.close();
        }
    }

    private static class Resp {
        int httpCode;
        JSONObject jsonContent;
        Map<String, List<String>> responseHeaders;

        private Resp(int httpCode, JSONObject jsonContent, Map<String, List<String>> responseHeaders) {
            this.httpCode = httpCode;
            this.jsonContent = jsonContent;
            this.responseHeaders = responseHeaders;
        }

        private Result toResult() {
            return new Result(this.httpCode, this.jsonContent, this.responseHeaders);
        }

        private ListResult toListResult() {
            return new ListResult(this.httpCode, this.jsonContent, this.responseHeaders);
        }
    }

    public static enum Method {
        GET,
        POST;

    }
}

