/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.internal;

import com.chargebee.org.json.JSONArray;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Params {
    private Map<String, Object> m = new HashMap<String, Object>();

    public void add(String paramName, Object value) {
        if (value == null) {
            throw new RuntimeException("The param {" + paramName + "} cannot be null");
        }
        this.m.put(paramName, Params.toValStr(value));
    }

    public void addOpt(String paramName, Object value) {
        this.m.put(paramName, value != null ? Params.toValStr(value) : "");
    }

    public int size() {
        return this.m.size();
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public Set<String> keys() {
        return this.m.keySet();
    }

    public Set<Map.Entry<String, Object>> entries() {
        return this.m.entrySet();
    }

    public static Object toValStr(Object value) {
        Class<?> c = value.getClass();
        if (c == String.class || c == Integer.class || c == Long.class || c == Boolean.class || c == Double.class) {
            return value.toString();
        }
        if (c == Date.class) {
            return new SimpleDateFormat("yyyy-MM-dd").format((Date)value);
        }
        if (c.isEnum()) {
            return value.toString().toLowerCase();
        }
        if (c == Timestamp.class) {
            return String.valueOf(Params.asUnixTimestamp((Timestamp)value));
        }
        if (value instanceof List) {
            List origList = (List)value;
            ArrayList<String> l = new ArrayList<String>(origList.size());
            for (Object item : origList) {
                l.add((String)Params.toValStr(item));
            }
            return l;
        }
        if (value instanceof Object[]) {
            Object[] origList = (Object[])value;
            ArrayList<String> l = new ArrayList<String>(origList.length);
            for (Object item : origList) {
                l.add((String)Params.toValStr(item));
            }
            return l;
        }
        if (value instanceof JSONObject) {
            return value.toString();
        }
        if (value instanceof JSONArray) {
            return value.toString();
        }
        throw new RuntimeException("Type [" + c.getName() + "] not handled");
    }

    public static Long asUnixTimestamp(Timestamp ts) {
        return ts.getTime() / 1000L;
    }

    public String toString() {
        return this.m.toString();
    }
}

