/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.filters;

import com.chargebee.internal.Params;
import com.chargebee.internal.RequestBase;
import com.chargebee.org.json.JSONArray;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class DateFilter<T extends Date, U extends RequestBase> {
    private U req;
    private String paramName;
    private boolean supportsPresenceOperator;

    public DateFilter(String paramName, U req) {
        this.paramName = paramName;
        this.req = req;
    }

    public DateFilter<T, U> supportsPresenceOperator(boolean supportsPresenceOperator) {
        this.supportsPresenceOperator = supportsPresenceOperator;
        return this;
    }

    public U on(T value) {
        ((RequestBase)this.req).params().addOpt(this.paramName + "[on]", value);
        return this.req;
    }

    public U before(T value) {
        ((RequestBase)this.req).params().addOpt(this.paramName + "[before]", value);
        return this.req;
    }

    public U after(T value) {
        ((RequestBase)this.req).params().addOpt(this.paramName + "[after]", value);
        return this.req;
    }

    public U between(T value1, T value2) {
        JSONArray jArr = this.serialize(Arrays.asList(value1, value2));
        ((RequestBase)this.req).params().addOpt(this.paramName + "[between]", jArr);
        return this.req;
    }

    public U isPresent(boolean value) {
        if (!this.supportsPresenceOperator) {
            throw new UnsupportedOperationException("operator '[is_present]' is not supported for this filter-parameter");
        }
        ((RequestBase)this.req).params().addOpt(this.paramName + "[is_present]", value);
        return this.req;
    }

    private JSONArray serialize(List<T> list) {
        JSONArray jArr = new JSONArray();
        for (Date dateTime : list) {
            jArr.put(Params.toValStr(dateTime));
        }
        return jArr;
    }
}

