/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.Action;
import com.chargebee.org.json.JSONObject;

public class ItemEntitlement
extends Resource<ItemEntitlement> {
    public ItemEntitlement(String jsonStr) {
        super(jsonStr);
    }

    public ItemEntitlement(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public String itemId() {
        return this.optString("item_id");
    }

    public ItemType itemType() {
        return this.optEnum("item_type", ItemType.class);
    }

    public String featureId() {
        return this.optString("feature_id");
    }

    public String featureName() {
        return this.optString("feature_name");
    }

    public String value() {
        return this.optString("value");
    }

    public String name() {
        return this.optString("name");
    }

    public static ItemEntitlementItemEntitlementsForItemRequest itemEntitlementsForItem(String id) {
        String uri = ItemEntitlement.uri("items", ItemEntitlement.nullCheck(id), "item_entitlements");
        return new ItemEntitlementItemEntitlementsForItemRequest(uri);
    }

    public static ItemEntitlementItemEntitlementsForFeatureRequest itemEntitlementsForFeature(String id) {
        String uri = ItemEntitlement.uri("features", ItemEntitlement.nullCheck(id), "item_entitlements");
        return new ItemEntitlementItemEntitlementsForFeatureRequest(uri);
    }

    public static AddItemEntitlementsRequest addItemEntitlements(String id) {
        String uri = ItemEntitlement.uri("features", ItemEntitlement.nullCheck(id), "item_entitlements");
        return new AddItemEntitlementsRequest(HttpUtil.Method.POST, uri);
    }

    public static UpsertOrRemoveItemEntitlementsForItemRequest upsertOrRemoveItemEntitlementsForItem(String id) {
        String uri = ItemEntitlement.uri("items", ItemEntitlement.nullCheck(id), "item_entitlements");
        return new UpsertOrRemoveItemEntitlementsForItemRequest(HttpUtil.Method.POST, uri);
    }

    public static class UpsertOrRemoveItemEntitlementsForItemRequest
    extends Request<UpsertOrRemoveItemEntitlementsForItemRequest> {
        private UpsertOrRemoveItemEntitlementsForItemRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpsertOrRemoveItemEntitlementsForItemRequest action(Action action) {
            this.params.add("action", (Object)action);
            return this;
        }

        public UpsertOrRemoveItemEntitlementsForItemRequest itemEntitlementFeatureId(int index, String itemEntitlementFeatureId) {
            this.params.add("item_entitlements[feature_id][" + index + "]", itemEntitlementFeatureId);
            return this;
        }

        public UpsertOrRemoveItemEntitlementsForItemRequest itemEntitlementValue(int index, String itemEntitlementValue) {
            this.params.addOpt("item_entitlements[value][" + index + "]", itemEntitlementValue);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class AddItemEntitlementsRequest
    extends Request<AddItemEntitlementsRequest> {
        private AddItemEntitlementsRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public AddItemEntitlementsRequest action(Action action) {
            this.params.add("action", (Object)action);
            return this;
        }

        public AddItemEntitlementsRequest itemEntitlementItemId(int index, String itemEntitlementItemId) {
            this.params.add("item_entitlements[item_id][" + index + "]", itemEntitlementItemId);
            return this;
        }

        public AddItemEntitlementsRequest itemEntitlementItemType(int index, ItemType itemEntitlementItemType) {
            this.params.addOpt("item_entitlements[item_type][" + index + "]", (Object)itemEntitlementItemType);
            return this;
        }

        public AddItemEntitlementsRequest itemEntitlementValue(int index, String itemEntitlementValue) {
            this.params.addOpt("item_entitlements[value][" + index + "]", itemEntitlementValue);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ItemEntitlementItemEntitlementsForFeatureRequest
    extends ListRequest<ItemEntitlementItemEntitlementsForFeatureRequest> {
        private ItemEntitlementItemEntitlementsForFeatureRequest(String uri) {
            super(uri);
        }

        @Deprecated
        public ItemEntitlementItemEntitlementsForFeatureRequest includeDrafts(Boolean includeDrafts) {
            this.params.addOpt("include_drafts", includeDrafts);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static class ItemEntitlementItemEntitlementsForItemRequest
    extends ListRequest<ItemEntitlementItemEntitlementsForItemRequest> {
        private ItemEntitlementItemEntitlementsForItemRequest(String uri) {
            super(uri);
        }

        @Deprecated
        public ItemEntitlementItemEntitlementsForItemRequest includeDrafts(Boolean includeDrafts) {
            this.params.addOpt("include_drafts", includeDrafts);
            return this;
        }

        @Deprecated
        public ItemEntitlementItemEntitlementsForItemRequest embed(String embed) {
            this.params.addOpt("embed", embed);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    public static enum ItemType {
        PLAN,
        ADDON,
        CHARGE,
        SUBSCRIPTION,
        ITEM,
        _UNKNOWN;

    }
}

